/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.mode.device;

import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.ContinuousID;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.featuregroup.AbstractParameterMode;
import de.mossgrabers.framework.parameter.IParameter;
import de.mossgrabers.framework.parameterprovider.IParameterProvider;
import de.mossgrabers.framework.parameterprovider.device.BankParameterProvider;
import java.util.List;
import java.util.function.BooleanSupplier;

public class ProjectParamsMode<S extends IControlSurface<C>, C extends Configuration>
extends AbstractParameterMode<S, C, IParameter> {
    protected IParameterProvider projectParameterProvider;
    protected IParameterProvider trackParameterProvider;
    protected boolean isProjectMode = true;
    protected boolean notifyPageChange = true;

    public ProjectParamsMode(S surface, IModel model, boolean isAbsolute, List<ContinuousID> knobs) {
        this(surface, model, isAbsolute, knobs, () -> surface.isShiftPressed());
    }

    public ProjectParamsMode(S surface, IModel model, boolean isAbsolute, List<ContinuousID> knobs, BooleanSupplier isAlternativeFunction) {
        this(surface, model, isAbsolute, knobs, isAlternativeFunction, true);
    }

    protected ProjectParamsMode(S surface, IModel model, boolean isAbsolute, List<ContinuousID> knobs, BooleanSupplier isAlternativeFunction, boolean addParameterProvider) {
        super("Project Parameters", surface, model, isAbsolute, model.getProject().getParameterBank(), knobs, isAlternativeFunction);
        if (addParameterProvider) {
            this.projectParameterProvider = new BankParameterProvider(model.getProject().getParameterBank());
            this.trackParameterProvider = new BankParameterProvider(model.getCursorTrack().getParameterBank());
            this.setParameterProvider(this.projectParameterProvider);
        }
    }

    @Override
    public String getName() {
        return this.isProjectMode ? "Project Parameters" : "Track Parameters";
    }

    @Override
    public void onKnobTouch(int index, boolean isTouched) {
        this.setTouchedKnob(index, isTouched);
        IParameter param = (IParameter)this.bank.getItem(index);
        if (!param.doesExist()) {
            return;
        }
        if (isTouched && this.surface.isDeletePressed()) {
            this.surface.setTriggerConsumed(ButtonID.DELETE);
            param.resetValue();
        }
        param.touchValue(isTouched);
    }

    @Override
    public void selectPreviousItem() {
        super.selectPreviousItem();
        this.notifyPage();
    }

    @Override
    public void selectNextItem() {
        super.selectNextItem();
        this.notifyPage();
    }

    public void toggleMode() {
        this.setMode(!this.isProjectMode);
    }

    public void setMode(boolean isProjectMode) {
        this.isProjectMode = isProjectMode;
        this.switchBanks(this.isProjectMode ? this.model.getProject().getParameterBank() : this.model.getCursorTrack().getParameterBank());
        this.setParameterProvider(this.isProjectMode ? this.projectParameterProvider : this.trackParameterProvider);
        this.bindControls();
    }

    private void notifyPage() {
        if (this.notifyPageChange) {
            if (this.isProjectMode) {
                this.mvHelper.notifySelectedProjectParameterPage();
            } else {
                this.mvHelper.notifySelectedTrackParameterPage();
            }
        }
    }
}

