/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.mode;

import java.util.EnumSet;
import java.util.Set;

public enum Modes {
    TRACK,
    TRACK_DETAILS,
    VOLUME,
    PAN,
    CROSSFADER,
    CROSSFADE_MODE_A,
    CROSSFADE_MODE_B,
    REC_ARM,
    TRACK_SELECT,
    MUTE,
    SOLO,
    STOP_CLIP,
    SEND1,
    SEND2,
    SEND3,
    SEND4,
    SEND5,
    SEND6,
    SEND7,
    SEND8,
    SEND,
    MASTER,
    MASTER_TEMP,
    DEVICE_PARAMS,
    EQ_DEVICE_PARAMS,
    INSTRUMENT_DEVICE_PARAMS,
    DEVICE_CHAINS,
    DEVICE_LAYER,
    DEVICE_LAYER_VOLUME,
    DEVICE_LAYER_PAN,
    DEVICE_LAYER_SEND1,
    DEVICE_LAYER_SEND2,
    DEVICE_LAYER_SEND3,
    DEVICE_LAYER_SEND4,
    DEVICE_LAYER_SEND5,
    DEVICE_LAYER_SEND6,
    DEVICE_LAYER_SEND7,
    DEVICE_LAYER_SEND8,
    DEVICE_LAYER_DETAILS,
    DEVICE_LAYER_MUTE,
    DEVICE_LAYER_SOLO,
    BROWSER,
    CLIP,
    NOTE,
    FRAME,
    GROOVE,
    ACCENT,
    SCALES,
    SCALE_LAYOUT,
    FIXED,
    RIBBON,
    VIEW_SELECT,
    AUTOMATION,
    TRANSPORT,
    CONFIGURATION,
    SETUP,
    INFO,
    PROJECT,
    AUDIO,
    SESSION_VIEW_SELECT,
    SESSION,
    MARKERS,
    REPEAT_NOTE,
    FUNCTIONS,
    PLAY_OPTIONS,
    POSITION,
    TEMPO,
    LOOP_START,
    LOOP_LENGTH,
    USER,
    DUMMY,
    ADD_TRACK,
    DRUM_SEQUENCER,
    NOTE_SEQUENCER;

    public static final String NAME_TRACK = "Track";
    public static final String NAME_VOLUME = "Volume";
    public static final String NAME_PANNING = "Panning";
    public static final String NAME_SENDS = "Sends";
    public static final String NAME_CROSSFADE = "Crossfade";
    public static final String NAME_PARAMETERS = "Parameters";
    public static final String NAME_LAYER = "Layer";
    public static final String NAME_LAYER_VOLUME = "Layer Volume";
    public static final String NAME_LAYER_PANNING = "Layer Panning";
    public static final String NAME_LAYER_SENDS = "Layer Sends";
    public static final String NAME_EQUALIZER = "Equalizer";
    public static final String NAME_AUTOMATION = "Automation";
    private static final Set<Modes> TRACK_MODES;
    private static final Set<Modes> LAYER_MODES;
    private static final Set<Modes> SEND_MODES;
    private static final Set<Modes> LAYER_SEND_MODES;
    private static final Set<Modes> MIX_MODES;
    private static final Set<Modes> MASTER_MODES;

    public static boolean isSendMode(Modes modeId) {
        return SEND_MODES.contains((Object)modeId);
    }

    public static boolean isTrackMode(Modes modeId) {
        return TRACK_MODES.contains((Object)modeId);
    }

    public static boolean isMixMode(Modes modeId) {
        return MIX_MODES.contains((Object)modeId);
    }

    public static boolean isLayerMode(Modes modeId) {
        return LAYER_MODES.contains((Object)modeId);
    }

    public static boolean isLayerSendMode(Modes modeId) {
        return LAYER_SEND_MODES.contains((Object)modeId);
    }

    public static boolean isMasterMode(Modes modeId) {
        return MASTER_MODES.contains((Object)modeId);
    }

    public static boolean isDeviceMode(Modes modeId) {
        return LAYER_MODES.contains((Object)modeId) || DEVICE_PARAMS == modeId;
    }

    public static Modes get(Modes mode, int offset) {
        return Modes.values()[mode.ordinal() + offset];
    }

    static {
        TRACK_MODES = EnumSet.range(TRACK, STOP_CLIP);
        LAYER_MODES = EnumSet.range(DEVICE_LAYER, DEVICE_LAYER_DETAILS);
        SEND_MODES = EnumSet.range(SEND1, SEND8);
        LAYER_SEND_MODES = EnumSet.range(DEVICE_LAYER_SEND1, DEVICE_LAYER_SEND8);
        MIX_MODES = EnumSet.range(TRACK, SEND);
        MASTER_MODES = EnumSet.of(MASTER, MASTER_TEMP, FRAME);
        TRACK_MODES.addAll(SEND_MODES);
    }
}

