/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.mode;

import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.ContinuousID;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.IItem;
import de.mossgrabers.framework.featuregroup.AbstractParameterMode;
import de.mossgrabers.framework.parameterprovider.special.FixedParameterProvider;
import java.util.Collections;

public class MasterVolumeMode<S extends IControlSurface<C>, C extends Configuration>
extends AbstractParameterMode<S, C, IItem> {
    private boolean controlLastParamActive = false;
    private final FixedParameterProvider masterVolumeProvider = new FixedParameterProvider(this.model.getMasterTrack().getVolumeParameter());
    private final FixedParameterProvider focusedParameterProvider = new FixedParameterProvider(this.model.getFocusedParameter().get());

    public MasterVolumeMode(S surface, IModel model, ContinuousID masterID) {
        super("Master Volume", surface, model, true, null, Collections.singletonList(masterID));
    }

    @Override
    public void onActivate() {
        this.setParameterProvider(this.masterVolumeProvider);
        this.setParameterProvider(ButtonID.SHIFT, new FixedParameterProvider(this.model.getTransport().getMetronomeVolumeParameter()));
        this.setParameterProvider(ButtonID.SELECT, new FixedParameterProvider(this.model.getApplication().getZoomParameter()));
        super.onActivate();
    }

    public void toggleControlLastParamActive() {
        this.setControlLastParamActive(!this.controlLastParamActive);
    }

    public void setControlLastParamActive(boolean active) {
        this.controlLastParamActive = active;
        this.setParameterProvider(this.controlLastParamActive ? this.focusedParameterProvider : this.masterVolumeProvider);
        this.bindControls();
    }

    public boolean isControlLastParamActive() {
        return this.controlLastParamActive;
    }
}

