/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.graphics.canvas.component;

import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.daw.resource.ChannelType;
import de.mossgrabers.framework.daw.resource.DeviceTypes;
import de.mossgrabers.framework.graphics.Align;
import de.mossgrabers.framework.graphics.IGraphicsConfiguration;
import de.mossgrabers.framework.graphics.IGraphicsContext;
import de.mossgrabers.framework.graphics.IGraphicsDimensions;
import de.mossgrabers.framework.graphics.IGraphicsInfo;
import de.mossgrabers.framework.graphics.canvas.component.ChannelSelectComponent;
import de.mossgrabers.framework.graphics.canvas.component.LabelComponent;
import de.mossgrabers.framework.graphics.canvas.component.MenuComponent;

public class ParameterComponent
extends MenuComponent {
    private final String paramName;
    private final String paramValueText;
    private final int paramValue;
    private final int modulatedParamValue;
    private final boolean isTouched;

    public ParameterComponent(String menuName, boolean isMenuSelected, String name, ColorEx color, boolean isSelected, String paramName, int paramValue, int modulatedParamValue, String paramValueText, boolean isTouched) {
        this(menuName, isMenuSelected, name, (String)null, color, isSelected, paramName, paramValue, modulatedParamValue, paramValueText, isTouched);
    }

    public ParameterComponent(String menuName, boolean isMenuSelected, String name, String deviceName, ColorEx color, boolean isSelected, String paramName, int paramValue, int modulatedParamValue, String paramValueText, boolean isTouched) {
        this(menuName, isMenuSelected, name, deviceName, color, isSelected, paramName, paramValue, modulatedParamValue, paramValueText, isTouched, LabelComponent.LabelLayout.COLORED);
    }

    public ParameterComponent(String menuName, boolean isMenuSelected, String name, String deviceName, ColorEx color, boolean isSelected, String paramName, int paramValue, int modulatedParamValue, String paramValueText, boolean isTouched, LabelComponent.LabelLayout lowerLayout) {
        super(menuName, isMenuSelected, name, deviceName == null ? null : DeviceTypes.getIconId(deviceName), color, isSelected, true, lowerLayout);
        this.paramName = paramName;
        this.paramValue = paramValue;
        this.modulatedParamValue = modulatedParamValue;
        this.paramValueText = paramValueText;
        this.isTouched = isTouched;
    }

    public ParameterComponent(String menuName, boolean isMenuSelected, String name, ChannelType type, ColorEx color, boolean isSelected, String paramName, int paramValue, int modulatedParamValue, String paramValueText, boolean isTouched) {
        super(menuName, isMenuSelected, name, ChannelSelectComponent.getIcon(type, false), color, isSelected, true);
        this.paramName = paramName;
        this.paramValue = paramValue;
        this.modulatedParamValue = modulatedParamValue;
        this.paramValueText = paramValueText;
        this.isTouched = isTouched;
    }

    @Override
    public void draw(IGraphicsInfo info) {
        super.draw(info);
        IGraphicsContext gc = info.getContext();
        IGraphicsDimensions dimensions = info.getDimensions();
        IGraphicsConfiguration configuration = info.getConfiguration();
        double left = info.getBounds().left();
        double width = info.getBounds().width();
        double height = info.getBounds().height();
        double separatorSize = dimensions.getSeparatorSize();
        double menuHeight = dimensions.getMenuHeight();
        double unit = dimensions.getUnit();
        double controlsTop = dimensions.getControlsTop();
        double inset = dimensions.getInset();
        boolean isValueMissing = this.paramValue == -1;
        boolean isModulated = this.modulatedParamValue != -1;
        int trackRowHeight = (int)(1.6 * unit);
        double trackRowTop = height - (double)trackRowHeight - unit - separatorSize;
        if (this.paramName == null || this.paramName.length() == 0) {
            return;
        }
        double elementWidth = width - 2.0 * inset;
        double elementHeight = (trackRowTop - controlsTop - inset) / 3.0;
        ColorEx backgroundColor = configuration.getColorBackground();
        gc.fillRectangle(left, menuHeight + 1.0, width, trackRowTop - (isValueMissing ? controlsTop + elementHeight : menuHeight + 1.0), this.isTouched ? configuration.getColorBackgroundLighter() : backgroundColor);
        ColorEx textColor = configuration.getColorText();
        double fontSize = elementHeight * 2.0 / 3.0;
        gc.drawTextInBounds(this.paramName, left + inset - 1.0, controlsTop - inset, elementWidth, elementHeight, Align.CENTER, textColor, fontSize);
        gc.drawTextInBounds(this.paramValueText, left + inset - 1.0, controlsTop - inset + elementHeight, elementWidth, elementHeight, Align.CENTER, textColor, fontSize);
        if (isValueMissing) {
            return;
        }
        double elementInnerWidth = elementWidth - 2.0;
        double maxValue = dimensions.getParameterUpperBound();
        double value = isModulated ? (double)this.modulatedParamValue : (double)this.paramValue;
        double valueSliderWidth = value >= maxValue - 1.0 ? elementInnerWidth : elementInnerWidth * value / maxValue;
        double innerTop = controlsTop + 2.0 * elementHeight + 1.0;
        ColorEx borderColor = configuration.getColorBorder();
        gc.fillRectangle(left + inset - 1.0, controlsTop + 2.0 * elementHeight, elementWidth, elementHeight, borderColor);
        gc.fillRectangle(left + inset, innerTop, valueSliderWidth, elementHeight - 2.0, configuration.getColorFader());
        double w = this.isTouched ? 3.0 : 1.0;
        double valueWidth = (double)this.paramValue >= maxValue - 1.0 ? elementInnerWidth : elementInnerWidth * (double)this.paramValue / maxValue;
        gc.fillRectangle(left + inset + Math.max(0.0, valueWidth - w), innerTop, w, elementHeight - 2.0, configuration.getColorEdit());
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.isTouched ? 1231 : 1237);
        result = 31 * result + this.modulatedParamValue;
        result = 31 * result + (this.paramName == null ? 0 : this.paramName.hashCode());
        result = 31 * result + this.paramValue;
        result = 31 * result + (this.paramValueText == null ? 0 : this.paramValueText.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj) || this.getClass() != obj.getClass()) {
            return false;
        }
        ParameterComponent other = (ParameterComponent)obj;
        if (this.isTouched != other.isTouched || this.modulatedParamValue != other.modulatedParamValue) {
            return false;
        }
        if (this.paramName == null ? other.paramName != null : !this.paramName.equals(other.paramName)) {
            return false;
        }
        if (this.paramValue != other.paramValue) {
            return false;
        }
        return !(this.paramValueText == null ? other.paramValueText != null : !this.paramValueText.equals(other.paramValueText));
    }
}

