/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.graphics.canvas.component;

import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.daw.data.ISlot;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.resource.ChannelType;
import de.mossgrabers.framework.graphics.Align;
import de.mossgrabers.framework.graphics.IBounds;
import de.mossgrabers.framework.graphics.IGraphicsConfiguration;
import de.mossgrabers.framework.graphics.IGraphicsContext;
import de.mossgrabers.framework.graphics.IGraphicsDimensions;
import de.mossgrabers.framework.graphics.IGraphicsInfo;
import de.mossgrabers.framework.graphics.canvas.component.ChannelSelectComponent;
import de.mossgrabers.framework.utils.Pair;
import java.util.ArrayList;
import java.util.List;

public class ClipListComponent
extends ChannelSelectComponent {
    private final List<Pair<ITrack, ISlot>> items;

    public ClipListComponent(List<Pair<ITrack, ISlot>> slots, ChannelType type, String name, ColorEx color, boolean isSelected, boolean isActive, boolean isPinned) {
        super(type, null, false, name, color, isSelected, isActive, isPinned);
        this.items = new ArrayList<Pair<ITrack, ISlot>>(slots);
    }

    @Override
    public void draw(IGraphicsInfo info) {
        super.draw(info);
        IGraphicsContext gc = info.getContext();
        IGraphicsDimensions dimensions = info.getDimensions();
        IGraphicsConfiguration configuration = info.getConfiguration();
        IBounds bounds = info.getBounds();
        double left = bounds.left();
        double width = bounds.width();
        double height = bounds.height();
        double separatorSize = dimensions.getSeparatorSize() / 2.0;
        double inset = dimensions.getInset();
        int size = this.items.size();
        double itemLeft = left;
        double itemWidth = width;
        double itemHeight = height / (double)(size + 1);
        double fontHeight = itemHeight > 30.0 ? itemHeight / 2.0 : itemHeight * 2.0 / 3.0;
        double boxLeft = itemLeft + inset;
        double boxWidth = fontHeight - 2.0 * separatorSize;
        double radius = boxWidth / 2.0;
        ColorEx textColor = configuration.getColorText();
        for (int i = 0; i < size; ++i) {
            Pair<ITrack, ISlot> pair = this.items.get(i);
            ITrack track = pair.getKey();
            if (!track.doesExist()) continue;
            ISlot slot = pair.getValue();
            double itemTop = (double)i * itemHeight;
            Object name = slot.getName();
            double boxTop = itemTop + (itemHeight - fontHeight) / 2.0;
            ColorEx clipBackgroundColor = slot.getColor();
            if (track.isGroup()) {
                if (((String)name).isEmpty()) {
                    name = "Scene " + (slot.getPosition() + 1);
                }
                gc.fillRectangle(itemLeft, itemTop + separatorSize, itemWidth, itemHeight - 2.0 * separatorSize, ColorEx.darker(ColorEx.DARK_GRAY));
                gc.fillRectangle(itemLeft + itemWidth - 2.0 * inset, itemTop + separatorSize, 2.0 * inset, itemHeight - 2.0 * separatorSize, clipBackgroundColor);
            } else {
                gc.fillRectangle(itemLeft, itemTop + separatorSize, itemWidth, itemHeight - 2.0 * separatorSize, clipBackgroundColor);
            }
            if (slot.doesExist()) {
                boolean isPlaying = slot.isPlaying();
                if (isPlaying || slot.isRecording() || slot.isPlayingQueued() || slot.isRecordingQueued()) {
                    gc.fillRectangle(boxLeft, boxTop, fontHeight, fontHeight, ColorEx.BLACK);
                }
                if (slot.hasContent()) {
                    if (slot.isRecording()) {
                        gc.fillCircle(boxLeft + separatorSize + radius, boxTop + separatorSize + radius, radius, ColorEx.RED);
                    } else {
                        ColorEx fillColor = ColorEx.darker(clipBackgroundColor);
                        if (isPlaying) {
                            fillColor = ColorEx.GREEN;
                        } else if (slot.isPlayingQueued() || slot.isRecordingQueued()) {
                            fillColor = ColorEx.WHITE;
                        }
                        gc.fillTriangle(boxLeft + separatorSize, boxTop + separatorSize, boxLeft + separatorSize, boxTop + fontHeight - separatorSize, boxLeft + fontHeight - separatorSize, boxTop + fontHeight / 2.0, fillColor);
                    }
                } else if (track.isRecArm()) {
                    gc.fillCircle(boxLeft + separatorSize + radius, boxTop + separatorSize + radius, radius, ColorEx.DARK_GRAY);
                } else {
                    gc.fillRectangle(boxLeft + separatorSize, boxTop + separatorSize, boxWidth, boxWidth, ColorEx.DARK_GRAY);
                }
                double padLeft = 2.0 * inset + fontHeight;
                gc.drawTextInBounds((String)name, itemLeft + padLeft, itemTop - 1.0, itemWidth - padLeft - separatorSize - inset, itemHeight, Align.LEFT, slot.isSelected() ? ColorEx.calcContrastColor(textColor) : textColor, fontHeight);
            }
            if (!slot.isSelected()) continue;
            gc.strokeRectangle(itemLeft, itemTop + separatorSize, itemWidth, itemHeight - 2.0 * separatorSize, ColorEx.calcContrastColor(textColor), slot.isSelected() ? 2.0 : 1.0);
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.items == null ? 0 : this.items.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ClipListComponent other = (ClipListComponent)obj;
        return !(this.items == null ? other.items != null : !this.items.equals(other.items));
    }
}

