/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.daw.midi;

public class MidiConstants {
    public static final int CMD_NOTE_OFF = 128;
    public static final int CMD_NOTE_ON = 144;
    public static final int CMD_POLY_AFTERTOUCH = 160;
    public static final int CMD_CC = 176;
    public static final int CMD_PROGRAM_CHANGE = 192;
    public static final int CMD_CHANNEL_AFTERTOUCH = 208;
    public static final int CMD_PITCHBEND = 224;
    public static final int CMD_SYSTEM = 240;
    private static final String[] SYSEX_NAMES = new String[]{"F0: Start of System Exclusive Status Byte", "F1: MIDI Time Code Quarter Frame", "F2: Song Position Pointer", "F3: Song Select", "F4: Undefined", "F5: Undefined", "F6: Tune Request", "F7: End of System Exclusive", "F8: Timing Clock", "F9: Undefined", "FA: Start", "FB: Continue", "FC: Stop", "FD: Undefined", "FE: Active Sensing", "FF: System Reset"};
    private static final String[] CC_NAMES = new String[]{"00 Bank Select (MSB)", "01 Modulation Wheel (MSB)", "02 Breath Controller (MSB)", "03 Undefined (MSB)", "04 Foot Controller (MSB)", "05 Portamento Time (MSB)", "06 Data Entry (MSB)", "07 Channel Volume (MSB)", "08 Balance (MSB)", "09 Undefined (MSB)", "10 Pan (MSB)", "11 Expression (MSB)", "12 Effect Control 1 (MSB)", "13 Effect Control 2 (MSB)", "14 Undefined (MSB)", "15 Undefined (MSB)", "16 General Purpose Controller 1 (MSB)", "17 General Purpose Controller 2 (MSB)", "18 General Purpose Controller 3 (MSB)", "19 General Purpose Controller 4 (MSB)", "20 Undefined (MSB)", "21 Undefined (MSB)", "22 Undefined (MSB)", "23 Undefined (MSB)", "24 Undefined (MSB)", "25 Undefined (MSB)", "26 Undefined (MSB)", "27 Undefined (MSB)", "28 Undefined (MSB)", "29 Undefined (MSB)", "30 Undefined (MSB)", "31 Undefined (MSB)", "32 Bank Select (LSB)", "33 Modulation Wheel (LSB)", "34 Breath Controller (LSB)", "35 Undefined (LSB)", "36 Foot Controller (LSB)", "37 Portamento Time (LSB)", "38 Data Entry (LSB)", "39 Channel Volume (LSB)", "30 Balance (LSB)", "41 Undefined (LSB)", "42 Pan (LSB)", "43 Expression (LSB)", "44 Effect Control 1 (LSB)", "45 Effect Control 2 (LSB)", "46 Undefined (LSB)", "47 Undefined (LSB)", "48 General Purpose Controller 1 (LSB)", "49 General Purpose Controller 2 (LSB)", "50 General Purpose Controller 3 (LSB)", "51 General Purpose Controller 4 (LSB)", "52 Undefined (LSB)", "53 Undefined (LSB)", "54 Undefined (LSB)", "55 Undefined (LSB)", "56 Undefined (LSB)", "57 Undefined (LSB)", "58 Undefined (LSB)", "59 Undefined (LSB)", "60 Undefined (LSB)", "61 Undefined (LSB)", "62 Undefined (LSB)", "63 Undefined (LSB)", "64 Sustain Pedal", "65 Portamento On/Off", "66 Sostenuto", "67 Soft Pedal", "68 Legato Footswitch", "69 Hold 2", "70 Sound Controller 1 - Sound Variation", "71 Sound Controller 2 - Timbre/Harmonic Intensity", "72 Sound Controller 3 - Release Time", "73 Sound Controller 4 - Attack Time", "74 Sound Controller 5 - Brightness", "75 Sound Controller 6 - Decay Time", "76 Sound Controller 7 - Vibrato Rate", "77 Sound Controller 8 - Vibrato Depth", "78 Sound Controller 9 - Vibrato Delay", "79 Sound Controller 10", "80 General Purpose 5", "81 General Purpose 6", "82 General Purpose 7", "83 General Purpose 8", "84 Portamento Control", "85 Undefined", "86 Undefined", "87 Undefined", "88 High Resolution Velocity Prefix", "89 Undefined", "90 Undefined", "91 Effect 1 Depth - Reverb Send Level", "92 Effect 2 Depth - Tremolo Depth", "93 Effect 3 Depth - Chorus Send Level", "94 Effect 4 Depth - Celeste [Detune] Depth", "95 Effect 5 Depth - Phaser Depth", "96 Data Increment", "97 Data Decrement", "98 Non-Registered Parameter Number (NRPN) LSB", "99 Non-Registered Parameter Number (NRPN) MSB", "100 Registered Parameter Number (RPN) LSB", "101 Registered Parameter Number (RPN) MSB", "102 Undefined", "103 Undefined", "104 Undefined", "105 Undefined", "106 Undefined", "107 Undefined", "108 Undefined", "109 Undefined", "110 Undefined", "111 Undefined", "112 Undefined", "113 Undefined", "114 Undefined", "115 Undefined", "116 Undefined", "117 Undefined", "118 Undefined", "119 Undefined", "120 All Sound Off", "121 Reset All Controllers", "122 Local On/Off Switch", "123 All Notes Off", "124 Omni Mode Off", "125 Omni Mode On", "126 Mono Mode", "127 Poly Mode"};
    private static final String[] MMC_NAMES = new String[128];

    public static String[] getSysexNames() {
        return SYSEX_NAMES;
    }

    public static String[] getCCNames() {
        return CC_NAMES;
    }

    public static String[] getMMCNames() {
        return MMC_NAMES;
    }

    private MidiConstants() {
    }

    static {
        MidiConstants.MMC_NAMES[0] = "Reserved for extensions";
        MidiConstants.MMC_NAMES[1] = "Stop";
        MidiConstants.MMC_NAMES[2] = "Play";
        MidiConstants.MMC_NAMES[3] = "Deferred play";
        MidiConstants.MMC_NAMES[4] = "Fast forward";
        MidiConstants.MMC_NAMES[5] = "Rewind";
        MidiConstants.MMC_NAMES[6] = "Record strobe";
        MidiConstants.MMC_NAMES[7] = "Record exit";
        MidiConstants.MMC_NAMES[8] = "Record pause";
        MidiConstants.MMC_NAMES[9] = "Pause";
        MidiConstants.MMC_NAMES[10] = "Eject";
        MidiConstants.MMC_NAMES[11] = "Chase";
        MidiConstants.MMC_NAMES[12] = "Command error reset";
        MidiConstants.MMC_NAMES[13] = "MMC reset";
        MidiConstants.MMC_NAMES[64] = "Write";
        MidiConstants.MMC_NAMES[65] = "Masked write";
        MidiConstants.MMC_NAMES[66] = "Read";
        MidiConstants.MMC_NAMES[67] = "Update";
        MidiConstants.MMC_NAMES[68] = "Locate";
        MidiConstants.MMC_NAMES[69] = "Variable play";
        MidiConstants.MMC_NAMES[70] = "Search";
        MidiConstants.MMC_NAMES[71] = "Shuttle";
        MidiConstants.MMC_NAMES[72] = "Step";
        MidiConstants.MMC_NAMES[73] = "Assign system master";
        MidiConstants.MMC_NAMES[74] = "Generator command";
        MidiConstants.MMC_NAMES[75] = "Midi time code command";
        MidiConstants.MMC_NAMES[76] = "Move";
        MidiConstants.MMC_NAMES[77] = "Add";
        MidiConstants.MMC_NAMES[78] = "Subtract";
        MidiConstants.MMC_NAMES[79] = "Drop frame adjust";
        MidiConstants.MMC_NAMES[80] = "Procedure";
        MidiConstants.MMC_NAMES[81] = "Event";
        MidiConstants.MMC_NAMES[82] = "Group";
        MidiConstants.MMC_NAMES[83] = "Command segment";
        MidiConstants.MMC_NAMES[84] = "Deferred variable play";
        MidiConstants.MMC_NAMES[85] = "Record strobe variable";
        MidiConstants.MMC_NAMES[124] = "Wait";
        MidiConstants.MMC_NAMES[127] = "Resume";
        for (int i = 0; i < MMC_NAMES.length; ++i) {
            if (MMC_NAMES[i] != null) continue;
            MidiConstants.MMC_NAMES[i] = "-";
        }
    }
}

