/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.daw;

import de.mossgrabers.framework.controller.color.ColorManager;
import de.mossgrabers.framework.controller.valuechanger.IValueChanger;
import de.mossgrabers.framework.daw.DataSetup;
import de.mossgrabers.framework.daw.IApplication;
import de.mossgrabers.framework.daw.IArranger;
import de.mossgrabers.framework.daw.IBrowser;
import de.mossgrabers.framework.daw.IClipLauncherNavigator;
import de.mossgrabers.framework.daw.IGroove;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.IMixer;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.IProject;
import de.mossgrabers.framework.daw.ITransport;
import de.mossgrabers.framework.daw.ModelSetup;
import de.mossgrabers.framework.daw.clip.INoteClip;
import de.mossgrabers.framework.daw.constants.DeviceID;
import de.mossgrabers.framework.daw.data.ICursorDevice;
import de.mossgrabers.framework.daw.data.ICursorTrack;
import de.mossgrabers.framework.daw.data.IDrumDevice;
import de.mossgrabers.framework.daw.data.IMasterTrack;
import de.mossgrabers.framework.daw.data.ISlot;
import de.mossgrabers.framework.daw.data.ISpecificDevice;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.IMarkerBank;
import de.mossgrabers.framework.daw.data.bank.ISceneBank;
import de.mossgrabers.framework.daw.data.bank.ITrackBank;
import de.mossgrabers.framework.observer.IValueObserver;
import de.mossgrabers.framework.scale.Scales;
import de.mossgrabers.framework.utils.FrameworkException;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public abstract class AbstractModel
implements IModel {
    protected final IHost host;
    protected final Scales scales;
    protected final ColorManager colorManager;
    protected final IValueChanger valueChanger;
    protected final ModelSetup modelSetup;
    protected final Set<IValueObserver<ITrackBank>> trackBankObservers = new HashSet<IValueObserver<ITrackBank>>();
    protected IApplication application;
    protected IMixer mixer;
    protected ITransport transport;
    protected IGroove groove;
    protected IProject project;
    protected IBrowser browser;
    protected IArranger arranger;
    protected IMarkerBank markerBank;
    protected ITrackBank currentTrackBank;
    protected ITrackBank trackBank;
    protected ITrackBank effectTrackBank;
    protected ICursorTrack cursorTrack;
    protected IMasterTrack masterTrack;
    protected ICursorDevice cursorDevice;
    protected IDrumDevice drumDevice;
    protected IClipLauncherNavigator clipLauncherNavigator;
    protected Map<Integer, IDrumDevice> additionalDrumDevices = new HashMap<Integer, IDrumDevice>();
    protected Map<String, INoteClip> cursorClips = new HashMap<String, INoteClip>();
    protected final Map<DeviceID, ISpecificDevice> specificDevices = new EnumMap<DeviceID, ISpecificDevice>(DeviceID.class);
    private int lastSelection;

    protected AbstractModel(ModelSetup modelSetup, DataSetup dataSetup, Scales scales) {
        this.modelSetup = modelSetup;
        this.host = dataSetup.getHost();
        this.colorManager = dataSetup.getColorManager();
        this.valueChanger = dataSetup.getValueChanger();
        this.scales = scales;
    }

    @Override
    public IHost getHost() {
        return this.host;
    }

    @Override
    public IValueChanger getValueChanger() {
        return this.valueChanger;
    }

    @Override
    public IArranger getArranger() {
        return this.arranger;
    }

    @Override
    public IMarkerBank getMarkerBank() {
        return this.markerBank;
    }

    @Override
    public IMixer getMixer() {
        return this.mixer;
    }

    @Override
    public ColorManager getColorManager() {
        return this.colorManager;
    }

    @Override
    public IProject getProject() {
        return this.project;
    }

    @Override
    public ITransport getTransport() {
        return this.transport;
    }

    @Override
    public IGroove getGroove() {
        return this.groove;
    }

    @Override
    public IMasterTrack getMasterTrack() {
        return this.masterTrack;
    }

    @Override
    public Scales getScales() {
        return this.scales;
    }

    @Override
    public ICursorDevice getCursorDevice() {
        return this.cursorDevice;
    }

    @Override
    public ICursorTrack getCursorTrack() {
        return this.cursorTrack;
    }

    @Override
    public ISpecificDevice getSpecificDevice(DeviceID deviceID) {
        return this.specificDevices.get((Object)deviceID);
    }

    @Override
    public IDrumDevice getDrumDevice() {
        return this.drumDevice;
    }

    @Override
    public IDrumDevice getDrumDevice(int pageSize) {
        IDrumDevice additionalDrumDevice = this.additionalDrumDevices.get(pageSize);
        if (additionalDrumDevice == null) {
            throw new FrameworkException("Additional drum device of size " + pageSize + " was not configured!");
        }
        return additionalDrumDevice;
    }

    @Override
    public void toggleCurrentTrackBank() {
        if (this.effectTrackBank == null) {
            return;
        }
        Optional selectedItem = this.getCurrentTrackBank().getSelectedItem();
        int selPosition = selectedItem.isEmpty() ? -1 : ((ITrack)selectedItem.get()).getPosition();
        this.currentTrackBank = this.currentTrackBank == this.trackBank ? this.effectTrackBank : this.trackBank;
        this.currentTrackBank.selectItemAtPosition(this.lastSelection);
        this.lastSelection = selPosition;
        this.trackBankObservers.forEach(observer -> observer.update(this.currentTrackBank));
    }

    @Override
    public boolean isEffectTrackBankActive() {
        return this.currentTrackBank == this.effectTrackBank;
    }

    @Override
    public ITrackBank getCurrentTrackBank() {
        return this.currentTrackBank;
    }

    @Override
    public void addTrackBankObserver(IValueObserver<ITrackBank> observer) {
        this.trackBankObservers.add(observer);
    }

    @Override
    public void removeTrackBankObserver(IValueObserver<ITrackBank> observer) {
        this.trackBankObservers.remove(observer);
    }

    @Override
    public ITrackBank getTrackBank() {
        return this.trackBank;
    }

    @Override
    public ITrackBank getEffectTrackBank() {
        return this.effectTrackBank;
    }

    @Override
    public IApplication getApplication() {
        return this.application;
    }

    @Override
    public IBrowser getBrowser() {
        return this.browser;
    }

    @Override
    public boolean hasSelectedDevice() {
        return this.cursorDevice.doesExist();
    }

    @Override
    public ISceneBank getSceneBank() {
        return this.trackBank.getSceneBank();
    }

    @Override
    public boolean hasRecordingState() {
        return this.transport.isRecording() || this.transport.isLauncherOverdub() || this.currentTrackBank.isClipRecording();
    }

    @Override
    public boolean canSelectedTrackHoldNotes() {
        Optional t = this.getCurrentTrackBank().getSelectedItem();
        return t.isPresent() && ((ITrack)t.get()).canHoldNotes();
    }

    @Override
    public Optional<ISlot> getSelectedSlot() {
        ICursorTrack track = this.getCursorTrack();
        return track == null ? Optional.empty() : track.getSlotBank().getSelectedItem();
    }

    @Override
    public boolean canConvertClip() {
        ICursorTrack selectedTrack = this.getCursorTrack();
        if (!selectedTrack.doesExist() || !selectedTrack.canHoldAudioData()) {
            return false;
        }
        List slots = selectedTrack.getSlotBank().getSelectedItems();
        if (slots.isEmpty()) {
            return false;
        }
        for (ISlot slot : slots) {
            if (!slot.hasContent()) continue;
            return true;
        }
        return false;
    }

    @Override
    public IClipLauncherNavigator getClipLauncherNavigator() {
        return this.clipLauncherNavigator;
    }
}

