/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.controller.display;

import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.controller.display.IGraphicDisplay;
import de.mossgrabers.framework.controller.hardware.IHwGraphicsDisplay;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.clip.INoteClip;
import de.mossgrabers.framework.daw.clip.NotePosition;
import de.mossgrabers.framework.daw.data.IScene;
import de.mossgrabers.framework.daw.data.ISlot;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.resource.ChannelType;
import de.mossgrabers.framework.daw.resource.ResourceHandler;
import de.mossgrabers.framework.graphics.Align;
import de.mossgrabers.framework.graphics.DefaultGraphicsInfo;
import de.mossgrabers.framework.graphics.IBitmap;
import de.mossgrabers.framework.graphics.IGraphicsConfiguration;
import de.mossgrabers.framework.graphics.IGraphicsDimensions;
import de.mossgrabers.framework.graphics.canvas.component.ChannelComponent;
import de.mossgrabers.framework.graphics.canvas.component.ChannelSelectComponent;
import de.mossgrabers.framework.graphics.canvas.component.ClipListComponent;
import de.mossgrabers.framework.graphics.canvas.component.IComponent;
import de.mossgrabers.framework.graphics.canvas.component.LabelComponent;
import de.mossgrabers.framework.graphics.canvas.component.ListComponent;
import de.mossgrabers.framework.graphics.canvas.component.MidiClipComponent;
import de.mossgrabers.framework.graphics.canvas.component.OptionsComponent;
import de.mossgrabers.framework.graphics.canvas.component.ParameterComponent;
import de.mossgrabers.framework.graphics.canvas.component.SceneListGridElement;
import de.mossgrabers.framework.graphics.canvas.component.SendsComponent;
import de.mossgrabers.framework.graphics.canvas.utils.SendData;
import de.mossgrabers.framework.graphics.display.ModelInfo;
import de.mossgrabers.framework.utils.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public abstract class AbstractGraphicDisplay
implements IGraphicDisplay {
    public static final int GRID_ELEMENT_CHANNEL_SELECTION = 0;
    public static final int GRID_ELEMENT_CHANNEL_VOLUME = 1;
    public static final int GRID_ELEMENT_CHANNEL_PAN = 2;
    public static final int GRID_ELEMENT_CHANNEL_CROSSFADER = 3;
    public static final int GRID_ELEMENT_CHANNEL_SENDS = 4;
    public static final int GRID_ELEMENT_CHANNEL_ALL = 5;
    public static final int GRID_ELEMENT_PARAMETERS = 6;
    public static final int GRID_ELEMENT_OPTIONS = 7;
    public static final int GRID_ELEMENT_LIST = 8;
    private static final int TIMEOUT = 1;
    private final AtomicInteger counter = new AtomicInteger();
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
    private final Object counterSync = new Object();
    private final List<IComponent> columns = new ArrayList<IComponent>(8);
    private final AtomicReference<String> notificationMessage = new AtomicReference();
    private ModelInfo info = new ModelInfo(null, Collections.emptyList());
    protected final IHost host;
    protected final IGraphicsConfiguration configuration;
    protected final IGraphicsDimensions dimensions;
    private final IBitmap image;
    private IHwGraphicsDisplay hardwareDisplay;

    protected AbstractGraphicDisplay(IHost host, IGraphicsConfiguration configuration, IGraphicsDimensions dimensions, String windowTitle) {
        this.host = host;
        this.configuration = configuration;
        this.dimensions = dimensions;
        ResourceHandler.init(host);
        this.image = host.createBitmap(dimensions.getWidth(), dimensions.getHeight());
        this.image.setDisplayWindowTitle(windowTitle);
        this.executor.scheduleAtFixedRate(this::checkNotificationCounter, 1L, 1L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelNotification() {
        Object object = this.counterSync;
        synchronized (object) {
            this.counter.set(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isNotificationActive() {
        Object object = this.counterSync;
        synchronized (object) {
            return this.counter.get() > 0;
        }
    }

    @Override
    public void showDebugWindow() {
        this.image.showDisplayWindow();
    }

    @Override
    public void shutdown() {
        this.executor.shutdown();
        try {
            if (!this.executor.awaitTermination(5L, TimeUnit.SECONDS)) {
                this.host.error("Display send executor did not end in 5 seconds.");
            }
        }
        catch (InterruptedException ex) {
            this.host.error("Display send executor interrupted.", ex);
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send() {
        if (this.executor.isShutdown()) {
            return;
        }
        try {
            String notification;
            Object object = this.counterSync;
            synchronized (object) {
                notification = this.notificationMessage.get();
            }
            ModelInfo newInfo = new ModelInfo(notification, this.columns);
            if (!this.info.equals(newInfo)) {
                this.info = newInfo;
                this.renderImage();
            }
        }
        finally {
            this.columns.clear();
        }
        this.send(this.image);
    }

    protected abstract void send(IBitmap var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNotificationMessage(String message) {
        Object object = this.counterSync;
        synchronized (object) {
            this.counter.set(1);
            this.notificationMessage.set(message);
        }
    }

    @Override
    public void setMidiClipElement(INoteClip clip, int quartersPerMeasure, NotePosition activePosition) {
        this.addElement(new MidiClipComponent(clip, quartersPerMeasure, activePosition));
    }

    @Override
    public IGraphicDisplay setMessage(int column, String text) {
        for (int i = 0; i < 8; ++i) {
            this.addOptionElement(column == i ? text : "", "", false, "", "", false, false);
        }
        return this;
    }

    @Override
    public void addEmptyElement() {
        this.addOptionElement("", "", false, "", "", false, false);
    }

    @Override
    public void addEmptyElement(boolean hasSmallEmptyMenu) {
        this.addOptionElement("", " ", false, "", "", false, true);
    }

    @Override
    public void addChannelSelectorElement(String topMenu, boolean isTopMenuOn, String bottomMenu, ChannelType type, ColorEx bottomMenuColor, boolean isBottomMenuOn, boolean isActive) {
        this.addElement(new ChannelSelectComponent(type, topMenu, isTopMenuOn, bottomMenu, bottomMenuColor, isBottomMenuOn, isActive));
    }

    @Override
    public void addChannelElement(String topMenu, boolean isTopMenuOn, String bottomMenu, ChannelType type, ColorEx bottomMenuColor, boolean isBottomMenuOn, int volume, int modulatedVolume, String volumeStr, int pan, int modulatedPan, String panStr, int vuLeft, int vuRight, boolean mute, boolean solo, boolean recarm, boolean isActive, int crossfadeMode, boolean isPinned) {
        this.addChannelElement(5, topMenu, isTopMenuOn, bottomMenu, type, bottomMenuColor, isBottomMenuOn, volume, modulatedVolume, volumeStr, pan, modulatedPan, panStr, vuLeft, vuRight, mute, solo, recarm, isActive, crossfadeMode, isPinned);
    }

    @Override
    public void addChannelElement(int channelType, String topMenu, boolean isTopMenuOn, String bottomMenu, ChannelType type, ColorEx bottomMenuColor, boolean isBottomMenuOn, int volume, int modulatedVolume, String volumeStr, int pan, int modulatedPan, String panStr, int vuLeft, int vuRight, boolean mute, boolean solo, boolean recarm, boolean isActive, int crossfadeMode, boolean isPinned) {
        this.addElement(new ChannelComponent(switch (channelType) {
            case 1 -> 0;
            case 2 -> 1;
            case 3 -> 2;
            default -> 3;
        }, topMenu, isTopMenuOn, bottomMenu, bottomMenuColor, isBottomMenuOn, type, volume, modulatedVolume, volumeStr, pan, modulatedPan, panStr, vuLeft, vuRight, mute, solo, recarm, isActive, crossfadeMode, isPinned));
    }

    @Override
    public void addSendsElement(String topMenu, boolean isTopMenuOn, String bottomMenu, ChannelType type, ColorEx bottomMenuColor, boolean isBottomMenuOn, SendData[] sendData, boolean isTrackMode, boolean isSendActive, boolean isChannelLabelActive) {
        this.addElement(new SendsComponent(sendData, topMenu, isTopMenuOn, bottomMenu, bottomMenuColor, isBottomMenuOn, type, isTrackMode, isSendActive, isChannelLabelActive));
    }

    @Override
    public void addParameterElement(String parameterName, int parameterValue, String parameterValueStr, boolean parameterIsActive, int parameterModulatedValue) {
        this.addParameterElement("", false, "", (ChannelType)null, ColorEx.BLACK, false, parameterName, parameterValue, parameterValueStr, parameterIsActive, parameterModulatedValue);
    }

    @Override
    public void addParameterElement(String topMenu, boolean isTopMenuOn, String bottomMenu, ChannelType type, ColorEx bottomMenuColor, boolean isBottomMenuOn, String parameterName, int parameterValue, String parameterValueStr, boolean parameterIsActive, int parameterModulatedValue) {
        this.addElement(new ParameterComponent(topMenu, isTopMenuOn, bottomMenu, type, bottomMenuColor, isBottomMenuOn, parameterName, parameterValue, parameterModulatedValue, parameterValueStr, parameterIsActive));
    }

    @Override
    public void addParameterElementWithPlainMenu(String topMenu, boolean isTopMenuOn, String bottomMenu, ColorEx bottomMenuColor, boolean isBottomMenuOn, String parameterName, int parameterValue, String parameterValueStr, boolean parameterIsActive, int parameterModulatedValue) {
        this.addElement(new ParameterComponent(topMenu, isTopMenuOn, bottomMenu, null, bottomMenuColor, isBottomMenuOn, parameterName, parameterValue, parameterModulatedValue, parameterValueStr, parameterIsActive, LabelComponent.LabelLayout.PLAIN));
    }

    @Override
    public void addParameterElement(String topMenu, boolean isTopMenuOn, String bottomMenu, String deviceName, ColorEx bottomMenuColor, boolean isBottomMenuOn, String parameterName, int parameterValue, String parameterValueStr, boolean parameterIsActive, int parameterModulatedValue) {
        this.addElement(new ParameterComponent(topMenu, isTopMenuOn, bottomMenu, deviceName, bottomMenuColor, isBottomMenuOn, parameterName, parameterValue, parameterModulatedValue, parameterValueStr, parameterIsActive));
    }

    @Override
    public void addOptionElement(String headerTopName, String menuTopName, boolean isMenuTopSelected, String headerBottomName, String menuBottomName, boolean isMenuBottomSelected, boolean useSmallTopMenu) {
        this.addOptionElement(headerTopName, menuTopName, isMenuTopSelected, null, headerBottomName, menuBottomName, isMenuBottomSelected, null, useSmallTopMenu);
    }

    @Override
    public void addOptionElement(String headerTopName, String menuTopName, boolean isMenuTopSelected, ColorEx menuTopColor, String headerBottomName, String menuBottomName, boolean isMenuBottomSelected, ColorEx menuBottomColor, boolean useSmallTopMenu) {
        this.addOptionElement(headerTopName, menuTopName, isMenuTopSelected, menuTopColor, headerBottomName, menuBottomName, isMenuBottomSelected, menuBottomColor, useSmallTopMenu, false);
    }

    @Override
    public void addOptionElement(String headerTopName, String menuTopName, boolean isMenuTopSelected, ColorEx menuTopColor, String headerBottomName, String menuBottomName, boolean isMenuBottomSelected, ColorEx menuBottomColor, boolean useSmallTopMenu, boolean isBottomHeaderSelected) {
        this.addElement(new OptionsComponent(headerTopName, menuTopName, isMenuTopSelected, menuTopColor, headerBottomName, menuBottomName, isMenuBottomSelected, menuBottomColor, useSmallTopMenu, isBottomHeaderSelected));
    }

    @Override
    public void addListElement(int displaySize, String[] elements, int selectedIndex) {
        ArrayList<Pair<String, Boolean>> menu = new ArrayList<Pair<String, Boolean>>();
        int startIndex = Math.max(0, Math.min(selectedIndex, elements.length - displaySize));
        for (int i = 0; i < displaySize; ++i) {
            int pos = startIndex + i;
            String itemName = pos < elements.length ? elements[pos] : "";
            menu.add(new Pair<String, Boolean>(itemName, pos == selectedIndex));
        }
        this.addElement(new ListComponent(menu));
    }

    @Override
    public void addListElement(String[] items, boolean[] selected) {
        ArrayList<Pair<String, Boolean>> menu = new ArrayList<Pair<String, Boolean>>();
        for (int i = 0; i < items.length; ++i) {
            menu.add(new Pair<String, Boolean>(items[i], selected[i]));
        }
        this.addElement(new ListComponent(menu));
    }

    @Override
    public void addSceneListElement(List<IScene> scenes, ChannelType type, String name, ColorEx color, boolean isSelected, boolean isActive, boolean isPinned) {
        this.addElement(new SceneListGridElement(scenes, type, name, color, isSelected, isActive, isPinned));
    }

    @Override
    public void addSlotListElement(List<Pair<ITrack, ISlot>> slots, ChannelType type, String name, ColorEx color, boolean isSelected, boolean isActive, boolean isPinned) {
        this.addElement(new ClipListComponent(slots, type, name, color, isSelected, isActive, isPinned));
    }

    @Override
    public void addElement(IComponent component) {
        this.columns.add(component);
    }

    @Override
    public void setHardwareDisplay(IHwGraphicsDisplay display) {
        this.hardwareDisplay = display;
    }

    @Override
    public IHwGraphicsDisplay getHardwareDisplay() {
        return this.hardwareDisplay;
    }

    @Override
    public IBitmap getImage() {
        return this.image;
    }

    private void renderImage() {
        this.image.render(this.configuration.isAntialiasEnabled(), gc -> {
            int width = this.dimensions.getWidth();
            int height = this.dimensions.getHeight();
            double separatorSize = this.dimensions.getSeparatorSize();
            ColorEx colorBorder = this.configuration.getColorBorder();
            gc.fillRectangle(0.0, 0.0, width, height, colorBorder);
            List<IComponent> elements = this.info.getComponents();
            int size = elements.size();
            if (size == 0) {
                return;
            }
            int gridWidth = width / size;
            double paintWidth = (double)gridWidth - separatorSize;
            double offsetX = separatorSize / 2.0;
            DefaultGraphicsInfo graphicsInfo = new DefaultGraphicsInfo(gc, this.configuration, this.dimensions);
            for (int i = 0; i < size; ++i) {
                IComponent component = elements.get(i);
                if (component == null) continue;
                component.draw(graphicsInfo.withBounds((double)(i * gridWidth) + offsetX, 0.0, paintWidth, height));
            }
            String notification = this.info.getNotification();
            if (notification == null) {
                return;
            }
            ColorEx colorText = this.configuration.getColorText();
            gc.drawTextInBounds(notification, 0.0, 0.0, width, height, Align.CENTER, colorText, ColorEx.calcContrastColor(colorText), (double)height / 4.0);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkNotificationCounter() {
        Object object = this.counterSync;
        synchronized (object) {
            int c = this.counter.get();
            if (c < 0) {
                return;
            }
            c = this.counter.decrementAndGet();
            if (c < 0) {
                this.notificationMessage.set(null);
            }
        }
    }
}

