/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.controller;

import de.mossgrabers.framework.command.core.ContinuousCommand;
import de.mossgrabers.framework.command.core.PitchbendCommand;
import de.mossgrabers.framework.command.core.TriggerCommand;
import de.mossgrabers.framework.configuration.AbstractConfiguration;
import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.configuration.ISettingsUI;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.ContinuousID;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.controller.IControllerSetup;
import de.mossgrabers.framework.controller.ISetupFactory;
import de.mossgrabers.framework.controller.OutputID;
import de.mossgrabers.framework.controller.color.ColorManager;
import de.mossgrabers.framework.controller.hardware.BindType;
import de.mossgrabers.framework.controller.hardware.IHwAbsoluteKnob;
import de.mossgrabers.framework.controller.hardware.IHwButton;
import de.mossgrabers.framework.controller.hardware.IHwContinuousControl;
import de.mossgrabers.framework.controller.hardware.IHwFader;
import de.mossgrabers.framework.controller.hardware.IHwRelativeKnob;
import de.mossgrabers.framework.controller.valuechanger.IValueChanger;
import de.mossgrabers.framework.controller.valuechanger.RelativeEncoding;
import de.mossgrabers.framework.daw.IBrowser;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.constants.Capability;
import de.mossgrabers.framework.daw.midi.IMidiInput;
import de.mossgrabers.framework.daw.midi.INoteInput;
import de.mossgrabers.framework.daw.midi.INoteRepeat;
import de.mossgrabers.framework.featuregroup.IMode;
import de.mossgrabers.framework.featuregroup.IView;
import de.mossgrabers.framework.featuregroup.ModeManager;
import de.mossgrabers.framework.featuregroup.ViewManager;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.scale.Scales;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.utils.ConsoleLogger;
import de.mossgrabers.framework.utils.IntConsumerSupplier;
import de.mossgrabers.framework.utils.TestCallback;
import de.mossgrabers.framework.utils.TestFramework;
import de.mossgrabers.framework.view.AbstractDrum64View;
import de.mossgrabers.framework.view.Views;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.IntSupplier;

public abstract class AbstractControllerSetup<S extends IControlSurface<C>, C extends Configuration>
implements IControllerSetup<S, C> {
    protected final List<S> surfaces = new ArrayList<S>();
    protected final IHost host;
    protected final ISettingsUI globalSettings;
    protected final ISettingsUI documentSettings;
    protected final ISetupFactory factory;
    protected Scales scales;
    protected IModel model;
    protected C configuration;
    protected ColorManager colorManager;
    protected IValueChanger valueChanger;
    protected Modes currentMode = null;

    protected AbstractControllerSetup(ISetupFactory factory, IHost host, ISettingsUI globalSettings, ISettingsUI documentSettings) {
        this.factory = factory;
        this.host = host;
        this.globalSettings = globalSettings;
        this.documentSettings = documentSettings;
        ConsoleLogger.init(host);
    }

    @Override
    public boolean hasSurface() {
        return !this.surfaces.isEmpty();
    }

    @Override
    public S getSurface() {
        return (S)((IControlSurface)this.surfaces.get(0));
    }

    @Override
    public List<S> getSurfaces() {
        return new ArrayList<S>(this.surfaces);
    }

    @Override
    public S getSurface(int index) {
        return (S)((IControlSurface)this.surfaces.get(index));
    }

    @Override
    public IModel getModel() {
        return this.model;
    }

    public C getConfiguration() {
        return this.configuration;
    }

    @Override
    public void init() {
        this.initConfiguration();
        this.createScales();
        this.createModel();
        this.createSurface();
        this.createModes();
        this.createObservers();
        this.createViews();
        this.registerTriggerCommands();
        this.registerContinuousCommands();
        this.layoutControls();
        if (this.model != null) {
            this.model.ensureClip();
        }
        this.configuration.notifyAllObservers();
    }

    @Override
    public void exit() {
        this.configuration.clearSettingObservers();
        for (IControlSurface surface : this.surfaces) {
            surface.shutdown();
        }
        this.host.releaseUsbDevices();
        if (this.model != null) {
            this.model.cleanup();
        }
        this.host.println("Exited.");
    }

    @Override
    public void flush() {
        try {
            for (IControlSurface surface : this.surfaces) {
                surface.flush();
            }
        }
        catch (Exception ex) {
            this.host.error("Error during flush.", ex);
        }
    }

    @Override
    public void test(TestCallback callback) {
        TestFramework framework = new TestFramework(this.host);
        this.getSurfaces().forEach(surface -> {
            framework.scheduleFunction(() -> this.host.println("Testing controller: " + this.getClass().getName()));
            ViewManager viewManager = surface.getViewManager();
            ModeManager modeManager = surface.getModeManager();
            int max = this.model.getValueChanger().getUpperBound() - 1;
            for (Views viewID : Views.values()) {
                if (viewManager.get(viewID) == null) continue;
                for (Modes modeID : Modes.values()) {
                    if (modeManager.get(modeID) == null) continue;
                    framework.scheduleFunction(() -> {
                        this.host.println("- View " + String.valueOf((Object)viewID) + " Mode " + String.valueOf((Object)modeID));
                        viewManager.setActive(viewID);
                        modeManager.setActive(modeID);
                        for (ButtonID buttonID : ButtonID.values()) {
                            IHwButton button = surface.getButton(buttonID);
                            if (button == null) continue;
                            button.trigger(ButtonEvent.DOWN);
                            button.trigger(ButtonEvent.LONG);
                            button.trigger(ButtonEvent.UP);
                        }
                        for (Enum enum_ : ContinuousID.values()) {
                            PitchbendCommand pitchbendCommand;
                            ContinuousCommand command;
                            IHwContinuousControl continuous = surface.getContinuous((ContinuousID)enum_);
                            if (continuous == null) continue;
                            TriggerCommand touchCommand = continuous.getTouchCommand();
                            if (touchCommand != null) {
                                touchCommand.execute(ButtonEvent.DOWN, 127);
                                touchCommand.execute(ButtonEvent.LONG, 127);
                                touchCommand.execute(ButtonEvent.UP, 0);
                            }
                            if ((command = continuous.getCommand()) != null) {
                                command.execute(0);
                                command.execute(max);
                                command.execute(max / 2);
                            }
                            if ((pitchbendCommand = continuous.getPitchbendCommand()) == null) continue;
                            pitchbendCommand.onPitchbend(0, 0);
                            pitchbendCommand.onPitchbend(0, 127);
                            pitchbendCommand.onPitchbend(0, 64);
                        }
                    });
                }
            }
        });
        callback.startTesting();
        framework.executeScheduler(callback);
    }

    protected void activateBrowserObserver(Modes browserMode) {
        IBrowser browser = this.model.getBrowser();
        if (browser == null) {
            return;
        }
        browser.addActiveObserver(isActive -> {
            ModeManager modeManager = this.getSurface().getModeManager();
            if (isActive.booleanValue()) {
                modeManager.setTemporary(browserMode);
            } else if (modeManager.isActive(new Modes[]{browserMode})) {
                modeManager.restore();
            }
        });
    }

    protected void activateBrowserObserver(Views browserView) {
        this.model.getBrowser().addActiveObserver(isActive -> {
            ViewManager viewManager = this.getSurface().getViewManager();
            if (isActive.booleanValue()) {
                Views previousViewId = (Views)((Object)((Object)viewManager.getPreviousID()));
                viewManager.setTemporary(browserView);
                if (viewManager.getPreviousID() == Views.SHIFT) {
                    viewManager.setPreviousID(previousViewId);
                }
            } else if (viewManager.isActive(new Views[]{browserView})) {
                viewManager.restore();
            }
        });
    }

    protected void initConfiguration() {
        this.configuration.init(this.globalSettings, this.documentSettings);
    }

    protected void createScales() {
        this.scales = new Scales(this.valueChanger, 36, 100, 8, 8);
    }

    protected abstract void createModel();

    protected abstract void createSurface();

    protected void createModes() {
    }

    protected void createViews() {
    }

    protected void createObservers() {
        if (this.configuration.canSettingBeObserved(AbstractConfiguration.KNOB_SENSITIVITY_DEFAULT)) {
            this.configuration.addSettingObserver(AbstractConfiguration.KNOB_SENSITIVITY_DEFAULT, this::updateRelativeKnobSensitivity);
            this.configuration.addSettingObserver(AbstractConfiguration.KNOB_SENSITIVITY_SLOW, this::updateRelativeKnobSensitivity);
            this.surfaces.forEach(surface -> surface.addKnobSensitivityObserver(this::updateRelativeKnobSensitivity));
        }
    }

    protected void registerTriggerCommands() {
    }

    protected void registerContinuousCommands() {
    }

    protected void layoutControls() {
    }

    protected void addButton(ButtonID buttonID, String label, TriggerCommand command, int midiControl, BooleanSupplier supplier) {
        this.addButton(buttonID, label, command, 0, midiControl, supplier);
    }

    protected void addButton(ButtonID buttonID, String label, TriggerCommand command, int midiChannel, int midiControl, BooleanSupplier supplier) {
        this.addButton(buttonID, label, command, midiChannel, midiControl, () -> supplier.getAsBoolean() ? 1 : 0, "BUTTON_STATE_ON", "BUTTON_STATE_HI");
    }

    protected void addButton(S surface, ButtonID buttonID, String label, TriggerCommand command, int midiChannel, int midiControl, BooleanSupplier supplier) {
        this.addButton(surface, buttonID, label, command, midiChannel, midiControl, () -> supplier.getAsBoolean() ? 1 : 0, "BUTTON_STATE_ON", "BUTTON_STATE_HI");
    }

    protected void addButton(ButtonID buttonID, String label, TriggerCommand command, int midiControl, BooleanSupplier supplier, String colorIdOn, String colorIdHi) {
        this.addButton(buttonID, label, command, midiControl, () -> supplier.getAsBoolean() ? 1 : 0, colorIdOn, colorIdHi);
    }

    protected void addButton(ButtonID buttonID, String label, TriggerCommand command, int midiControl) {
        this.addButton(buttonID, label, command, 0, midiControl);
    }

    protected void addButton(S surface, ButtonID buttonID, String label, TriggerCommand command, int midiControl) {
        this.addButton(surface, buttonID, label, command, 0, midiControl, (IntSupplier)null, "BUTTON_STATE_ON", "BUTTON_STATE_HI");
    }

    protected void addButton(S surface, ButtonID buttonID, String label, TriggerCommand command, int midiChannel, int midiControl) {
        this.addButton(surface, buttonID, label, command, midiChannel, midiControl, (IntSupplier)null, "BUTTON_STATE_ON", "BUTTON_STATE_HI");
    }

    protected void addButton(ButtonID buttonID, String label, TriggerCommand command, int midiChannel, int midiControl) {
        this.addButton(buttonID, label, command, midiChannel, midiControl, (IntSupplier)null, "BUTTON_STATE_ON", "BUTTON_STATE_HI");
    }

    protected void addButton(ButtonID buttonID, String label, TriggerCommand command, int midiControl, IntSupplier supplier, String ... colorIds) {
        this.addButton(0, buttonID, label, command, midiControl, supplier, colorIds);
    }

    protected void addButton(ButtonID buttonID, String label, TriggerCommand command, int midiChannel, int midiControl, IntSupplier supplier, String ... colorIds) {
        this.addButton(0, buttonID, label, command, midiChannel, midiControl, supplier, colorIds);
    }

    protected void addButton(int deviceIndex, ButtonID buttonID, String label, TriggerCommand command, int midiChannel, int midiControl, IntSupplier supplier, String ... colorIds) {
        this.addButton((IControlSurface)this.surfaces.get(deviceIndex), buttonID, label, command, midiChannel, midiControl, supplier, colorIds);
    }

    protected void addButton(int deviceIndex, ButtonID buttonID, String label, TriggerCommand command, int midiControl, IntSupplier supplier, String ... colorIds) {
        this.addButton((IControlSurface)this.surfaces.get(deviceIndex), buttonID, label, command, midiControl, supplier, colorIds);
    }

    protected void addButton(ButtonID buttonID, String label, TriggerCommand command, int midiControl, IntSupplier supplier) {
        this.addButton(0, buttonID, label, command, midiControl, supplier);
    }

    protected void addButton(ButtonID buttonID, String label, TriggerCommand command, int midiChannel, int midiControl, IntSupplier supplier) {
        this.addButton(0, buttonID, label, command, midiChannel, midiControl, supplier);
    }

    protected void addButton(int deviceIndex, ButtonID buttonID, String label, TriggerCommand command, int midiControl, IntSupplier supplier) {
        this.addButton(deviceIndex, buttonID, label, command, 0, midiControl, supplier);
    }

    protected void addButton(int deviceIndex, ButtonID buttonID, String label, TriggerCommand command, int midiChannel, int midiControl, IntSupplier supplier) {
        this.addButton((IControlSurface)this.surfaces.get(deviceIndex), buttonID, label, command, midiChannel, midiControl, supplier, new String[0]);
    }

    protected void addButton(S surface, ButtonID buttonID, String label, TriggerCommand command, int midiControl, IntSupplier supplier, String ... colorIds) {
        this.addButton(surface, buttonID, label, command, 0, midiControl, supplier, colorIds);
    }

    protected void addDummyButton(ButtonID buttonID, int midiChannel, int midiControl) {
        this.addButton(this.getSurface(), buttonID, "", null, midiChannel, midiControl, -1, false, null, new String[0]);
    }

    protected void addButton(S surface, ButtonID buttonID, String label, TriggerCommand command, int midiChannel, int midiControl, int value, IntSupplier supplier, String ... colorIds) {
        this.addButton(surface, buttonID, label, command, midiChannel, midiControl, value, true, supplier, colorIds);
    }

    protected void addButton(S surface, ButtonID buttonID, String label, TriggerCommand command, int midiChannel, int midiControl, IntSupplier supplier, String ... colorIds) {
        this.addButton(surface, buttonID, label, command, midiChannel, midiControl, -1, true, supplier, colorIds);
    }

    protected void addButton(S surface, ButtonID buttonID, String label, TriggerCommand command, int midiChannel, int midiControl, int value, boolean hasLight, IntSupplier supplier, String ... colorIds) {
        this.addButton(surface, buttonID, label, command, midiChannel, midiChannel, midiControl, value, hasLight, supplier, colorIds);
    }

    protected void addButton(S surface, ButtonID buttonID, String label, TriggerCommand command, int midiInputChannel, int midiOutputChannel, int midiControl, int value, boolean hasLight, IntSupplier supplier, String ... colorIds) {
        IHwButton button = surface.createButton(buttonID, label);
        button.bind(command);
        if (midiControl < 0) {
            return;
        }
        IMidiInput midiInput = surface.getMidiInput();
        BindType bindType = this.getTriggerBindType(buttonID);
        if (value == -1) {
            button.bind(midiInput, bindType, midiInputChannel, midiControl);
        } else {
            button.bind(midiInput, bindType, midiInputChannel, midiControl, value);
        }
        if (hasLight) {
            IntSupplier supp = supplier == null ? new ButtonPressedSupplier(this, button) : supplier;
            this.addLight(surface, null, buttonID, button, bindType, midiOutputChannel, midiControl, supp, colorIds);
        }
    }

    protected void addButtons(S surface, int startValue, int numberOfValues, ButtonID firstButtonID, String label, TriggerCommand command, int midiChannel, int midiControl, IntConsumerSupplier supplier, String ... colorIds) {
        for (int i = 0; i < numberOfValues; ++i) {
            int index = i;
            ButtonID buttonID = ButtonID.get(firstButtonID, i);
            IHwButton button = surface.createButton(buttonID, label + " " + (i + 1));
            button.bind((event, velocity) -> command.execute(event, index));
            if (midiControl < 0) continue;
            BindType bindType = this.getTriggerBindType(buttonID);
            button.bind(surface.getMidiInput(), bindType, midiChannel, midiControl, startValue + i);
            IntSupplier supp = supplier == null ? new ButtonPressedSupplier(this, button) : () -> supplier.process(index);
            this.addLight(surface, null, buttonID, button, bindType, midiChannel, midiControl, supp, colorIds);
        }
    }

    protected void addLight(S surface, OutputID outputID, int midiChannel, int midiControl, IntSupplier supplier, String ... colorIds) {
        this.addLight(surface, outputID, null, null, null, midiChannel, midiControl, supplier, colorIds);
    }

    protected void addLight(S surface, OutputID outputID, ButtonID buttonID, IHwButton button, BindType bindType, int midiChannel, int midiControl, IntSupplier supplier, String ... colorIds) {
        surface.createLight(outputID, () -> {
            int state = supplier.getAsInt();
            if (colorIds == null || colorIds.length == 0) {
                return state;
            }
            return this.colorManager.getColorIndex(state < 0 ? "BUTTON_STATE_OFF" : colorIds[state]);
        }, color -> surface.setTrigger(bindType, midiChannel, midiControl, color), state -> this.colorManager.getColor(state, buttonID), button);
    }

    protected BindType getTriggerBindType(ButtonID buttonID) {
        return BindType.CC;
    }

    protected IHwFader addFader(ContinuousID continuousID, String label, PitchbendCommand command) {
        return this.addFader(this.getSurface(), continuousID, label, command, 0);
    }

    protected IHwFader addFader(ContinuousID continuousID, String label, PitchbendCommand command, int midiChannel) {
        return this.addFader(this.getSurface(), continuousID, label, command, midiChannel);
    }

    protected IHwFader addFader(S surface, ContinuousID continuousID, String label, PitchbendCommand command, int midiChannel) {
        IHwFader fader = surface.createFader(continuousID, label, true);
        if (command != null) {
            fader.bind(command);
        }
        fader.bind(surface.getMidiInput(), BindType.PITCHBEND, midiChannel, 0);
        return fader;
    }

    protected IHwFader addFader(ContinuousID continuousID, String label, ContinuousCommand command, BindType bindType, int midiControl) {
        return this.addFader(continuousID, label, command, bindType, 0, midiControl, true);
    }

    protected IHwFader addFader(ContinuousID continuousID, String label, ContinuousCommand command, BindType bindType, int midiControl, boolean isVertical) {
        return this.addFader(continuousID, label, command, bindType, 0, midiControl, isVertical);
    }

    protected IHwFader addFader(ContinuousID continuousID, String label, ContinuousCommand command, BindType bindType, int midiChannel, int midiControl) {
        return this.addFader(this.getSurface(), continuousID, label, command, bindType, midiChannel, midiControl, true);
    }

    protected IHwFader addFader(ContinuousID continuousID, String label, ContinuousCommand command, BindType bindType, int midiChannel, int midiControl, boolean isVertical) {
        return this.addFader(this.getSurface(), continuousID, label, command, bindType, midiChannel, midiControl, isVertical);
    }

    protected IHwFader addFader(S surface, ContinuousID continuousID, String label, ContinuousCommand command, BindType bindType, int midiChannel, int midiControl) {
        return this.addFader(surface, continuousID, label, command, bindType, midiChannel, midiControl, true);
    }

    protected IHwFader addFader(S surface, ContinuousID continuousID, String label, ContinuousCommand command, BindType bindType, int midiChannel, int midiControl, boolean isVertical) {
        IHwFader fader = surface.createFader(continuousID, label, isVertical);
        fader.bind(command);
        fader.bind(surface.getMidiInput(), bindType, midiChannel, midiControl);
        return fader;
    }

    protected IHwAbsoluteKnob addAbsoluteKnob(ContinuousID continuousID, String label, ContinuousCommand command, int midiControl) {
        return this.addAbsoluteKnob(continuousID, label, command, BindType.CC, 0, midiControl);
    }

    protected IHwAbsoluteKnob addAbsoluteKnob(ContinuousID continuousID, String label, ContinuousCommand command, BindType bindType, int midiChannel, int midiControl) {
        return this.addAbsoluteKnob(this.getSurface(), continuousID, label, command, bindType, midiChannel, midiControl);
    }

    protected IHwAbsoluteKnob addAbsoluteKnob(S surface, ContinuousID continuousID, String label, ContinuousCommand command, BindType bindType, int midiChannel, int midiControl) {
        IHwAbsoluteKnob knob = surface.createAbsoluteKnob(continuousID, label);
        if (command != null) {
            knob.bind(command);
        }
        knob.bind(surface.getMidiInput(), bindType, midiChannel, midiControl);
        return knob;
    }

    protected IHwAbsoluteKnob addHiResAbsoluteKnob(S surface, ContinuousID continuousID, String label, ContinuousCommand command, int midiChannel, int midiControl) {
        IHwAbsoluteKnob knob = surface.createAbsoluteKnob(continuousID, label);
        if (command != null) {
            knob.bind(command);
        }
        knob.bindHiRes(surface.getMidiInput(), midiChannel, midiControl);
        return knob;
    }

    protected IHwRelativeKnob addRelativeKnob(ContinuousID continuousID, String label, ContinuousCommand command, int midiControl) {
        return this.addRelativeKnob(continuousID, label, command, BindType.CC, 0, midiControl, RelativeEncoding.TWOS_COMPLEMENT);
    }

    protected IHwRelativeKnob addRelativeKnob(ContinuousID continuousID, String label, ContinuousCommand command, int midiControl, RelativeEncoding encoding) {
        return this.addRelativeKnob(continuousID, label, command, BindType.CC, 0, midiControl, encoding);
    }

    protected IHwRelativeKnob addRelativeKnob(S surface, ContinuousID continuousID, String label, ContinuousCommand command, int midiControl) {
        return this.addRelativeKnob(surface, continuousID, label, command, BindType.CC, 0, midiControl, RelativeEncoding.TWOS_COMPLEMENT);
    }

    protected IHwRelativeKnob addRelativeKnob(S surface, ContinuousID continuousID, String label, ContinuousCommand command, int midiControl, RelativeEncoding encoding) {
        return this.addRelativeKnob(surface, continuousID, label, command, BindType.CC, 0, midiControl, encoding);
    }

    protected IHwRelativeKnob addRelativeKnob(ContinuousID continuousID, String label, ContinuousCommand command, BindType bindType, int midiChannel, int midiControl) {
        return this.addRelativeKnob(this.getSurface(), continuousID, label, command, bindType, midiChannel, midiControl, RelativeEncoding.TWOS_COMPLEMENT);
    }

    protected IHwRelativeKnob addRelativeKnob(ContinuousID continuousID, String label, ContinuousCommand command, BindType bindType, int midiChannel, int midiControl, RelativeEncoding encoding) {
        return this.addRelativeKnob(this.getSurface(), continuousID, label, command, bindType, midiChannel, midiControl, encoding);
    }

    protected IHwRelativeKnob addRelativeKnob(S surface, ContinuousID continuousID, String label, ContinuousCommand command, BindType bindType, int midiChannel, int midiControl, RelativeEncoding encoding) {
        IHwRelativeKnob knob = surface.createRelativeKnob(continuousID, label, encoding);
        knob.bind(command);
        knob.bind(surface.getMidiInput(), bindType, midiChannel, midiControl);
        return knob;
    }

    protected void createScaleObservers(C conf) {
        if (conf.canSettingBeObserved(AbstractConfiguration.SCALES_SCALE)) {
            conf.addSettingObserver(AbstractConfiguration.SCALES_SCALE, () -> {
                this.scales.setScaleByName(conf.getScale());
                this.updateViewNoteMapping();
            });
        }
        if (conf.canSettingBeObserved(AbstractConfiguration.SCALES_BASE)) {
            conf.addSettingObserver(AbstractConfiguration.SCALES_BASE, () -> {
                this.scales.setScaleOffsetByName(conf.getScaleBase());
                this.updateViewNoteMapping();
            });
        }
        if (conf.canSettingBeObserved(AbstractConfiguration.SCALES_IN_KEY)) {
            conf.addSettingObserver(AbstractConfiguration.SCALES_IN_KEY, () -> {
                this.scales.setChromatic(!conf.isScaleInKey());
                this.updateViewNoteMapping();
            });
        }
        if (conf.canSettingBeObserved(AbstractConfiguration.SCALES_LAYOUT)) {
            conf.addSettingObserver(AbstractConfiguration.SCALES_LAYOUT, () -> {
                this.scales.setScaleLayoutByName(conf.getScaleLayout());
                this.updateViewNoteMapping();
            });
        }
    }

    protected void createNoteRepeatObservers(C conf, S surface) {
        INoteInput defaultNoteInput = surface.getMidiInput().getDefaultNoteInput();
        if (defaultNoteInput == null) {
            return;
        }
        INoteRepeat noteRepeat = defaultNoteInput.getNoteRepeat();
        conf.addSettingObserver(AbstractConfiguration.NOTEREPEAT_ACTIVE, () -> noteRepeat.setActive(conf.isNoteRepeatActive()));
        conf.addSettingObserver(AbstractConfiguration.NOTEREPEAT_PERIOD, () -> noteRepeat.setPeriod(conf.getNoteRepeatPeriod().getValue()));
        if (this.host.supports(Capability.NOTE_REPEAT_LENGTH)) {
            conf.addSettingObserver(AbstractConfiguration.NOTEREPEAT_LENGTH, () -> noteRepeat.setNoteLength(conf.getNoteRepeatLength().getValue()));
        }
        if (this.host.supports(Capability.NOTE_REPEAT_MODE)) {
            conf.addSettingObserver(AbstractConfiguration.NOTEREPEAT_MODE, () -> noteRepeat.setMode(conf.getNoteRepeatMode()));
        }
        if (this.host.supports(Capability.NOTE_REPEAT_OCTAVES)) {
            conf.addSettingObserver(AbstractConfiguration.NOTEREPEAT_OCTAVE, () -> noteRepeat.setOctaves(conf.getNoteRepeatOctave()));
        }
    }

    protected void updateViewNoteMapping() {
        for (IControlSurface surface : this.surfaces) {
            IView view = (IView)surface.getViewManager().getActive();
            if (view == null) continue;
            view.updateNoteMapping();
        }
    }

    protected boolean isRecordShifted(S surface) {
        boolean isShift = surface.isShiftPressed();
        boolean isFlipRecord = this.configuration.isFlipRecord();
        return isShift && !isFlipRecord || !isShift && isFlipRecord;
    }

    protected int getModeColor(ButtonID buttonID) {
        return this.getModeColor(this.getSurface().getModeManager(), buttonID);
    }

    protected int getModeColor(ModeManager modeManager, ButtonID buttonID) {
        IMode mode = (IMode)modeManager.getActive();
        return mode == null ? 0 : mode.getButtonColor(buttonID);
    }

    protected int getButtonColorFromActiveView(ButtonID buttonID) {
        IView view = (IView)this.getSurface().getViewManager().getActive();
        return view == null ? 0 : view.getButtonColor(buttonID);
    }

    protected void updateRelativeKnobSensitivity() {
        this.surfaces.forEach(surface -> {
            int knobSensitivity = surface.isKnobSensitivitySlow() ? this.configuration.getKnobSensitivitySlow() : this.configuration.getKnobSensitivityDefault();
            this.valueChanger.setSensitivity(knobSensitivity);
            surface.getRelativeKnobs().forEach(knob -> {
                if (knob.shouldAdaptSensitivity()) {
                    knob.setSensitivity(knobSensitivity);
                }
            });
        });
    }

    protected int getButtonColor(S surface, ButtonID buttonID) {
        IMode mode = (IMode)surface.getModeManager().getActive();
        return mode == null ? 0 : mode.getButtonColor(buttonID);
    }

    protected void handleTrackChange(boolean isSelected) {
        if (!isSelected) {
            return;
        }
        this.updateView();
        this.updateMode();
    }

    protected void updateView() {
        this.recallLastView();
        this.resetDrumOctave();
    }

    protected void resetDrumOctave() {
        ViewManager viewManager = this.getSurface().getViewManager();
        IView activeView = (IView)viewManager.getActive();
        if (viewManager.isActive(new Views[]{Views.DRUM, Views.PLAY})) {
            activeView.updateNoteMapping();
        } else if (activeView instanceof AbstractDrum64View) {
            AbstractDrum64View drum64View = (AbstractDrum64View)activeView;
            drum64View.resetOctave();
        }
    }

    protected void recallLastView() {
        S surface = this.getSurface();
        if (!surface.getViewManager().isActive(new Views[]{Views.SESSION, Views.MIX})) {
            surface.recallPreferredView(this.model.getCursorTrack());
        }
    }

    protected void updateMode() {
        ModeManager modeManager = this.getSurface().getModeManager();
        if (modeManager.isActive(new Modes[]{Modes.MASTER}) && !this.model.getMasterTrack().isSelected()) {
            if (Modes.isTrackMode((Modes)((Object)modeManager.getPreviousID()))) {
                modeManager.restore();
            } else {
                modeManager.setActive(Modes.TRACK);
            }
        }
    }

    private class ButtonPressedSupplier
    implements IntSupplier {
        private final IHwButton button;

        ButtonPressedSupplier(AbstractControllerSetup abstractControllerSetup, IHwButton button) {
            this.button = button;
        }

        @Override
        public int getAsInt() {
            return this.button.isPressed() ? 1 : 0;
        }
    }
}

