/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.command.trigger.view;

import de.mossgrabers.framework.command.core.AbstractTriggerCommand;
import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.featuregroup.IView;
import de.mossgrabers.framework.featuregroup.ViewManager;
import de.mossgrabers.framework.utils.ButtonEvent;

public class ViewButtonCommand<S extends IControlSurface<C>, C extends Configuration>
extends AbstractTriggerCommand<S, C> {
    protected final ViewManager viewManager;
    protected ButtonID buttonID;

    public ViewButtonCommand(ButtonID buttonID, S surface) {
        this(buttonID, null, surface);
    }

    public ViewButtonCommand(ButtonID buttonID, IModel model, S surface) {
        super(model, surface);
        this.buttonID = buttonID;
        this.viewManager = this.surface.getViewManager();
    }

    @Override
    public void execute(ButtonEvent event, int velocity) {
        IView view = (IView)this.viewManager.getActive();
        if (view != null) {
            view.onButton(this.buttonID, event, velocity);
        }
    }
}

