/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.command.trigger.transport;

import de.mossgrabers.framework.command.trigger.AbstractDoubleTriggerCommand;
import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.ITransport;
import de.mossgrabers.framework.utils.ButtonEvent;

public class PlayCommand<S extends IControlSurface<C>, C extends Configuration>
extends AbstractDoubleTriggerCommand<S, C> {
    protected final ButtonID selectButtonID;
    protected final ITransport transport;

    public PlayCommand(IModel model, S surface) {
        this(model, surface, ButtonID.SELECT);
    }

    public PlayCommand(IModel model, S surface, ButtonID selectButtonID) {
        super(model, surface);
        this.selectButtonID = selectButtonID;
        this.transport = this.model.getTransport();
    }

    @Override
    protected void executeSingleClick() {
        switch (this.surface.getConfiguration().getBehaviourOnPause()) {
            case RETURN_TO_ZERO: {
                if (this.transport.isPlaying()) {
                    this.transport.stopAndRewind();
                    break;
                }
                this.transport.play();
                break;
            }
            case STOP: {
                if (this.transport.isPlaying()) {
                    this.transport.stop();
                } else {
                    this.transport.play();
                }
                this.doubleClickTest();
                break;
            }
            case PAUSE: {
                this.transport.play();
                this.doubleClickTest();
            }
        }
    }

    @Override
    protected void executeDoubleClick() {
        this.transport.stopAndRewind();
    }

    @Override
    protected boolean handleButtonCombinations() {
        if (this.surface.isPressed(this.selectButtonID)) {
            this.surface.setTriggerConsumed(this.selectButtonID);
            this.transport.togglePunchIn();
            return true;
        }
        return false;
    }

    @Override
    public void executeShifted(ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        if (this.surface.isPressed(this.selectButtonID)) {
            this.surface.setTriggerConsumed(this.selectButtonID);
            this.transport.togglePunchOut();
        } else {
            this.executeShifted();
        }
    }

    protected void executeShifted() {
        this.transport.toggleLoop();
    }
}

