/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.command.trigger.transport;

import de.mossgrabers.framework.command.core.AbstractTriggerCommand;
import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.utils.ButtonEvent;

public class MetronomeCommand<S extends IControlSurface<C>, C extends Configuration>
extends AbstractTriggerCommand<S, C> {
    private final boolean tapWithShift;

    public MetronomeCommand(IModel model, S surface, boolean tapWithShift) {
        super(model, surface);
        this.tapWithShift = tapWithShift;
    }

    @Override
    public void executeNormal(ButtonEvent event) {
        if (event == ButtonEvent.UP) {
            this.model.getTransport().toggleMetronome();
        }
    }

    @Override
    public void executeShifted(ButtonEvent event) {
        if (event != ButtonEvent.UP) {
            return;
        }
        if (this.tapWithShift) {
            this.model.getTransport().tapTempo();
        } else {
            this.model.getTransport().toggleMetronomeTicks();
        }
    }
}

