/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.command.continuous;

import de.mossgrabers.framework.command.continuous.PlayPositionCommand;
import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.controller.valuechanger.IValueChanger;
import de.mossgrabers.framework.daw.IBrowser;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.parameter.IFocusedParameter;
import java.util.Optional;

public class JogWheelCommand<S extends IControlSurface<C>, C extends Configuration>
extends PlayPositionCommand<S, C> {
    private boolean controlLastParamActive = false;

    public JogWheelCommand(IModel model, S surface) {
        super(model, surface);
    }

    public void toggleControlLastParamActive() {
        this.controlLastParamActive = !this.controlLastParamActive;
    }

    public void setControlLastParamActive(boolean active) {
        this.controlLastParamActive = active;
    }

    public boolean isControlLastParamActive() {
        return this.controlLastParamActive;
    }

    @Override
    public void execute(int value) {
        IValueChanger valueChanger = this.model.getValueChanger();
        if (this.controlLastParamActive) {
            Optional<IFocusedParameter> parameterOpt = this.model.getFocusedParameter();
            if (parameterOpt.isPresent() && parameterOpt.get().doesExist()) {
                double increment = valueChanger.calcKnobChange(value);
                parameterOpt.get().inc(increment *= this.surface.isShiftPressed() ? 10.0 : 50.0);
            }
            return;
        }
        boolean increase = valueChanger.isIncrease(value);
        IBrowser browser = this.model.getBrowser();
        if (browser.isActive()) {
            if (increase) {
                browser.selectNextResult();
            } else {
                browser.selectPreviousResult();
            }
            return;
        }
        if (this.surface.isPressed(ButtonID.SELECT)) {
            this.model.getTransport().changeTempo(increase, this.surface.isKnobSensitivitySlow());
            return;
        }
        if (this.surface.isPressed(ButtonID.CONTROL)) {
            this.model.getTransport().changeLoopStart(increase, this.surface.isKnobSensitivitySlow());
            return;
        }
        if (this.surface.isPressed(ButtonID.ALT)) {
            this.model.getTransport().changeLoopLength(increase, this.surface.isKnobSensitivitySlow());
            return;
        }
        if (this.surface.isPressed(ButtonID.ARROW_LEFT) || this.surface.isPressed(ButtonID.ARROW_RIGHT)) {
            this.surface.setTriggerConsumed(ButtonID.ARROW_LEFT);
            this.surface.setTriggerConsumed(ButtonID.ARROW_RIGHT);
            if (increase) {
                this.model.getApplication().zoomIn();
            } else {
                this.model.getApplication().zoomOut();
            }
            return;
        }
        if (this.surface.isPressed(ButtonID.ARROW_UP) || this.surface.isPressed(ButtonID.ARROW_DOWN)) {
            this.surface.setTriggerConsumed(ButtonID.ARROW_UP);
            this.surface.setTriggerConsumed(ButtonID.ARROW_DOWN);
            if (increase) {
                this.model.getApplication().incTrackHeight();
            } else {
                this.model.getApplication().decTrackHeight();
            }
            return;
        }
        super.execute(value);
    }
}

