/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.yaeltex.turn;

import de.mossgrabers.controller.yaeltex.turn.YaeltexTurnConfiguration;
import de.mossgrabers.controller.yaeltex.turn.command.trigger.YaeltexTurnModeCursorCommand;
import de.mossgrabers.controller.yaeltex.turn.command.trigger.YaeltexTurnRecordCommand;
import de.mossgrabers.controller.yaeltex.turn.command.trigger.YaeltexTurnTapTempoCommand;
import de.mossgrabers.controller.yaeltex.turn.controller.YaeltexTurnColorManager;
import de.mossgrabers.controller.yaeltex.turn.controller.YaeltexTurnControlSurface;
import de.mossgrabers.controller.yaeltex.turn.mode.YaeltexTurnDrumMixMode;
import de.mossgrabers.controller.yaeltex.turn.mode.YaeltexTurnDrumSeqMode;
import de.mossgrabers.controller.yaeltex.turn.mode.YaeltexTurnNoteSeqMode;
import de.mossgrabers.controller.yaeltex.turn.mode.YaeltexTurnTrackMixMode;
import de.mossgrabers.controller.yaeltex.turn.view.DrumView;
import de.mossgrabers.controller.yaeltex.turn.view.MonophonicSequencerView;
import de.mossgrabers.controller.yaeltex.turn.view.SessionView;
import de.mossgrabers.framework.command.TempoCommand;
import de.mossgrabers.framework.command.core.NopCommand;
import de.mossgrabers.framework.command.core.TriggerCommand;
import de.mossgrabers.framework.command.trigger.Direction;
import de.mossgrabers.framework.command.trigger.ShiftCommand;
import de.mossgrabers.framework.command.trigger.application.OverdubCommand;
import de.mossgrabers.framework.command.trigger.mode.ButtonRowModeCommand;
import de.mossgrabers.framework.command.trigger.mode.ModeSelectCommand;
import de.mossgrabers.framework.command.trigger.transport.PlayCommand;
import de.mossgrabers.framework.command.trigger.transport.StopCommand;
import de.mossgrabers.framework.command.trigger.transport.ToggleLoopCommand;
import de.mossgrabers.framework.configuration.ISettingsUI;
import de.mossgrabers.framework.controller.AbstractControllerSetup;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.ContinuousID;
import de.mossgrabers.framework.controller.ISetupFactory;
import de.mossgrabers.framework.controller.hardware.BindType;
import de.mossgrabers.framework.controller.valuechanger.TwosComplementValueChanger;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.ITransport;
import de.mossgrabers.framework.daw.ModelSetup;
import de.mossgrabers.framework.daw.constants.DeviceID;
import de.mossgrabers.framework.daw.data.bank.ITrackBank;
import de.mossgrabers.framework.daw.midi.IMidiAccess;
import de.mossgrabers.framework.daw.midi.IMidiInput;
import de.mossgrabers.framework.daw.midi.IMidiOutput;
import de.mossgrabers.framework.featuregroup.IMode;
import de.mossgrabers.framework.featuregroup.IView;
import de.mossgrabers.framework.featuregroup.ModeManager;
import de.mossgrabers.framework.featuregroup.ViewManager;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.mode.track.TrackVolumeMode;
import de.mossgrabers.framework.scale.Scales;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.ScenePlayView;
import de.mossgrabers.framework.view.Views;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.IntSupplier;

public class YaeltexTurnControllerSetup
extends AbstractControllerSetup<YaeltexTurnControlSurface, YaeltexTurnConfiguration> {
    private static final List<ContinuousID> CONTINUOUS_CONTROLS = new ArrayList<ContinuousID>();
    private Views sessionView = Views.SESSION;

    public YaeltexTurnControllerSetup(IHost host, ISetupFactory factory, ISettingsUI globalSettings, ISettingsUI documentSettings) {
        super(factory, host, globalSettings, documentSettings);
        this.colorManager = new YaeltexTurnColorManager(host);
        this.valueChanger = new TwosComplementValueChanger(128, 1);
        this.configuration = new YaeltexTurnConfiguration(host, this.valueChanger, factory.getArpeggiatorModes());
    }

    @Override
    protected void createScales() {
        this.scales = new Scales(this.valueChanger, 36, 68, 8, 4);
        this.scales.setDrumDefaultOffset(8);
    }

    @Override
    protected void createModel() {
        ModelSetup ms = new ModelSetup();
        ms.setHasFlatTrackList(true);
        ms.setHasFullFlatTrackList(((YaeltexTurnConfiguration)this.configuration).areMasterTracksIncluded());
        ms.setNumScenes(4);
        ms.setNumSends(2);
        ms.setNumDrumPadLayers(8);
        ms.setNumDevicesInBank(16);
        ms.setNumParamPages(16);
        ms.enableDevice(DeviceID.EQ);
        ms.enableDevice(DeviceID.FIRST_INSTRUMENT);
        this.model = this.factory.createModel(this.configuration, this.colorManager, this.valueChanger, this.scales, ms);
        ITrackBank trackBank = this.model.getTrackBank();
        trackBank.setIndication(true);
        trackBank.addSelectionObserver((index, isSelected) -> this.handleTrackChange(isSelected));
    }

    @Override
    protected void createSurface() {
        IMidiAccess midiAccess = this.factory.createMidiAccess();
        IMidiOutput output = midiAccess.createOutput();
        IMidiInput input = midiAccess.createInput("Pads", "80????", "90????", "B040??");
        YaeltexTurnControlSurface surface = new YaeltexTurnControlSurface(this.host, this.colorManager, (YaeltexTurnConfiguration)this.configuration, output, input);
        this.surfaces.add(surface);
    }

    @Override
    protected void createObservers() {
        super.createObservers();
        ((YaeltexTurnConfiguration)this.configuration).registerDeactivatedItemsHandler(this.model);
        this.createScaleObservers((YaeltexTurnConfiguration)this.configuration);
        this.createNoteRepeatObservers((YaeltexTurnConfiguration)this.configuration, (YaeltexTurnControlSurface)this.getSurface());
    }

    @Override
    protected void createModes() {
        YaeltexTurnControlSurface surface = (YaeltexTurnControlSurface)this.getSurface();
        ModeManager modeManager = surface.getModeManager();
        modeManager.register(Modes.TRACK, new YaeltexTurnTrackMixMode(surface, this.model, CONTINUOUS_CONTROLS));
        modeManager.register(Modes.NOTE_SEQUENCER, new YaeltexTurnNoteSeqMode(surface, this.model, CONTINUOUS_CONTROLS));
        modeManager.register(Modes.DEVICE_LAYER, new YaeltexTurnDrumMixMode(surface, this.model, CONTINUOUS_CONTROLS));
        modeManager.register(Modes.DRUM_SEQUENCER, new YaeltexTurnDrumSeqMode(surface, this.model, CONTINUOUS_CONTROLS));
    }

    @Override
    protected void createViews() {
        YaeltexTurnControlSurface surface = (YaeltexTurnControlSurface)this.getSurface();
        ViewManager viewManager = surface.getViewManager();
        viewManager.register(Views.SESSION, new SessionView(surface, this.model));
        viewManager.register(Views.SCENE_PLAY, new ScenePlayView(surface, this.model));
        viewManager.register(Views.SEQUENCER, new MonophonicSequencerView(surface, this.model));
        viewManager.register(Views.DRUM, new DrumView(surface, this.model));
    }

    @Override
    protected void registerTriggerCommands() {
        YaeltexTurnControlSurface surface = (YaeltexTurnControlSurface)this.getSurface();
        ModeManager modeManager = surface.getModeManager();
        ViewManager viewManager = surface.getViewManager();
        ITransport t = this.model.getTransport();
        int channel = 15;
        ColorIntensity shiftIntensity = new ColorIntensity(this, () -> surface.isPressed(ButtonID.SHIFT), "BUTTON_STATE_SHIFT");
        ColorIntensity selectIntensity = new ColorIntensity(this, () -> surface.isPressed(ButtonID.SELECT), "BUTTON_STATE_SELECT");
        this.addButton(ButtonID.SHIFT, "shift", new ShiftCommand(this.model, surface), 15, 15, (IntSupplier)shiftIntensity);
        this.addButton(ButtonID.SELECT, "select", (TriggerCommand)NopCommand.INSTANCE, 15, 14, (IntSupplier)selectIntensity);
        ColorIntensity clipIntensity = new ColorIntensity(this, () -> viewManager.isActive(new Views[]{Views.SEQUENCER, Views.DRUM}), "BUTTON_STATE_SESSION");
        ColorIntensity sessionIntensity = new ColorIntensity(this, () -> viewManager.isActive(new Views[]{Views.SCENE_PLAY}), "BUTTON_STATE_SESSION");
        this.addButton(ButtonID.CLIP, "clips", (ButtonEvent event, int velocity) -> this.toggleSequencer(event), 15, 8, (IntSupplier)clipIntensity);
        this.addButton(ButtonID.SESSION, "session", (ButtonEvent event, int velocity) -> this.toggleSession(event), 15, 0, (IntSupplier)sessionIntensity);
        this.addButton(ButtonID.USER, "usr", new ModeSelectCommand(this.model, surface, Modes.DEVICE_LAYER), 15, 9);
        this.addButton(ButtonID.TRACK, "trk", (ButtonEvent event, int velocity) -> this.toggleTrackAndLayer(event), 15, 1, () -> modeManager.isActive(new Modes[]{Modes.TRACK, Modes.NOTE_SEQUENCER}) ? 1 : 0, "BUTTON_STATE_TRACK", "BUTTON_STATE_LAYER");
        OverdubCommand overdubCommand = new OverdubCommand(this.model, surface);
        YaeltexTurnRecordCommand recordCommand = new YaeltexTurnRecordCommand(this.model, surface);
        ColorIntensity playIntensity = new ColorIntensity(this, t::isPlaying, "BUTTON_STATE_PLAY");
        ColorIntensity stopIntensity = new ColorIntensity(this, () -> !t.isPlaying(), "BUTTON_STATE_STOP");
        ColorIntensity recIntensity = new ColorIntensity(this, recordCommand::isActive, "BUTTON_STATE_REC");
        ColorIntensity overdubIntensity = new ColorIntensity(this, overdubCommand::isActive, "BUTTON_STATE_OVERDUB");
        ColorIntensity loopIntensity = new ColorIntensity(this, t::isLoop, "BUTTON_STATE_LOOP");
        ColorIntensity tapTempoIntensity = new ColorIntensity(this, () -> surface.isPressed(ButtonID.TAP_TEMPO), "BUTTON_STATE_TAP_TEMPO");
        this.addButton(ButtonID.PLAY, "play", new PlayCommand(this.model, surface), 15, 10, (IntSupplier)playIntensity);
        this.addButton(ButtonID.STOP, "stop", new StopCommand(this.model, surface), 15, 2, (IntSupplier)stopIntensity);
        this.addButton(ButtonID.RECORD, "rec", (TriggerCommand)recordCommand, 15, 11, (IntSupplier)recIntensity);
        this.addButton(ButtonID.OVERDUB, "overdub", overdubCommand, 15, 3, (IntSupplier)overdubIntensity);
        this.addButton(ButtonID.LOOP, "loop", new ToggleLoopCommand(this.model, surface), 15, 12, (IntSupplier)loopIntensity);
        this.addButton(ButtonID.TAP_TEMPO, "tap tempo", (TriggerCommand)new YaeltexTurnTapTempoCommand(this.model, surface), 15, 4, (IntSupplier)tapTempoIntensity);
        YaeltexTurnModeCursorCommand leftCommand = new YaeltexTurnModeCursorCommand(Direction.LEFT, this.model, surface);
        YaeltexTurnModeCursorCommand rightCommand = new YaeltexTurnModeCursorCommand(Direction.RIGHT, this.model, surface);
        YaeltexTurnModeCursorCommand upCommand = new YaeltexTurnModeCursorCommand(Direction.UP, this.model, surface);
        YaeltexTurnModeCursorCommand downCommand = new YaeltexTurnModeCursorCommand(Direction.DOWN, this.model, surface);
        ColorIntensity leftIntensity = new ColorIntensity(this, leftCommand::canScroll, "BUTTON_STATE_ARROW");
        ColorIntensity rightIntensity = new ColorIntensity(this, rightCommand::canScroll, "BUTTON_STATE_ARROW");
        ColorIntensity upIntensity = new ColorIntensity(this, upCommand::canScroll, "BUTTON_STATE_ARROW");
        ColorIntensity downIntensity = new ColorIntensity(this, downCommand::canScroll, "BUTTON_STATE_ARROW");
        this.addButton(ButtonID.ARROW_LEFT, "Left", (TriggerCommand)leftCommand, 15, 13, (IntSupplier)leftIntensity);
        this.addButton(ButtonID.ARROW_RIGHT, "Right", (TriggerCommand)rightCommand, 15, 5, (IntSupplier)rightIntensity);
        this.addButton(ButtonID.ARROW_UP, "Up", (TriggerCommand)upCommand, 15, 6, (IntSupplier)upIntensity);
        this.addButton(ButtonID.ARROW_DOWN, "Down", (TriggerCommand)downCommand, 15, 7, (IntSupplier)downIntensity);
        for (int i = 0; i < 8; ++i) {
            int number = i + 1;
            int midiID = 70 + i * 2;
            ButtonID crossfadeButtonID = ButtonID.get(ButtonID.ROW1_1, i);
            this.addButton(crossfadeButtonID, "A|B " + number, new ButtonRowModeCommand(0, i, this.model, surface), 15, midiID, () -> this.getModeColor(crossfadeButtonID));
            ButtonID stopButtonID = ButtonID.get(ButtonID.ROW2_1, i);
            this.addButton(stopButtonID, "Stop " + number, new ButtonRowModeCommand(1, i, this.model, surface), 15, midiID + 1, () -> this.getModeColor(stopButtonID));
            midiID = 86 + i * 2;
            ButtonID armButtonID = ButtonID.get(ButtonID.ROW3_1, i);
            this.addButton(armButtonID, "Arm " + number, new ButtonRowModeCommand(2, i, this.model, surface), 15, midiID, () -> this.getModeColor(armButtonID));
            ButtonID soloButtonID = ButtonID.get(ButtonID.ROW4_1, i);
            this.addButton(soloButtonID, "Solo " + number, new ButtonRowModeCommand(3, i, this.model, surface), 15, midiID + 1, () -> this.getModeColor(soloButtonID));
            ButtonID muteButtonID = ButtonID.get(ButtonID.ROW5_1, i);
            this.addButton(muteButtonID, "Mute " + number, new ButtonRowModeCommand(4, i, this.model, surface), 15, 102 + i, () -> this.getModeColor(muteButtonID));
            ButtonID selectButtonID = ButtonID.get(ButtonID.ROW6_1, i);
            this.addButton(selectButtonID, "Select " + number, new ButtonRowModeCommand(5, i, this.model, surface), 15, 110 + i, () -> this.getModeColor(selectButtonID));
        }
    }

    @Override
    protected void registerContinuousCommands() {
        YaeltexTurnControlSurface surface = (YaeltexTurnControlSurface)this.getSurface();
        ITransport transport = this.model.getTransport();
        this.addFader(ContinuousID.TEMPO, "Tempo", new TempoCommand(this.model, surface, 60, 188), BindType.CC, 15, 72);
        this.addFader(ContinuousID.CROSSFADER, "A|B", null, BindType.CC, 15, 73, false).bind(transport.getCrossfadeParameter());
        this.addFader(ContinuousID.CUE, "Cue", null, BindType.CC, 15, 74).bind(this.model.getProject().getCueVolumeParameter());
        this.addFader(ContinuousID.FADER_MASTER, "Master", null, BindType.CC, 15, 75).bind(this.model.getMasterTrack().getVolumeParameter());
        for (int i = 0; i < 8; ++i) {
            int number = i + 1;
            ContinuousID continuousID = ContinuousID.get(ContinuousID.PAN_KNOB1, i);
            this.addRelativeKnob(continuousID, "Pan Knob " + number, null, BindType.CC, 15, 0 + i).setIndexInGroup(i);
            continuousID = ContinuousID.get(ContinuousID.SEND1_KNOB1, i);
            this.addRelativeKnob(continuousID, "Send 1 Knob " + number, null, BindType.CC, 15, 8 + i).setIndexInGroup(i);
            continuousID = ContinuousID.get(ContinuousID.SEND2_KNOB1, i);
            this.addRelativeKnob(continuousID, "Send 2 Knob " + number, null, BindType.CC, 15, 16 + i).setIndexInGroup(i);
            continuousID = ContinuousID.get(ContinuousID.DEVICE_KNOB1, i);
            this.addRelativeKnob(continuousID, "Device Knob " + number, null, BindType.CC, 15, 24 + i).setIndexInGroup(i);
            continuousID = ContinuousID.get(ContinuousID.EQ_TYPE_KNOB1, i);
            this.addAbsoluteKnob(continuousID, "EQ Type Knob " + number, null, BindType.CC, 15, 32 + i).setIndexInGroup(i);
            continuousID = ContinuousID.get(ContinuousID.EQ_Q_KNOB1, i);
            this.addAbsoluteKnob(continuousID, "EQ Q Knob " + number, null, BindType.CC, 15, 40 + i).setIndexInGroup(i);
            continuousID = ContinuousID.get(ContinuousID.EQ_FREQUENCY_KNOB1, i);
            this.addAbsoluteKnob(continuousID, "EQ Frequency Knob " + number, null, BindType.CC, 15, 48 + i).setIndexInGroup(i);
            continuousID = ContinuousID.get(ContinuousID.EQ_GAIN_KNOB1, i);
            this.addAbsoluteKnob(continuousID, "EQ Gain Knob " + number, null, BindType.CC, 15, 56 + i).setIndexInGroup(i);
            continuousID = ContinuousID.get(ContinuousID.FADER1, i);
            this.addFader(continuousID, "Fader " + number, null, BindType.CC, 15, 64 + i).setIndexInGroup(i);
        }
        new TrackVolumeMode(surface, this.model, true, ContinuousID.createSequentialList(ContinuousID.FADER1, 8)).onActivate();
    }

    @Override
    protected void layoutControls() {
        YaeltexTurnControlSurface surface = (YaeltexTurnControlSurface)this.getSurface();
        surface.getButton(ButtonID.PAD1).setBounds(24.75, 288.0, 51.25, 22.5);
        surface.getButton(ButtonID.PAD2).setBounds(99.0, 287.5, 51.25, 22.5);
        surface.getButton(ButtonID.PAD3).setBounds(173.5, 287.5, 51.25, 22.5);
        surface.getButton(ButtonID.PAD4).setBounds(247.75, 287.5, 51.25, 22.5);
        surface.getButton(ButtonID.PAD5).setBounds(322.0, 287.5, 51.25, 22.5);
        surface.getButton(ButtonID.PAD6).setBounds(396.5, 287.5, 51.25, 22.5);
        surface.getButton(ButtonID.PAD7).setBounds(470.75, 287.5, 51.25, 22.5);
        surface.getButton(ButtonID.PAD8).setBounds(545.0, 287.5, 51.25, 22.5);
        surface.getButton(ButtonID.PAD9).setBounds(24.75, 215.0, 51.25, 22.5);
        surface.getButton(ButtonID.PAD10).setBounds(99.0, 214.5, 51.25, 22.5);
        surface.getButton(ButtonID.PAD11).setBounds(173.0, 214.5, 51.25, 22.5);
        surface.getButton(ButtonID.PAD12).setBounds(247.25, 214.5, 51.25, 22.5);
        surface.getButton(ButtonID.PAD13).setBounds(321.25, 214.5, 51.25, 22.5);
        surface.getButton(ButtonID.PAD14).setBounds(395.5, 214.5, 51.25, 22.5);
        surface.getButton(ButtonID.PAD15).setBounds(469.5, 214.5, 51.25, 22.5);
        surface.getButton(ButtonID.PAD16).setBounds(543.75, 214.5, 51.25, 22.5);
        surface.getButton(ButtonID.PAD17).setBounds(24.75, 138.5, 51.25, 22.5);
        surface.getButton(ButtonID.PAD18).setBounds(98.75, 138.0, 51.25, 22.5);
        surface.getButton(ButtonID.PAD19).setBounds(172.5, 138.0, 51.25, 22.5);
        surface.getButton(ButtonID.PAD20).setBounds(246.5, 138.0, 51.25, 22.5);
        surface.getButton(ButtonID.PAD21).setBounds(320.5, 138.0, 51.25, 22.5);
        surface.getButton(ButtonID.PAD22).setBounds(394.25, 138.0, 51.25, 22.5);
        surface.getButton(ButtonID.PAD23).setBounds(468.25, 138.0, 51.25, 22.5);
        surface.getButton(ButtonID.PAD24).setBounds(542.25, 138.0, 51.25, 22.5);
        surface.getButton(ButtonID.PAD25).setBounds(23.25, 64.25, 51.25, 22.5);
        surface.getButton(ButtonID.PAD26).setBounds(97.5, 63.75, 51.25, 22.5);
        surface.getButton(ButtonID.PAD27).setBounds(172.0, 63.75, 51.25, 22.5);
        surface.getButton(ButtonID.PAD28).setBounds(246.25, 63.75, 51.25, 22.5);
        surface.getButton(ButtonID.PAD29).setBounds(320.5, 63.75, 51.25, 22.5);
        surface.getButton(ButtonID.PAD30).setBounds(395.0, 63.75, 51.25, 22.5);
        surface.getButton(ButtonID.PAD31).setBounds(469.25, 63.75, 51.25, 22.5);
        surface.getButton(ButtonID.PAD32).setBounds(543.5, 63.75, 51.25, 22.5);
        surface.getButton(ButtonID.SHIFT).setBounds(633.5, 812.5, 20.25, 22.75);
        surface.getButton(ButtonID.SELECT).setBounds(633.5, 783.75, 20.25, 22.75);
        surface.getButton(ButtonID.CLIP).setBounds(633.5, 608.75, 20.25, 22.75);
        surface.getButton(ButtonID.SESSION).setBounds(663.0, 608.75, 20.25, 22.75);
        surface.getButton(ButtonID.USER).setBounds(633.5, 637.75, 20.25, 22.75);
        surface.getButton(ButtonID.TRACK).setBounds(663.0, 637.75, 20.25, 22.75);
        surface.getButton(ButtonID.PLAY).setBounds(633.5, 665.25, 20.25, 22.75);
        surface.getButton(ButtonID.STOP).setBounds(663.0, 665.25, 20.25, 22.75);
        surface.getButton(ButtonID.RECORD).setBounds(633.5, 695.75, 20.25, 22.75);
        surface.getButton(ButtonID.OVERDUB).setBounds(663.0, 695.75, 20.25, 22.75);
        surface.getButton(ButtonID.LOOP).setBounds(633.5, 726.0, 20.25, 22.75);
        surface.getButton(ButtonID.TAP_TEMPO).setBounds(663.0, 726.0, 20.25, 22.75);
        surface.getButton(ButtonID.ARROW_LEFT).setBounds(633.5, 754.5, 20.25, 22.75);
        surface.getButton(ButtonID.ARROW_RIGHT).setBounds(663.0, 754.5, 20.25, 22.75);
        surface.getButton(ButtonID.ARROW_UP).setBounds(663.0, 783.75, 20.25, 22.75);
        surface.getButton(ButtonID.ARROW_DOWN).setBounds(663.0, 812.5, 20.25, 22.75);
        surface.getButton(ButtonID.ROW1_1).setBounds(12.0, 603.75, 31.25, 27.75);
        surface.getButton(ButtonID.ROW2_1).setBounds(49.25, 603.75, 31.25, 27.75);
        surface.getButton(ButtonID.ROW3_1).setBounds(12.5, 641.75, 31.25, 27.75);
        surface.getButton(ButtonID.ROW4_1).setBounds(49.75, 641.75, 31.25, 27.75);
        surface.getButton(ButtonID.ROW5_1).setBounds(13.5, 688.25, 67.25, 27.75);
        surface.getButton(ButtonID.ROW6_1).setBounds(15.25, 728.25, 67.25, 27.75);
        surface.getButton(ButtonID.ROW1_2).setBounds(86.75, 603.75, 31.25, 27.75);
        surface.getButton(ButtonID.ROW6_8).setBounds(537.5, 728.25, 67.25, 27.75);
        surface.getButton(ButtonID.ROW2_2).setBounds(124.0, 603.75, 31.25, 27.75);
        surface.getButton(ButtonID.ROW3_2).setBounds(87.25, 641.75, 31.25, 27.75);
        surface.getButton(ButtonID.ROW4_2).setBounds(124.5, 641.75, 31.25, 27.75);
        surface.getButton(ButtonID.ROW5_2).setBounds(88.25, 688.25, 67.25, 27.75);
        surface.getButton(ButtonID.ROW6_2).setBounds(89.75, 728.25, 67.25, 27.75);
        surface.getButton(ButtonID.ROW1_3).setBounds(161.5, 603.75, 31.25, 27.75);
        surface.getButton(ButtonID.ROW2_3).setBounds(198.75, 603.75, 31.25, 27.75);
        surface.getButton(ButtonID.ROW3_3).setBounds(161.75, 641.75, 31.25, 27.75);
        surface.getButton(ButtonID.ROW4_3).setBounds(199.0, 641.75, 31.25, 27.75);
        surface.getButton(ButtonID.ROW5_3).setBounds(162.75, 688.25, 67.25, 27.75);
        surface.getButton(ButtonID.ROW6_3).setBounds(164.5, 728.25, 67.25, 27.75);
        surface.getButton(ButtonID.ROW1_4).setBounds(236.25, 603.75, 31.25, 27.75);
        surface.getButton(ButtonID.ROW2_4).setBounds(273.5, 603.75, 31.25, 27.75);
        surface.getButton(ButtonID.ROW3_4).setBounds(236.5, 641.75, 31.25, 27.75);
        surface.getButton(ButtonID.ROW4_4).setBounds(273.75, 641.75, 31.25, 27.75);
        surface.getButton(ButtonID.ROW5_4).setBounds(237.5, 688.25, 67.25, 27.75);
        surface.getButton(ButtonID.ROW6_4).setBounds(239.0, 728.25, 67.25, 27.75);
        surface.getButton(ButtonID.ROW1_5).setBounds(311.0, 603.75, 31.25, 27.75);
        surface.getButton(ButtonID.ROW2_5).setBounds(348.25, 603.75, 31.25, 27.75);
        surface.getButton(ButtonID.ROW5_8).setBounds(536.0, 688.25, 67.25, 27.75);
        surface.getButton(ButtonID.ROW3_5).setBounds(311.0, 641.75, 31.25, 27.75);
        surface.getButton(ButtonID.ROW4_5).setBounds(348.25, 641.75, 31.25, 27.75);
        surface.getButton(ButtonID.ROW5_5).setBounds(312.0, 688.25, 67.25, 27.75);
        surface.getButton(ButtonID.ROW6_5).setBounds(313.75, 728.25, 67.25, 27.75);
        surface.getButton(ButtonID.ROW1_6).setBounds(385.75, 603.75, 31.25, 27.75);
        surface.getButton(ButtonID.ROW2_6).setBounds(423.0, 603.75, 31.25, 27.75);
        surface.getButton(ButtonID.ROW3_6).setBounds(385.75, 641.75, 31.25, 27.75);
        surface.getButton(ButtonID.ROW4_6).setBounds(423.0, 641.75, 31.25, 27.75);
        surface.getButton(ButtonID.ROW5_6).setBounds(386.75, 688.25, 67.25, 27.75);
        surface.getButton(ButtonID.ROW6_6).setBounds(388.25, 728.25, 67.25, 27.75);
        surface.getButton(ButtonID.ROW1_7).setBounds(460.5, 603.75, 31.25, 27.75);
        surface.getButton(ButtonID.ROW2_7).setBounds(496.75, 603.75, 31.25, 27.75);
        surface.getButton(ButtonID.ROW3_7).setBounds(460.25, 641.75, 31.25, 27.75);
        surface.getButton(ButtonID.ROW4_7).setBounds(497.5, 641.75, 31.25, 27.75);
        surface.getButton(ButtonID.ROW5_7).setBounds(461.25, 688.25, 67.25, 27.75);
        surface.getButton(ButtonID.ROW6_7).setBounds(463.0, 728.25, 67.25, 27.75);
        surface.getButton(ButtonID.ROW1_8).setBounds(534.25, 603.75, 31.25, 27.75);
        surface.getButton(ButtonID.ROW2_8).setBounds(571.5, 603.75, 31.25, 27.75);
        surface.getButton(ButtonID.ROW3_8).setBounds(535.0, 641.75, 31.25, 27.75);
        surface.getButton(ButtonID.ROW4_8).setBounds(572.25, 641.75, 31.25, 27.75);
        surface.getContinuous(ContinuousID.EQ_Q_KNOB3).setBounds(167.75, 411.0, 46.25, 33.5);
        surface.getContinuous(ContinuousID.EQ_FREQUENCY_KNOB3).setBounds(171.25, 464.0, 46.25, 33.5);
        surface.getContinuous(ContinuousID.EQ_GAIN_KNOB3).setBounds(175.0, 514.5, 38.25, 33.5);
        surface.getContinuous(ContinuousID.FADER3).setBounds(164.25, 765.5, 67.25, 75.5);
        surface.getContinuous(ContinuousID.PAN_KNOB4).setBounds(247.25, 18.5, 46.25, 33.5);
        surface.getContinuous(ContinuousID.SEND1_KNOB4).setBounds(247.25, 97.25, 46.25, 33.5);
        surface.getContinuous(ContinuousID.SEND2_KNOB4).setBounds(247.75, 174.0, 46.25, 33.5);
        surface.getContinuous(ContinuousID.DEVICE_KNOB4).setBounds(248.5, 247.0, 46.25, 33.5);
        surface.getContinuous(ContinuousID.EQ_TYPE_KNOB4).setBounds(243.0, 348.75, 46.25, 33.5);
        surface.getContinuous(ContinuousID.EQ_Q_KNOB4).setBounds(243.0, 411.0, 46.25, 33.5);
        surface.getContinuous(ContinuousID.EQ_FREQUENCY_KNOB4).setBounds(245.75, 464.0, 46.25, 33.5);
        surface.getContinuous(ContinuousID.EQ_GAIN_KNOB4).setBounds(249.75, 514.5, 38.25, 33.5);
        surface.getContinuous(ContinuousID.FADER4).setBounds(238.75, 765.5, 67.25, 75.5);
        surface.getContinuous(ContinuousID.PAN_KNOB5).setBounds(321.5, 18.5, 46.25, 33.5);
        surface.getContinuous(ContinuousID.SEND1_KNOB5).setBounds(321.5, 97.25, 46.25, 33.5);
        surface.getContinuous(ContinuousID.SEND2_KNOB5).setBounds(322.0, 174.0, 46.25, 33.5);
        surface.getContinuous(ContinuousID.DEVICE_KNOB5).setBounds(323.0, 247.0, 46.25, 33.5);
        surface.getContinuous(ContinuousID.EQ_TYPE_KNOB5).setBounds(317.5, 348.75, 46.25, 33.5);
        surface.getContinuous(ContinuousID.EQ_Q_KNOB5).setBounds(318.0, 411.0, 46.25, 33.5);
        surface.getContinuous(ContinuousID.EQ_FREQUENCY_KNOB5).setBounds(320.0, 464.0, 46.25, 33.5);
        surface.getContinuous(ContinuousID.EQ_GAIN_KNOB5).setBounds(324.5, 514.5, 38.25, 33.5);
        surface.getContinuous(ContinuousID.FADER5).setBounds(313.25, 765.5, 67.25, 75.5);
        surface.getContinuous(ContinuousID.PAN_KNOB6).setBounds(395.75, 18.5, 46.25, 33.5);
        surface.getContinuous(ContinuousID.SEND1_KNOB6).setBounds(395.75, 97.25, 46.25, 33.5);
        surface.getContinuous(ContinuousID.SEND2_KNOB6).setBounds(396.5, 174.0, 46.25, 33.5);
        surface.getContinuous(ContinuousID.DEVICE_KNOB6).setBounds(397.5, 247.0, 46.25, 33.5);
        surface.getContinuous(ContinuousID.EQ_TYPE_KNOB6).setBounds(391.75, 348.75, 46.25, 33.5);
        surface.getContinuous(ContinuousID.EQ_Q_KNOB6).setBounds(393.0, 411.0, 46.25, 33.5);
        surface.getContinuous(ContinuousID.EQ_FREQUENCY_KNOB6).setBounds(394.5, 464.0, 46.25, 33.5);
        surface.getContinuous(ContinuousID.EQ_GAIN_KNOB6).setBounds(399.25, 514.5, 38.25, 33.5);
        surface.getContinuous(ContinuousID.FADER6).setBounds(387.5, 765.5, 67.25, 75.5);
        surface.getContinuous(ContinuousID.PAN_KNOB7).setBounds(470.0, 18.5, 46.25, 33.5);
        surface.getContinuous(ContinuousID.SEND1_KNOB7).setBounds(470.0, 97.25, 46.25, 33.5);
        surface.getContinuous(ContinuousID.SEND2_KNOB7).setBounds(470.75, 174.0, 46.25, 33.5);
        surface.getContinuous(ContinuousID.DEVICE_KNOB7).setBounds(472.0, 247.0, 46.25, 33.5);
        surface.getContinuous(ContinuousID.EQ_TYPE_KNOB7).setBounds(466.25, 348.75, 46.25, 33.5);
        surface.getContinuous(ContinuousID.EQ_Q_KNOB7).setBounds(468.0, 411.0, 46.25, 33.5);
        surface.getContinuous(ContinuousID.EQ_FREQUENCY_KNOB7).setBounds(468.75, 464.0, 46.25, 33.5);
        surface.getContinuous(ContinuousID.EQ_GAIN_KNOB7).setBounds(473.75, 514.5, 38.25, 33.5);
        surface.getContinuous(ContinuousID.TEMPO).setBounds(636.5, 350.75, 39.0, 50.0);
        surface.getContinuous(ContinuousID.CROSSFADER).setBounds(636.5, 518.0, 39.5, 34.25);
        surface.getContinuous(ContinuousID.CUE).setBounds(636.5, 406.5, 39.0, 50.0);
        surface.getContinuous(ContinuousID.FADER_MASTER).setBounds(636.5, 462.25, 39.0, 50.0);
        surface.getContinuous(ContinuousID.PAN_KNOB1).setBounds(24.75, 19.0, 46.25, 33.5);
        surface.getContinuous(ContinuousID.SEND1_KNOB1).setBounds(24.75, 97.75, 46.25, 33.5);
        surface.getContinuous(ContinuousID.SEND2_KNOB1).setBounds(24.75, 174.5, 46.25, 33.5);
        surface.getContinuous(ContinuousID.DEVICE_KNOB1).setBounds(24.75, 247.5, 46.25, 33.5);
        surface.getContinuous(ContinuousID.EQ_TYPE_KNOB1).setBounds(24.75, 349.25, 46.25, 33.5);
        surface.getContinuous(ContinuousID.EQ_Q_KNOB1).setBounds(24.75, 411.5, 46.25, 33.5);
        surface.getContinuous(ContinuousID.EQ_FREQUENCY_KNOB1).setBounds(24.75, 464.5, 46.25, 33.5);
        surface.getContinuous(ContinuousID.EQ_GAIN_KNOB1).setBounds(24.75, 515.0, 38.25, 33.5);
        surface.getContinuous(ContinuousID.FADER1).setBounds(15.5, 765.5, 67.25, 76.75);
        surface.getContinuous(ContinuousID.PAN_KNOB2).setBounds(99.0, 18.5, 46.25, 33.5);
        surface.getContinuous(ContinuousID.SEND1_KNOB2).setBounds(99.0, 97.25, 46.25, 33.5);
        surface.getContinuous(ContinuousID.SEND2_KNOB2).setBounds(99.0, 174.0, 46.25, 33.5);
        surface.getContinuous(ContinuousID.DEVICE_KNOB2).setBounds(99.25, 247.0, 46.25, 33.5);
        surface.getContinuous(ContinuousID.EQ_TYPE_KNOB2).setBounds(94.25, 348.75, 46.25, 33.5);
        surface.getContinuous(ContinuousID.EQ_Q_KNOB2).setBounds(92.75, 411.0, 46.25, 33.5);
        surface.getContinuous(ContinuousID.EQ_FREQUENCY_KNOB2).setBounds(97.0, 464.0, 46.25, 33.5);
        surface.getContinuous(ContinuousID.EQ_GAIN_KNOB2).setBounds(100.5, 514.5, 38.25, 33.5);
        surface.getContinuous(ContinuousID.FADER2).setBounds(90.0, 765.5, 67.25, 75.5);
        surface.getContinuous(ContinuousID.PAN_KNOB3).setBounds(173.25, 18.5, 46.25, 33.5);
        surface.getContinuous(ContinuousID.SEND1_KNOB3).setBounds(173.25, 97.25, 46.25, 33.5);
        surface.getContinuous(ContinuousID.SEND2_KNOB3).setBounds(173.5, 174.0, 46.25, 33.5);
        surface.getContinuous(ContinuousID.DEVICE_KNOB3).setBounds(173.75, 247.0, 46.25, 33.5);
        surface.getContinuous(ContinuousID.EQ_TYPE_KNOB3).setBounds(168.5, 348.75, 46.25, 33.5);
        surface.getContinuous(ContinuousID.FADER7).setBounds(462.0, 765.5, 67.25, 75.5);
        surface.getContinuous(ContinuousID.PAN_KNOB8).setBounds(544.25, 18.5, 46.25, 33.5);
        surface.getContinuous(ContinuousID.SEND1_KNOB8).setBounds(544.25, 97.25, 46.25, 33.5);
        surface.getContinuous(ContinuousID.SEND2_KNOB8).setBounds(545.0, 174.0, 46.25, 33.5);
        surface.getContinuous(ContinuousID.DEVICE_KNOB8).setBounds(546.5, 247.0, 46.25, 33.5);
        surface.getContinuous(ContinuousID.EQ_TYPE_KNOB8).setBounds(540.75, 348.75, 46.25, 33.5);
        surface.getContinuous(ContinuousID.EQ_Q_KNOB8).setBounds(543.25, 411.0, 46.25, 33.5);
        surface.getContinuous(ContinuousID.EQ_FREQUENCY_KNOB8).setBounds(543.25, 464.0, 46.25, 33.5);
        surface.getContinuous(ContinuousID.EQ_GAIN_KNOB8).setBounds(548.5, 514.5, 38.25, 33.5);
        surface.getContinuous(ContinuousID.FADER8).setBounds(536.5, 765.5, 67.25, 75.5);
    }

    @Override
    public void startup() {
        YaeltexTurnControlSurface surface = (YaeltexTurnControlSurface)this.getSurface();
        surface.getViewManager().setActive(Views.SESSION);
        surface.getModeManager().setActive(Modes.TRACK);
    }

    @Override
    public void flush() {
        super.flush();
        YaeltexTurnControlSurface surface = (YaeltexTurnControlSurface)this.getSurface();
        IMode mode = (IMode)surface.getModeManager().getActive();
        if (mode == null) {
            return;
        }
        for (int i = 0; i < 32; ++i) {
            surface.setLED(0 + i, mode.getKnobValue(i), mode.getKnobColor(i));
        }
    }

    @Override
    protected BindType getTriggerBindType(ButtonID buttonID) {
        return BindType.NOTE;
    }

    private void toggleSequencer(ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        YaeltexTurnControlSurface surface = (YaeltexTurnControlSurface)this.getSurface();
        ModeManager modeManager = surface.getModeManager();
        Modes mode = modeManager.isActive(new Modes[]{Modes.TRACK, Modes.NOTE_SEQUENCER}) ? (modeManager.isActive(new Modes[]{Modes.TRACK}) ? Modes.NOTE_SEQUENCER : Modes.TRACK) : (modeManager.isActive(new Modes[]{Modes.DEVICE_LAYER}) ? Modes.DRUM_SEQUENCER : Modes.DEVICE_LAYER);
        modeManager.setActive(mode);
        this.host.showNotification(((IMode)modeManager.getActive()).getName());
        surface.getViewManager().setActive(switch (mode) {
            case Modes.NOTE_SEQUENCER -> Views.SEQUENCER;
            case Modes.DRUM_SEQUENCER -> Views.DRUM;
            default -> this.sessionView;
        });
    }

    private void toggleSession(ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        ViewManager viewManager = ((YaeltexTurnControlSurface)this.getSurface()).getViewManager();
        if (viewManager.isActive(new Views[]{Views.SESSION, Views.SCENE_PLAY})) {
            this.sessionView = viewManager.isActive(new Views[]{Views.SESSION}) ? Views.SCENE_PLAY : Views.SESSION;
        }
        viewManager.setActive(this.sessionView);
        this.host.showNotification(((IView)viewManager.getActive()).getName());
        ModeManager modeManager = ((YaeltexTurnControlSurface)this.getSurface()).getModeManager();
        if (modeManager.isActive(new Modes[]{Modes.NOTE_SEQUENCER})) {
            modeManager.setActive(Modes.TRACK);
        } else if (modeManager.isActive(new Modes[]{Modes.DRUM_SEQUENCER})) {
            modeManager.setActive(Modes.DEVICE_LAYER);
        }
    }

    private void toggleTrackAndLayer(ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        YaeltexTurnControlSurface surface = (YaeltexTurnControlSurface)this.getSurface();
        ModeManager modeManager = surface.getModeManager();
        Modes mode = modeManager.isActive(new Modes[]{Modes.TRACK, Modes.NOTE_SEQUENCER}) ? (modeManager.isActive(new Modes[]{Modes.TRACK}) ? Modes.DEVICE_LAYER : Modes.DRUM_SEQUENCER) : (modeManager.isActive(new Modes[]{Modes.DEVICE_LAYER}) ? Modes.TRACK : Modes.NOTE_SEQUENCER);
        modeManager.setActive(mode);
        this.host.showNotification(((IMode)modeManager.getActive()).getName());
        surface.getViewManager().setActive(switch (mode) {
            case Modes.NOTE_SEQUENCER -> Views.SEQUENCER;
            case Modes.DRUM_SEQUENCER -> Views.DRUM;
            default -> this.sessionView;
        });
    }

    static {
        CONTINUOUS_CONTROLS.addAll(ContinuousID.createSequentialList(ContinuousID.PAN_KNOB1, 8));
        CONTINUOUS_CONTROLS.addAll(ContinuousID.createSequentialList(ContinuousID.SEND1_KNOB1, 8));
        CONTINUOUS_CONTROLS.addAll(ContinuousID.createSequentialList(ContinuousID.SEND2_KNOB1, 8));
        CONTINUOUS_CONTROLS.addAll(ContinuousID.createSequentialList(ContinuousID.DEVICE_KNOB1, 8));
        CONTINUOUS_CONTROLS.addAll(ContinuousID.createSequentialList(ContinuousID.EQ_TYPE_KNOB1, 8));
        CONTINUOUS_CONTROLS.addAll(ContinuousID.createSequentialList(ContinuousID.EQ_Q_KNOB1, 8));
        CONTINUOUS_CONTROLS.addAll(ContinuousID.createSequentialList(ContinuousID.EQ_FREQUENCY_KNOB1, 8));
        CONTINUOUS_CONTROLS.addAll(ContinuousID.createSequentialList(ContinuousID.EQ_GAIN_KNOB1, 8));
        CONTINUOUS_CONTROLS.addAll(ContinuousID.createSequentialList(ContinuousID.FADER1, 8));
    }

    private class ColorIntensity
    implements IntSupplier {
        private final BooleanSupplier supplier;
        private final int colorIndex;

        ColorIntensity(YaeltexTurnControllerSetup yaeltexTurnControllerSetup, BooleanSupplier supplier, String colorID) {
            this.supplier = supplier;
            this.colorIndex = yaeltexTurnControllerSetup.getModel().getColorManager().getColorIndex(colorID);
        }

        @Override
        public int getAsInt() {
            return this.supplier.getAsBoolean() ? this.colorIndex : 128 + this.colorIndex;
        }
    }
}

