/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.oxi.one;

import de.mossgrabers.framework.configuration.AbstractConfiguration;
import de.mossgrabers.framework.configuration.ISettingsUI;
import de.mossgrabers.framework.controller.valuechanger.IValueChanger;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.constants.Capability;
import de.mossgrabers.framework.daw.midi.ArpeggiatorMode;
import de.mossgrabers.framework.view.Views;
import java.util.List;

public class OxiOneConfiguration
extends AbstractConfiguration {
    private static final Views[] PREFERRED_NOTE_VIEWS = new Views[]{Views.SESSION, Views.DRUM_XOX, Views.PLAY, Views.DRUM64, Views.DRUM8, Views.SEQUENCER, Views.POLY_SEQUENCER, Views.RAINDROPS};

    public OxiOneConfiguration(IHost host, IValueChanger valueChanger, List<ArpeggiatorMode> arpeggiatorModes) {
        super(host, valueChanger, arpeggiatorModes);
        Views.setViewName(Views.DRUM64, "Drum 128");
        this.accentActive = true;
    }

    @Override
    public void init(ISettingsUI globalSettings, ISettingsUI documentSettings) {
        this.activateScaleSetting(documentSettings);
        this.activateScaleBaseSetting(documentSettings);
        this.activateScaleInScaleSetting(documentSettings);
        this.activateScaleLayoutSetting(documentSettings);
        this.activateNoteRepeatSetting(documentSettings);
        this.activateSelectClipOnLaunchSetting(globalSettings);
        this.activateDrawRecordStripeSetting(globalSettings);
        this.activateActionForRecArmedPad(globalSettings);
        this.activateBehaviourOnStopSetting(globalSettings);
        this.activateBehaviourOnPauseSetting(globalSettings);
        this.activateRecordButtonSetting(globalSettings);
        this.activateShiftedRecordButtonSetting(globalSettings);
        this.activateQuantizeAmountSetting(globalSettings);
        this.activateMidiEditChannelSetting(documentSettings);
        this.activateTurnOffScalePadsSetting(globalSettings);
        this.activateShowPlayedChordsSetting(globalSettings);
        this.activateStartupViewSetting(globalSettings, PREFERRED_NOTE_VIEWS);
        if (this.host.supports(Capability.HAS_DRUM_DEVICE)) {
            this.activateTurnOffEmptyDrumPadsSetting(globalSettings);
        }
        this.activateExcludeDeactivatedItemsSetting(globalSettings);
        this.activateNewClipLengthSetting(globalSettings);
        this.activateKnobSpeedSetting(globalSettings);
        this.activateColorTrackStates(globalSettings);
    }
}

