/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.novation.slmkiii.mode;

import de.mossgrabers.controller.novation.slmkiii.controller.SLMkIIIControlSurface;
import de.mossgrabers.controller.novation.slmkiii.controller.SLMkIIIDisplay;
import de.mossgrabers.controller.novation.slmkiii.mode.BaseMode;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.daw.IBrowser;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.IBrowserColumn;
import de.mossgrabers.framework.daw.data.IItem;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.utils.StringUtils;

public class BrowserMode
extends BaseMode<IItem> {
    public BrowserMode(SLMkIIIControlSurface surface, IModel model) {
        super("Browser", surface, model);
    }

    @Override
    public void onKnobValue(int index, int value) {
        boolean isInc = this.model.getValueChanger().isIncrease(value);
        IBrowser browser = this.model.getBrowser();
        if (browser == null) {
            return;
        }
        switch (index) {
            case 0: 
            case 1: {
                if (isInc) {
                    browser.nextContentType();
                    break;
                }
                browser.previousContentType();
                break;
            }
            case 2: 
            case 3: {
                if (isInc) {
                    browser.selectNextFilterColumn();
                    break;
                }
                browser.selectPreviousFilterColumn();
                break;
            }
            case 4: 
            case 5: {
                if (isInc) {
                    browser.getSelectedFilterColumn().selectNextItem();
                    break;
                }
                browser.getSelectedFilterColumn().selectPreviousItem();
                break;
            }
            case 6: 
            case 7: {
                if (isInc) {
                    browser.selectNextResult();
                    break;
                }
                browser.selectPreviousResult();
                break;
            }
        }
    }

    @Override
    public int getKnobValue(int index) {
        return 0;
    }

    @Override
    public void onButton(int row, int index, ButtonEvent event) {
        if (event != ButtonEvent.UP) {
            return;
        }
        IBrowser browser = this.model.getBrowser();
        if (browser == null) {
            return;
        }
        switch (index) {
            case 0: {
                browser.previousContentType();
                break;
            }
            case 1: {
                browser.nextContentType();
                break;
            }
            case 2: {
                browser.selectPreviousFilterColumn();
                break;
            }
            case 3: {
                browser.selectNextFilterColumn();
                break;
            }
            case 4: {
                browser.getSelectedFilterColumn().selectPreviousItem();
                break;
            }
            case 5: {
                browser.getSelectedFilterColumn().selectNextItem();
                break;
            }
            case 6: {
                browser.selectPreviousResult();
                break;
            }
            case 7: {
                browser.selectNextResult();
                break;
            }
        }
    }

    @Override
    public int getButtonColor(ButtonID buttonID) {
        switch (buttonID) {
            case ROW1_1: 
            case ROW1_2: {
                return 21;
            }
            case ROW1_3: 
            case ROW1_4: {
                return 22;
            }
            case ROW1_5: 
            case ROW1_6: {
                return 16;
            }
            case ROW1_7: 
            case ROW1_8: {
                return 20;
            }
        }
        return 0;
    }

    @Override
    public void updateDisplay() {
        IBrowser browser = this.model.getBrowser();
        if (!browser.isActive()) {
            return;
        }
        SLMkIIIDisplay d = ((SLMkIIIControlSurface)this.surface).getDisplay();
        d.clear();
        d.setCell(0, 0, StringUtils.fixASCII(browser.getSelectedContentType()));
        d.setPropertyColor(0, 0, 21);
        d.setCell(3, 0, "<< Tab");
        d.setPropertyColor(0, 2, 21);
        d.setPropertyValue(0, 1, 0);
        d.setPropertyColor(1, 0, 21);
        d.setCell(3, 1, "Tab >>");
        d.setPropertyColor(1, 2, 21);
        d.setPropertyValue(1, 1, 0);
        IBrowserColumn selectedFilterColumn = browser.getSelectedFilterColumn();
        d.setCell(0, 2, selectedFilterColumn.doesExist() ? StringUtils.fixASCII(selectedFilterColumn.getName()) : "-");
        d.setPropertyColor(2, 0, 22);
        d.setCell(3, 2, "<< Filter");
        d.setPropertyColor(2, 2, 22);
        d.setPropertyValue(2, 1, 0);
        d.setPropertyColor(3, 0, 22);
        d.setCell(3, 3, "Filter >>");
        d.setPropertyColor(3, 2, 22);
        d.setPropertyValue(3, 1, 0);
        d.setCell(0, 4, selectedFilterColumn.doesExist() ? StringUtils.fixASCII(selectedFilterColumn.getCursorName()) : "-");
        d.setPropertyColor(4, 0, 16);
        d.setCell(3, 4, "<< F-Sel");
        d.setPropertyColor(4, 2, 16);
        d.setPropertyValue(4, 1, 0);
        d.setPropertyColor(5, 0, 16);
        d.setCell(3, 5, "F-Sel >>");
        d.setPropertyColor(5, 2, 16);
        d.setPropertyValue(5, 1, 0);
        String resultName = StringUtils.pad(StringUtils.fixASCII(browser.getSelectedResult()), 18, ' ');
        String name1 = resultName.substring(0, 9);
        String name2 = resultName.substring(9, 18);
        d.setCell(0, 6, name1);
        d.setPropertyColor(6, 0, 20);
        d.setCell(3, 6, "<< Result");
        d.setPropertyColor(6, 2, 20);
        d.setPropertyValue(6, 1, 0);
        d.setCell(0, 7, name2);
        d.setPropertyColor(7, 0, 20);
        d.setCell(3, 7, "Result >>");
        d.setPropertyColor(7, 2, 20);
        d.setPropertyValue(7, 1, 0);
        d.setCell(0, 8, "Browser");
        this.setButtonInfo(d);
        d.allDone();
    }

    @Override
    public int getModeColor() {
        return 20;
    }
}

