/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.novation.sl.view;

import de.mossgrabers.controller.novation.sl.SLConfiguration;
import de.mossgrabers.controller.novation.sl.command.trigger.ButtonRowSelectCommand;
import de.mossgrabers.controller.novation.sl.command.trigger.P2ButtonCommand;
import de.mossgrabers.controller.novation.sl.controller.SLControlSurface;
import de.mossgrabers.controller.novation.sl.mode.device.SLParameterMode;
import de.mossgrabers.controller.novation.sl.view.SLView;
import de.mossgrabers.controller.novation.sl.view.TransportControl;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.ITransport;
import de.mossgrabers.framework.daw.clip.INoteClip;
import de.mossgrabers.framework.daw.clip.NotePosition;
import de.mossgrabers.framework.daw.clip.StepState;
import de.mossgrabers.framework.daw.constants.Resolution;
import de.mossgrabers.framework.daw.data.IDrumDevice;
import de.mossgrabers.framework.daw.data.IDrumPad;
import de.mossgrabers.framework.daw.data.IScene;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.IDrumPadBank;
import de.mossgrabers.framework.daw.data.bank.ITrackBank;
import de.mossgrabers.framework.featuregroup.ModeManager;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.Views;
import de.mossgrabers.framework.view.sequencer.AbstractSequencerView;
import java.util.Arrays;
import java.util.Optional;

public class PlayView
extends AbstractSequencerView<SLControlSurface, SLConfiguration>
implements SLView {
    private static final int NUM_DISPLAY_COLS = 16;
    private static final int NOTE_VELOCITY = 127;
    private int selectedPad;
    private boolean isPlayMode;
    protected int[] pressedKeys;
    private final TransportControl transportControl;

    public PlayView(SLControlSurface surface, IModel model) {
        super("Play", surface, model, 128, 16, false);
        this.transportControl = new TransportControl(surface, model);
        this.selectedPad = 0;
        this.pressedKeys = new int[128];
        Arrays.fill(this.pressedKeys, 0);
        this.isPlayMode = true;
        ITrackBank tb = model.getTrackBank();
        tb.addSelectionObserver((index, isSelected) -> this.clearPressedKeys());
        tb.addNoteObserver(this::updateNote);
    }

    @Override
    public void onButtonRow1(int index, ButtonEvent event) {
        if (event == ButtonEvent.LONG) {
            return;
        }
        if (event == ButtonEvent.DOWN) {
            ModeManager modeManager = ((SLControlSurface)this.surface).getModeManager();
            Modes activeModeId = (Modes)((Object)modeManager.getActiveID());
            if (Modes.VIEW_SELECT == activeModeId) {
                if (index == 0) {
                    ((SLControlSurface)this.surface).getViewManager().setActive(Views.CONTROL);
                    if (Modes.VOLUME.equals(modeManager.getPreviousID())) {
                        modeManager.restore();
                    } else {
                        modeManager.setActive(Modes.TRACK);
                    }
                } else {
                    modeManager.restore();
                }
                ((SLControlSurface)this.surface).turnOffTransport();
                return;
            }
            if (!Modes.SESSION.equals((Object)activeModeId)) {
                modeManager.setActive(Modes.SESSION);
            }
        }
        ((IScene)this.model.getSceneBank().getItem(index)).launch(event == ButtonEvent.DOWN, false);
    }

    @Override
    public void onButtonRow2(int index, ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        ModeManager modeManager = ((SLControlSurface)this.surface).getModeManager();
        Modes cm = (Modes)((Object)modeManager.getActiveID());
        if (!Modes.PLAY_OPTIONS.equals((Object)cm)) {
            modeManager.setActive(Modes.PLAY_OPTIONS);
        }
        switch (index) {
            case 0: {
                this.clearPressedKeys();
                this.scales.decDrumOctave();
                this.model.getDrumDevice().getDrumPadBank().selectPreviousPage();
                this.updateNoteMapping();
                ((SLControlSurface)this.surface).getDisplay().notify(this.scales.getDrumRangeText());
                break;
            }
            case 1: {
                this.clearPressedKeys();
                this.scales.incDrumOctave();
                this.model.getDrumDevice().getDrumPadBank().selectNextPage();
                this.updateNoteMapping();
                ((SLControlSurface)this.surface).getDisplay().notify(this.scales.getDrumRangeText());
                break;
            }
            case 2: {
                this.changeResolution(0);
                ((SLControlSurface)this.surface).getDisplay().notify(Resolution.getNameAt(this.getResolutionIndex()));
                break;
            }
            case 3: {
                this.changeResolution(127);
                ((SLControlSurface)this.surface).getDisplay().notify(Resolution.getNameAt(this.getResolutionIndex()));
                break;
            }
            case 4: {
                this.changeScrollPosition(0);
                break;
            }
            case 5: {
                this.changeScrollPosition(127);
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                this.isPlayMode = !this.isPlayMode;
                ((SLControlSurface)this.surface).getDisplay().notify(this.isPlayMode ? "Play/Select" : "Sequence");
                this.updateNoteMapping();
                break;
            }
        }
    }

    @Override
    public void onButtonRow3(int index, ButtonEvent event) {
        if (event == ButtonEvent.DOWN) {
            this.onSeqGridNote(44 + index, 127);
        } else if (event == ButtonEvent.UP) {
            this.onSeqGridNote(44 + index, 0);
        }
    }

    @Override
    public void onButtonRow4(int index, ButtonEvent event) {
        if (event == ButtonEvent.DOWN) {
            this.onSeqGridNote(36 + index, 127);
        } else if (event == ButtonEvent.UP) {
            this.onSeqGridNote(36 + index, 0);
        }
    }

    @Override
    public void onButtonRow5(int index, ButtonEvent event) {
        this.transportControl.execute(index, event);
    }

    @Override
    public void onButtonRow1Select() {
        ((SLControlSurface)this.surface).getModeManager().setActive(Modes.SESSION);
    }

    @Override
    public void onButtonRow2Select() {
        ((SLControlSurface)this.surface).getModeManager().setActive(Modes.PLAY_OPTIONS);
    }

    @Override
    public void onButtonP1(boolean isUp, ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        Modes activeModeId = (Modes)((Object)((SLControlSurface)this.surface).getModeManager().getActiveID());
        if (Modes.SESSION == activeModeId) {
            if (isUp) {
                this.model.getSceneBank().selectNextPage();
            } else {
                this.model.getSceneBank().selectPreviousPage();
            }
            return;
        }
        if (Modes.VOLUME.equals((Object)activeModeId)) {
            new P2ButtonCommand(isUp, this.model, (SLControlSurface)this.surface).execute(ButtonEvent.DOWN, 127);
            return;
        }
        if (Modes.TRACK.equals((Object)activeModeId)) {
            new ButtonRowSelectCommand(3, this.model, (SLControlSurface)this.surface).execute(ButtonEvent.DOWN, 127);
            return;
        }
        if (Modes.PLAY_OPTIONS.equals((Object)activeModeId)) {
            return;
        }
        SLParameterMode mode = (SLParameterMode)((SLControlSurface)this.surface).getModeManager().get(Modes.DEVICE_PARAMS);
        if (isUp) {
            mode.selectNextItemPage();
        } else {
            mode.selectPreviousItemPage();
        }
    }

    @Override
    public int getButtonColor(ButtonID buttonID) {
        int buttonIDOrdinal = buttonID.ordinal();
        if (buttonIDOrdinal >= ButtonID.ROW1_1.ordinal() && buttonIDOrdinal <= ButtonID.ROW1_8.ordinal() || buttonIDOrdinal >= ButtonID.ROW2_1.ordinal() && buttonIDOrdinal <= ButtonID.ROW2_8.ordinal()) {
            return 0;
        }
        Modes mode = (Modes)((Object)((SLControlSurface)this.surface).getModeManager().getActiveID());
        boolean isSession = Modes.SESSION == mode;
        boolean isDevice = Modes.DEVICE_PARAMS == mode;
        boolean isPlayOptions = Modes.PLAY_OPTIONS == mode;
        boolean isTrack = Modes.TRACK == mode;
        boolean isVolume = Modes.VOLUME == mode;
        switch (buttonID) {
            case ROW_SELECT_1: {
                return isSession ? 1 : 0;
            }
            case ROW_SELECT_2: {
                return isDevice ? 1 : 0;
            }
            case ROW_SELECT_3: {
                return isPlayOptions ? 1 : 0;
            }
            case ROW_SELECT_4: {
                return isTrack ? 1 : 0;
            }
            case ROW_SELECT_5: {
                return 0;
            }
            case ROW_SELECT_6: {
                return isVolume ? 1 : 0;
            }
            case ROW_SELECT_7: 
            case ROW_SELECT_8: {
                return 0;
            }
        }
        if (((SLControlSurface)this.surface).isTransportActive()) {
            if (buttonIDOrdinal >= ButtonID.ROW3_1.ordinal() && buttonIDOrdinal <= ButtonID.ROW3_8.ordinal()) {
                return 0;
            }
            ITransport transport = this.model.getTransport();
            switch (buttonID) {
                case ROW4_3: {
                    return !transport.isPlaying() ? 1 : 0;
                }
                case ROW4_4: {
                    return transport.isPlaying() ? 1 : 0;
                }
                case ROW4_5: {
                    return transport.isLoop() ? 1 : 0;
                }
                case ROW4_6: {
                    return transport.isRecording() ? 1 : 0;
                }
            }
            return 0;
        }
        return this.drawDrumGrid(buttonIDOrdinal);
    }

    public int drawDrumGrid(int buttonIDOrdinal) {
        int index;
        boolean isRow3 = buttonIDOrdinal >= ButtonID.ROW3_1.ordinal() && buttonIDOrdinal <= ButtonID.ROW3_8.ordinal();
        int x = index = isRow3 ? buttonIDOrdinal - ButtonID.ROW3_1.ordinal() : buttonIDOrdinal - ButtonID.ROW4_1.ordinal();
        int y = this.isPlayMode ? (isRow3 ? 1 : 0) : (isRow3 ? 0 : 1);
        int col = 8 * y + x;
        if (this.isPlayMode) {
            return this.getDrumPadColor(col);
        }
        if (!this.isActive()) {
            return 0;
        }
        INoteClip clip = this.getClip();
        boolean exists = clip.doesExist();
        int step = clip.getCurrentStep();
        int hiStep = this.isInXRange(step) ? step % 16 : -1;
        int offsetY = this.scales.getDrumOffset();
        if (col >= 16) {
            return 0;
        }
        NotePosition notePosition = new NotePosition(this.configuration.getMidiEditChannel(), col, offsetY + this.selectedPad);
        StepState isSet = clip.getStep(notePosition).getState();
        boolean hilite = col == hiStep;
        return exists && (isSet != StepState.OFF || hilite) ? 1 : 0;
    }

    public void clearPressedKeys() {
        for (int i = 0; i < 128; ++i) {
            this.pressedKeys[i] = 0;
        }
    }

    public void onSeqGridNote(int note, int velocity) {
        if (!this.model.canSelectedTrackHoldNotes()) {
            return;
        }
        int index = note - 36;
        int offsetY = this.scales.getDrumOffset();
        if (this.isPlayMode) {
            this.selectedPad = index;
            this.pressedKeys[offsetY + this.selectedPad] = velocity;
            ((SLControlSurface)this.surface).sendMidiEvent(144, this.keyManager.map(note), velocity);
        } else if (velocity != 0) {
            NotePosition notePosition = new NotePosition(this.configuration.getMidiEditChannel(), index < 8 ? index + 8 : index - 8, offsetY + this.selectedPad);
            this.getClip().toggleStep(notePosition, this.configuration.isAccentActive() ? this.configuration.getFixedAccentValue() : velocity);
        }
    }

    @Override
    public void updateNoteMapping() {
        this.delayedUpdateNoteMapping(this.model.canSelectedTrackHoldNotes() && this.isPlayMode ? this.scales.getDrumMatrix() : EMPTY_TABLE);
    }

    private int getDrumPadColor(int index) {
        int offsetY = this.scales.getDrumOffset();
        if (this.pressedKeys[offsetY + index] > 0 || this.selectedPad == index) {
            return 1;
        }
        IDrumDevice primary = this.model.getDrumDevice();
        IDrumPadBank drumPadBank = primary.getDrumPadBank();
        boolean isSoloed = primary.hasDrumPads() && drumPadBank.hasSoloedPads();
        IDrumPad drumPad = drumPadBank.getItem(index);
        if (!drumPad.doesExist() || !drumPad.isActivated()) {
            return 0;
        }
        if (drumPad.isMute() || isSoloed && !drumPad.isSolo()) {
            return 0;
        }
        return 0;
    }

    private void changeScrollPosition(int value) {
        boolean isInc;
        boolean bl = isInc = value >= 65;
        if (isInc) {
            this.getClip().scrollStepsPageForward();
        } else {
            this.getClip().scrollStepsPageBackwards();
        }
    }

    private void changeResolution(int value) {
        boolean isInc = value >= 65;
        int selectedResolutionIndex = Resolution.change(this.getResolutionIndex(), isInc);
        this.getClip().setStepLength(Resolution.getValueAt(selectedResolutionIndex));
    }

    @Override
    public void drawGrid() {
    }

    @Override
    public void onGridNote(int note, int velocity) {
    }

    private void updateNote(int trackIndex, int note, int velocity) {
        Optional sel = this.model.getCurrentTrackBank().getSelectedItem();
        if (sel.isPresent() && ((ITrack)sel.get()).getIndex() == trackIndex) {
            this.pressedKeys[note] = velocity;
        }
    }
}

