/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.novation.launchpad.view;

import de.mossgrabers.controller.novation.launchpad.LaunchpadConfiguration;
import de.mossgrabers.controller.novation.launchpad.command.trigger.SelectSessionViewCommand;
import de.mossgrabers.controller.novation.launchpad.controller.LaunchpadControlSurface;
import de.mossgrabers.framework.configuration.AbstractConfiguration;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.grid.IPadGrid;
import de.mossgrabers.framework.controller.grid.LightInfo;
import de.mossgrabers.framework.daw.DAWColor;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.IScene;
import de.mossgrabers.framework.daw.data.ISlot;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.ISceneBank;
import de.mossgrabers.framework.daw.data.bank.ITrackBank;
import de.mossgrabers.framework.featuregroup.IScrollableView;
import de.mossgrabers.framework.featuregroup.ModeManager;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.utils.Pair;
import de.mossgrabers.framework.utils.ScrollStates;
import de.mossgrabers.framework.view.AbstractSessionView;
import java.util.Optional;

public class SessionView
extends AbstractSessionView<LaunchpadControlSurface, LaunchpadConfiguration>
implements IScrollableView {
    protected boolean isShowTemporarily;
    private final LaunchpadConfiguration configuration;

    public SessionView(String name, LaunchpadControlSurface surface, IModel model) {
        super(name, surface, model, 8, 8, true);
        this.ignoreClipColorForPlayAndRecord = true;
        this.configuration = (LaunchpadConfiguration)((LaunchpadControlSurface)this.surface).getConfiguration();
        LightInfo isRecording = new LightInfo(5, 5, false);
        LightInfo isRecordingQueued = new LightInfo(5, 7, true);
        LightInfo isPlaying = new LightInfo(22, 22, false);
        LightInfo isPlayingQueued = new LightInfo(22, 23, true);
        LightInfo hasContent = new LightInfo(10, -1, false);
        LightInfo noContent = new LightInfo(0, -1, false);
        LightInfo recArmed = new LightInfo(7, -1, false);
        LightInfo isMuted = new LightInfo(1, -1, false);
        this.setColors(isRecording, isRecordingQueued, isPlaying, isPlayingQueued, hasContent, noContent, recArmed, isMuted);
        this.birdColorHasContent = hasContent;
        this.birdColorSelected = new LightInfo(22, -1, false);
        this.configuration.addSettingObserver(AbstractConfiguration.FLIP_SESSION, this::updateRowsCols);
        ((LaunchpadControlSurface)this.surface).getModeManager().addChangeListener((oldMode, newMode) -> this.updateRowsCols());
    }

    @Override
    public void onActivate() {
        super.onActivate();
        this.updateRowsCols();
    }

    @Override
    public void onGridNote(int note, int velocity) {
        int modeIndex;
        if (velocity == 0) {
            ((SelectSessionViewCommand)((LaunchpadControlSurface)this.surface).getButton(ButtonID.SESSION).getCommand()).setTemporary();
        }
        if ((modeIndex = this.getControlModeIndex(note)) >= 0) {
            if (velocity != 0) {
                this.handleFirstRowModes(modeIndex);
            }
            return;
        }
        if (this.isBirdsEyeActive()) {
            this.onGridNoteBankSelection(note, velocity);
            return;
        }
        super.onGridNote(note, velocity);
    }

    @Override
    public void onButton(ButtonID buttonID, ButtonEvent event, int velocity) {
        super.onButton(buttonID, event, velocity);
        if (ButtonID.isSceneButton(buttonID) && event == ButtonEvent.UP) {
            ((SelectSessionViewCommand)((LaunchpadControlSurface)this.surface).getButton(ButtonID.SESSION).getCommand()).setTemporary();
            if (((LaunchpadControlSurface)this.surface).isShiftPressed()) {
                this.setAlternateInteractionUsed(true);
            }
        }
    }

    @Override
    protected boolean isSceneLaunchAlternateAction() {
        return ((LaunchpadControlSurface)this.surface).isShiftPressed();
    }

    @Override
    protected boolean isSceneSelectAction() {
        return false;
    }

    @Override
    public void drawGrid() {
        super.drawGrid();
        if (this.isControlModeOff()) {
            return;
        }
        ITrackBank tb = this.model.getCurrentTrackBank();
        IPadGrid pads = ((LaunchpadControlSurface)this.surface).getPadGrid();
        boolean flipSession = this.configuration.isFlipSession();
        for (int x = 0; x < 8; ++x) {
            int padX = flipSession ? 7 : x;
            int padY = flipSession ? x : 7;
            pads.lightEx(padX, padY, this.getModeColor((ITrack)tb.getItem(x), x));
        }
    }

    @Override
    public void setBirdsEyeActive(boolean isBirdsEyeActive) {
        super.setBirdsEyeActive(isBirdsEyeActive);
        this.updateRowsCols();
    }

    @Override
    public String getButtonColorID(ButtonID buttonID) {
        ITrackBank tb;
        ISceneBank sceneBank;
        IScene s;
        int index = buttonID.ordinal() - ButtonID.SCENE1.ordinal();
        if ((index >= 0 || index < 8) && (s = (IScene)(sceneBank = (tb = this.model.getCurrentTrackBank()).getSceneBank()).getItem(index)).doesExist()) {
            return DAWColor.getColorID(s.getColor());
        }
        return "BUTTON_COLOR_OFF";
    }

    @Override
    protected void drawSessionGrid() {
        this.drawSessionGrid(true);
    }

    @Override
    public int getButtonColor(ButtonID buttonID) {
        if (((LaunchpadControlSurface)this.surface).getButton(buttonID).isPressed()) {
            return 3;
        }
        return super.getButtonColor(buttonID);
    }

    public void onSession(ButtonEvent event) {
        switch (event) {
            case LONG: {
                this.isShowTemporarily = true;
                break;
            }
            case UP: {
                if (!this.isShowTemporarily) {
                    return;
                }
                this.isShowTemporarily = false;
                ((LaunchpadControlSurface)this.surface).recallPreferredView(this.model.getCursorTrack());
                break;
            }
            default: {
                return;
            }
        }
    }

    @Override
    protected boolean handleButtonCombinations(ITrack track, ISlot slot) {
        boolean result = super.handleButtonCombinations(track, slot);
        if (this.isButtonCombination(ButtonID.DELETE) && this.configuration.isDeleteModeActive()) {
            this.configuration.toggleDeleteModeActive();
        } else if (this.isButtonCombination(ButtonID.DUPLICATE) && this.configuration.isDuplicateModeActive() && (!slot.doesExist() || !slot.hasContent())) {
            this.configuration.toggleDuplicateModeActive();
        }
        return result;
    }

    @Override
    protected boolean isButtonCombination(ButtonID buttonID) {
        if (super.isButtonCombination(buttonID) || buttonID == ButtonID.DELETE && this.configuration.isDeleteModeActive()) {
            return true;
        }
        return buttonID == ButtonID.DUPLICATE && this.configuration.isDuplicateModeActive();
    }

    protected void onGridNoteBankSelection(int note, int velocity) {
        if (velocity == 0) {
            return;
        }
        int index = note - 36;
        this.onGridNoteBirdsEyeView(index % this.columns, this.rows - 1 - index / this.columns, 0);
        if (((LaunchpadControlSurface)this.surface).isPressed(ButtonID.SESSION)) {
            this.setBirdsEyeActive(false);
        }
    }

    private void handleFirstRowModes(int index) {
        ITrack track = (ITrack)this.model.getCurrentTrackBank().getItem(index);
        if (this.isButtonCombination(ButtonID.DELETE)) {
            track.remove();
            return;
        }
        if (this.isButtonCombination(ButtonID.DUPLICATE)) {
            track.duplicate();
            return;
        }
        ModeManager modeManager = ((LaunchpadControlSurface)this.surface).getModeManager();
        if (modeManager.isActive(new Modes[]{Modes.REC_ARM})) {
            track.toggleRecArm();
        } else if (modeManager.isActive(new Modes[]{Modes.TRACK_SELECT})) {
            track.selectOrExpandGroup();
            this.mvHelper.notifySelectedTrack();
        } else if (modeManager.isActive(new Modes[]{Modes.MUTE})) {
            track.toggleMute();
        } else if (modeManager.isActive(new Modes[]{Modes.SOLO})) {
            track.toggleSolo();
        } else if (modeManager.isActive(new Modes[]{Modes.STOP_CLIP})) {
            ((LaunchpadControlSurface)this.surface).setTriggerConsumed(ButtonID.SHIFT);
            track.stop(((LaunchpadControlSurface)this.surface).isShiftPressed());
        }
    }

    private boolean isControlModeOff() {
        return ((LaunchpadControlSurface)this.surface).hasTrackSelectionButtons() || this.isBirdsEyeActive() || ((LaunchpadControlSurface)this.surface).getModeManager().getActiveID() == Modes.DUMMY;
    }

    private void updateRowsCols() {
        this.rows = 8;
        this.columns = 8;
        if (!this.isControlModeOff()) {
            this.rows = 7;
        }
    }

    private int getModeColor(ITrack track, int index) {
        if (track.doesExist()) {
            ModeManager modeManager = ((LaunchpadControlSurface)this.surface).getModeManager();
            if (modeManager.isActive(new Modes[]{Modes.REC_ARM})) {
                return track.isRecArm() ? 5 : 7;
            }
            if (modeManager.isActive(new Modes[]{Modes.TRACK_SELECT})) {
                return track.isSelected() ? 21 : 23;
            }
            if (modeManager.isActive(new Modes[]{Modes.MUTE})) {
                return track.isMute() ? 13 : 15;
            }
            if (modeManager.isActive(new Modes[]{Modes.SOLO})) {
                return track.isSolo() ? 45 : 47;
            }
            if (modeManager.isActive(new Modes[]{Modes.STOP_CLIP})) {
                return ((LaunchpadControlSurface)this.surface).isPressed(ButtonID.get(ButtonID.PAD1, index)) ? 6 : 4;
            }
        }
        return 0;
    }

    private int getControlModeIndex(int note) {
        if (this.isControlModeOff()) {
            return -1;
        }
        if (this.configuration.isFlipSession()) {
            int n = note + 1 - 36;
            if (n % 8 == 0) {
                return 8 - n / 8;
            }
            return -1;
        }
        if (note < 44) {
            return note - 36;
        }
        return -1;
    }

    @Override
    protected Pair<Integer, Integer> getPad(int note) {
        int index = note - 36;
        int x = index % 8;
        int y = 7 - index / 8;
        return this.configuration.isFlipSession() ? new Pair<Integer, Integer>(y, x) : new Pair<Integer, Integer>(x, y);
    }

    @Override
    public void updateScrollStates(ScrollStates scrollStates) {
        ITrackBank tb = this.model.getCurrentTrackBank();
        Optional sel = tb.getSelectedItem();
        int selIndex = sel.isPresent() ? ((ITrack)sel.get()).getIndex() : -1;
        ISceneBank sceneBank = tb.getSceneBank();
        scrollStates.setCanScrollLeft(selIndex > 0 || tb.canScrollPageBackwards());
        scrollStates.setCanScrollRight(selIndex >= 0 && selIndex < 7 && ((ITrack)tb.getItem(selIndex + 1)).doesExist() || tb.canScrollPageForwards());
        scrollStates.setCanScrollUp(sceneBank.canScrollPageBackwards());
        scrollStates.setCanScrollDown(sceneBank.canScrollPageForwards());
    }
}

