/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.novation.launchpad;

import de.mossgrabers.controller.novation.launchpad.LaunchpadConfiguration;
import de.mossgrabers.controller.novation.launchpad.command.trigger.DeleteCommand;
import de.mossgrabers.controller.novation.launchpad.command.trigger.LaunchpadCursorCommand;
import de.mossgrabers.controller.novation.launchpad.command.trigger.LaunchpadDuplicateCommand;
import de.mossgrabers.controller.novation.launchpad.command.trigger.MuteCommand;
import de.mossgrabers.controller.novation.launchpad.command.trigger.PanCommand;
import de.mossgrabers.controller.novation.launchpad.command.trigger.PlayAndNewCommand;
import de.mossgrabers.controller.novation.launchpad.command.trigger.ProjectCommand;
import de.mossgrabers.controller.novation.launchpad.command.trigger.RecordArmCommand;
import de.mossgrabers.controller.novation.launchpad.command.trigger.SelectDeviceViewCommand;
import de.mossgrabers.controller.novation.launchpad.command.trigger.SelectMainViewCommand;
import de.mossgrabers.controller.novation.launchpad.command.trigger.SelectSessionViewCommand;
import de.mossgrabers.controller.novation.launchpad.command.trigger.SendsCommand;
import de.mossgrabers.controller.novation.launchpad.command.trigger.SoloCommand;
import de.mossgrabers.controller.novation.launchpad.command.trigger.StopClipCommand;
import de.mossgrabers.controller.novation.launchpad.command.trigger.TrackSelectCommand;
import de.mossgrabers.controller.novation.launchpad.command.trigger.VolumeCommand;
import de.mossgrabers.controller.novation.launchpad.controller.LaunchpadColorManager;
import de.mossgrabers.controller.novation.launchpad.controller.LaunchpadControlSurface;
import de.mossgrabers.controller.novation.launchpad.controller.LaunchpadScales;
import de.mossgrabers.controller.novation.launchpad.definition.ILaunchpadControllerDefinition;
import de.mossgrabers.controller.novation.launchpad.definition.button.ButtonSetup;
import de.mossgrabers.controller.novation.launchpad.definition.button.LaunchpadButton;
import de.mossgrabers.controller.novation.launchpad.definition.button.LaunchpadButtonInfo;
import de.mossgrabers.controller.novation.launchpad.view.ChordsView;
import de.mossgrabers.controller.novation.launchpad.view.DeviceView;
import de.mossgrabers.controller.novation.launchpad.view.Drum4View;
import de.mossgrabers.controller.novation.launchpad.view.Drum64View;
import de.mossgrabers.controller.novation.launchpad.view.Drum8View;
import de.mossgrabers.controller.novation.launchpad.view.DrumView;
import de.mossgrabers.controller.novation.launchpad.view.LaunchpadBrowserView;
import de.mossgrabers.controller.novation.launchpad.view.LaunchpadShuffleView;
import de.mossgrabers.controller.novation.launchpad.view.MixView;
import de.mossgrabers.controller.novation.launchpad.view.NoteEditView;
import de.mossgrabers.controller.novation.launchpad.view.NoteViewSelectView;
import de.mossgrabers.controller.novation.launchpad.view.PanView;
import de.mossgrabers.controller.novation.launchpad.view.PianoView;
import de.mossgrabers.controller.novation.launchpad.view.PlayView;
import de.mossgrabers.controller.novation.launchpad.view.PolySequencerView;
import de.mossgrabers.controller.novation.launchpad.view.ProjectView;
import de.mossgrabers.controller.novation.launchpad.view.RaindropsView;
import de.mossgrabers.controller.novation.launchpad.view.SendsView;
import de.mossgrabers.controller.novation.launchpad.view.SequencerView;
import de.mossgrabers.controller.novation.launchpad.view.SessionView;
import de.mossgrabers.controller.novation.launchpad.view.ShiftView;
import de.mossgrabers.controller.novation.launchpad.view.UserView;
import de.mossgrabers.controller.novation.launchpad.view.VolumeView;
import de.mossgrabers.framework.command.aftertouch.AftertouchViewCommand;
import de.mossgrabers.framework.command.core.TriggerCommand;
import de.mossgrabers.framework.command.trigger.Direction;
import de.mossgrabers.framework.command.trigger.application.UndoCommand;
import de.mossgrabers.framework.command.trigger.clip.NewCommand;
import de.mossgrabers.framework.command.trigger.clip.QuantizeCommand;
import de.mossgrabers.framework.command.trigger.transport.ConfiguredRecordCommand;
import de.mossgrabers.framework.command.trigger.transport.MetronomeCommand;
import de.mossgrabers.framework.command.trigger.view.SelectPlayViewCommand;
import de.mossgrabers.framework.command.trigger.view.ToggleShiftViewCommand;
import de.mossgrabers.framework.command.trigger.view.ViewButtonCommand;
import de.mossgrabers.framework.command.trigger.view.ViewMultiSelectCommand;
import de.mossgrabers.framework.configuration.ISettingsUI;
import de.mossgrabers.framework.controller.AbstractControllerSetup;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.ISetupFactory;
import de.mossgrabers.framework.controller.OutputID;
import de.mossgrabers.framework.controller.hardware.BindType;
import de.mossgrabers.framework.controller.hardware.IHwButton;
import de.mossgrabers.framework.controller.hardware.IHwLight;
import de.mossgrabers.framework.controller.valuechanger.TwosComplementValueChanger;
import de.mossgrabers.framework.daw.DAWColor;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.ITransport;
import de.mossgrabers.framework.daw.ModelSetup;
import de.mossgrabers.framework.daw.data.ICursorDevice;
import de.mossgrabers.framework.daw.data.ICursorTrack;
import de.mossgrabers.framework.daw.data.ISend;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.IParameterBank;
import de.mossgrabers.framework.daw.data.bank.ISendBank;
import de.mossgrabers.framework.daw.data.bank.ITrackBank;
import de.mossgrabers.framework.daw.midi.IMidiAccess;
import de.mossgrabers.framework.daw.midi.IMidiInput;
import de.mossgrabers.framework.daw.midi.IMidiOutput;
import de.mossgrabers.framework.featuregroup.IMode;
import de.mossgrabers.framework.featuregroup.IView;
import de.mossgrabers.framework.featuregroup.ModeManager;
import de.mossgrabers.framework.featuregroup.ViewManager;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.mode.track.TrackMuteMode;
import de.mossgrabers.framework.mode.track.TrackPanMode;
import de.mossgrabers.framework.mode.track.TrackRecArmMode;
import de.mossgrabers.framework.mode.track.TrackSelectMode;
import de.mossgrabers.framework.mode.track.TrackSendMode;
import de.mossgrabers.framework.mode.track.TrackSoloMode;
import de.mossgrabers.framework.mode.track.TrackStopClipMode;
import de.mossgrabers.framework.mode.track.TrackVolumeMode;
import de.mossgrabers.framework.parameter.IParameter;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.ScenePlayView;
import de.mossgrabers.framework.view.TempoView;
import de.mossgrabers.framework.view.Views;
import de.mossgrabers.framework.view.sequencer.ClipLengthView;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class LaunchpadControllerSetup
extends AbstractControllerSetup<LaunchpadControlSurface, LaunchpadConfiguration> {
    private final ILaunchpadControllerDefinition definition;
    private static final Views[] PLAY_VIEWS = new Views[]{Views.PLAY, Views.PIANO, Views.DRUM64};
    private static final Views[] SEQUENCER_VIEWS = new Views[]{Views.SEQUENCER, Views.POLY_SEQUENCER, Views.RAINDROPS};
    private static final Views[] DRUM_VIEWS = new Views[]{Views.DRUM, Views.DRUM4, Views.DRUM8};
    private static final Set<Views> MAIN_VIEWS = new HashSet<Views>();

    public LaunchpadControllerSetup(IHost host, ISetupFactory factory, ISettingsUI globalSettings, ISettingsUI documentSettings, ILaunchpadControllerDefinition definition) {
        super(factory, host, globalSettings, documentSettings);
        this.definition = definition;
        this.colorManager = new LaunchpadColorManager();
        this.valueChanger = new TwosComplementValueChanger(128, 1);
        this.configuration = new LaunchpadConfiguration(host, this.valueChanger, factory.getArpeggiatorModes(), definition);
    }

    @Override
    protected void createScales() {
        this.scales = new LaunchpadScales(this.valueChanger, 36, 100, 8, 8);
    }

    @Override
    protected void createModel() {
        ModelSetup ms = new ModelSetup();
        ms.enableDrum64Device();
        ms.setHasFullFlatTrackList(((LaunchpadConfiguration)this.configuration).areMasterTracksIncluded());
        this.model = this.factory.createModel(this.configuration, this.colorManager, this.valueChanger, this.scales, ms);
    }

    @Override
    protected void createSurface() {
        IMidiAccess midiAccess = this.factory.createMidiAccess();
        IMidiOutput output = midiAccess.createOutput();
        IMidiInput input = midiAccess.createInput("Pads", "80????", "90????");
        LaunchpadControlSurface surface = new LaunchpadControlSurface(this.host, this.colorManager, (LaunchpadConfiguration)this.configuration, output, input, this.definition);
        this.surfaces.add(surface);
        surface.setLaunchpadToStandalone();
        surface.setLaunchpadToPrgMode();
    }

    @Override
    protected void createModes() {
        LaunchpadControlSurface surface = (LaunchpadControlSurface)this.getSurface();
        ModeManager modeManager = surface.getModeManager();
        modeManager.register(Modes.REC_ARM, new TrackRecArmMode(surface, this.model));
        modeManager.register(Modes.TRACK_SELECT, new TrackSelectMode(surface, this.model));
        modeManager.register(Modes.MUTE, new TrackMuteMode(surface, this.model));
        modeManager.register(Modes.SOLO, new TrackSoloMode(surface, this.model));
        modeManager.register(Modes.VOLUME, new TrackVolumeMode(surface, this.model, true));
        modeManager.register(Modes.PAN, new TrackPanMode(surface, this.model, true));
        modeManager.register(Modes.SEND, new TrackSendMode(-1, surface, this.model, true));
        modeManager.register(Modes.STOP_CLIP, new TrackStopClipMode(surface, this.model));
        modeManager.register(Modes.DUMMY, new TrackSelectMode(surface, this.model));
    }

    @Override
    protected void createViews() {
        LaunchpadControlSurface surface = (LaunchpadControlSurface)this.getSurface();
        ViewManager viewManager = surface.getViewManager();
        viewManager.register(Views.SHIFT, new ShiftView(surface, this.model));
        viewManager.register(Views.SESSION, new SessionView("Session", surface, this.model));
        viewManager.register(Views.SCENE_PLAY, new ScenePlayView(surface, this.model));
        viewManager.register(Views.PLAY, new PlayView(surface, this.model));
        viewManager.register(Views.CHORDS, new ChordsView(surface, this.model));
        viewManager.register(Views.PIANO, new PianoView(surface, this.model));
        viewManager.register(Views.SEQUENCER, new SequencerView(surface, this.model));
        viewManager.register(Views.POLY_SEQUENCER, new PolySequencerView(surface, this.model, true));
        viewManager.register(Views.RAINDROPS, new RaindropsView(surface, this.model));
        viewManager.register(Views.DRUM, new DrumView(surface, this.model));
        viewManager.register(Views.DRUM4, new Drum4View(surface, this.model));
        viewManager.register(Views.DRUM8, new Drum8View(surface, this.model));
        viewManager.register(Views.DRUM64, new Drum64View(surface, this.model));
        viewManager.register(Views.DEVICE, new DeviceView(surface, this.model));
        viewManager.register(Views.USER, new UserView(surface, this.model));
        viewManager.register(Views.BROWSER, new LaunchpadBrowserView(surface, this.model));
        viewManager.register(Views.TRACK_PAN, new PanView(surface, this.model));
        viewManager.register(Views.TRACK_VOLUME, new VolumeView(surface, this.model));
        viewManager.register(Views.TRACK_SENDS, new SendsView(surface, this.model));
        viewManager.register(Views.MIX, new MixView(surface, this.model));
        viewManager.register(Views.CONTROL, new NoteViewSelectView(surface, this.model));
        viewManager.register(Views.NOTE_EDIT_VIEW, new NoteEditView(surface, this.model));
        viewManager.register(Views.CLIP_LENGTH, new ClipLengthView(surface, this.model, true));
        viewManager.register(Views.TEMPO, new TempoView(surface, this.model, 45, 3, 0));
        viewManager.register(Views.SHUFFLE, new LaunchpadShuffleView(surface, this.model, 57, 3, 0));
        viewManager.register(Views.PROJECT, new ProjectView(surface, this.model));
    }

    @Override
    protected void createObservers() {
        super.createObservers();
        LaunchpadControlSurface surface = (LaunchpadControlSurface)this.getSurface();
        surface.getViewManager().addChangeListener((previousViewId, activeViewId) -> {
            surface.getLight(OutputID.LED1).forceFlush();
            this.updateIndication();
        });
        ITrackBank trackBank = this.model.getTrackBank();
        trackBank.addSelectionObserver((index, isSelected) -> this.handleTrackChange(isSelected));
        if (((LaunchpadConfiguration)this.configuration).canSettingBeObserved(LaunchpadConfiguration.PAD_BRIGHTNESS)) {
            ((LaunchpadConfiguration)this.configuration).addSettingObserver(LaunchpadConfiguration.PAD_BRIGHTNESS, surface::updateBrightness);
        }
        ((LaunchpadConfiguration)this.configuration).registerDeactivatedItemsHandler(this.model);
        this.createScaleObservers((LaunchpadConfiguration)this.configuration);
        this.createNoteRepeatObservers((LaunchpadConfiguration)this.configuration, surface);
        this.activateBrowserObserver(Views.BROWSER);
    }

    @Override
    protected void registerTriggerCommands() {
        int i;
        LaunchpadButtonInfo projectInfo;
        LaunchpadControlSurface surface = (LaunchpadControlSurface)this.getSurface();
        ViewManager viewManager = surface.getViewManager();
        ITransport transport = this.model.getTransport();
        ButtonSetup buttonSetup = this.definition.getButtonSetup();
        this.addButton(ButtonID.SHIFT, "Shift", new ToggleShiftViewCommand(this.model, surface), buttonSetup.get(LaunchpadButton.SHIFT).getControl(), () -> viewManager.isActive(new Views[]{Views.SHIFT}) || surface.isShiftPressed() ? 3 : 1);
        LaunchpadCursorCommand commandUp = new LaunchpadCursorCommand(Direction.UP, this.model, surface);
        LaunchpadCursorCommand commandDown = new LaunchpadCursorCommand(Direction.DOWN, this.model, surface);
        LaunchpadCursorCommand commandLeft = new LaunchpadCursorCommand(Direction.LEFT, this.model, surface);
        LaunchpadCursorCommand commandRight = new LaunchpadCursorCommand(Direction.RIGHT, this.model, surface);
        this.addButton(ButtonID.UP, "Up", (TriggerCommand)commandUp, buttonSetup.get(LaunchpadButton.ARROW_UP).getControl(), () -> commandUp.canScroll() ? this.getViewColor() : 0);
        this.addButton(ButtonID.DOWN, "Down", (TriggerCommand)commandDown, buttonSetup.get(LaunchpadButton.ARROW_DOWN).getControl(), () -> commandDown.canScroll() ? this.getViewColor() : 0);
        this.addButton(ButtonID.LEFT, "Left", (TriggerCommand)commandLeft, buttonSetup.get(LaunchpadButton.ARROW_LEFT).getControl(), () -> commandLeft.canScroll() ? this.getViewColor() : 0);
        this.addButton(ButtonID.RIGHT, "Right", (TriggerCommand)commandRight, buttonSetup.get(LaunchpadButton.ARROW_RIGHT).getControl(), () -> commandRight.canScroll() ? this.getViewColor() : 0);
        this.addButton(ButtonID.SESSION, "Session", (TriggerCommand)new SelectSessionViewCommand(this.model, surface), buttonSetup.get(LaunchpadButton.SESSION).getControl(), () -> this.getViewStateColor(18, Views.SESSION, Views.MIX));
        SelectDeviceViewCommand selectDeviceViewCommand = new SelectDeviceViewCommand(this.model, surface);
        this.addButton(ButtonID.DEVICE, "Device", (TriggerCommand)selectDeviceViewCommand, buttonSetup.get(LaunchpadButton.DEVICE).getControl(), selectDeviceViewCommand::getButtonColor);
        LaunchpadButtonInfo userInfo = buttonSetup.get(LaunchpadButton.USER);
        if (!userInfo.isVirtual()) {
            this.addButton(ButtonID.USER, "User", new ViewMultiSelectCommand(this.model, surface, Views.CLIP_LENGTH), userInfo.getControl(), () -> viewManager.isActive(new Views[]{Views.CLIP_LENGTH}) ? 54 : 1);
        }
        if (!(projectInfo = buttonSetup.get(LaunchpadButton.PROJECT)).isVirtual()) {
            this.addButton(ButtonID.PROJECT, "Project", (TriggerCommand)new ProjectCommand(this.model, surface), projectInfo.getControl(), () -> viewManager.isActive(new Views[]{Views.PROJECT}) ? 33 : 1);
        }
        LaunchpadButtonInfo clickInfo = buttonSetup.get(LaunchpadButton.CLICK);
        this.addButton(ButtonID.METRONOME, "Metronome", new MetronomeCommand(this.model, surface, true), clickInfo.isShifted() ? -1 : clickInfo.getControl(), () -> {
            if (surface.isShiftPressed()) {
                return surface.isPressed(ButtonID.METRONOME) ? 3 : 24;
            }
            return transport.isMetronomeOn() ? 21 : 23;
        });
        LaunchpadButtonInfo shiftInfo = buttonSetup.get(LaunchpadButton.UNDO);
        this.addButton(ButtonID.UNDO, "Undo", new UndoCommand(this.model, surface), shiftInfo.isShifted() ? -1 : shiftInfo.getControl(), () -> LaunchpadControllerSetup.get2StateColor(surface, ButtonID.UNDO));
        this.addButton(ButtonID.DELETE, "Delete", (TriggerCommand)new DeleteCommand(this.model, surface), buttonSetup.get(LaunchpadButton.DELETE).getControl(), () -> this.getDeleteStateColor(surface));
        this.addButton(ButtonID.QUANTIZE, "Quantize", new QuantizeCommand(this.model, surface), buttonSetup.get(LaunchpadButton.QUANTIZE).getControl(), () -> LaunchpadControllerSetup.getStateColor(surface, ButtonID.QUANTIZE));
        this.addButton(ButtonID.DUPLICATE, "Duplicate", (TriggerCommand)new LaunchpadDuplicateCommand(this.model, surface), buttonSetup.get(LaunchpadButton.DUPLICATE).getControl(), () -> LaunchpadControllerSetup.getDuplicateStateColor(surface));
        this.addButton(ButtonID.PLAY, "Play", (TriggerCommand)new PlayAndNewCommand(this.model, surface), buttonSetup.get(LaunchpadButton.PLAY).getControl(), () -> this.getPlayStateColor(surface));
        if (this.definition.isPro()) {
            ConfiguredRecordCommand configuredRecordCommand = new ConfiguredRecordCommand(this.model, surface);
            this.addButton(ButtonID.RECORD, "Record", configuredRecordCommand, buttonSetup.get(LaunchpadButton.RECORD).getControl(), () -> {
                boolean isShift = surface.isShiftPressed();
                boolean isLit = configuredRecordCommand.isLit(isShift);
                if (isShift) {
                    return isLit ? 4 : 8;
                }
                return isLit ? 5 : 7;
            });
        }
        this.addButton(ButtonID.REC_ARM, "Rec Arm", (TriggerCommand)new RecordArmCommand(this.model, surface), buttonSetup.get(LaunchpadButton.REC_ARM).getControl(), () -> this.getModeColorIndex(ButtonID.REC_ARM));
        this.addButton(ButtonID.TRACK, "Track", (TriggerCommand)new TrackSelectCommand(this.model, surface), buttonSetup.get(LaunchpadButton.TRACK_SELECT).getControl(), () -> this.getModeColorIndex(ButtonID.TRACK));
        this.addButton(ButtonID.MUTE, "Mute", (TriggerCommand)new MuteCommand(this.model, surface), buttonSetup.get(LaunchpadButton.MUTE).getControl(), () -> this.getModeColorIndex(ButtonID.MUTE));
        this.addButton(ButtonID.SOLO, "Solo", (TriggerCommand)new SoloCommand(this.model, surface), buttonSetup.get(LaunchpadButton.SOLO).getControl(), () -> this.getModeColorIndex(ButtonID.SOLO));
        this.addButton(ButtonID.VOLUME, "Volume", (TriggerCommand)new VolumeCommand(this.model, surface), buttonSetup.get(LaunchpadButton.VOLUME).getControl(), () -> this.getModeColorIndex(ButtonID.VOLUME));
        this.addButton(ButtonID.PAN_SEND, "Panning", (TriggerCommand)new PanCommand(this.model, surface), buttonSetup.get(LaunchpadButton.PAN).getControl(), () -> this.getModeColorIndex(ButtonID.PAN_SEND));
        this.addButton(ButtonID.SENDS, "Sends", (TriggerCommand)new SendsCommand(this.model, surface), buttonSetup.get(LaunchpadButton.SENDS).getControl(), () -> this.getModeColorIndex(ButtonID.SENDS));
        this.addButton(ButtonID.STOP_CLIP, "Stop Clip", (TriggerCommand)new StopClipCommand(this.model, surface), buttonSetup.get(LaunchpadButton.STOP_CLIP).getControl(), () -> this.getModeColorIndex(ButtonID.STOP_CLIP));
        for (i = 0; i < 8; ++i) {
            ButtonID buttonID = ButtonID.get(ButtonID.SCENE1, i);
            this.addButton(buttonID, "Scene " + (i + 1), new ViewButtonCommand(buttonID, surface), buttonSetup.get(LaunchpadButton.SCENES.get(i)).getControl(), () -> this.getButtonColorFromActiveView(buttonID));
        }
        if (this.definition.hasTrackSelectionButtons()) {
            for (i = 0; i < 8; ++i) {
                int index = i;
                this.addButton(ButtonID.get(ButtonID.ROW1_1, i), "Track Select " + (i + 1), (ButtonEvent event, int velocity) -> this.handleTrackSelection(event, index), 101 + i, () -> this.getTrackModeColorIndex(index));
            }
            this.addButton(ButtonID.NOTE, "Note", new SelectPlayViewCommand(this.model, surface, PLAY_VIEWS, MAIN_VIEWS), buttonSetup.get(LaunchpadButton.NOTE).getControl(), () -> this.getViewStateColor(9, PLAY_VIEWS));
            this.addButton(ButtonID.DRUM, "Drum Seq", new SelectPlayViewCommand(this.model, surface, DRUM_VIEWS, MAIN_VIEWS), 95, () -> this.getViewStateColor(41, DRUM_VIEWS));
            this.addButton(ButtonID.SEQUENCER, "Sequencer", new SelectPlayViewCommand(this.model, surface, SEQUENCER_VIEWS, MAIN_VIEWS), 97, () -> this.getViewStateColor(13, SEQUENCER_VIEWS));
            this.addButton(ButtonID.NEW, "New", new NewCommand(this.model, surface), 30, () -> surface.isPressed(ButtonID.NEW) ? 9 : 11);
        } else {
            this.addButton(ButtonID.NOTE, "Note", (TriggerCommand)new SelectMainViewCommand(this.model, surface, MAIN_VIEWS), buttonSetup.get(LaunchpadButton.NOTE).getControl(), this::getNoteButtonColor);
        }
        surface.createLight(OutputID.LED1, () -> {
            ICursorTrack cursorTrack = this.model.getCursorTrack();
            return cursorTrack.doesExist() ? this.colorManager.getColorIndex(DAWColor.getColorID(cursorTrack.getColor())) : 0;
        }, color -> this.definition.setLogoColor(surface, color), state -> this.colorManager.getColor(state, null), null);
        for (Map.Entry<ButtonID, IHwButton> entry : surface.getButtons().entrySet()) {
            ButtonID key = entry.getKey();
            int keyValue = key.ordinal();
            if (ButtonID.PAD1.ordinal() >= keyValue && ButtonID.PAD64.ordinal() <= keyValue) continue;
            entry.getValue().addEventHandler(ButtonEvent.UP, event -> {
                IHwLight light = surface.getButton(key).getLight();
                if (light != null) {
                    light.forceFlush();
                }
            });
        }
    }

    private int getNoteButtonColor() {
        ViewManager viewManager = ((LaunchpadControlSurface)this.getSurface()).getViewManager();
        Views activeID = (Views)((Object)viewManager.getActiveID());
        if (activeID == Views.CONTROL) {
            return 22;
        }
        return MAIN_VIEWS.contains((Object)activeID) ? this.getViewColor() : 1;
    }

    @Override
    protected BindType getTriggerBindType(ButtonID buttonID) {
        if (ButtonID.isSceneButton(buttonID)) {
            return this.definition.sceneButtonsUseCC() ? BindType.CC : BindType.NOTE;
        }
        return super.getTriggerBindType(buttonID);
    }

    @Override
    protected void registerContinuousCommands() {
        Views[] views;
        LaunchpadControlSurface surface = (LaunchpadControlSurface)this.getSurface();
        ViewManager viewManager = surface.getViewManager();
        for (Views viewID : views = new Views[]{Views.PLAY, Views.PIANO, Views.DRUM, Views.DRUM64}) {
            IView view = (IView)viewManager.get(viewID);
            view.registerAftertouchCommand(new AftertouchViewCommand(view, this.model, surface));
        }
    }

    @Override
    protected void layoutControls() {
        LaunchpadControlSurface surface = (LaunchpadControlSurface)this.getSurface();
        double offset = this.definition.isPro() ? 0.0 : 100.0;
        surface.getButton(ButtonID.PAD1).setBounds(114.0 - offset, 596.0, 61.0, 60.0);
        surface.getButton(ButtonID.PAD2).setBounds(188.5 - offset, 596.0, 61.0, 60.0);
        surface.getButton(ButtonID.PAD3).setBounds(262.25 - offset, 596.0, 61.0, 60.0);
        surface.getButton(ButtonID.PAD4).setBounds(335.75 - offset, 596.0, 61.0, 60.0);
        surface.getButton(ButtonID.PAD5).setBounds(410.25 - offset, 596.0, 61.0, 60.0);
        surface.getButton(ButtonID.PAD6).setBounds(483.0 - offset, 596.0, 61.0, 60.0);
        surface.getButton(ButtonID.PAD7).setBounds(559.25 - offset, 596.0, 61.0, 60.0);
        surface.getButton(ButtonID.PAD8).setBounds(632.75 - offset, 596.0, 61.0, 60.0);
        surface.getButton(ButtonID.PAD9).setBounds(114.0 - offset, 522.25, 61.0, 60.0);
        surface.getButton(ButtonID.PAD10).setBounds(188.5 - offset, 522.25, 61.0, 60.0);
        surface.getButton(ButtonID.PAD11).setBounds(262.25 - offset, 522.25, 61.0, 60.0);
        surface.getButton(ButtonID.PAD12).setBounds(335.75 - offset, 522.25, 61.0, 60.0);
        surface.getButton(ButtonID.PAD13).setBounds(410.25 - offset, 522.25, 61.0, 60.0);
        surface.getButton(ButtonID.PAD14).setBounds(483.0 - offset, 522.25, 61.0, 60.0);
        surface.getButton(ButtonID.PAD15).setBounds(559.25 - offset, 522.25, 61.0, 60.0);
        surface.getButton(ButtonID.PAD16).setBounds(632.75 - offset, 522.25, 61.0, 60.0);
        surface.getButton(ButtonID.PAD17).setBounds(114.0 - offset, 450.5, 61.0, 60.0);
        surface.getButton(ButtonID.PAD18).setBounds(188.5 - offset, 450.5, 61.0, 60.0);
        surface.getButton(ButtonID.PAD19).setBounds(262.25 - offset, 450.5, 61.0, 60.0);
        surface.getButton(ButtonID.PAD20).setBounds(335.75 - offset, 450.5, 61.0, 60.0);
        surface.getButton(ButtonID.PAD21).setBounds(410.25 - offset, 450.5, 61.0, 60.0);
        surface.getButton(ButtonID.PAD22).setBounds(483.0 - offset, 450.5, 61.0, 60.0);
        surface.getButton(ButtonID.PAD23).setBounds(559.25 - offset, 450.5, 61.0, 60.0);
        surface.getButton(ButtonID.PAD24).setBounds(632.75 - offset, 450.5, 61.0, 60.0);
        surface.getButton(ButtonID.PAD25).setBounds(114.0 - offset, 373.0, 61.0, 60.0);
        surface.getButton(ButtonID.PAD26).setBounds(188.5 - offset, 373.0, 61.0, 60.0);
        surface.getButton(ButtonID.PAD27).setBounds(262.25 - offset, 373.0, 61.0, 60.0);
        surface.getButton(ButtonID.PAD28).setBounds(335.75 - offset, 373.0, 61.0, 60.0);
        surface.getButton(ButtonID.PAD29).setBounds(410.25 - offset, 373.0, 61.0, 60.0);
        surface.getButton(ButtonID.PAD30).setBounds(483.0 - offset, 373.0, 61.0, 60.0);
        surface.getButton(ButtonID.PAD31).setBounds(559.25 - offset, 373.0, 61.0, 60.0);
        surface.getButton(ButtonID.PAD32).setBounds(632.75 - offset, 373.0, 61.0, 60.0);
        surface.getButton(ButtonID.PAD33).setBounds(114.0 - offset, 299.75, 61.0, 60.0);
        surface.getButton(ButtonID.PAD34).setBounds(188.5 - offset, 299.75, 61.0, 60.0);
        surface.getButton(ButtonID.PAD35).setBounds(262.25 - offset, 299.75, 61.0, 60.0);
        surface.getButton(ButtonID.PAD36).setBounds(335.75 - offset, 299.75, 61.0, 60.0);
        surface.getButton(ButtonID.PAD37).setBounds(410.25 - offset, 299.75, 61.0, 60.0);
        surface.getButton(ButtonID.PAD38).setBounds(483.0 - offset, 299.75, 61.0, 60.0);
        surface.getButton(ButtonID.PAD39).setBounds(559.25 - offset, 299.75, 61.0, 60.0);
        surface.getButton(ButtonID.PAD40).setBounds(632.75 - offset, 299.75, 61.0, 60.0);
        surface.getButton(ButtonID.PAD41).setBounds(114.0 - offset, 226.75, 61.0, 60.0);
        surface.getButton(ButtonID.PAD42).setBounds(188.5 - offset, 226.75, 61.0, 60.0);
        surface.getButton(ButtonID.PAD43).setBounds(262.25 - offset, 226.75, 61.0, 60.0);
        surface.getButton(ButtonID.PAD44).setBounds(335.75 - offset, 226.75, 61.0, 60.0);
        surface.getButton(ButtonID.PAD45).setBounds(410.25 - offset, 226.75, 61.0, 60.0);
        surface.getButton(ButtonID.PAD46).setBounds(483.0 - offset, 226.75, 61.0, 60.0);
        surface.getButton(ButtonID.PAD47).setBounds(559.25 - offset, 226.75, 61.0, 60.0);
        surface.getButton(ButtonID.PAD48).setBounds(632.75 - offset, 226.75, 61.0, 60.0);
        surface.getButton(ButtonID.PAD49).setBounds(114.0 - offset, 150.75, 61.0, 60.0);
        surface.getButton(ButtonID.PAD50).setBounds(188.5 - offset, 150.75, 61.0, 60.0);
        surface.getButton(ButtonID.PAD51).setBounds(262.25 - offset, 150.75, 61.0, 60.0);
        surface.getButton(ButtonID.PAD52).setBounds(335.75 - offset, 150.75, 61.0, 60.0);
        surface.getButton(ButtonID.PAD53).setBounds(410.25 - offset, 150.75, 61.0, 60.0);
        surface.getButton(ButtonID.PAD54).setBounds(483.0 - offset, 150.75, 61.0, 60.0);
        surface.getButton(ButtonID.PAD55).setBounds(559.25 - offset, 150.75, 61.0, 60.0);
        surface.getButton(ButtonID.PAD56).setBounds(632.75 - offset, 150.75, 61.0, 60.0);
        surface.getButton(ButtonID.PAD57).setBounds(114.0 - offset, 79.0, 61.0, 60.0);
        surface.getButton(ButtonID.PAD58).setBounds(188.5 - offset, 79.0, 61.0, 60.0);
        surface.getButton(ButtonID.PAD59).setBounds(262.25 - offset, 79.0, 61.0, 60.0);
        surface.getButton(ButtonID.PAD60).setBounds(335.75 - offset, 79.0, 61.0, 60.0);
        surface.getButton(ButtonID.PAD61).setBounds(410.25 - offset, 79.0, 61.0, 60.0);
        surface.getButton(ButtonID.PAD62).setBounds(483.0 - offset, 79.0, 61.0, 60.0);
        surface.getButton(ButtonID.PAD63).setBounds(559.25 - offset, 79.0, 61.0, 60.0);
        surface.getButton(ButtonID.PAD64).setBounds(632.75 - offset, 79.0, 61.0, 60.0);
        surface.getButton(ButtonID.SCENE1).setBounds(707.0 - offset, 79.0, 61.0, 60.0);
        surface.getButton(ButtonID.SCENE2).setBounds(707.0 - offset, 150.75, 61.0, 60.0);
        surface.getButton(ButtonID.SCENE3).setBounds(707.0 - offset, 226.75, 61.0, 60.0);
        surface.getButton(ButtonID.SCENE4).setBounds(707.0 - offset, 299.75, 61.0, 60.0);
        surface.getButton(ButtonID.SCENE5).setBounds(707.0 - offset, 373.0, 61.0, 60.0);
        surface.getButton(ButtonID.SCENE6).setBounds(707.0 - offset, 450.5, 61.0, 60.0);
        surface.getButton(ButtonID.SCENE7).setBounds(707.0 - offset, 596.0, 61.0, 60.0);
        surface.getButton(ButtonID.SCENE8).setBounds(707.0 - offset, 522.25, 61.0, 60.0);
        if (this.definition.isPro()) {
            surface.getButton(ButtonID.QUANTIZE).setBounds(41.0, 373.0, 61.0, 60.0);
            surface.getButton(ButtonID.PLAY).setBounds(41.0, 522.25, 61.0, 60.0);
            surface.getButton(ButtonID.RECORD).setBounds(41.0, 596.0, 61.0, 60.0);
            if (this.definition.hasTrackSelectionButtons()) {
                surface.getButton(ButtonID.SHIFT).setBounds(41.0, 8.5, 61.0, 60.0);
                surface.getButton(ButtonID.LEFT).setBounds(114.0, 8.5, 61.0, 60.0);
                surface.getButton(ButtonID.RIGHT).setBounds(188.5, 8.5, 61.0, 60.0);
                surface.getButton(ButtonID.SESSION).setBounds(262.25, 8.5, 61.0, 60.0);
                surface.getButton(ButtonID.NOTE).setBounds(335.75, 8.5, 61.0, 60.0);
                surface.getButton(ButtonID.DRUM).setBounds(410.25, 8.5, 61.0, 60.0);
                surface.getButton(ButtonID.USER).setBounds(483.0, 8.5, 61.0, 60.0);
                surface.getButton(ButtonID.SEQUENCER).setBounds(559.25, 8.5, 61.0, 60.0);
                surface.getButton(ButtonID.PROJECT).setBounds(632.75, 8.5, 61.0, 60.0);
                surface.getButton(ButtonID.UP).setBounds(41.0, 79.0, 61.0, 60.0);
                surface.getButton(ButtonID.DOWN).setBounds(41.0, 150.75, 61.0, 60.0);
                surface.getButton(ButtonID.DELETE).setBounds(41.0, 226.75, 61.0, 60.0);
                surface.getButton(ButtonID.DUPLICATE).setBounds(41.0, 299.75, 61.0, 60.0);
                surface.getButton(ButtonID.NEW).setBounds(41.0, 450.5, 61.0, 60.0);
                surface.getButton(ButtonID.REC_ARM).setBounds(113.25, 698.0, 61.0, 30.0);
                surface.getButton(ButtonID.MUTE).setBounds(188.5, 698.0, 61.0, 30.0);
                surface.getButton(ButtonID.SOLO).setBounds(262.25, 698.0, 61.0, 30.0);
                surface.getButton(ButtonID.VOLUME).setBounds(335.75, 698.0, 61.0, 30.0);
                surface.getButton(ButtonID.PAN_SEND).setBounds(410.25, 698.0, 61.0, 30.0);
                surface.getButton(ButtonID.SENDS).setBounds(483.0, 698.0, 61.0, 30.0);
                surface.getButton(ButtonID.DEVICE).setBounds(559.25, 698.0, 61.0, 30.0);
                surface.getButton(ButtonID.STOP_CLIP).setBounds(632.75, 698.0, 61.0, 30.0);
                surface.getButton(ButtonID.ROW1_1).setBounds(113.25, 666.0, 61.0, 30.0);
                surface.getButton(ButtonID.ROW1_2).setBounds(188.5, 666.0, 61.0, 30.0);
                surface.getButton(ButtonID.ROW1_3).setBounds(262.25, 666.0, 61.0, 30.0);
                surface.getButton(ButtonID.ROW1_4).setBounds(335.75, 666.0, 61.0, 30.0);
                surface.getButton(ButtonID.ROW1_5).setBounds(410.25, 666.0, 61.0, 30.0);
                surface.getButton(ButtonID.ROW1_6).setBounds(483.0, 666.0, 61.0, 30.0);
                surface.getButton(ButtonID.ROW1_7).setBounds(559.25, 666.0, 61.0, 30.0);
                surface.getButton(ButtonID.ROW1_8).setBounds(632.75, 666.0, 61.0, 30.0);
            } else {
                surface.getButton(ButtonID.SHIFT).setBounds(41.0, 79.0, 61.0, 60.0);
                surface.getButton(ButtonID.USER).setBounds(632.75, 8.5, 61.0, 60.0);
                surface.getButton(ButtonID.METRONOME).setBounds(41.0, 150.75, 61.0, 60.0);
                surface.getButton(ButtonID.UNDO).setBounds(41.0, 226.75, 61.0, 60.0);
                surface.getButton(ButtonID.DELETE).setBounds(41.0, 299.75, 61.0, 60.0);
                surface.getButton(ButtonID.DUPLICATE).setBounds(41.0, 450.5, 61.0, 60.0);
                surface.getButton(ButtonID.REC_ARM).setBounds(113.25, 668.0, 61.0, 60.0);
                surface.getButton(ButtonID.TRACK).setBounds(188.5, 668.0, 61.0, 60.0);
                surface.getButton(ButtonID.MUTE).setBounds(262.25, 668.0, 61.0, 60.0);
                surface.getButton(ButtonID.SOLO).setBounds(335.75, 668.0, 61.0, 60.0);
                surface.getButton(ButtonID.VOLUME).setBounds(410.25, 668.0, 61.0, 60.0);
                surface.getButton(ButtonID.PAN_SEND).setBounds(483.0, 668.0, 61.0, 60.0);
                surface.getButton(ButtonID.SENDS).setBounds(559.25, 668.0, 61.0, 60.0);
                surface.getButton(ButtonID.STOP_CLIP).setBounds(632.75, 668.0, 61.0, 60.0);
                surface.getButton(ButtonID.SESSION).setBounds(410.25, 8.5, 61.0, 60.0);
                surface.getButton(ButtonID.NOTE).setBounds(483.0, 8.5, 61.0, 60.0);
                surface.getButton(ButtonID.DEVICE).setBounds(559.25, 8.5, 61.0, 60.0);
                surface.getButton(ButtonID.UP).setBounds(114.0, 8.5, 61.0, 60.0);
                surface.getButton(ButtonID.DOWN).setBounds(188.5, 8.5, 61.0, 60.0);
                surface.getButton(ButtonID.LEFT).setBounds(262.25, 8.5, 61.0, 60.0);
                surface.getButton(ButtonID.RIGHT).setBounds(335.75, 8.5, 61.0, 60.0);
            }
        } else {
            surface.getButton(ButtonID.SHIFT).setBounds(632.75 - offset, 8.5, 61.0, 60.0);
            surface.getButton(ButtonID.SESSION).setBounds(410.25 - offset, 8.5, 61.0, 60.0);
            surface.getButton(ButtonID.NOTE).setBounds(483.0 - offset, 8.5, 61.0, 60.0);
            surface.getButton(ButtonID.DEVICE).setBounds(559.25 - offset, 8.5, 61.0, 60.0);
            surface.getButton(ButtonID.UP).setBounds(114.0 - offset, 8.5, 61.0, 60.0);
            surface.getButton(ButtonID.DOWN).setBounds(188.5 - offset, 8.5, 61.0, 60.0);
            surface.getButton(ButtonID.LEFT).setBounds(262.25 - offset, 8.5, 61.0, 60.0);
            surface.getButton(ButtonID.RIGHT).setBounds(335.75 - offset, 8.5, 61.0, 60.0);
        }
        surface.getLight(OutputID.LED1).setBounds(707.0 - offset, 8.5, 61.0, 60.0);
    }

    @Override
    public void startup() {
        LaunchpadControlSurface surface = (LaunchpadControlSurface)this.getSurface();
        surface.getViewManager().setActive(((LaunchpadConfiguration)this.configuration).shouldStartWithSessionView() ? Views.SESSION : ((LaunchpadConfiguration)this.configuration).getStartupView());
        surface.getModeManager().setActive(Modes.DUMMY);
    }

    protected void updateIndication() {
        int n;
        ViewManager viewManager = ((LaunchpadControlSurface)this.getSurface()).getViewManager();
        boolean isVolume = viewManager.isActive(new Views[]{Views.TRACK_VOLUME});
        boolean isPan = viewManager.isActive(new Views[]{Views.TRACK_PAN});
        boolean isSends = viewManager.isActive(new Views[]{Views.TRACK_SENDS});
        boolean isDevice = viewManager.isActive(new Views[]{Views.DEVICE});
        ITrackBank tb = this.model.getTrackBank();
        ITrackBank tbe = this.model.getEffectTrackBank();
        ICursorDevice cursorDevice = this.model.getCursorDevice();
        IView view = (IView)viewManager.getActive();
        if (view instanceof SendsView) {
            SendsView sendsView = (SendsView)view;
            n = sendsView.getSelectedSend();
        } else {
            n = -1;
        }
        int selSend = n;
        boolean isSession = view instanceof SessionView && !isVolume && !isPan && !isSends;
        boolean isEffect = this.model.isEffectTrackBankActive();
        tb.setIndication(!isEffect && isSession);
        if (tbe != null) {
            tbe.setIndication(isEffect && isSession);
        }
        IParameterBank parameterBank = cursorDevice.getParameterBank();
        for (int i = 0; i < 8; ++i) {
            ITrack track = (ITrack)tb.getItem(i);
            track.setVolumeIndication(!isEffect && isVolume);
            track.setPanIndication(!isEffect && isPan);
            ISendBank sendBank = track.getSendBank();
            for (int j = 0; j < 8; ++j) {
                ((ISend)sendBank.getItem(j)).setIndication(!isEffect && isSends && selSend == j);
            }
            if (tbe != null) {
                ITrack fxTrack = (ITrack)tbe.getItem(i);
                fxTrack.setVolumeIndication(isEffect && isVolume);
                fxTrack.setPanIndication(isEffect && isPan);
            }
            ((IParameter)parameterBank.getItem(i)).setIndication(isDevice);
        }
    }

    @Override
    protected void handleTrackChange(boolean isSelected) {
        if (!isSelected) {
            return;
        }
        if (!((LaunchpadControlSurface)this.getSurface()).getViewManager().isActive(new Views[]{Views.MIX, Views.USER, Views.TRACK_PAN, Views.TRACK_VOLUME, Views.TRACK_SENDS, Views.DEVICE})) {
            super.handleTrackChange(isSelected);
        }
    }

    @Override
    protected void recallLastView() {
        LaunchpadControlSurface surface = (LaunchpadControlSurface)this.getSurface();
        if (!surface.getViewManager().isActive(new Views[]{Views.SESSION}) || surface.isPressed(ButtonID.TRACK)) {
            surface.recallPreferredView(this.model.getCursorTrack());
        }
    }

    private static int getStateColor(LaunchpadControlSurface surface, ButtonID buttonID) {
        if (surface.isShiftPressed()) {
            return 24;
        }
        return surface.isPressed(buttonID) ? 22 : 23;
    }

    private static int get2StateColor(LaunchpadControlSurface surface, ButtonID buttonID) {
        boolean isPressed = surface.isPressed(buttonID);
        if (surface.isShiftPressed()) {
            return isPressed ? 3 : 24;
        }
        return isPressed ? 22 : 23;
    }

    private int getDeleteStateColor(LaunchpadControlSurface surface) {
        if (surface.isShiftPressed()) {
            return this.model.getTransport().isLoop() ? 45 : 47;
        }
        return surface.isPressed(ButtonID.DELETE) ? 53 : 55;
    }

    private static int getDuplicateStateColor(LaunchpadControlSurface surface) {
        if (surface.isShiftPressed()) {
            return 48;
        }
        return 46;
    }

    private int getPlayStateColor(LaunchpadControlSurface surface) {
        if (surface.isShiftPressed()) {
            return surface.isPressed(ButtonID.PLAY) ? 3 : 24;
        }
        return this.model.getTransport().isPlaying() ? 22 : 23;
    }

    private int getViewStateColor(int viewColor, Views ... views) {
        ViewManager viewManager = ((LaunchpadControlSurface)this.getSurface()).getViewManager();
        for (Views view : views) {
            if (!viewManager.isActive(new Views[]{view})) continue;
            return viewColor;
        }
        return 1;
    }

    private int getTrackModeColorIndex(int index) {
        LaunchpadControlSurface surface = (LaunchpadControlSurface)this.getSurface();
        if (surface.isPressed(ButtonID.NEW)) {
            return 3;
        }
        ITrackBank tb = this.model.getCurrentTrackBank();
        ModeManager modeManager = surface.getModeManager();
        ITrack track = (ITrack)tb.getItem(index);
        if (!track.doesExist()) {
            return 0;
        }
        Modes activeID = (Modes)((Object)modeManager.getActiveID());
        if (activeID == null) {
            return 0;
        }
        switch (activeID) {
            case REC_ARM: {
                return track.isRecArm() ? 5 : 7;
            }
            case TRACK_SELECT: {
                return track.isSelected() ? 21 : 23;
            }
            case MUTE: {
                return track.isMute() ? 13 : 15;
            }
            case SOLO: {
                return track.isSolo() ? 45 : 47;
            }
            case STOP_CLIP: {
                return surface.isPressed(ButtonID.get(ButtonID.PAD1, index)) ? 6 : 4;
            }
        }
        return this.colorManager.getColorIndex(DAWColor.getColorID(track.getColor()));
    }

    private int getModeColorIndex(ButtonID buttonID) {
        LaunchpadControlSurface surface = (LaunchpadControlSurface)this.getSurface();
        ModeManager modeManager = surface.getModeManager();
        ViewManager viewManager = surface.getViewManager();
        switch (buttonID) {
            case REC_ARM: {
                return modeManager.isActive(new Modes[]{Modes.REC_ARM}) ? 6 : 1;
            }
            case TRACK: {
                return modeManager.isActive(new Modes[]{Modes.TRACK_SELECT}) ? 22 : 1;
            }
            case MUTE: {
                return modeManager.isActive(new Modes[]{Modes.MUTE}) ? 14 : 1;
            }
            case SOLO: {
                if (this.definition.hasTrackSelectionButtons() && surface.isShiftPressed()) {
                    return this.model.getTransport().isMetronomeOn() ? 22 : 1;
                }
                return modeManager.isActive(new Modes[]{Modes.SOLO}) ? 46 : 1;
            }
            case VOLUME: {
                return viewManager.isActive(new Views[]{Views.TRACK_VOLUME}) ? 34 : 1;
            }
            case PAN_SEND: {
                return viewManager.isActive(new Views[]{Views.TRACK_PAN}) ? 38 : 1;
            }
            case SENDS: {
                return viewManager.isActive(new Views[]{Views.TRACK_SENDS}) ? 50 : 1;
            }
            case STOP_CLIP: {
                return modeManager.isActive(new Modes[]{Modes.STOP_CLIP}) ? 4 : 1;
            }
        }
        return 0;
    }

    private int getViewColor() {
        LaunchpadControlSurface surface = (LaunchpadControlSurface)this.getSurface();
        switch ((Views)((Object)surface.getViewManager().getActiveID())) {
            case SESSION: 
            case TRACK_VOLUME: 
            case TRACK_PAN: 
            case TRACK_SENDS: 
            case MIX: {
                return 18;
            }
            case PLAY: 
            case CHORDS: 
            case PIANO: 
            case DRUM64: {
                return 10;
            }
            case SEQUENCER: 
            case POLY_SEQUENCER: 
            case RAINDROPS: {
                return 14;
            }
            case DRUM: 
            case DRUM4: 
            case DRUM8: {
                return 46;
            }
            case DEVICE: 
            case BROWSER: {
                return 30;
            }
            case CLIP_LENGTH: {
                return 54;
            }
            case PROJECT: {
                return 33;
            }
            case SHIFT: {
                return 3;
            }
            case TEMPO: {
                return 41;
            }
            case SHUFFLE: {
                return 57;
            }
            case USER: {
                return 49;
            }
        }
        return 0;
    }

    private void handleTrackSelection(ButtonEvent event, int index) {
        IMode active = (IMode)((LaunchpadControlSurface)this.getSurface()).getModeManager().getActive();
        if (active != null) {
            active.onButton(0, index, event);
        }
    }

    static {
        MAIN_VIEWS.add(Views.PLAY);
        MAIN_VIEWS.add(Views.CHORDS);
        MAIN_VIEWS.add(Views.PIANO);
        MAIN_VIEWS.add(Views.DRUM64);
        MAIN_VIEWS.add(Views.SEQUENCER);
        MAIN_VIEWS.add(Views.POLY_SEQUENCER);
        MAIN_VIEWS.add(Views.RAINDROPS);
        MAIN_VIEWS.add(Views.DRUM);
        MAIN_VIEWS.add(Views.DRUM4);
        MAIN_VIEWS.add(Views.DRUM8);
        MAIN_VIEWS.add(Views.CLIP_LENGTH);
    }
}

