/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.novation.launchpad;

import de.mossgrabers.controller.novation.launchpad.definition.ILaunchpadControllerDefinition;
import de.mossgrabers.framework.configuration.AbstractConfiguration;
import de.mossgrabers.framework.configuration.IEnumSetting;
import de.mossgrabers.framework.configuration.ISettingsUI;
import de.mossgrabers.framework.controller.valuechanger.IValueChanger;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.midi.ArpeggiatorMode;
import de.mossgrabers.framework.view.Views;
import java.util.List;

public class LaunchpadConfiguration
extends AbstractConfiguration {
    private static final Views[] PREFERRED_NOTE_VIEWS = new Views[]{Views.PLAY, Views.CHORDS, Views.PIANO, Views.DRUM64, Views.DRUM, Views.DRUM4, Views.DRUM8, Views.SEQUENCER, Views.RAINDROPS, Views.POLY_SEQUENCER};
    public static final Integer PAD_BRIGHTNESS = 50;
    private static final String[] PAD_BRIGHTNESS_VALUES = new String[128];
    private final ILaunchpadControllerDefinition definition;
    private int padBrightness;

    public LaunchpadConfiguration(IHost host, IValueChanger valueChanger, List<ArpeggiatorMode> arpeggiatorModes, ILaunchpadControllerDefinition definition) {
        super(host, valueChanger, arpeggiatorModes);
        this.definition = definition;
        this.preferredAudioView = Views.CLIP_LENGTH;
    }

    @Override
    public void init(ISettingsUI globalSettings, ISettingsUI documentSettings) {
        this.activateScaleSetting(documentSettings);
        this.activateScaleBaseSetting(documentSettings);
        this.activateScaleInScaleSetting(documentSettings);
        this.activateScaleLayoutSetting(documentSettings);
        this.activateNoteRepeatSetting(documentSettings);
        this.activateAccentActiveSetting(globalSettings);
        this.activateAccentValueSetting(globalSettings);
        this.activateQuantizeAmountSetting(globalSettings);
        this.activateStartupViewSetting(globalSettings, PREFERRED_NOTE_VIEWS);
        this.activateStartWithSessionViewSetting(globalSettings);
        this.activateTurnOffScalePadsSetting(globalSettings);
        this.activateShowPlayedChordsSetting(globalSettings);
        this.activateBehaviourOnPauseSetting(globalSettings);
        this.activateRecordButtonSetting(globalSettings);
        this.activateShiftedRecordButtonSetting(globalSettings);
        this.activateFlipSessionSetting(globalSettings);
        this.activateSelectClipOnLaunchSetting(globalSettings);
        this.activateActionForRecArmedPad(globalSettings);
        this.activateAutoSelectDrumSetting(globalSettings);
        this.activateTurnOffEmptyDrumPadsSetting(globalSettings);
        this.activateExcludeDeactivatedItemsSetting(globalSettings);
        this.activateIncludeMasterSetting(globalSettings);
        this.activateNewClipLengthSetting(globalSettings);
        this.activateConvertAftertouchSetting(globalSettings);
        if (!this.definition.getBrightnessSysex().isEmpty()) {
            this.activatePadBrightnessSetting(globalSettings);
        }
    }

    protected void activatePadBrightnessSetting(ISettingsUI settingsUI) {
        IEnumSetting padBrightnessSetting = settingsUI.getEnumSetting("Brightness", "Pads", PAD_BRIGHTNESS_VALUES, PAD_BRIGHTNESS_VALUES[127]);
        padBrightnessSetting.addValueObserver(value -> {
            this.padBrightness = LaunchpadConfiguration.lookupIndex(PAD_BRIGHTNESS_VALUES, value);
            this.notifyObservers(PAD_BRIGHTNESS);
        });
        this.isSettingActive.add(PAD_BRIGHTNESS);
    }

    public int getPadBrightness() {
        return this.padBrightness;
    }

    static {
        for (int i = 0; i < 128; ++i) {
            LaunchpadConfiguration.PAD_BRIGHTNESS_VALUES[i] = Integer.toString(i);
        }
    }
}

