/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.novation.launchkey.mini.view;

import de.mossgrabers.controller.novation.launchkey.mini.LaunchkeyMiniMk3Configuration;
import de.mossgrabers.controller.novation.launchkey.mini.controller.LaunchkeyMiniMk3ControlSurface;
import de.mossgrabers.controller.novation.launchkey.mini.controller.LaunchkeyPadGrid;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.clip.INoteClip;
import de.mossgrabers.framework.daw.clip.IStepInfo;
import de.mossgrabers.framework.daw.clip.NotePosition;
import de.mossgrabers.framework.daw.data.IDrumDevice;
import de.mossgrabers.framework.daw.data.bank.IDrumPadBank;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.Views;
import de.mossgrabers.framework.view.sequencer.AbstractDrumView;
import java.util.List;
import java.util.Optional;

public class DrumView
extends AbstractDrumView<LaunchkeyMiniMk3ControlSurface, LaunchkeyMiniMk3Configuration> {
    private static final int NUM_DISPLAY_COLS = 16;
    private boolean isPlayMode = true;

    public DrumView(LaunchkeyMiniMk3ControlSurface surface, IModel model) {
        super("Drum", surface, model, 2, 16, true);
        this.allRows = 2;
        this.firstPad = ButtonID.PAD17;
    }

    @Override
    public void onGridNote(int note, int velocity) {
        if (!this.model.canSelectedTrackHoldNotes()) {
            return;
        }
        int index = note - ((LaunchkeyMiniMk3ControlSurface)this.surface).getPadGrid().getStartNote();
        int offsetY = this.scales.getDrumOffset();
        if (this.isPlayMode) {
            this.setSelectedPad(index, velocity);
            this.keyManager.setKeyPressed(offsetY + this.getSelectedPad(), velocity);
        } else if (this.isActive()) {
            int x = index % this.numColumns;
            int y = index / this.numColumns;
            this.handleSequencerArea(index, x, y, offsetY, velocity);
        }
    }

    @Override
    public void updateNoteMapping() {
        this.delayedUpdateNoteMapping(this.model.canSelectedTrackHoldNotes() && this.isPlayMode ? this.scales.getDrumMatrix() : EMPTY_TABLE);
    }

    @Override
    public void drawGrid() {
        LaunchkeyPadGrid padGrid = ((LaunchkeyMiniMk3ControlSurface)this.surface).getPadGrid();
        IDrumDevice primary = this.model.getDrumDevice();
        IDrumPadBank drumPadBank = primary.getDrumPadBank();
        if (this.isPlayMode) {
            for (int y = 0; y < 2; ++y) {
                for (int x = 0; x < 8; ++x) {
                    int index = 8 * y + x;
                    padGrid.lightEx(x, 1 - y, this.getDrumPadColor(index, drumPadBank, false));
                }
            }
            return;
        }
        if (!this.isActive()) {
            padGrid.turnOff();
            return;
        }
        INoteClip clip = this.getClip();
        int step = clip.getCurrentStep();
        int hiStep = this.isInXRange(step) ? step % this.sequencerSteps : -1;
        int offsetY = this.scales.getDrumOffset();
        int channel = this.configuration.getMidiEditChannel();
        int selPad = this.getSelectedPad();
        List<NotePosition> editNotes = this.getEditNotes();
        NotePosition notePosition = new NotePosition(channel, 0, 0);
        for (int col = 0; col < 16; ++col) {
            int noteRow = offsetY + selPad;
            notePosition.setStep(col);
            notePosition.setNote(noteRow);
            IStepInfo stepInfo = clip.getStep(notePosition);
            boolean hilite = col == hiStep;
            int x = col % 8;
            int y = col / 8;
            Optional<ColorEx> rowColor = this.getPadColor(primary, this.selectedPad);
            padGrid.lightEx(x, y, this.getStepColor(stepInfo, hilite, rowColor, channel, col, noteRow, editNotes));
        }
    }

    @Override
    public int getButtonColor(ButtonID buttonID) {
        if (buttonID == ButtonID.SCENE1) {
            return this.isPlayMode ? 22 : 46;
        }
        return 1;
    }

    @Override
    public void onButton(ButtonID buttonID, ButtonEvent event, int velocity) {
        if (!ButtonID.isSceneButton(buttonID) || event != ButtonEvent.DOWN) {
            return;
        }
        if (buttonID == ButtonID.SCENE1) {
            this.isPlayMode = !this.isPlayMode;
            this.updateNoteMapping();
            ((LaunchkeyMiniMk3ControlSurface)this.surface).getDisplay().notify(this.isPlayMode ? "Play / Select" : "Steps");
        } else if (this.isActive()) {
            ((LaunchkeyMiniMk3ControlSurface)this.surface).getViewManager().setActive(Views.SHIFT);
        }
    }

    public boolean isPlayMode() {
        return this.isPlayMode;
    }
}

