/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.novation.launchkey.maxi.view;

import de.mossgrabers.controller.novation.launchkey.maxi.LaunchkeyMk3Configuration;
import de.mossgrabers.controller.novation.launchkey.maxi.controller.LaunchkeyMk3ControlSurface;
import de.mossgrabers.controller.novation.launchkey.maxi.controller.LaunchkeyPadGrid;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.color.ColorManager;
import de.mossgrabers.framework.controller.grid.LightInfo;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.IScene;
import de.mossgrabers.framework.daw.data.ISlot;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.ISceneBank;
import de.mossgrabers.framework.daw.data.bank.ITrackBank;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.utils.Pair;
import de.mossgrabers.framework.view.AbstractSessionView;
import de.mossgrabers.framework.view.Views;
import java.util.List;

public class SessionView
extends AbstractSessionView<LaunchkeyMk3ControlSurface, LaunchkeyMk3Configuration> {
    public static final List<Modes> PAD_MODES = List.of(Modes.REC_ARM, Modes.TRACK_SELECT, Modes.MUTE, Modes.SOLO, Modes.STOP_CLIP);
    private Modes padMode = null;

    public SessionView(LaunchkeyMk3ControlSurface surface, IModel model) {
        super("Session", surface, model, 2, 8, true);
        LightInfo isRecording = new LightInfo(6, 6, false);
        LightInfo isRecordingQueued = new LightInfo(7, 7, true);
        LightInfo isPlaying = new LightInfo(24, 22, false);
        LightInfo isPlayingQueued = new LightInfo(24, 22, true);
        LightInfo hasContent = new LightInfo(10, -1, false);
        LightInfo noContent = new LightInfo(0, -1, false);
        LightInfo recArmed = new LightInfo(7, -1, false);
        LightInfo isMuted = new LightInfo(1, -1, false);
        this.setColors(isRecording, isRecordingQueued, isPlaying, isPlayingQueued, hasContent, noContent, recArmed, isMuted);
    }

    @Override
    public void drawGrid() {
        boolean controlModeIsOff = this.padMode == null;
        this.rows = controlModeIsOff ? 2 : 1;
        super.drawGrid();
        if (controlModeIsOff) {
            return;
        }
        ITrackBank tb = this.model.getCurrentTrackBank();
        LaunchkeyPadGrid pads = ((LaunchkeyMk3ControlSurface)this.surface).getPadGrid();
        block7: for (int x = 0; x < this.columns; ++x) {
            ITrack track = (ITrack)tb.getItem(x);
            if (!track.doesExist()) {
                pads.lightEx(x, 1, 0);
                continue;
            }
            switch (this.padMode) {
                case REC_ARM: {
                    pads.lightEx(x, 1, track.isRecArm() ? 5 : 7);
                    continue block7;
                }
                case TRACK_SELECT: {
                    pads.lightEx(x, 1, track.isSelected() ? 3 : 1);
                    continue block7;
                }
                case MUTE: {
                    pads.lightEx(x, 1, track.isMute() ? 9 : 11);
                    continue block7;
                }
                case SOLO: {
                    pads.lightEx(x, 1, track.isSolo() ? 13 : 15);
                    continue block7;
                }
                case STOP_CLIP: {
                    pads.lightEx(x, 1, 4);
                    continue block7;
                }
            }
        }
    }

    @Override
    public void onGridNote(int note, int velocity) {
        Pair<Integer, Integer> padPos = this.getPad(note);
        int row = padPos.getValue();
        int column = padPos.getKey();
        if (row == 0 || this.padMode == null) {
            ITrack track = (ITrack)this.model.getCurrentTrackBank().getItem(column);
            if (this.isButtonCombination(ButtonID.STOP)) {
                track.stop(false);
                return;
            }
            if (this.isButtonCombination(ButtonID.UNDO)) {
                ((ISlot)track.getSlotBank().getItem(row)).remove();
                return;
            }
            super.onGridNote(note, velocity);
        } else if (velocity != 0) {
            this.handleFirstRowModes(column);
        }
    }

    @Override
    public void onGridNoteLongPress(int note) {
        Pair<Integer, Integer> padPos = this.getPad(note);
        int row = padPos.getValue();
        if (row == 0 || this.padMode == null) {
            super.onGridNoteLongPress(note);
        }
    }

    @Override
    protected boolean handleButtonCombinations(ITrack track, ISlot slot) {
        if (super.handleButtonCombinations(track, slot)) {
            return true;
        }
        if (this.isButtonCombination(ButtonID.PLAY)) {
            track.returnToArrangement();
            return true;
        }
        return false;
    }

    @Override
    public void onButton(ButtonID buttonID, ButtonEvent event, int velocity) {
        ISceneBank sceneBank = this.model.getCurrentTrackBank().getSceneBank();
        if (buttonID == ButtonID.ARROW_UP || buttonID == ButtonID.ARROW_DOWN) {
            if (event != ButtonEvent.UP) {
                return;
            }
            if (buttonID == ButtonID.ARROW_UP) {
                sceneBank.scrollBackwards();
            } else {
                sceneBank.scrollForwards();
            }
            return;
        }
        if (!ButtonID.isSceneButton(buttonID)) {
            return;
        }
        int index = buttonID.ordinal() - ButtonID.SCENE1.ordinal();
        if (event == ButtonEvent.DOWN) {
            if (index == 1) {
                ((LaunchkeyMk3ControlSurface)this.surface).getViewManager().setActive(Views.CONTROL);
            }
            return;
        }
        if (event == ButtonEvent.UP) {
            IScene scene = (IScene)sceneBank.getItem(index);
            scene.select();
            scene.launch(true, false);
        }
    }

    @Override
    public int getButtonColor(ButtonID buttonID) {
        ISceneBank sceneBank = this.model.getSceneBank();
        ColorManager colorManager = this.model.getColorManager();
        if (buttonID == ButtonID.ARROW_UP || buttonID == ButtonID.ARROW_DOWN) {
            boolean isOn = buttonID == ButtonID.ARROW_UP ? sceneBank.canScrollPageBackwards() : sceneBank.canScrollPageForwards();
            return isOn ? 22 : 1;
        }
        if (!ButtonID.isSceneButton(buttonID)) {
            return 0;
        }
        if (buttonID == ButtonID.SCENE1) {
            return colorManager.getColorIndex(SessionView.getSceneColor((IScene)sceneBank.getItem(0)));
        }
        if (this.padMode == null) {
            return colorManager.getColorIndex(SessionView.getSceneColor((IScene)sceneBank.getItem(1)));
        }
        switch (this.padMode) {
            case REC_ARM: {
                return 5;
            }
            case TRACK_SELECT: {
                return 3;
            }
            case MUTE: {
                return 9;
            }
            case SOLO: {
                return 13;
            }
            case STOP_CLIP: {
                return 4;
            }
        }
        return 0;
    }

    @Override
    protected Pair<Integer, Integer> getPad(int note) {
        Pair<Integer, Integer> pad = super.getPad(note);
        if (this.padMode != null) {
            pad.setValue(pad.getValue() == 0 ? -1 : 0);
        }
        return pad;
    }

    public Modes getPadMode() {
        return this.padMode;
    }

    public void setPadMode(Modes padMode) {
        this.padMode = padMode;
    }

    private void handleFirstRowModes(int column) {
        ITrack track = (ITrack)this.model.getCurrentTrackBank().getItem(column);
        switch (this.padMode) {
            case REC_ARM: {
                track.toggleRecArm();
                break;
            }
            case TRACK_SELECT: {
                this.selectTrack(column);
                break;
            }
            case MUTE: {
                track.toggleMute();
                break;
            }
            case SOLO: {
                track.toggleSolo();
                break;
            }
            case STOP_CLIP: {
                track.stop(false);
                break;
            }
        }
    }

    private static String getSceneColor(IScene scene) {
        if (scene.doesExist()) {
            return scene.isSelected() ? "COLOR_SELECTED_SCENE" : "COLOR_SCENE";
        }
        return "COLOR_SELECTED_OFF";
    }

    @Override
    protected boolean isAlternateFunction() {
        boolean isPressed = ((LaunchkeyMk3ControlSurface)this.surface).isPressed(ButtonID.REPEAT);
        if (isPressed) {
            ((LaunchkeyMk3ControlSurface)this.surface).setTriggerConsumed(ButtonID.REPEAT);
        }
        return isPressed;
    }
}

