/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.novation.launchcontrol.mode.main;

import de.mossgrabers.controller.novation.launchcontrol.LaunchControlXLConfiguration;
import de.mossgrabers.controller.novation.launchcontrol.controller.LaunchControlXLControlSurface;
import de.mossgrabers.controller.novation.launchcontrol.mode.buttons.XLTemporaryButtonMode;
import de.mossgrabers.controller.novation.launchcontrol.mode.main.XLAbstractMainMode;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.ContinuousID;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.constants.DeviceID;
import de.mossgrabers.framework.daw.data.ILayer;
import de.mossgrabers.framework.daw.data.ISend;
import de.mossgrabers.framework.daw.data.ISpecificDevice;
import de.mossgrabers.framework.featuregroup.ModeManager;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.parameter.IParameter;
import de.mossgrabers.framework.parameterprovider.device.BankParameterProvider;
import de.mossgrabers.framework.parameterprovider.device.PanLayerOrDrumPadParameterProvider;
import de.mossgrabers.framework.parameterprovider.device.SendLayerOrDrumPadParameterProvider;
import de.mossgrabers.framework.parameterprovider.special.CombinedParameterProvider;
import de.mossgrabers.framework.utils.ButtonEvent;
import java.util.List;

public class XLLayerMixMode
extends XLAbstractMainMode<ILayer> {
    private final ISpecificDevice firstInstrument;

    public XLLayerMixMode(LaunchControlXLControlSurface surface, IModel model, List<ContinuousID> controls) {
        super("Layer", surface, model, model.getSpecificDevice(DeviceID.FIRST_INSTRUMENT).getLayerBank(), controls);
        this.defaultMode = Modes.DEVICE_LAYER_MUTE;
        this.firstInstrument = model.getSpecificDevice(DeviceID.FIRST_INSTRUMENT);
        SendLayerOrDrumPadParameterProvider sendParameterProvider1 = new SendLayerOrDrumPadParameterProvider(this.firstInstrument, 0);
        SendLayerOrDrumPadParameterProvider sendParameterProvider2 = new SendLayerOrDrumPadParameterProvider(this.firstInstrument, 1);
        PanLayerOrDrumPadParameterProvider panParameterProvider = new PanLayerOrDrumPadParameterProvider(this.firstInstrument);
        BankParameterProvider deviceParameterProvider = new BankParameterProvider(this.firstInstrument.getParameterBank());
        this.setParameterProviders(new CombinedParameterProvider(sendParameterProvider1, sendParameterProvider2, panParameterProvider), new CombinedParameterProvider(sendParameterProvider1, sendParameterProvider2, deviceParameterProvider));
        this.firstInstrument.addHasDrumPadsObserver(hasDrumPads -> this.parametersAdjusted());
    }

    @Override
    public int getKnobValue(int index) {
        int row = index / 8;
        int column = index % 8;
        ILayer layer = (ILayer)this.bank.getItem(column);
        switch (row) {
            case 0: {
                return ((ISend)layer.getSendBank().getItem(0)).getValue();
            }
            case 1: {
                return ((ISend)layer.getSendBank().getItem(1)).getValue();
            }
            case 2: {
                if (this.configuration.isDeviceActive()) {
                    return ((IParameter)this.firstInstrument.getParameterBank().getItem(column)).getValue();
                }
                return layer.getPan();
            }
        }
        return 0;
    }

    @Override
    protected void executeRow0(int index) {
        ILayer layer = (ILayer)this.bank.getItem(index);
        if (!layer.doesExist()) {
            return;
        }
        layer.select();
        this.mvHelper.notifySelectedLayer();
    }

    @Override
    protected void handleRow2(int index, ButtonEvent event) {
        ModeManager trackButtonModeManager = ((LaunchControlXLControlSurface)this.surface).getTrackButtonModeManager();
        switch (index) {
            case 0: {
                if (event == ButtonEvent.DOWN) {
                    trackButtonModeManager.setTemporary(Modes.INSTRUMENT_DEVICE_PARAMS);
                    return;
                }
                if (event != ButtonEvent.UP) break;
                if (!((XLTemporaryButtonMode)trackButtonModeManager.get(Modes.INSTRUMENT_DEVICE_PARAMS)).hasBeenUsed()) {
                    this.toggleDeviceActive();
                }
                trackButtonModeManager.restore();
                break;
            }
            case 1: {
                if (event != ButtonEvent.DOWN) break;
                trackButtonModeManager.setActive(Modes.DEVICE_LAYER_MUTE);
                break;
            }
            case 2: {
                this.alternativeModeSelect(event, Modes.DEVICE_LAYER_SOLO, Modes.CLIP);
                break;
            }
            case 3: {
                this.alternativeModeSelect(event, null, Modes.TRANSPORT);
                break;
            }
        }
    }

    @Override
    public int getButtonColor(ButtonID buttonID) {
        ModeManager trackModeManager = ((LaunchControlXLControlSurface)this.surface).getTrackButtonModeManager();
        switch (buttonID) {
            case DEVICE: {
                return ((LaunchControlXLConfiguration)((LaunchControlXLControlSurface)this.surface).getConfiguration()).isDeviceActive() ? 127 : 0;
            }
            case MUTE: {
                return trackModeManager.isActive(new Modes[]{Modes.DEVICE_LAYER_MUTE}) ? 127 : 0;
            }
            case SOLO: {
                return trackModeManager.isActive(new Modes[]{Modes.DEVICE_LAYER_SOLO}) ? 127 : 0;
            }
            case REC_ARM: {
                return 12;
            }
            case ROW1_1: 
            case ROW1_2: 
            case ROW1_3: 
            case ROW1_4: 
            case ROW1_5: 
            case ROW1_6: 
            case ROW1_7: 
            case ROW1_8: {
                int index = buttonID.ordinal() - ButtonID.ROW1_1.ordinal();
                if (((LaunchControlXLControlSurface)this.surface).isPressed(ButtonID.REC_ARM)) {
                    return super.getTransportButtonColor(index);
                }
                ILayer layer = (ILayer)this.bank.getItem(index);
                if (layer.doesExist()) {
                    return layer.isSelected() ? 62 : 29;
                }
                return 12;
            }
        }
        return 12;
    }

    @Override
    public void selectPreviousItem() {
        for (int i = 0; i < 8; ++i) {
            ((ILayer)this.bank.getItem(i)).getSendBank().selectPreviousPage();
        }
        this.mvHelper.notifySelectedSends(((ILayer)this.bank.getItem(0)).getSendBank());
    }

    @Override
    public void selectNextItem() {
        for (int i = 0; i < 8; ++i) {
            ((ILayer)this.bank.getItem(i)).getSendBank().selectNextPage();
        }
        this.mvHelper.notifySelectedSends(((ILayer)this.bank.getItem(0)).getSendBank());
    }

    @Override
    public boolean hasPreviousItem() {
        boolean canScroll = false;
        for (int i = 0; i < 8; ++i) {
            canScroll |= ((ILayer)this.bank.getItem(i)).getSendBank().canScrollPageBackwards();
        }
        return canScroll;
    }

    @Override
    public boolean hasNextItem() {
        boolean canScroll = false;
        for (int i = 0; i < 8; ++i) {
            canScroll |= ((ILayer)this.bank.getItem(i)).getSendBank().canScrollPageForwards();
        }
        return canScroll;
    }

    @Override
    public void selectPreviousItemPage() {
        if (this.isButtonCombination(ButtonID.SOLO)) {
            Object f = ((LaunchControlXLControlSurface)this.surface).getTrackButtonModeManager().getActive();
            if (f instanceof XLTemporaryButtonMode) {
                XLTemporaryButtonMode tempMode = (XLTemporaryButtonMode)f;
                tempMode.setHasBeenUsed();
            }
            this.model.getSceneBank().selectPreviousPage();
            this.mvHelper.notifyScenePage();
            return;
        }
        super.selectPreviousItemPage();
        this.mvHelper.notifySelectedLayer();
    }

    @Override
    public void selectNextItemPage() {
        if (((LaunchControlXLControlSurface)this.surface).isPressed(ButtonID.SOLO)) {
            Object f = ((LaunchControlXLControlSurface)this.surface).getTrackButtonModeManager().getActive();
            if (f instanceof XLTemporaryButtonMode) {
                XLTemporaryButtonMode tempMode = (XLTemporaryButtonMode)f;
                tempMode.setHasBeenUsed();
            }
            this.model.getSceneBank().selectNextPage();
            this.mvHelper.notifyScenePage();
            return;
        }
        super.selectNextItemPage();
        this.mvHelper.notifySelectedLayer();
    }

    @Override
    public boolean hasPreviousItemPage() {
        if (((LaunchControlXLControlSurface)this.surface).isPressed(ButtonID.SOLO)) {
            return this.model.getSceneBank().canScrollPageBackwards();
        }
        return super.hasPreviousItemPage();
    }

    @Override
    public boolean hasNextItemPage() {
        if (((LaunchControlXLControlSurface)this.surface).isPressed(ButtonID.SOLO)) {
            return this.model.getSceneBank().canScrollPageForwards();
        }
        return super.hasNextItemPage();
    }

    @Override
    public void setKnobColor(int row, int column, int value) {
        int green = 0;
        int red = 0;
        switch (row) {
            case 0: {
                green = value == 0 ? 0 : value / 42 + 1;
                break;
            }
            case 1: {
                red = value == 0 ? 0 : value / 42 + 1;
                break;
            }
            case 2: {
                int n = green = value == 0 ? 0 : value / 42 + 1;
                if (this.configuration.isDeviceActive()) {
                    red = green == 0 ? 0 : 1;
                    break;
                }
                red = green;
                break;
            }
            default: {
                return;
            }
        }
        ((LaunchControlXLControlSurface)this.surface).setKnobLEDColor(row, column, green, red);
    }

    @Override
    public void parametersAdjusted() {
        this.switchBanks(this.firstInstrument.hasDrumPads() ? this.firstInstrument.getDrumPadBank() : this.firstInstrument.getLayerBank());
        super.parametersAdjusted();
    }
}

