/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.novation.launchcontrol.mode.main;

import de.mossgrabers.controller.novation.launchcontrol.LaunchControlXLConfiguration;
import de.mossgrabers.controller.novation.launchcontrol.controller.LaunchControlXLControlSurface;
import de.mossgrabers.controller.novation.launchcontrol.mode.buttons.XLTemporaryButtonMode;
import de.mossgrabers.controller.novation.launchcontrol.mode.main.XLAbstractMainMode;
import de.mossgrabers.controller.novation.launchcontrol.mode.main.XLTrackMixMode;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.ContinuousID;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.ITrackBank;
import de.mossgrabers.framework.featuregroup.ModeManager;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.utils.ButtonEvent;
import java.util.List;

public abstract class XLAbstractTrackMode
extends XLAbstractMainMode<ITrack> {
    protected XLAbstractTrackMode(String name, LaunchControlXLControlSurface surface, IModel model, List<ContinuousID> controls) {
        super(name, surface, model, model.getTrackBank(), controls);
    }

    @Override
    protected void executeRow0(int index) {
        ITrack track = (ITrack)this.model.getTrackBank().getItem(index);
        if (!track.doesExist()) {
            return;
        }
        if (track.isSelected() && track.isGroup()) {
            track.toggleGroupExpanded();
            return;
        }
        track.select();
        this.mvHelper.notifySelectedTrack();
    }

    @Override
    protected void handleRow2(int index, ButtonEvent event) {
        ModeManager trackButtonModeManager = ((LaunchControlXLControlSurface)this.surface).getTrackButtonModeManager();
        switch (index) {
            case 0: {
                if (event == ButtonEvent.DOWN) {
                    trackButtonModeManager.setTemporary(Modes.DEVICE_PARAMS);
                    return;
                }
                if (event != ButtonEvent.UP) break;
                if (!((XLTemporaryButtonMode)trackButtonModeManager.get(Modes.DEVICE_PARAMS)).hasBeenUsed()) {
                    this.toggleDeviceActive();
                }
                trackButtonModeManager.restore();
                break;
            }
            case 1: {
                if (event != ButtonEvent.DOWN) break;
                trackButtonModeManager.setActive(Modes.MUTE);
                break;
            }
            case 2: {
                this.alternativeModeSelect(event, Modes.SOLO, Modes.CLIP);
                break;
            }
            case 3: {
                this.alternativeModeSelect(event, Modes.REC_ARM, Modes.TRANSPORT);
                break;
            }
        }
    }

    @Override
    public int getButtonColor(ButtonID buttonID) {
        ModeManager trackModeManager = ((LaunchControlXLControlSurface)this.surface).getTrackButtonModeManager();
        switch (buttonID) {
            case DEVICE: {
                return ((LaunchControlXLConfiguration)((LaunchControlXLControlSurface)this.surface).getConfiguration()).isDeviceActive() ? 127 : 0;
            }
            case MUTE: {
                return trackModeManager.isActive(new Modes[]{Modes.MUTE}) ? 127 : 0;
            }
            case SOLO: {
                return trackModeManager.isActive(new Modes[]{Modes.SOLO}) ? 127 : 0;
            }
            case REC_ARM: {
                return trackModeManager.isActive(new Modes[]{Modes.REC_ARM}) ? 127 : 0;
            }
            case ROW1_1: 
            case ROW1_2: 
            case ROW1_3: 
            case ROW1_4: 
            case ROW1_5: 
            case ROW1_6: 
            case ROW1_7: 
            case ROW1_8: {
                int index = buttonID.ordinal() - ButtonID.ROW1_1.ordinal();
                if (((LaunchControlXLControlSurface)this.surface).isPressed(ButtonID.REC_ARM)) {
                    return super.getTransportButtonColor(index);
                }
                ITrack track = (ITrack)this.model.getTrackBank().getItem(index);
                if (track.doesExist()) {
                    return track.isSelected() ? 62 : 29;
                }
                return 12;
            }
        }
        return 12;
    }

    @Override
    public void selectPreviousItem() {
        if (((LaunchControlXLControlSurface)this.surface).isPressed(ButtonID.DEVICE)) {
            Object f = ((LaunchControlXLControlSurface)this.surface).getTrackButtonModeManager().getActive();
            if (f instanceof XLTemporaryButtonMode) {
                XLTemporaryButtonMode tempMode = (XLTemporaryButtonMode)f;
                tempMode.setHasBeenUsed();
            }
            if ((f = ((LaunchControlXLControlSurface)this.surface).getModeManager().get(Modes.SEND)) instanceof XLTrackMixMode) {
                XLTrackMixMode mixMode = (XLTrackMixMode)f;
                mixMode.selectParameterMode(false);
            }
            return;
        }
        ITrackBank trackBank = this.model.getTrackBank();
        for (int i = 0; i < 8; ++i) {
            ((ITrack)trackBank.getItem(i)).getSendBank().selectPreviousPage();
        }
        this.mvHelper.notifySelectedSends(((ITrack)trackBank.getItem(0)).getSendBank());
    }

    @Override
    public void selectNextItem() {
        if (((LaunchControlXLControlSurface)this.surface).isPressed(ButtonID.DEVICE)) {
            Object f = ((LaunchControlXLControlSurface)this.surface).getTrackButtonModeManager().getActive();
            if (f instanceof XLTemporaryButtonMode) {
                XLTemporaryButtonMode tempMode = (XLTemporaryButtonMode)f;
                tempMode.setHasBeenUsed();
            }
            if ((f = ((LaunchControlXLControlSurface)this.surface).getModeManager().get(Modes.SEND)) instanceof XLTrackMixMode) {
                XLTrackMixMode mixMode = (XLTrackMixMode)f;
                mixMode.selectParameterMode(true);
            }
            return;
        }
        ITrackBank trackBank = this.model.getTrackBank();
        for (int i = 0; i < 8; ++i) {
            ((ITrack)trackBank.getItem(i)).getSendBank().selectNextPage();
        }
        this.mvHelper.notifySelectedSends(((ITrack)trackBank.getItem(0)).getSendBank());
    }

    @Override
    public boolean hasPreviousItem() {
        if (((LaunchControlXLControlSurface)this.surface).isPressed(ButtonID.DEVICE)) {
            return true;
        }
        ITrackBank trackBank = this.model.getTrackBank();
        boolean canScroll = false;
        for (int i = 0; i < 8; ++i) {
            canScroll |= ((ITrack)trackBank.getItem(i)).getSendBank().canScrollPageBackwards();
        }
        return canScroll;
    }

    @Override
    public boolean hasNextItem() {
        if (((LaunchControlXLControlSurface)this.surface).isPressed(ButtonID.DEVICE)) {
            return true;
        }
        ITrackBank trackBank = this.model.getTrackBank();
        boolean canScroll = false;
        for (int i = 0; i < 8; ++i) {
            canScroll |= ((ITrack)trackBank.getItem(i)).getSendBank().canScrollPageForwards();
        }
        return canScroll;
    }

    @Override
    public void selectPreviousItemPage() {
        if (this.isButtonCombination(ButtonID.DEVICE)) {
            Object f = ((LaunchControlXLControlSurface)this.surface).getTrackButtonModeManager().getActive();
            if (f instanceof XLTemporaryButtonMode) {
                XLTemporaryButtonMode tempMode = (XLTemporaryButtonMode)f;
                tempMode.setHasBeenUsed();
            }
            this.model.getCursorDevice().selectPrevious();
            this.mvHelper.notifySelectedDevice();
            return;
        }
        if (this.isButtonCombination(ButtonID.SOLO)) {
            Object f = ((LaunchControlXLControlSurface)this.surface).getTrackButtonModeManager().getActive();
            if (f instanceof XLTemporaryButtonMode) {
                XLTemporaryButtonMode tempMode = (XLTemporaryButtonMode)f;
                tempMode.setHasBeenUsed();
            }
            this.model.getSceneBank().selectPreviousPage();
            this.mvHelper.notifyScenePage();
            return;
        }
        super.selectPreviousItemPage();
        this.mvHelper.notifySelectedTrack();
    }

    @Override
    public void selectNextItemPage() {
        if (((LaunchControlXLControlSurface)this.surface).isPressed(ButtonID.DEVICE)) {
            Object f = ((LaunchControlXLControlSurface)this.surface).getTrackButtonModeManager().getActive();
            if (f instanceof XLTemporaryButtonMode) {
                XLTemporaryButtonMode tempMode = (XLTemporaryButtonMode)f;
                tempMode.setHasBeenUsed();
            }
            this.model.getCursorDevice().selectNext();
            this.mvHelper.notifySelectedDevice();
            return;
        }
        if (((LaunchControlXLControlSurface)this.surface).isPressed(ButtonID.SOLO)) {
            Object f = ((LaunchControlXLControlSurface)this.surface).getTrackButtonModeManager().getActive();
            if (f instanceof XLTemporaryButtonMode) {
                XLTemporaryButtonMode tempMode = (XLTemporaryButtonMode)f;
                tempMode.setHasBeenUsed();
            }
            this.model.getSceneBank().selectNextPage();
            this.mvHelper.notifyScenePage();
            return;
        }
        super.selectNextItemPage();
        this.mvHelper.notifySelectedTrack();
    }

    @Override
    public boolean hasPreviousItemPage() {
        if (((LaunchControlXLControlSurface)this.surface).isPressed(ButtonID.DEVICE)) {
            return this.model.getCursorDevice().canSelectPrevious();
        }
        if (((LaunchControlXLControlSurface)this.surface).isPressed(ButtonID.SOLO)) {
            return this.model.getSceneBank().canScrollPageBackwards();
        }
        return super.hasPreviousItemPage();
    }

    @Override
    public boolean hasNextItemPage() {
        if (((LaunchControlXLControlSurface)this.surface).isPressed(ButtonID.DEVICE)) {
            return this.model.getCursorDevice().canSelectNext();
        }
        if (((LaunchControlXLControlSurface)this.surface).isPressed(ButtonID.SOLO)) {
            return this.model.getSceneBank().canScrollPageForwards();
        }
        return super.hasNextItemPage();
    }
}

