/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.novation.launchcontrol.mode.faders;

import de.mossgrabers.controller.novation.launchcontrol.LaunchControlXLConfiguration;
import de.mossgrabers.controller.novation.launchcontrol.controller.LaunchControlXLControlSurface;
import de.mossgrabers.framework.controller.ContinuousID;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.constants.DeviceID;
import de.mossgrabers.framework.daw.data.ILayer;
import de.mossgrabers.framework.daw.data.ISpecificDevice;
import de.mossgrabers.framework.featuregroup.AbstractParameterMode;
import de.mossgrabers.framework.parameterprovider.device.VolumeLayerOrDrumPadParameterProvider;
import java.util.List;

public class XLLayerVolumeMode
extends AbstractParameterMode<LaunchControlXLControlSurface, LaunchControlXLConfiguration, ILayer> {
    final ISpecificDevice firstInstrument;

    public XLLayerVolumeMode(LaunchControlXLControlSurface surface, IModel model, List<ContinuousID> controls) {
        super("Layer Volume", surface, model, true, model.getSpecificDevice(DeviceID.FIRST_INSTRUMENT).getLayerBank(), controls);
        this.firstInstrument = model.getSpecificDevice(DeviceID.FIRST_INSTRUMENT);
        this.setParameterProvider(new VolumeLayerOrDrumPadParameterProvider(this.firstInstrument));
        this.firstInstrument.addHasDrumPadsObserver(hasDrumPads -> this.parametersAdjusted());
    }

    @Override
    public void parametersAdjusted() {
        this.switchBanks(this.firstInstrument.hasDrumPads() ? this.firstInstrument.getDrumPadBank() : this.firstInstrument.getLayerBank());
        super.parametersAdjusted();
    }
}

