/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.novation.launchcontrol.mode.buttons;

import de.mossgrabers.controller.novation.launchcontrol.LaunchControlXLConfiguration;
import de.mossgrabers.controller.novation.launchcontrol.controller.LaunchControlXLControlSurface;
import de.mossgrabers.controller.novation.launchcontrol.mode.buttons.XLTemporaryButtonMode;
import de.mossgrabers.framework.command.trigger.transport.PlayCommand;
import de.mossgrabers.framework.command.trigger.transport.WindCommand;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.IProject;
import de.mossgrabers.framework.daw.ITransport;
import de.mossgrabers.framework.utils.ButtonEvent;

public class XLTransportMode
extends XLTemporaryButtonMode {
    private final WindCommand<LaunchControlXLControlSurface, LaunchControlXLConfiguration> rwdCommand;
    private final WindCommand<LaunchControlXLControlSurface, LaunchControlXLConfiguration> fwdCommand;
    private final PlayCommand<LaunchControlXLControlSurface, LaunchControlXLConfiguration> playCommand;

    public XLTransportMode(LaunchControlXLControlSurface surface, IModel model) {
        super("Transport", surface, model);
        this.rwdCommand = new WindCommand(model, surface, false);
        this.fwdCommand = new WindCommand(model, surface, true);
        this.playCommand = new PlayCommand(model, surface);
    }

    @Override
    public void onButton(int row, int index, ButtonEvent event) {
        if (row != 0) {
            return;
        }
        this.setHasBeenUsed();
        ITransport transport = this.model.getTransport();
        switch (index) {
            case 0: {
                this.playCommand.executeNormal(event);
                break;
            }
            case 1: {
                if (event != ButtonEvent.DOWN) break;
                transport.startRecording();
                break;
            }
            case 2: {
                this.rwdCommand.executeNormal(event);
                break;
            }
            case 3: {
                this.fwdCommand.executeNormal(event);
                break;
            }
            case 4: {
                if (event != ButtonEvent.DOWN) break;
                transport.toggleLoop();
                break;
            }
            case 5: {
                if (event != ButtonEvent.DOWN) break;
                transport.toggleMetronome();
                break;
            }
            case 6: {
                if (event != ButtonEvent.DOWN) break;
                transport.toggleWriteArrangerAutomation();
                break;
            }
            case 7: {
                if (event != ButtonEvent.DOWN) break;
                IProject project = this.model.getProject();
                project.clearMute();
                project.clearSolo();
                break;
            }
        }
    }

    @Override
    public int getButtonColor(ButtonID buttonID) {
        int index = buttonID.ordinal() - ButtonID.ROW2_1.ordinal();
        if (index < 0 || index >= 8) {
            return 12;
        }
        ITransport transport = this.model.getTransport();
        switch (index) {
            case 0: {
                return transport.isPlaying() ? 60 : 28;
            }
            case 1: {
                return transport.isRecording() ? 15 : 13;
            }
            case 2: 
            case 3: {
                return 30;
            }
            case 4: {
                return transport.isLoop() ? 62 : 29;
            }
            case 5: {
                return transport.isMetronomeOn() ? 60 : 28;
            }
            case 6: {
                return transport.isWritingArrangerAutomation() ? 15 : 13;
            }
            case 7: {
                return 30;
            }
        }
        return 12;
    }
}

