/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ni.maschine.mk3.mode;

import de.mossgrabers.controller.ni.maschine.mk3.MaschineConfiguration;
import de.mossgrabers.controller.ni.maschine.mk3.controller.MaschineControlSurface;
import de.mossgrabers.controller.ni.maschine.mk3.mode.BaseMode;
import de.mossgrabers.controller.ni.maschine.mk3.view.PlayView;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.display.ITextDisplay;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.featuregroup.IView;
import de.mossgrabers.framework.mode.INoteEditor;
import de.mossgrabers.framework.mode.INoteEditorMode;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.scale.Scale;
import de.mossgrabers.framework.scale.ScaleLayout;
import de.mossgrabers.framework.scale.Scales;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.utils.StringUtils;
import de.mossgrabers.framework.view.TransposeView;
import de.mossgrabers.framework.view.Views;

public class PlayConfigurationMode
extends BaseMode {
    public PlayConfigurationMode(MaschineControlSurface surface, IModel model) {
        super("Play Configuration", surface, model);
    }

    @Override
    public void onKnobValue(int index, int value) {
        if (!this.model.canSelectedTrackHoldNotes()) {
            return;
        }
        int idx = index < 0 ? this.selectedParam : index;
        Scales scales = this.model.getScales();
        boolean inc = this.model.getValueChanger().isIncrease(value);
        switch (idx) {
            case 0: 
            case 1: 
            case 2: {
                if (inc) {
                    scales.nextScale();
                } else {
                    scales.prevScale();
                }
                if (((MaschineControlSurface)this.surface).getMaschine().hasMCUDisplay()) break;
                ((MaschineControlSurface)this.surface).getDisplay().notify(scales.getScale().getName());
                break;
            }
            case 3: {
                if (inc) {
                    scales.nextScaleOffset();
                    break;
                }
                scales.prevScaleOffset();
                break;
            }
            case 4: 
            case 5: {
                if (inc) {
                    scales.nextScaleLayout();
                    break;
                }
                scales.prevScaleLayout();
                break;
            }
            case 6: {
                scales.setChromatic(!inc);
                ((MaschineConfiguration)((MaschineControlSurface)this.surface).getConfiguration()).setScaleInKey(!scales.isChromatic());
                break;
            }
            case 7: {
                PlayView playView = (PlayView)((MaschineControlSurface)this.surface).getViewManager().get(Views.PLAY);
                if (inc) {
                    playView.onOctaveUp(ButtonEvent.DOWN);
                } else {
                    playView.onOctaveDown(ButtonEvent.DOWN);
                }
                this.getNoteEditor().clearNotes();
                break;
            }
        }
        this.update();
    }

    private INoteEditor getNoteEditor() {
        return ((INoteEditorMode)((MaschineControlSurface)this.surface).getModeManager().get(Modes.NOTE)).getNoteEditor();
    }

    @Override
    public void onKnobTouch(int index, boolean isTouched) {
        if (isTouched && ((MaschineControlSurface)this.surface).isDeletePressed()) {
            ((MaschineControlSurface)this.surface).setTriggerConsumed(ButtonID.DELETE);
            Scales scales = this.model.getScales();
            int idx = index < 0 ? this.selectedParam : index;
            switch (idx) {
                case 0: 
                case 1: 
                case 2: {
                    scales.setScale(Scale.MAJOR);
                    if (((MaschineControlSurface)this.surface).getMaschine().hasMCUDisplay()) break;
                    ((MaschineControlSurface)this.surface).getDisplay().notify(scales.getScale().getName());
                    break;
                }
                case 3: {
                    scales.setScaleOffsetByIndex(0);
                    break;
                }
                case 4: 
                case 5: {
                    scales.setScaleLayout(ScaleLayout.SEQUENT_UP);
                    break;
                }
                case 6: {
                    scales.setChromatic(false);
                    ((MaschineConfiguration)((MaschineControlSurface)this.surface).getConfiguration()).setScaleInKey(!scales.isChromatic());
                    break;
                }
                case 7: {
                    ((TransposeView)((MaschineControlSurface)this.surface).getViewManager().get(Views.PLAY)).resetOctave();
                    break;
                }
            }
            this.update();
        }
    }

    @Override
    public void updateDisplay() {
        ITextDisplay d = ((MaschineControlSurface)this.surface).getTextDisplay().clear();
        Scales scales = this.model.getScales();
        d.setBlock(0, 0, this.mark("Scale", 0)).setBlock(1, 0, scales.getScale().getName());
        d.setCell(0, 3, this.mark("Base", 3)).setCell(1, 3, Scales.BASES.get(scales.getScaleOffsetIndex()));
        d.setBlock(0, 2, this.mark("Layout", 4)).setBlock(1, 2, StringUtils.optimizeName(scales.getScaleLayout().getName(), 12));
        d.setCell(0, 6, this.mark("In-Key", 6)).setCell(1, 6, scales.isChromatic() ? "Off" : "On");
        int octave = scales.getOctave();
        d.setCell(0, 7, this.mark("Octave", 7)).setCell(1, 7, (octave > 0 ? "+" : "") + Integer.toString(octave));
        d.allDone();
    }

    @Override
    public void selectPreviousItem() {
        super.selectPreviousItem();
        if (this.selectedParam == 1 || this.selectedParam == 2) {
            this.selectedParam = 0;
        } else if (this.selectedParam == 5) {
            this.selectedParam = 4;
        }
    }

    @Override
    public void selectNextItem() {
        super.selectNextItem();
        if (this.selectedParam == 1 || this.selectedParam == 2) {
            this.selectedParam = 3;
        } else if (this.selectedParam == 5) {
            this.selectedParam = 6;
        }
    }

    private void update() {
        ((IView)((MaschineControlSurface)this.surface).getViewManager().get(Views.PLAY)).updateNoteMapping();
        MaschineConfiguration config = (MaschineConfiguration)((MaschineControlSurface)this.surface).getConfiguration();
        Scales scales = this.model.getScales();
        config.setScale(scales.getScale().getName());
        config.setScaleBase(Scales.BASES.get(scales.getScaleOffsetIndex()));
        config.setScaleLayout(scales.getScaleLayout().getName());
    }
}

