/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ni.maschine.mk3.mode;

import de.mossgrabers.controller.ni.maschine.mk3.MaschineConfiguration;
import de.mossgrabers.controller.ni.maschine.mk3.controller.MaschineControlSurface;
import de.mossgrabers.framework.controller.display.ITextDisplay;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.mode.device.ProjectParamsMode;
import de.mossgrabers.framework.parameter.IParameter;
import de.mossgrabers.framework.utils.StringUtils;

public class MaschineUserMode
extends ProjectParamsMode<MaschineControlSurface, MaschineConfiguration> {
    private int selParam = 0;

    public MaschineUserMode(MaschineControlSurface surface, IModel model) {
        super(surface, model, false, DEFAULT_KNOB_IDS);
        this.initTouchedStates(9);
    }

    @Override
    public void updateDisplay() {
        ITextDisplay d = ((MaschineControlSurface)this.surface).getTextDisplay().clear();
        for (int i = 0; i < 8; ++i) {
            Object name;
            IParameter param = (IParameter)this.bank.getItem(i);
            Object object = name = param.doesExist() ? StringUtils.shortenAndFixASCII(param.getName(), 6) : "";
            if (i == this.getSelectedParameter()) {
                name = ">" + (String)name;
            }
            d.setCell(0, i, (String)name).setCell(1, i, param.getDisplayedValue(8));
        }
        d.allDone();
    }

    @Override
    public void onKnobValue(int index, int value) {
        IParameter param = (IParameter)this.bank.getItem(index < 0 ? this.selParam : index);
        if (param.doesExist()) {
            param.changeValue(value);
        }
    }

    @Override
    public void onKnobTouch(int index, boolean isTouched) {
        this.setTouchedKnob(index, isTouched);
        if (index < 8) {
            super.onKnobTouch(index == 8 ? -1 : index, isTouched);
        }
    }

    public void selectParameter(int index) {
        this.selParam = index;
    }

    public int getSelectedParameter() {
        return this.selParam == -1 ? 0 : this.selParam;
    }

    @Override
    public void selectPreviousItem() {
        int selectedParameter = this.getSelectedParameter();
        if (selectedParameter == 0) {
            super.selectPreviousItem();
            this.selectParameter(7);
        } else {
            this.selectParameter(selectedParameter - 1);
        }
    }

    @Override
    public void selectNextItem() {
        int selectedParameter = this.getSelectedParameter();
        if (selectedParameter == 7) {
            super.selectNextItem();
            this.selectParameter(0);
        } else {
            this.selectParameter(selectedParameter + 1);
        }
    }

    @Override
    public void selectPreviousItemPage() {
        super.selectPreviousItem();
        if (this.isProjectMode) {
            this.mvHelper.notifySelectedProjectParameterPage();
        } else {
            this.mvHelper.notifySelectedTrackParameterPage();
        }
    }

    @Override
    public void selectNextItemPage() {
        super.selectNextItem();
        if (this.isProjectMode) {
            this.mvHelper.notifySelectedProjectParameterPage();
        } else {
            this.mvHelper.notifySelectedTrackParameterPage();
        }
    }

    @Override
    public boolean hasPreviousItem() {
        return this.getSelectedParameter() > 0 || super.hasPreviousItem();
    }

    @Override
    public boolean hasNextItem() {
        return this.getSelectedParameter() < 7 || super.hasNextItem();
    }

    @Override
    public boolean hasPreviousItemPage() {
        return super.hasPreviousItem();
    }

    @Override
    public boolean hasNextItemPage() {
        return super.hasNextItem();
    }

    @Override
    public void setMode(boolean isProjectMode) {
        super.setMode(isProjectMode);
        if (isProjectMode) {
            this.mvHelper.notifySelectedProjectParameterPage();
        } else {
            this.mvHelper.notifySelectedTrackParameterPage();
        }
    }
}

