/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ni.maschine.mk3;

import de.mossgrabers.controller.mackie.mcu.controller.MCUDisplay;
import de.mossgrabers.controller.ni.maschine.Maschine;
import de.mossgrabers.controller.ni.maschine.core.MaschineColorManager;
import de.mossgrabers.controller.ni.maschine.core.RibbonMode;
import de.mossgrabers.controller.ni.maschine.core.command.trigger.EncoderMode;
import de.mossgrabers.controller.ni.maschine.core.command.trigger.GroupButtonCommand;
import de.mossgrabers.controller.ni.maschine.core.command.trigger.MaschineMonitorEncoderCommand;
import de.mossgrabers.controller.ni.maschine.mk3.MaschineConfiguration;
import de.mossgrabers.controller.ni.maschine.mk3.command.continuous.MainKnobRowModeCommand;
import de.mossgrabers.controller.ni.maschine.mk3.command.continuous.TouchstripCommand;
import de.mossgrabers.controller.ni.maschine.mk3.command.trigger.AddDeviceCommand;
import de.mossgrabers.controller.ni.maschine.mk3.command.trigger.KeyboardCommand;
import de.mossgrabers.controller.ni.maschine.mk3.command.trigger.MaschineCursorCommand;
import de.mossgrabers.controller.ni.maschine.mk3.command.trigger.MaschineSelectButtonCommand;
import de.mossgrabers.controller.ni.maschine.mk3.command.trigger.MaschineSendSelectCommand;
import de.mossgrabers.controller.ni.maschine.mk3.command.trigger.MaschineStopCommand;
import de.mossgrabers.controller.ni.maschine.mk3.command.trigger.PadModeCommand;
import de.mossgrabers.controller.ni.maschine.mk3.command.trigger.PageCommand;
import de.mossgrabers.controller.ni.maschine.mk3.command.trigger.ProjectButtonCommand;
import de.mossgrabers.controller.ni.maschine.mk3.command.trigger.RibbonCommand;
import de.mossgrabers.controller.ni.maschine.mk3.command.trigger.SwingCommand;
import de.mossgrabers.controller.ni.maschine.mk3.command.trigger.TempoCommand;
import de.mossgrabers.controller.ni.maschine.mk3.command.trigger.ToggleFixedVelCommand;
import de.mossgrabers.controller.ni.maschine.mk3.command.trigger.VolumePanSendCommand;
import de.mossgrabers.controller.ni.maschine.mk3.controller.MaschineControlSurface;
import de.mossgrabers.controller.ni.maschine.mk3.controller.StudioEncoderModeManager;
import de.mossgrabers.controller.ni.maschine.mk3.mode.BrowseMode;
import de.mossgrabers.controller.ni.maschine.mk3.mode.DrumConfigurationMode;
import de.mossgrabers.controller.ni.maschine.mk3.mode.EditNoteMode;
import de.mossgrabers.controller.ni.maschine.mk3.mode.LoopLengthMode;
import de.mossgrabers.controller.ni.maschine.mk3.mode.LoopStartMode;
import de.mossgrabers.controller.ni.maschine.mk3.mode.MaschinePanMode;
import de.mossgrabers.controller.ni.maschine.mk3.mode.MaschineParametersMode;
import de.mossgrabers.controller.ni.maschine.mk3.mode.MaschineSendMode;
import de.mossgrabers.controller.ni.maschine.mk3.mode.MaschineUserMode;
import de.mossgrabers.controller.ni.maschine.mk3.mode.MaschineVolumeMode;
import de.mossgrabers.controller.ni.maschine.mk3.mode.NoteRepeatMode;
import de.mossgrabers.controller.ni.maschine.mk3.mode.PlayConfigurationMode;
import de.mossgrabers.controller.ni.maschine.mk3.mode.PositionMode;
import de.mossgrabers.controller.ni.maschine.mk3.mode.TempoMode;
import de.mossgrabers.controller.ni.maschine.mk3.view.ClipView;
import de.mossgrabers.controller.ni.maschine.mk3.view.DrumView;
import de.mossgrabers.controller.ni.maschine.mk3.view.MuteView;
import de.mossgrabers.controller.ni.maschine.mk3.view.NoteRepeatView;
import de.mossgrabers.controller.ni.maschine.mk3.view.ParameterView;
import de.mossgrabers.controller.ni.maschine.mk3.view.PlayView;
import de.mossgrabers.controller.ni.maschine.mk3.view.SceneView;
import de.mossgrabers.controller.ni.maschine.mk3.view.SelectView;
import de.mossgrabers.controller.ni.maschine.mk3.view.ShiftView;
import de.mossgrabers.controller.ni.maschine.mk3.view.SoloView;
import de.mossgrabers.framework.command.aftertouch.AftertouchViewCommand;
import de.mossgrabers.framework.command.continuous.KnobRowModeCommand;
import de.mossgrabers.framework.command.core.ContinuousCommand;
import de.mossgrabers.framework.command.core.NopCommand;
import de.mossgrabers.framework.command.core.TriggerCommand;
import de.mossgrabers.framework.command.trigger.BrowserCommand;
import de.mossgrabers.framework.command.trigger.Direction;
import de.mossgrabers.framework.command.trigger.FootswitchCommand;
import de.mossgrabers.framework.command.trigger.application.LayoutCommand;
import de.mossgrabers.framework.command.trigger.application.OverdubCommand;
import de.mossgrabers.framework.command.trigger.application.PaneCommand;
import de.mossgrabers.framework.command.trigger.application.PanelLayoutCommand;
import de.mossgrabers.framework.command.trigger.clip.ConvertCommand;
import de.mossgrabers.framework.command.trigger.clip.FillModeNoteRepeatCommand;
import de.mossgrabers.framework.command.trigger.clip.NewCommand;
import de.mossgrabers.framework.command.trigger.mode.ModeCursorCommand;
import de.mossgrabers.framework.command.trigger.mode.ModeSelectCommand;
import de.mossgrabers.framework.command.trigger.track.AddTrackCommand;
import de.mossgrabers.framework.command.trigger.transport.AutomationCommand;
import de.mossgrabers.framework.command.trigger.transport.ConfiguredRecordCommand;
import de.mossgrabers.framework.command.trigger.transport.MetronomeCommand;
import de.mossgrabers.framework.command.trigger.transport.PlayCommand;
import de.mossgrabers.framework.command.trigger.transport.TapTempoCommand;
import de.mossgrabers.framework.command.trigger.transport.ToggleLoopCommand;
import de.mossgrabers.framework.command.trigger.view.ToggleShiftViewCommand;
import de.mossgrabers.framework.command.trigger.view.ViewMultiSelectCommand;
import de.mossgrabers.framework.configuration.ISettingsUI;
import de.mossgrabers.framework.controller.AbstractControllerSetup;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.ContinuousID;
import de.mossgrabers.framework.controller.ISetupFactory;
import de.mossgrabers.framework.controller.hardware.BindType;
import de.mossgrabers.framework.controller.hardware.IHwAbsoluteKnob;
import de.mossgrabers.framework.controller.hardware.IHwContinuousControl;
import de.mossgrabers.framework.controller.hardware.IHwRelativeKnob;
import de.mossgrabers.framework.controller.valuechanger.TwosComplementValueChanger;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.ITransport;
import de.mossgrabers.framework.daw.ModelSetup;
import de.mossgrabers.framework.daw.data.ICursorTrack;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.ITrackBank;
import de.mossgrabers.framework.daw.data.empty.EmptyTrack;
import de.mossgrabers.framework.daw.midi.IMidiAccess;
import de.mossgrabers.framework.daw.midi.IMidiInput;
import de.mossgrabers.framework.daw.midi.IMidiOutput;
import de.mossgrabers.framework.featuregroup.IMode;
import de.mossgrabers.framework.featuregroup.IView;
import de.mossgrabers.framework.featuregroup.ModeManager;
import de.mossgrabers.framework.featuregroup.ViewManager;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.scale.Scales;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.utils.FrameworkException;
import de.mossgrabers.framework.utils.OperatingSystem;
import de.mossgrabers.framework.view.Views;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class MaschineControllerSetup
extends AbstractControllerSetup<MaschineControlSurface, MaschineConfiguration> {
    private static final int[] DRUM_MATRIX = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    private static final List<RibbonMode> RIBBON_MODES_PITCH = Arrays.asList(RibbonMode.PITCH_DOWN, RibbonMode.PITCH_DOWN_UP, RibbonMode.PITCH_UP);
    private static final List<RibbonMode> RIBBON_MODES_CC = Arrays.asList(RibbonMode.CC_1, RibbonMode.CC_11);
    private static final List<RibbonMode> RIBBON_MODES_MASTER_VOLUME = Arrays.asList(RibbonMode.MASTER_VOLUME);
    private static final List<RibbonMode> RIBBON_MODES_NOTE_REPEAT = Arrays.asList(RibbonMode.NOTE_REPEAT_PERIOD, RibbonMode.NOTE_REPEAT_LENGTH);
    private StudioEncoderModeManager encoderManager;
    private final Maschine maschine;
    private ShiftView shiftView;
    private MainKnobRowModeCommand mainKnobCommand;

    public MaschineControllerSetup(IHost host, ISetupFactory factory, ISettingsUI globalSettings, ISettingsUI documentSettings, Maschine maschine) {
        super(factory, host, globalSettings, documentSettings);
        this.maschine = maschine;
        this.colorManager = new MaschineColorManager();
        this.valueChanger = new TwosComplementValueChanger(128, 1);
        this.configuration = new MaschineConfiguration(host, this.valueChanger, factory.getArpeggiatorModes(), maschine);
    }

    @Override
    public void init() {
        if (OperatingSystem.get() == OperatingSystem.LINUX) {
            throw new FrameworkException("Maschine is not supported on Linux since there is no Native Instruments DAW Integration Host.");
        }
        super.init();
    }

    @Override
    protected void createScales() {
        this.scales = new Scales(this.valueChanger, 36, 52, 4, 4);
        this.scales.setDrumMatrix(DRUM_MATRIX);
    }

    @Override
    protected void createModel() {
        ModelSetup ms = new ModelSetup();
        ms.setHasFullFlatTrackList(true);
        ms.setWantsFocusedParameter(true);
        ms.setNumTracks(this.maschine.hasGroupButtons() ? 8 : 16);
        ms.setNumDevicesInBank(16);
        ms.setNumScenes(16);
        this.model = this.factory.createModel(this.configuration, this.colorManager, this.valueChanger, this.scales, ms);
        ITrackBank trackBank = this.model.getTrackBank();
        trackBank.setIndication(true);
        trackBank.addSelectionObserver((index, isSelected) -> this.handleTrackChange(isSelected));
    }

    @Override
    protected void createSurface() {
        IMidiAccess midiAccess = this.factory.createMidiAccess();
        IMidiOutput output = midiAccess.createOutput();
        IMidiInput input = midiAccess.createInput(this.maschine.getName(), "80????", "90????");
        MaschineControlSurface surface = new MaschineControlSurface(this.host, this.colorManager, this.maschine, (MaschineConfiguration)this.configuration, output, input);
        this.surfaces.add(surface);
        if (this.maschine.hasMCUDisplay()) {
            MCUDisplay display = new MCUDisplay(this.host, output, true, false, false, this.configuration);
            display.setCenterNotification(false);
            surface.addTextDisplay(display);
        }
    }

    @Override
    protected void createModes() {
        MaschineControlSurface surface = (MaschineControlSurface)this.getSurface();
        ModeManager modeManager = surface.getModeManager();
        modeManager.register(Modes.BROWSER, new BrowseMode(surface, this.model));
        modeManager.register(Modes.VOLUME, new MaschineVolumeMode(surface, this.model));
        modeManager.register(Modes.PAN, new MaschinePanMode(surface, this.model));
        for (int i = 0; i < 8; ++i) {
            modeManager.register(Modes.get(Modes.SEND1, i), new MaschineSendMode(i, surface, this.model));
        }
        modeManager.register(Modes.TEMPO, new TempoMode(surface, this.model));
        modeManager.register(Modes.POSITION, new PositionMode(surface, this.model));
        modeManager.register(Modes.LOOP_START, new LoopStartMode(surface, this.model));
        modeManager.register(Modes.LOOP_LENGTH, new LoopLengthMode(surface, this.model));
        modeManager.register(Modes.REPEAT_NOTE, new NoteRepeatMode(surface, this.model));
        modeManager.register(Modes.SCALES, new PlayConfigurationMode(surface, this.model));
        modeManager.register(Modes.PLAY_OPTIONS, new DrumConfigurationMode(surface, this.model));
        modeManager.register(Modes.NOTE, new EditNoteMode(surface, this.model));
        modeManager.register(Modes.DEVICE_PARAMS, new MaschineParametersMode(surface, this.model));
        if (this.maschine.hasMCUDisplay()) {
            modeManager.register(Modes.USER, new MaschineUserMode(surface, this.model));
        }
        modeManager.setDefaultID(Modes.VOLUME);
    }

    @Override
    protected void createViews() {
        MaschineControlSurface surface = (MaschineControlSurface)this.getSurface();
        ViewManager viewManager = surface.getViewManager();
        viewManager.register(Views.SCENE_PLAY, new SceneView(surface, this.model));
        viewManager.register(Views.SESSION, new ClipView(surface, this.model));
        DrumView drumView = new DrumView(surface, this.model);
        viewManager.register(Views.DRUM, drumView);
        viewManager.register(Views.PLAY, new PlayView(surface, this.model, drumView));
        viewManager.register(Views.DEVICE, new ParameterView(surface, this.model));
        if (!this.maschine.hasGroupButtons()) {
            viewManager.register(Views.TRACK_SELECT, new SelectView(surface, this.model));
            viewManager.register(Views.TRACK_SOLO, new SoloView(surface, this.model));
            viewManager.register(Views.TRACK_MUTE, new MuteView(surface, this.model));
        }
        viewManager.register(Views.REPEAT_NOTE, new NoteRepeatView(surface, this.model));
        this.shiftView = new ShiftView(surface, this.model);
        viewManager.register(Views.SHIFT, this.shiftView);
    }

    @Override
    protected void createObservers() {
        super.createObservers();
        MaschineControlSurface surface = (MaschineControlSurface)this.getSurface();
        ((MaschineConfiguration)this.configuration).registerDeactivatedItemsHandler(this.model);
        this.createScaleObservers((MaschineConfiguration)this.configuration);
        this.createNoteRepeatObservers((MaschineConfiguration)this.configuration, surface);
        this.activateBrowserObserver(Modes.BROWSER);
    }

    @Override
    protected void registerTriggerCommands() {
        int footswitches;
        MaschineControlSurface surface = (MaschineControlSurface)this.getSurface();
        ModeManager modeManager = surface.getModeManager();
        ViewManager viewManager = surface.getViewManager();
        ITransport t = this.model.getTransport();
        this.addButton(ButtonID.SHIFT, "SHIFT", new ToggleShiftViewCommand(this.model, surface), this.maschine == Maschine.STUDIO ? 11 : -1, () -> viewManager.isActive(new Views[]{Views.SHIFT}) || surface.isShiftPressed());
        this.addButton(ButtonID.PLAY, "PLAY", new PlayCommand(this.model, surface), 57, t::isPlaying);
        ConfiguredRecordCommand recordCommand = new ConfiguredRecordCommand(this.model, surface);
        this.addButton(ButtonID.RECORD, "RECORD", recordCommand, 58, recordCommand::isLit);
        this.addButton(ButtonID.STOP, "STOP", (TriggerCommand)new MaschineStopCommand(this.model, surface), 59, () -> !t.isPlaying());
        this.addButton(ButtonID.LOOP, "LOOP", new ToggleLoopCommand(this.model, surface), 53, t::isLoop);
        this.addButton(ButtonID.DELETE, "ERASE", NopCommand.INSTANCE, 54);
        MetronomeCommand metroCommand = new MetronomeCommand(this.model, surface, false);
        TapTempoCommand tapTempoCommand = new TapTempoCommand(this.model, surface);
        this.addButton(ButtonID.TAP_TEMPO, "TAP/METRO", (ButtonEvent event, int velocity) -> {
            if (event != ButtonEvent.UP) {
                return;
            }
            if (surface.isShiftPressed()) {
                surface.setStopConsumed();
                metroCommand.executeNormal(event);
            } else {
                tapTempoCommand.execute(ButtonEvent.DOWN, velocity);
            }
        }, 55, t::isMetronomeOn);
        this.addButton(ButtonID.FLIP, this.maschine == Maschine.STUDIO || this.maschine == Maschine.MK2 ? "GRID" : "FOLLOW", (ButtonEvent event, int velocity) -> {
            if (event != ButtonEvent.UP) {
                return;
            }
            if (viewManager.isActive(new Views[]{Views.DRUM, Views.PLAY})) {
                ((DrumView)viewManager.get(Views.DRUM)).toggleGridEditor();
            }
        }, 56, () -> viewManager.isActive(new Views[]{Views.DRUM, Views.PLAY}) && ((DrumView)viewManager.get(Views.DRUM)).isGridEditor());
        this.addButton(ButtonID.NEW, this.maschine.hasCursorKeys() ? "MACRO" : "GROUP", new NewCommand(this.model, surface), 34);
        AutomationCommand<MaschineControlSurface, MaschineConfiguration> automationCommand = new AutomationCommand<MaschineControlSurface, MaschineConfiguration>(this, this.model, surface){

            @Override
            protected void cleanupShift() {
                ((MaschineControlSurface)this.surface).setStopConsumed();
            }
        };
        this.addButton(ButtonID.AUTOMATION, "AUTO", (TriggerCommand)automationCommand, 35, automationCommand::isLit);
        this.addButton(ButtonID.OVERDUB, this.maschine == Maschine.STUDIO || this.maschine == Maschine.MK2 ? "ENTER" : "LOCK", (TriggerCommand)new OverdubCommand<MaschineControlSurface, MaschineConfiguration>(this, this.model, surface){

            @Override
            protected void shiftedFunction() {
                ((MaschineControlSurface)this.surface).setStopConsumed();
                super.shiftedFunction();
            }
        }, 36, () -> surface.isShiftPressed() ? t.isLauncherOverdub() : t.isArrangerOverdub());
        this.addButton(ButtonID.REPEAT, "NOTE REPEAT", new FillModeNoteRepeatCommand(this.model, surface, this.maschine.hasMCUDisplay()), 37, ((MaschineConfiguration)this.configuration)::isNoteRepeatActive);
        this.addButton(ButtonID.F1, "PITCH", (TriggerCommand)new RibbonCommand(this.model, surface, RIBBON_MODES_PITCH), 49, () -> this.isRibbonMode(new HashSet<RibbonMode>(RIBBON_MODES_PITCH)));
        this.addButton(ButtonID.F2, "MOD", (TriggerCommand)new RibbonCommand(this.model, surface, RIBBON_MODES_CC), 50, () -> this.isRibbonMode(new HashSet<RibbonMode>(RIBBON_MODES_CC)));
        this.addButton(ButtonID.F3, "PERFORM", (TriggerCommand)new RibbonCommand(this.model, surface, RIBBON_MODES_MASTER_VOLUME), 51, () -> this.isRibbonMode(new HashSet<RibbonMode>(RIBBON_MODES_MASTER_VOLUME)));
        this.addButton(ButtonID.F4, "NOTES", (TriggerCommand)new RibbonCommand(this.model, surface, RIBBON_MODES_NOTE_REPEAT), 52, () -> this.isRibbonMode(new HashSet<RibbonMode>(RIBBON_MODES_NOTE_REPEAT)));
        this.addButton(ButtonID.FADER_TOUCH_1, "ENCODER PRESS", (event, velocity) -> {
            if (event != ButtonEvent.DOWN) {
                return;
            }
            if (modeManager.getActiveID() == Modes.BROWSER) {
                this.model.getBrowser().stopBrowsing(true);
                modeManager.restore();
            } else {
                this.mainKnobCommand.toggleControlLastParamActive();
                surface.getDisplay().notify("Last Param: " + (this.mainKnobCommand.isControlLastParamActive() ? " ON" : "OFF"));
            }
        }, 8);
        this.addButton(ButtonID.VOLUME, "VOLUME", (TriggerCommand)new VolumePanSendCommand(this.model, surface), 44, () -> Modes.isTrackMode((Modes)((Object)((Object)modeManager.getActiveID()))));
        this.addButton(ButtonID.SWING, "SWING", (TriggerCommand)new SwingCommand(this.model, surface), 46, () -> modeManager.isActive(new Modes[]{Modes.POSITION, Modes.LOOP_START, Modes.LOOP_LENGTH}));
        this.addButton(ButtonID.TEMPO_TOUCH, "TEMPO", (TriggerCommand)new TempoCommand(this.model, surface), 48, () -> modeManager.isActive(new Modes[]{Modes.TEMPO}));
        this.addButton(ButtonID.DEVICE, "PLUG-IN", (ButtonEvent event, int velocity) -> {
            if (this.maschine.hasMCUDisplay() || surface.isShiftPressed()) {
                new PanelLayoutCommand(this.model, surface).executeNormal(event);
            } else {
                new ModeSelectCommand(this.model, surface, Modes.DEVICE_PARAMS).execute(event, velocity);
            }
        }, 45, () -> this.maschine.hasMCUDisplay() || surface.isShiftPressed() ? this.model.getCursorDevice().isWindowOpen() : modeManager.isActive(new Modes[]{Modes.DEVICE_PARAMS}));
        this.addButton(ButtonID.DEVICE_ON_OFF, "SAMPLING", new ConvertCommand<MaschineControlSurface, MaschineConfiguration>(this, this.model, surface){

            @Override
            protected void sliceToSampler() {
                ((MaschineControlSurface)this.surface).setStopConsumed();
                super.sliceToSampler();
            }
        }, 47);
        String fileLabel = this.maschine.hasCursorKeys() ? (this.maschine == Maschine.STUDIO || this.maschine == Maschine.MK2 ? "ALL/SAVE" : "FILE") : "PROJECT";
        this.addButton(ButtonID.ADD_TRACK, fileLabel, new ProjectButtonCommand(this.model, surface), 38);
        this.addButton(ButtonID.ADD_EFFECT, this.maschine.hasCursorKeys() ? "SETTINGS" : "FAVORITES", new AddDeviceCommand(this.model, surface), 39);
        this.addButton(ButtonID.BROWSE, this.maschine == Maschine.STUDIO || this.maschine == Maschine.MK2 ? "BROWSE" : "BROWSER", (TriggerCommand)new BrowserCommand<MaschineControlSurface, MaschineConfiguration>(this, this.model, surface, ButtonID.SHIFT, ButtonID.SELECT){

            @Override
            protected boolean getCommit() {
                return false;
            }
        }, 40, this.model.getBrowser()::isActive);
        this.addButton(ButtonID.ACCENT, "ACCENT", (TriggerCommand)new ToggleFixedVelCommand(this.model, surface), 80, ((MaschineConfiguration)this.configuration)::isAccentActive);
        this.addButton(ButtonID.SCENE1, "SCENE", new ViewMultiSelectCommand(this.model, surface, Views.SCENE_PLAY), 85, () -> viewManager.isActive(new Views[]{Views.SCENE_PLAY}));
        this.addButton(ButtonID.CLIP, "PATTERN", new ViewMultiSelectCommand(this.model, surface, Views.SESSION), 86, () -> viewManager.isActive(new Views[]{Views.CLIP_LENGTH}));
        this.addButton(ButtonID.NOTE, "EVENTS", new ModeSelectCommand(this.model, surface, Modes.NOTE, true), 87, () -> modeManager.isActive(new Modes[]{Modes.NOTE}));
        this.addButton(ButtonID.TOGGLE_DEVICE, this.maschine == Maschine.STUDIO || this.maschine == Maschine.MK2 ? "NAVIGATE" : "VARIATION", new ViewMultiSelectCommand(this.model, surface, Views.DEVICE), 88, () -> viewManager.isActive(new Views[]{Views.DEVICE}));
        this.addButton(ButtonID.DUPLICATE, "DUPLICATE", NopCommand.INSTANCE, 89);
        if (this.maschine.hasGroupButtons()) {
            this.addButton(ButtonID.SELECT, "SELECT", new MaschineSelectButtonCommand(this.model, surface), 90);
            this.addButton(ButtonID.SOLO, "SOLO", (event, velocity) -> {
                if (event == ButtonEvent.UP && surface.isShiftPressed()) {
                    surface.setStopConsumed();
                    this.model.getProject().clearSolo();
                }
            }, 91);
            this.addButton(ButtonID.MUTE, "MUTE", (event, velocity) -> {
                if (event == ButtonEvent.UP && surface.isShiftPressed()) {
                    surface.setStopConsumed();
                    this.model.getProject().clearMute();
                }
            }, 92);
        } else {
            this.addButton(ButtonID.SELECT, "SELECT", new ViewMultiSelectCommand(this.model, surface, Views.TRACK_SELECT), 90, () -> viewManager.isActive(new Views[]{Views.TRACK_SELECT}));
            this.addButton(ButtonID.SOLO, "SOLO", new ViewMultiSelectCommand(this.model, surface, Views.TRACK_SOLO), 91, () -> viewManager.isActive(new Views[]{Views.TRACK_SOLO}));
            this.addButton(ButtonID.MUTE, "MUTE", new ViewMultiSelectCommand(this.model, surface, Views.TRACK_MUTE), 92, () -> viewManager.isActive(new Views[]{Views.TRACK_MUTE}));
        }
        KeyboardCommand keyboardCommand = new KeyboardCommand(this.model, surface);
        this.addButton(ButtonID.ROW1_1, "PAD MODE", (TriggerCommand)new PadModeCommand(keyboardCommand, this.model, surface), 81, () -> viewManager.isActive(new Views[]{Views.DRUM}));
        this.addButton(ButtonID.ROW1_2, "KEYBOARD", (TriggerCommand)keyboardCommand, 82, () -> viewManager.isActive(new Views[]{Views.PLAY}));
        this.addButton(ButtonID.ROW1_3, "CHORDS", (ButtonEvent event, int velocity) -> {
            if (velocity == 0) {
                ((PlayView)viewManager.get(Views.PLAY)).toggleChordMode();
            }
        }, 84, ((PlayView)viewManager.get(Views.PLAY))::isChordMode);
        DrumView drumView = (DrumView)viewManager.get(Views.DRUM);
        this.addButton(ButtonID.ROW1_4, "STEP", (ButtonEvent event, int velocity) -> {
            if (event == ButtonEvent.UP) {
                drumView.toggleSequencerVisible();
            }
        }, 83, drumView::isSequencerVisible);
        this.registerCursorKeys(surface);
        this.registerDisplayButtons(surface, modeManager);
        this.registerGroupButtons(surface);
        if (this.maschine == Maschine.STUDIO) {
            this.registerMaschineStudioButtons(surface);
        }
        if ((footswitches = this.maschine.getFootswitches()) >= 2) {
            this.addButton(ButtonID.FOOTSWITCH1, "Foot Controller (Tip)", new FootswitchCommand(this.model, surface, 0), 3);
            this.addButton(ButtonID.FOOTSWITCH2, "Foot Controller (Ring)", new FootswitchCommand(this.model, surface, 1), 4);
            if (footswitches == 4) {
                this.addButton(ButtonID.FOOTSWITCH3, "Foot Controller 2 (Tip)", new FootswitchCommand(this.model, surface, 2), 5);
                this.addButton(ButtonID.FOOTSWITCH4, "Foot Controller 2 (Ring)", new FootswitchCommand(this.model, surface, 3), 6);
            }
        }
    }

    private void registerCursorKeys(MaschineControlSurface surface) {
        if (!this.maschine.hasCursorKeys()) {
            return;
        }
        this.addButton(ButtonID.ARROW_LEFT, "LEFT", (TriggerCommand)new MaschineCursorCommand(Direction.LEFT, this.model, surface), 33, () -> this.getEncoderColor(ButtonID.ARROW_LEFT));
        this.addButton(ButtonID.ARROW_RIGHT, "RIGHT", (TriggerCommand)new MaschineCursorCommand(Direction.RIGHT, this.model, surface), 31, () -> this.getEncoderColor(ButtonID.ARROW_RIGHT));
        this.addButton(ButtonID.ARROW_UP, "UP", new ModeCursorCommand(Direction.UP, this.model, surface, false), 30, () -> this.getEncoderColor(ButtonID.ARROW_UP));
        this.addButton(ButtonID.ARROW_DOWN, "DOWN", new ModeCursorCommand(Direction.DOWN, this.model, surface, false), 32, () -> this.getEncoderColor(ButtonID.ARROW_DOWN));
        this.addButton(ButtonID.PAGE_LEFT, "PAGE LEFT", new PageCommand(Direction.LEFT, this.model, surface), 110);
        this.addButton(ButtonID.PAGE_RIGHT, "PAGE RIGHT", new PageCommand(Direction.RIGHT, this.model, surface), 111);
        this.addButton(ButtonID.LAYOUT_ARRANGE, this.maschine == Maschine.STUDIO ? "ARRANGE" : "ARRANGER", new LayoutCommand(this.model, surface), 42);
        this.addButton(ButtonID.MIXER, this.maschine == Maschine.STUDIO ? "MIX" : "MIXER", new PaneCommand(PaneCommand.Panels.MIXER, this.model, surface), 43);
        this.addButton(ButtonID.DRUM, this.maschine == Maschine.MK2 ? "CONTROL" : "CHANNEL", new AddTrackCommand(this.model, surface, null, ButtonID.STOP), 41);
    }

    private void registerDisplayButtons(MaschineControlSurface surface, ModeManager modeManager) {
        if (!this.maschine.hasMCUDisplay()) {
            return;
        }
        this.addButton(ButtonID.ROW2_1, "Volume", new ModeSelectCommand(this.model, surface, Modes.VOLUME), 22, () -> modeManager.isActive(new Modes[]{Modes.VOLUME}));
        this.addButton(ButtonID.ROW2_2, "Pan", new ModeSelectCommand(this.model, surface, Modes.PAN), 23, () -> modeManager.isActive(new Modes[]{Modes.PAN}));
        MaschineSendSelectCommand sendSelectCommand = new MaschineSendSelectCommand(this.model, surface);
        this.addButton(ButtonID.ROW2_3, "Send -", (ButtonEvent event, int velocity) -> sendSelectCommand.executeShifted(event), 24, () -> Modes.isSendMode((Modes)((Object)((Object)modeManager.getActiveID()))));
        this.addButton(ButtonID.ROW2_4, "Send +", (TriggerCommand)sendSelectCommand, 25, () -> Modes.isSendMode((Modes)((Object)((Object)modeManager.getActiveID()))));
        this.addButton(ButtonID.ROW2_5, "Pin", (ButtonEvent event, int velocity) -> {
            if (event != ButtonEvent.DOWN) {
                return;
            }
            if (modeManager.isActive(new Modes[]{Modes.DEVICE_PARAMS})) {
                this.model.getCursorDevice().togglePinned();
            } else {
                this.model.getCursorTrack().togglePinned();
            }
        }, 26, () -> {
            if (modeManager.isActive(new Modes[]{Modes.DEVICE_PARAMS})) {
                return this.model.getCursorDevice().isPinned();
            }
            return this.model.getCursorTrack().isPinned();
        });
        this.addButton(ButtonID.ROW2_6, "Active", (ButtonEvent event, int velocity) -> {
            if (event != ButtonEvent.DOWN) {
                return;
            }
            if (modeManager.isActive(new Modes[]{Modes.DEVICE_PARAMS})) {
                this.model.getCursorDevice().toggleEnabledState();
            } else {
                this.model.getCursorTrack().toggleIsActivated();
            }
        }, 27, () -> {
            if (modeManager.isActive(new Modes[]{Modes.DEVICE_PARAMS})) {
                return this.model.getCursorDevice().isEnabled();
            }
            ICursorTrack selectedTrack = this.model.getCursorTrack();
            return selectedTrack.doesExist() && selectedTrack.isActivated();
        });
        this.addButton(ButtonID.ROW2_7, "User Params", new ModeSelectCommand(this.model, surface, Modes.USER), 28, () -> modeManager.isActive(new Modes[]{Modes.USER}));
        this.addButton(ButtonID.ROW2_8, "Parameters", new ModeSelectCommand(this.model, surface, Modes.DEVICE_PARAMS), 29, () -> modeManager.isActive(new Modes[]{Modes.DEVICE_PARAMS}));
    }

    private void registerGroupButtons(MaschineControlSurface surface) {
        if (!this.maschine.hasGroupButtons()) {
            return;
        }
        for (int i = 0; i < 8; ++i) {
            GroupButtonCommand command = new GroupButtonCommand(this.model, surface, i);
            this.addButton(ButtonID.get(ButtonID.ROW3_1, i), "Bank " + (i + 1), command, 100 + i, command::getButtonColor);
        }
    }

    private void registerMaschineStudioButtons(MaschineControlSurface surface) {
        this.addButton(ButtonID.METRONOME, "METRO", new MetronomeCommand(this.model, surface, false), 14, () -> this.model.getTransport().isMetronomeOn());
        this.addButton(ButtonID.UNDO, "UNDO", this.createShiftViewFunction(surface, 0, 2), 116);
        this.addButton(ButtonID.REDO, "REDO", this.createShiftViewFunction(surface, 1, 3), 117);
        this.addButton(ButtonID.QUANTIZE, "QUANTIZE", this.createShiftViewFunction(surface, 4, 5), 118);
        this.addButton(ButtonID.CONTROL, "CLEAR", this.createShiftViewFunction(surface, 8, 9), 119);
        this.addButton(ButtonID.COPY, "COPY", this.createShiftViewFunction(surface, 10, 10), 112);
        this.addButton(ButtonID.PASTE, "PASTE", this.createShiftViewFunction(surface, 11, 11), 113);
        this.addButton(ButtonID.NUDGE_MINUS, "NOTE", this.createShiftViewFunction(surface, 13, 12), 114);
        this.addButton(ButtonID.NUDGE_PLUS, "NUDGE", this.createShiftViewFunction(surface, 15, 14), 115);
    }

    private TriggerCommand createShiftViewFunction(MaschineControlSurface surface, int padIndex, int shiftPadIndex) {
        return (event, velocity) -> this.shiftView.executeFunction(surface.isShiftPressed() ? shiftPadIndex : padIndex, event);
    }

    private int getEncoderColor(ButtonID arrowButton) {
        boolean isOn;
        MaschineControlSurface surface = (MaschineControlSurface)this.getSurface();
        ModeManager modeManager = surface.getModeManager();
        Modes modeID = (Modes)((Object)modeManager.getActiveID());
        if (modeID == null) {
            return 0;
        }
        IMode mode = (IMode)modeManager.getActive();
        switch (arrowButton) {
            case ARROW_LEFT: {
                isOn = mode.hasPreviousItem();
                break;
            }
            case ARROW_RIGHT: {
                isOn = mode.hasNextItem();
                break;
            }
            case ARROW_UP: {
                isOn = mode.hasNextItemPage();
                break;
            }
            case ARROW_DOWN: {
                isOn = mode.hasPreviousItemPage();
                break;
            }
            default: {
                return 0;
            }
        }
        if (!isOn) {
            return 0;
        }
        switch (modeID) {
            case VOLUME: {
                return surface.isPressed(arrowButton) ? 42 : 45;
            }
            case PAN: {
                return surface.isPressed(arrowButton) ? 38 : 37;
            }
            case SEND1: 
            case SEND2: 
            case SEND3: 
            case SEND4: 
            case SEND5: 
            case SEND6: 
            case SEND7: 
            case SEND8: {
                return surface.isPressed(arrowButton) ? 78 : 22;
            }
            case DEVICE_PARAMS: 
            case USER: {
                return surface.isPressed(arrowButton) ? 62 : 61;
            }
            case BROWSER: {
                return surface.isPressed(arrowButton) ? 14 : 13;
            }
            case NOTE: {
                return surface.isPressed(arrowButton) ? 30 : 29;
            }
        }
        return 0;
    }

    @Override
    protected void registerContinuousCommands() {
        Views[] views;
        MaschineControlSurface surface = (MaschineControlSurface)this.getSurface();
        ModeManager modeManager = surface.getModeManager();
        ViewManager viewManager = surface.getViewManager();
        this.mainKnobCommand = new MainKnobRowModeCommand(this.model, surface);
        IHwRelativeKnob knob = this.addRelativeKnob(ContinuousID.MASTER_KNOB, "Encoder", this.mainKnobCommand, 7);
        knob.bindTouch((event, velocity) -> {
            IMode mode = (IMode)modeManager.getActive();
            if (mode != null && event != ButtonEvent.LONG) {
                mode.onKnobTouch(8, event == ButtonEvent.DOWN);
            }
        }, surface.getMidiInput(), BindType.CC, 0, 9);
        if (this.maschine.hasMCUDisplay()) {
            for (int i = 0; i < 8; ++i) {
                int index = i;
                Views[] modeKnob = this.addRelativeKnob(ContinuousID.get(ContinuousID.KNOB1, i), "Knob " + (i + 1), new KnobRowModeCommand(i, this.model, surface), 70 + i);
                modeKnob.bindTouch((event, velocity) -> {
                    IMode mode = (IMode)modeManager.getActive();
                    if (mode != null && event != ButtonEvent.LONG) {
                        mode.onKnobTouch(index, event == ButtonEvent.DOWN);
                    }
                }, surface.getMidiInput(), BindType.CC, 0, 60 + i);
                modeKnob.setIndexInGroup(i);
            }
        }
        TouchstripCommand touchstripCommand = new TouchstripCommand(this.model, surface);
        this.addFader(ContinuousID.CROSSFADER, "Touchstrip", (ContinuousCommand)touchstripCommand, BindType.CC, 1, false);
        surface.getContinuous(ContinuousID.CROSSFADER).bindTouch(touchstripCommand, surface.getMidiInput(), BindType.CC, 0, 2);
        for (Views viewID : views = new Views[]{Views.PLAY, Views.DRUM}) {
            IView view = (IView)viewManager.get(viewID);
            view.registerAftertouchCommand(new AftertouchViewCommand(view, this.model, surface));
        }
        if (this.maschine == Maschine.STUDIO) {
            IHwAbsoluteKnob masterKnob = this.addAbsoluteKnob(ContinuousID.MONITOR_KNOB, "Encoder", null, 10);
            this.encoderManager = new StudioEncoderModeManager((IHwContinuousControl)masterKnob, this.model, surface);
            masterKnob.bind(this.encoderManager);
            MaschineMonitorEncoderCommand<MaschineControlSurface, MaschineConfiguration> encoderCommandMaster = new MaschineMonitorEncoderCommand<MaschineControlSurface, MaschineConfiguration>(this.encoderManager, EncoderMode.MASTER_VOLUME, this.model, surface);
            this.addButton(ButtonID.ROW4_1, "MST", encoderCommandMaster, 124, encoderCommandMaster::isLit);
            MaschineMonitorEncoderCommand<MaschineControlSurface, MaschineConfiguration> encoderCommandSelectedTrack = new MaschineMonitorEncoderCommand<MaschineControlSurface, MaschineConfiguration>(this.encoderManager, EncoderMode.SELECTED_TRACK_VOLUME, this.model, surface);
            this.addButton(ButtonID.ROW4_2, "GRP", encoderCommandSelectedTrack, 125, encoderCommandSelectedTrack::isLit);
            MaschineMonitorEncoderCommand<MaschineControlSurface, MaschineConfiguration> encoderCommandMetronome = new MaschineMonitorEncoderCommand<MaschineControlSurface, MaschineConfiguration>(this.encoderManager, EncoderMode.METRONOME_VOLUME, this.model, surface);
            this.addButton(ButtonID.ROW4_3, "SND", encoderCommandMetronome, 126, encoderCommandMetronome::isLit);
            MaschineMonitorEncoderCommand<MaschineControlSurface, MaschineConfiguration> encoderCommandCue = new MaschineMonitorEncoderCommand<MaschineControlSurface, MaschineConfiguration>(this.encoderManager, EncoderMode.CUE_VOLUME, this.model, surface);
            this.addButton(ButtonID.ROW4_4, "CUE", encoderCommandCue, 127, encoderCommandCue::isLit);
            MaschineMonitorEncoderCommand<MaschineControlSurface, MaschineConfiguration> encoderCommandMasterPan = new MaschineMonitorEncoderCommand<MaschineControlSurface, MaschineConfiguration>(this.encoderManager, EncoderMode.MASTER_PANNING, this.model, surface);
            this.addButton(ButtonID.ROW4_5, "IN1", encoderCommandMasterPan, 120, encoderCommandMasterPan::isLit);
            MaschineMonitorEncoderCommand<MaschineControlSurface, MaschineConfiguration> encoderCommandSelectedTrackPan = new MaschineMonitorEncoderCommand<MaschineControlSurface, MaschineConfiguration>(this.encoderManager, EncoderMode.SELECTED_TRACK_PANNING, this.model, surface);
            this.addButton(ButtonID.ROW4_6, "IN2", encoderCommandSelectedTrackPan, 121, encoderCommandSelectedTrackPan::isLit);
            MaschineMonitorEncoderCommand<MaschineControlSurface, MaschineConfiguration> encoderCommandCueMix = new MaschineMonitorEncoderCommand<MaschineControlSurface, MaschineConfiguration>(this.encoderManager, EncoderMode.CUE_MIX, this.model, surface);
            this.addButton(ButtonID.ROW4_8, "IN4", encoderCommandCueMix, 123, encoderCommandCueMix::isLit);
            this.addButton(ButtonID.TOGGLE_VU, "IN3", (ButtonEvent event, int value) -> {
                if (event == ButtonEvent.UP) {
                    this.encoderManager.toggleMode();
                }
            }, 122, this.encoderManager::isParameterMode);
            this.encoderManager.setActiveEncoderMode(EncoderMode.MASTER_VOLUME);
        }
    }

    @Override
    protected void layoutControls() {
        switch (this.maschine) {
            case MK2: {
                this.layoutMk2();
                break;
            }
            case MK3: 
            case PLUS: {
                this.layoutMk3();
                break;
            }
            case STUDIO: {
                this.layoutStudio();
                break;
            }
            case MIKRO_MK3: {
                this.layoutMikroMk3();
                break;
            }
        }
    }

    private void layoutMk2() {
        MaschineControlSurface surface = (MaschineControlSurface)this.getSurface();
        surface.getButton(ButtonID.PAD1).setBounds(425.5, 604.5, 76.25, 79.0);
        surface.getButton(ButtonID.PAD2).setBounds(516.25, 605.25, 76.25, 79.0);
        surface.getButton(ButtonID.PAD3).setBounds(606.75, 605.25, 76.25, 79.0);
        surface.getButton(ButtonID.PAD4).setBounds(694.75, 605.25, 76.25, 79.0);
        surface.getButton(ButtonID.PAD5).setBounds(425.5, 515.0, 76.25, 79.0);
        surface.getButton(ButtonID.PAD6).setBounds(516.25, 515.5, 76.25, 79.0);
        surface.getButton(ButtonID.PAD7).setBounds(606.75, 515.75, 76.25, 79.0);
        surface.getButton(ButtonID.PAD8).setBounds(694.75, 515.5, 76.25, 79.0);
        surface.getButton(ButtonID.PAD9).setBounds(425.5, 425.25, 76.25, 79.0);
        surface.getButton(ButtonID.PAD10).setBounds(516.25, 426.0, 76.25, 79.0);
        surface.getButton(ButtonID.PAD11).setBounds(606.75, 426.25, 76.25, 79.0);
        surface.getButton(ButtonID.PAD12).setBounds(694.75, 425.5, 76.25, 79.0);
        surface.getButton(ButtonID.PAD13).setBounds(425.5, 335.75, 76.25, 79.0);
        surface.getButton(ButtonID.PAD14).setBounds(516.25, 336.25, 76.25, 79.0);
        surface.getButton(ButtonID.PAD15).setBounds(606.75, 336.75, 76.25, 79.0);
        surface.getButton(ButtonID.PAD16).setBounds(694.75, 335.75, 76.25, 79.0);
        surface.getButton(ButtonID.SHIFT).setBounds(96.75, 619.0, 56.0, 18.0);
        surface.getButton(ButtonID.PLAY).setBounds(24.75, 650.0, 55.75, 32.0);
        surface.getButton(ButtonID.RECORD).setBounds(96.75, 650.0, 55.75, 32.0);
        surface.getButton(ButtonID.LOOP).setBounds(24.75, 619.0, 56.0, 18.0);
        surface.getButton(ButtonID.DELETE).setBounds(166.25, 650.0, 55.75, 32.0);
        surface.getButton(ButtonID.TAP_TEMPO).setBounds(166.25, 619.0, 56.0, 18.0);
        surface.getButton(ButtonID.FLIP).setBounds(236.5, 619.0, 56.0, 18.0);
        surface.getButton(ButtonID.AUTOMATION).setBounds(94.0, 236.25, 55.75, 32.0);
        surface.getButton(ButtonID.OVERDUB).setBounds(231.5, 406.75, 58.0, 19.0);
        surface.getButton(ButtonID.REPEAT).setBounds(231.5, 337.25, 58.0, 46.25);
        surface.getButton(ButtonID.FADER_TOUCH_1).setBounds(123.25, 303.25, 69.5, 22.75);
        surface.getButton(ButtonID.VOLUME).setBounds(27.75, 337.25, 58.0, 18.0);
        surface.getButton(ButtonID.SWING).setBounds(27.75, 373.0, 58.0, 18.0);
        surface.getButton(ButtonID.TEMPO_TOUCH).setBounds(27.75, 407.75, 58.0, 18.0);
        surface.getButton(ButtonID.DEVICE_ON_OFF).setBounds(95.75, 107.25, 55.75, 38.5);
        surface.getButton(ButtonID.ADD_TRACK).setBounds(27.25, 236.25, 55.75, 32.0);
        surface.getButton(ButtonID.BROWSE).setBounds(28.75, 107.25, 55.75, 38.5);
        surface.getButton(ButtonID.SCENE1).setBounds(346.5, 335.5, 58.0, 34.0);
        surface.getButton(ButtonID.CLIP).setBounds(346.5, 379.25, 58.0, 34.0);
        surface.getButton(ButtonID.NOTE).setBounds(346.5, 561.5, 58.0, 34.0);
        surface.getButton(ButtonID.TOGGLE_DEVICE).setBounds(346.5, 466.75, 58.0, 41.25);
        surface.getButton(ButtonID.DUPLICATE).setBounds(347.25, 515.0, 58.0, 34.0);
        surface.getButton(ButtonID.SOLO).setBounds(346.5, 605.25, 58.0, 34.0);
        surface.getButton(ButtonID.MUTE).setBounds(346.5, 649.0, 58.0, 34.0);
        surface.getButton(ButtonID.ROW1_1).setBounds(346.5, 423.0, 58.0, 34.0);
        surface.getButton(ButtonID.ROW1_4).setBounds(95.75, 21.25, 55.75, 23.0);
        surface.getButton(ButtonID.ARROW_LEFT).setBounds(121.5, 408.25, 32.75, 17.5);
        surface.getButton(ButtonID.ARROW_RIGHT).setBounds(157.0, 408.25, 32.75, 17.5);
        surface.getButton(ButtonID.PAGE_LEFT).setBounds(28.75, 157.75, 55.75, 23.0);
        surface.getButton(ButtonID.PAGE_RIGHT).setBounds(95.75, 157.75, 55.75, 23.0);
        surface.getButton(ButtonID.DRUM).setBounds(28.75, 21.25, 55.75, 23.0);
        surface.getButton(ButtonID.ROW2_1).setBounds(179.25, 21.25, 66.25, 27.25);
        surface.getButton(ButtonID.ROW2_2).setBounds(254.25, 21.25, 66.25, 27.25);
        surface.getButton(ButtonID.ROW2_3).setBounds(329.25, 21.25, 66.25, 27.25);
        surface.getButton(ButtonID.ROW2_4).setBounds(404.0, 21.25, 66.25, 27.25);
        surface.getButton(ButtonID.ROW2_5).setBounds(479.0, 21.25, 66.25, 27.25);
        surface.getButton(ButtonID.ROW2_6).setBounds(554.0, 21.25, 66.25, 27.25);
        surface.getButton(ButtonID.ROW2_7).setBounds(629.0, 21.25, 66.25, 27.25);
        surface.getButton(ButtonID.ROW2_8).setBounds(704.0, 21.25, 66.25, 27.25);
        surface.getButton(ButtonID.ROW3_1).setBounds(26.25, 480.0, 53.75, 35.0);
        surface.getButton(ButtonID.ROW3_2).setBounds(96.75, 480.0, 53.75, 35.0);
        surface.getButton(ButtonID.ROW3_3).setBounds(167.0, 480.0, 53.75, 35.0);
        surface.getButton(ButtonID.ROW3_4).setBounds(237.5, 480.0, 53.75, 35.0);
        surface.getButton(ButtonID.ROW3_5).setBounds(26.25, 526.0, 53.75, 35.0);
        surface.getButton(ButtonID.ROW3_6).setBounds(96.75, 526.0, 53.75, 35.0);
        surface.getButton(ButtonID.ROW3_7).setBounds(167.0, 526.0, 53.75, 35.0);
        surface.getButton(ButtonID.ROW3_8).setBounds(237.5, 526.0, 53.75, 35.0);
        surface.getContinuous(ContinuousID.MASTER_KNOB).setBounds(125.0, 337.25, 64.0, 63.0);
        surface.getContinuous(ContinuousID.KNOB1).setBounds(183.5, 226.25, 53.75, 49.25);
        surface.getContinuous(ContinuousID.KNOB2).setBounds(259.0, 226.25, 53.75, 49.25);
        surface.getContinuous(ContinuousID.KNOB3).setBounds(334.75, 226.25, 53.75, 49.25);
        surface.getContinuous(ContinuousID.KNOB4).setBounds(410.25, 226.25, 53.75, 49.25);
        surface.getContinuous(ContinuousID.KNOB5).setBounds(486.0, 226.25, 53.75, 49.25);
        surface.getContinuous(ContinuousID.KNOB6).setBounds(561.5, 226.25, 53.75, 49.25);
        surface.getContinuous(ContinuousID.KNOB7).setBounds(637.0, 226.25, 53.75, 49.25);
        surface.getContinuous(ContinuousID.KNOB8).setBounds(712.75, 226.25, 53.75, 49.25);
        surface.getTextDisplay().getHardwareDisplay().setBounds(182.75, 111.75, 591.75, 64.5);
    }

    private void layoutStudio() {
        MaschineControlSurface surface = (MaschineControlSurface)this.getSurface();
        surface.getButton(ButtonID.PAD1).setBounds(425.5, 590.0, 76.25, 79.0);
        surface.getButton(ButtonID.PAD2).setBounds(516.25, 590.75, 76.25, 79.0);
        surface.getButton(ButtonID.PAD3).setBounds(606.75, 590.75, 76.25, 79.0);
        surface.getButton(ButtonID.PAD4).setBounds(694.75, 590.75, 75.75, 79.0);
        surface.getButton(ButtonID.PAD5).setBounds(425.5, 500.5, 76.25, 79.0);
        surface.getButton(ButtonID.PAD6).setBounds(516.25, 501.0, 76.25, 79.0);
        surface.getButton(ButtonID.PAD7).setBounds(606.75, 501.25, 76.25, 79.0);
        surface.getButton(ButtonID.PAD8).setBounds(694.75, 501.0, 76.25, 79.0);
        surface.getButton(ButtonID.PAD9).setBounds(425.5, 410.75, 76.25, 79.0);
        surface.getButton(ButtonID.PAD10).setBounds(516.25, 411.5, 76.25, 79.0);
        surface.getButton(ButtonID.PAD11).setBounds(606.75, 411.75, 76.25, 79.0);
        surface.getButton(ButtonID.PAD12).setBounds(694.75, 411.0, 76.25, 79.0);
        surface.getButton(ButtonID.PAD13).setBounds(425.5, 321.25, 76.25, 79.0);
        surface.getButton(ButtonID.PAD14).setBounds(516.25, 321.75, 76.25, 79.0);
        surface.getButton(ButtonID.PAD15).setBounds(606.75, 322.25, 76.25, 79.0);
        surface.getButton(ButtonID.PAD16).setBounds(694.75, 321.25, 76.25, 79.0);
        surface.getButton(ButtonID.SHIFT).setBounds(837.25, 637.75, 56.25, 32.0);
        surface.getButton(ButtonID.PLAY).setBounds(24.0, 636.25, 56.75, 32.0);
        surface.getButton(ButtonID.RECORD).setBounds(96.0, 636.25, 56.75, 32.0);
        surface.getButton(ButtonID.LOOP).setBounds(24.75, 604.5, 56.0, 18.0);
        surface.getButton(ButtonID.DELETE).setBounds(165.5, 636.25, 56.75, 32.0);
        surface.getButton(ButtonID.TAP_TEMPO).setBounds(27.75, 318.0, 56.25, 37.0);
        surface.getButton(ButtonID.FLIP).setBounds(236.5, 604.5, 56.0, 18.0);
        surface.getButton(ButtonID.NEW).setBounds(168.5, 318.0, 56.25, 37.5);
        surface.getButton(ButtonID.AUTOMATION).setBounds(94.75, 236.75, 55.75, 32.0);
        surface.getButton(ButtonID.OVERDUB).setBounds(1052.0, 637.75, 56.25, 32.0);
        surface.getButton(ButtonID.REPEAT).setBounds(239.0, 318.0, 56.25, 37.0);
        surface.getButton(ButtonID.FADER_TOUCH_1).setBounds(1037.0, 426.5, 69.5, 22.75);
        surface.getButton(ButtonID.DEVICE).setBounds(94.75, 21.25, 55.75, 23.0);
        surface.getButton(ButtonID.DEVICE_ON_OFF).setBounds(94.75, 107.25, 55.75, 38.5);
        surface.getButton(ButtonID.ADD_TRACK).setBounds(27.75, 236.75, 55.75, 32.0);
        surface.getButton(ButtonID.BROWSE).setBounds(27.75, 107.25, 55.75, 38.5);
        surface.getButton(ButtonID.SCENE1).setBounds(347.25, 321.0, 58.0, 34.0);
        surface.getButton(ButtonID.CLIP).setBounds(347.25, 365.75, 58.0, 34.0);
        surface.getButton(ButtonID.NOTE).setBounds(165.5, 604.5, 56.0, 18.0);
        surface.getButton(ButtonID.TOGGLE_DEVICE).setBounds(347.25, 455.0, 58.0, 34.0);
        surface.getButton(ButtonID.DUPLICATE).setBounds(347.25, 499.5, 58.0, 34.0);
        surface.getButton(ButtonID.SELECT).setBounds(347.25, 544.25, 58.0, 34.0);
        surface.getButton(ButtonID.SOLO).setBounds(347.25, 588.75, 58.0, 34.0);
        surface.getButton(ButtonID.MUTE).setBounds(347.25, 633.5, 58.0, 34.0);
        surface.getButton(ButtonID.ROW1_1).setBounds(347.25, 410.25, 58.0, 34.0);
        surface.getButton(ButtonID.ROW1_4).setBounds(98.25, 318.0, 56.25, 37.0);
        surface.getButton(ButtonID.ARROW_LEFT).setBounds(908.75, 637.75, 56.25, 32.0);
        surface.getButton(ButtonID.ARROW_RIGHT).setBounds(980.5, 637.75, 56.25, 32.0);
        surface.getButton(ButtonID.PAGE_LEFT).setBounds(27.75, 157.75, 55.75, 23.0);
        surface.getButton(ButtonID.PAGE_RIGHT).setBounds(94.75, 157.75, 55.75, 23.0);
        surface.getButton(ButtonID.LAYOUT_ARRANGE).setBounds(27.75, 56.5, 55.75, 38.5);
        surface.getButton(ButtonID.MIXER).setBounds(94.75, 56.5, 55.75, 38.5);
        surface.getButton(ButtonID.DRUM).setBounds(27.75, 21.25, 55.75, 23.0);
        surface.getButton(ButtonID.ROW2_1).setBounds(179.25, 21.25, 66.25, 27.25);
        surface.getButton(ButtonID.ROW2_2).setBounds(254.25, 21.25, 66.25, 27.25);
        surface.getButton(ButtonID.ROW2_3).setBounds(329.25, 21.25, 66.25, 27.25);
        surface.getButton(ButtonID.ROW2_4).setBounds(404.0, 21.25, 66.25, 27.25);
        surface.getButton(ButtonID.ROW2_5).setBounds(479.0, 21.25, 66.25, 27.25);
        surface.getButton(ButtonID.ROW2_6).setBounds(554.0, 21.25, 66.25, 27.25);
        surface.getButton(ButtonID.ROW2_7).setBounds(629.0, 21.25, 66.25, 27.25);
        surface.getButton(ButtonID.ROW2_8).setBounds(704.0, 21.25, 66.25, 27.25);
        surface.getButton(ButtonID.ROW3_1).setBounds(28.5, 438.75, 53.75, 35.0);
        surface.getButton(ButtonID.ROW3_2).setBounds(98.25, 438.75, 53.75, 35.0);
        surface.getButton(ButtonID.ROW3_3).setBounds(167.75, 438.75, 53.75, 35.0);
        surface.getButton(ButtonID.ROW3_4).setBounds(239.75, 438.75, 53.75, 35.0);
        surface.getButton(ButtonID.ROW3_5).setBounds(28.5, 484.75, 53.75, 35.0);
        surface.getButton(ButtonID.ROW3_6).setBounds(98.25, 484.75, 53.75, 35.0);
        surface.getButton(ButtonID.ROW3_7).setBounds(167.75, 484.75, 53.75, 35.0);
        surface.getButton(ButtonID.ROW3_8).setBounds(239.75, 484.75, 53.75, 35.0);
        surface.getButton(ButtonID.METRONOME).setBounds(96.0, 604.5, 56.0, 18.0);
        surface.getButton(ButtonID.UNDO).setBounds(837.25, 366.25, 56.25, 32.0);
        surface.getButton(ButtonID.REDO).setBounds(908.75, 366.25, 56.25, 32.0);
        surface.getButton(ButtonID.QUANTIZE).setBounds(980.5, 366.25, 56.25, 32.0);
        surface.getButton(ButtonID.CONTROL).setBounds(1052.0, 366.25, 56.25, 32.0);
        surface.getButton(ButtonID.COPY).setBounds(837.25, 323.0, 56.25, 32.0);
        surface.getButton(ButtonID.PASTE).setBounds(908.75, 323.0, 56.25, 32.0);
        surface.getButton(ButtonID.NUDGE_MINUS).setBounds(980.5, 323.0, 56.25, 32.0);
        surface.getButton(ButtonID.NUDGE_PLUS).setBounds(1052.0, 323.0, 56.25, 32.0);
        surface.getButton(ButtonID.ROW4_1).setBounds(1033.75, 44.5, 27.5, 22.75);
        surface.getButton(ButtonID.ROW4_2).setBounds(1033.75, 89.5, 27.5, 22.75);
        surface.getButton(ButtonID.ROW4_3).setBounds(1033.75, 134.25, 27.5, 22.75);
        surface.getButton(ButtonID.ROW4_4).setBounds(1033.75, 179.25, 27.5, 22.75);
        surface.getButton(ButtonID.ROW4_5).setBounds(930.75, 44.5, 27.5, 22.75);
        surface.getButton(ButtonID.ROW4_6).setBounds(930.75, 89.5, 27.5, 22.75);
        surface.getButton(ButtonID.ROW4_8).setBounds(930.75, 179.25, 27.5, 22.75);
        surface.getButton(ButtonID.TOGGLE_VU).setBounds(930.75, 134.25, 27.5, 22.75);
        surface.getContinuous(ContinuousID.MASTER_KNOB).setBounds(905.0, 427.0, 143.5, 138.5);
        surface.getContinuous(ContinuousID.KNOB1).setBounds(183.5, 226.25, 53.75, 49.25);
        surface.getContinuous(ContinuousID.KNOB2).setBounds(259.0, 226.25, 53.75, 49.25);
        surface.getContinuous(ContinuousID.KNOB3).setBounds(334.75, 226.25, 53.75, 49.25);
        surface.getContinuous(ContinuousID.KNOB4).setBounds(410.25, 226.25, 53.75, 49.25);
        surface.getContinuous(ContinuousID.KNOB5).setBounds(486.0, 226.25, 53.75, 49.25);
        surface.getContinuous(ContinuousID.KNOB6).setBounds(561.5, 226.25, 53.75, 49.25);
        surface.getContinuous(ContinuousID.KNOB7).setBounds(637.0, 226.25, 53.75, 49.25);
        surface.getContinuous(ContinuousID.KNOB8).setBounds(712.75, 226.25, 53.75, 49.25);
        surface.getContinuous(ContinuousID.MONITOR_KNOB).setBounds(962.0, 217.0, 70.75, 69.0);
        surface.getTextDisplay().getHardwareDisplay().setBounds(182.75, 111.75, 591.75, 64.5);
    }

    private void layoutMk3() {
        MaschineControlSurface surface = (MaschineControlSurface)this.getSurface();
        surface.getButton(ButtonID.PAD1).setBounds(425.5, 652.25, 76.25, 79.0);
        surface.getButton(ButtonID.PAD2).setBounds(516.25, 653.0, 76.25, 79.0);
        surface.getButton(ButtonID.PAD3).setBounds(606.75, 653.0, 76.25, 79.0);
        surface.getButton(ButtonID.PAD4).setBounds(694.75, 653.0, 76.25, 79.0);
        surface.getButton(ButtonID.PAD5).setBounds(425.5, 562.75, 76.25, 79.0);
        surface.getButton(ButtonID.PAD6).setBounds(516.25, 563.25, 76.25, 79.0);
        surface.getButton(ButtonID.PAD7).setBounds(606.75, 563.5, 76.25, 79.0);
        surface.getButton(ButtonID.PAD8).setBounds(694.75, 563.25, 76.25, 79.0);
        surface.getButton(ButtonID.PAD9).setBounds(425.5, 473.0, 76.25, 79.0);
        surface.getButton(ButtonID.PAD10).setBounds(516.25, 473.75, 76.25, 79.0);
        surface.getButton(ButtonID.PAD11).setBounds(606.75, 474.0, 76.25, 79.0);
        surface.getButton(ButtonID.PAD12).setBounds(694.75, 473.25, 76.25, 79.0);
        surface.getButton(ButtonID.PAD13).setBounds(425.5, 383.5, 76.25, 79.0);
        surface.getButton(ButtonID.PAD14).setBounds(516.25, 384.0, 76.25, 79.0);
        surface.getButton(ButtonID.PAD15).setBounds(606.75, 384.5, 76.25, 79.0);
        surface.getButton(ButtonID.PAD16).setBounds(694.75, 383.5, 76.25, 79.0);
        surface.getButton(ButtonID.PLAY).setBounds(24.75, 697.75, 55.75, 32.0);
        surface.getButton(ButtonID.RECORD).setBounds(96.75, 697.75, 55.75, 32.0);
        surface.getButton(ButtonID.STOP).setBounds(166.25, 697.75, 55.75, 32.0);
        surface.getButton(ButtonID.SHIFT).setBounds(236.5, 697.75, 56.0, 32.0);
        surface.getButton(ButtonID.LOOP).setBounds(24.75, 666.75, 56.0, 18.0);
        surface.getButton(ButtonID.DELETE).setBounds(96.75, 666.75, 56.0, 18.0);
        surface.getButton(ButtonID.TAP_TEMPO).setBounds(166.25, 666.75, 56.0, 18.0);
        surface.getButton(ButtonID.FLIP).setBounds(236.5, 666.75, 56.0, 18.0);
        surface.getButton(ButtonID.NEW).setBounds(95.75, 237.25, 55.75, 32.0);
        surface.getButton(ButtonID.AUTOMATION).setBounds(28.75, 237.25, 55.75, 32.0);
        surface.getButton(ButtonID.OVERDUB).setBounds(233.75, 402.0, 58.0, 19.0);
        surface.getButton(ButtonID.REPEAT).setBounds(233.75, 343.75, 58.0, 46.25);
        surface.getButton(ButtonID.F1).setBounds(24.0, 464.75, 58.0, 19.0);
        surface.getButton(ButtonID.F2).setBounds(96.0, 465.5, 57.25, 18.25);
        surface.getButton(ButtonID.F3).setBounds(165.5, 465.5, 57.25, 18.25);
        surface.getButton(ButtonID.F4).setBounds(233.75, 465.5, 57.25, 18.25);
        surface.getButton(ButtonID.FADER_TOUCH_1).setBounds(51.25, 315.0, 69.5, 22.75);
        surface.getButton(ButtonID.VOLUME).setBounds(164.5, 343.75, 58.0, 18.0);
        surface.getButton(ButtonID.SWING).setBounds(164.5, 373.25, 58.0, 18.0);
        surface.getButton(ButtonID.TEMPO_TOUCH).setBounds(164.5, 402.75, 58.0, 18.0);
        surface.getButton(ButtonID.DEVICE).setBounds(95.75, 21.25, 55.75, 23.0);
        surface.getButton(ButtonID.DEVICE_ON_OFF).setBounds(95.75, 107.25, 55.75, 38.5);
        surface.getButton(ButtonID.ADD_TRACK).setBounds(28.75, 193.0, 55.75, 32.0);
        surface.getButton(ButtonID.ADD_EFFECT).setBounds(95.75, 193.0, 55.75, 32.0);
        surface.getButton(ButtonID.BROWSE).setBounds(28.75, 107.25, 55.75, 38.5);
        surface.getButton(ButtonID.ACCENT).setBounds(344.75, 343.75, 58.0, 20.75);
        surface.getButton(ButtonID.SCENE1).setBounds(346.5, 383.25, 58.0, 34.0);
        surface.getButton(ButtonID.CLIP).setBounds(346.5, 427.0, 58.0, 34.0);
        surface.getButton(ButtonID.NOTE).setBounds(346.5, 470.75, 58.0, 34.0);
        surface.getButton(ButtonID.TOGGLE_DEVICE).setBounds(346.5, 514.5, 58.0, 41.25);
        surface.getButton(ButtonID.DUPLICATE).setBounds(347.25, 562.75, 58.0, 34.0);
        surface.getButton(ButtonID.SELECT).setBounds(346.5, 609.25, 58.0, 34.0);
        surface.getButton(ButtonID.SOLO).setBounds(346.5, 653.0, 58.0, 34.0);
        surface.getButton(ButtonID.MUTE).setBounds(346.5, 696.75, 58.0, 34.0);
        surface.getButton(ButtonID.ROW1_1).setBounds(425.5, 343.75, 78.0, 20.75);
        surface.getButton(ButtonID.ROW1_2).setBounds(516.25, 343.75, 78.0, 20.75);
        surface.getButton(ButtonID.ROW1_3).setBounds(606.75, 343.75, 78.0, 20.75);
        surface.getButton(ButtonID.ROW1_4).setBounds(694.75, 343.75, 78.0, 20.75);
        surface.getButton(ButtonID.ARROW_LEFT).setBounds(25.75, 385.0, 22.25, 17.5);
        surface.getButton(ButtonID.ARROW_RIGHT).setBounds(120.25, 385.0, 22.25, 17.5);
        surface.getButton(ButtonID.ARROW_UP).setBounds(76.0, 342.5, 22.25, 17.5);
        surface.getButton(ButtonID.ARROW_DOWN).setBounds(76.0, 431.25, 22.25, 17.5);
        surface.getButton(ButtonID.PAGE_LEFT).setBounds(28.75, 157.75, 55.75, 23.0);
        surface.getButton(ButtonID.PAGE_RIGHT).setBounds(95.75, 157.75, 55.75, 23.0);
        surface.getButton(ButtonID.ROW2_1).setBounds(179.25, 21.25, 66.25, 27.25);
        surface.getButton(ButtonID.ROW2_2).setBounds(254.25, 21.25, 66.25, 27.25);
        surface.getButton(ButtonID.ROW2_3).setBounds(329.25, 21.25, 66.25, 27.25);
        surface.getButton(ButtonID.ROW2_4).setBounds(404.0, 21.25, 66.25, 27.25);
        surface.getButton(ButtonID.ROW2_5).setBounds(479.0, 21.25, 66.25, 27.25);
        surface.getButton(ButtonID.ROW2_6).setBounds(554.0, 21.25, 66.25, 27.25);
        surface.getButton(ButtonID.ROW2_7).setBounds(629.0, 21.25, 66.25, 27.25);
        surface.getButton(ButtonID.ROW2_8).setBounds(704.0, 21.25, 66.25, 27.25);
        surface.getButton(ButtonID.ROW3_1).setBounds(26.25, 564.75, 53.75, 35.0);
        surface.getButton(ButtonID.ROW3_2).setBounds(96.75, 564.75, 53.75, 35.0);
        surface.getButton(ButtonID.ROW3_3).setBounds(167.0, 564.75, 53.75, 35.0);
        surface.getButton(ButtonID.ROW3_4).setBounds(237.5, 564.75, 53.75, 35.0);
        surface.getButton(ButtonID.ROW3_5).setBounds(26.25, 610.75, 53.75, 35.0);
        surface.getButton(ButtonID.ROW3_6).setBounds(96.75, 610.75, 53.75, 35.0);
        surface.getButton(ButtonID.ROW3_7).setBounds(167.0, 610.75, 53.75, 35.0);
        surface.getButton(ButtonID.ROW3_8).setBounds(237.5, 610.75, 53.75, 35.0);
        surface.getButton(ButtonID.LAYOUT_ARRANGE).setBounds(28.75, 56.5, 55.75, 38.5);
        surface.getButton(ButtonID.MIXER).setBounds(95.75, 56.5, 55.75, 38.5);
        surface.getButton(ButtonID.DRUM).setBounds(28.75, 21.25, 55.75, 23.0);
        surface.getContinuous(ContinuousID.KNOB1).setBounds(183.5, 226.25, 53.75, 49.25);
        surface.getContinuous(ContinuousID.KNOB2).setBounds(259.0, 226.25, 53.75, 49.25);
        surface.getContinuous(ContinuousID.KNOB3).setBounds(334.75, 226.25, 53.75, 49.25);
        surface.getContinuous(ContinuousID.KNOB4).setBounds(410.25, 226.25, 53.75, 49.25);
        surface.getContinuous(ContinuousID.KNOB5).setBounds(486.0, 226.25, 53.75, 49.25);
        surface.getContinuous(ContinuousID.KNOB6).setBounds(561.5, 226.25, 53.75, 49.25);
        surface.getContinuous(ContinuousID.KNOB7).setBounds(637.0, 226.25, 53.75, 49.25);
        surface.getContinuous(ContinuousID.KNOB8).setBounds(712.75, 226.25, 53.75, 49.25);
        surface.getContinuous(ContinuousID.MASTER_KNOB).setBounds(53.0, 362.25, 64.0, 63.0);
        surface.getContinuous(ContinuousID.CROSSFADER).setBounds(24.0, 498.75, 268.0, 50.0);
        surface.getTextDisplay().getHardwareDisplay().setBounds(182.75, 111.75, 591.75, 64.5);
    }

    private void layoutMikroMk3() {
        MaschineControlSurface surface = (MaschineControlSurface)this.getSurface();
        surface.getButton(ButtonID.PAD1).setBounds(427.0, 336.0, 76.25, 79.0);
        surface.getButton(ButtonID.PAD2).setBounds(517.75, 336.75, 76.25, 79.0);
        surface.getButton(ButtonID.PAD3).setBounds(608.25, 336.75, 76.25, 79.0);
        surface.getButton(ButtonID.PAD4).setBounds(696.25, 336.75, 76.25, 79.0);
        surface.getButton(ButtonID.PAD5).setBounds(427.0, 246.5, 76.25, 79.0);
        surface.getButton(ButtonID.PAD6).setBounds(517.75, 247.0, 76.25, 79.0);
        surface.getButton(ButtonID.PAD7).setBounds(608.25, 247.25, 76.25, 79.0);
        surface.getButton(ButtonID.PAD8).setBounds(696.25, 247.0, 76.25, 79.0);
        surface.getButton(ButtonID.PAD9).setBounds(427.0, 156.75, 76.25, 79.0);
        surface.getButton(ButtonID.PAD10).setBounds(517.75, 157.5, 76.25, 79.0);
        surface.getButton(ButtonID.PAD11).setBounds(608.25, 157.75, 76.25, 79.0);
        surface.getButton(ButtonID.PAD12).setBounds(696.25, 157.0, 76.25, 79.0);
        surface.getButton(ButtonID.PAD13).setBounds(427.0, 67.25, 76.25, 79.0);
        surface.getButton(ButtonID.PAD14).setBounds(517.75, 67.75, 76.25, 79.0);
        surface.getButton(ButtonID.PAD15).setBounds(608.25, 68.25, 76.25, 79.0);
        surface.getButton(ButtonID.PAD16).setBounds(696.25, 67.25, 76.25, 79.0);
        surface.getButton(ButtonID.PLAY).setBounds(26.25, 381.5, 55.75, 32.0);
        surface.getButton(ButtonID.RECORD).setBounds(98.25, 381.5, 55.75, 32.0);
        surface.getButton(ButtonID.STOP).setBounds(167.75, 381.5, 55.75, 32.0);
        surface.getButton(ButtonID.LOOP).setBounds(26.25, 350.5, 56.0, 18.0);
        surface.getButton(ButtonID.DELETE).setBounds(98.25, 350.5, 56.0, 18.0);
        surface.getButton(ButtonID.TAP_TEMPO).setBounds(167.75, 350.5, 56.0, 18.0);
        surface.getButton(ButtonID.FLIP).setBounds(238.0, 350.5, 56.0, 18.0);
        surface.getButton(ButtonID.NEW).setBounds(26.25, 280.5, 55.75, 32.0);
        surface.getButton(ButtonID.AUTOMATION).setBounds(98.25, 280.5, 55.75, 32.0);
        surface.getButton(ButtonID.OVERDUB).setBounds(167.75, 280.5, 55.75, 32.0);
        surface.getButton(ButtonID.REPEAT).setBounds(238.0, 280.5, 55.75, 32.0);
        surface.getButton(ButtonID.F1).setBounds(26.25, 170.0, 58.0, 19.0);
        surface.getButton(ButtonID.F2).setBounds(98.25, 170.75, 57.25, 18.25);
        surface.getButton(ButtonID.F3).setBounds(167.75, 170.75, 57.25, 18.25);
        surface.getButton(ButtonID.F4).setBounds(238.0, 170.75, 57.25, 18.25);
        surface.getButton(ButtonID.FADER_TOUCH_1).setBounds(74.0, 21.25, 69.5, 22.75);
        surface.getButton(ButtonID.VOLUME).setBounds(166.0, 25.75, 58.0, 19.0);
        surface.getButton(ButtonID.SWING).setBounds(166.0, 56.75, 58.0, 19.0);
        surface.getButton(ButtonID.TEMPO_TOUCH).setBounds(166.0, 85.75, 58.0, 19.0);
        surface.getButton(ButtonID.DEVICE).setBounds(238.0, 25.75, 58.0, 19.0);
        surface.getButton(ButtonID.DEVICE_ON_OFF).setBounds(238.0, 56.75, 58.0, 19.0);
        surface.getButton(ButtonID.ADD_TRACK).setBounds(26.25, 22.75, 25.5, 25.0);
        surface.getButton(ButtonID.ADD_EFFECT).setBounds(26.25, 51.75, 25.5, 25.0);
        surface.getButton(ButtonID.BROWSE).setBounds(26.25, 80.75, 25.5, 25.0);
        surface.getButton(ButtonID.ACCENT).setBounds(346.25, 25.75, 58.0, 20.75);
        surface.getButton(ButtonID.SCENE1).setBounds(348.0, 67.0, 58.0, 34.0);
        surface.getButton(ButtonID.CLIP).setBounds(348.0, 110.75, 58.0, 34.0);
        surface.getButton(ButtonID.NOTE).setBounds(348.0, 154.5, 58.0, 34.0);
        surface.getButton(ButtonID.TOGGLE_DEVICE).setBounds(348.0, 198.25, 58.0, 41.25);
        surface.getButton(ButtonID.DUPLICATE).setBounds(348.75, 246.5, 58.0, 34.0);
        surface.getButton(ButtonID.SELECT).setBounds(348.0, 293.0, 58.0, 34.0);
        surface.getButton(ButtonID.SOLO).setBounds(348.0, 336.75, 58.0, 34.0);
        surface.getButton(ButtonID.MUTE).setBounds(348.0, 380.5, 58.0, 34.0);
        surface.getButton(ButtonID.ROW1_1).setBounds(427.0, 25.75, 78.0, 20.75);
        surface.getButton(ButtonID.ROW1_2).setBounds(517.75, 25.75, 78.0, 20.75);
        surface.getButton(ButtonID.ROW1_3).setBounds(608.25, 25.75, 78.0, 20.75);
        surface.getButton(ButtonID.ROW1_4).setBounds(696.25, 25.75, 78.0, 20.75);
        surface.getContinuous(ContinuousID.MASTER_KNOB).setBounds(75.0, 50.0, 64.0, 63.0);
        surface.getContinuous(ContinuousID.CROSSFADER).setBounds(26.25, 204.0, 268.0, 50.0);
    }

    @Override
    public void startup() {
        MaschineControlSurface surface = (MaschineControlSurface)this.getSurface();
        surface.getModeManager().setActive(Modes.VOLUME);
        surface.getViewManager().setActive(((MaschineConfiguration)this.configuration).getStartupView());
    }

    @Override
    public void flush() {
        super.flush();
        MaschineControlSurface surface = (MaschineControlSurface)this.getSurface();
        TouchstripCommand command = (TouchstripCommand)surface.getContinuous(ContinuousID.CROSSFADER).getCommand();
        if (command != null) {
            command.updateValue();
        }
        if (this.maschine == Maschine.STUDIO) {
            int value;
            IMidiOutput midiOutput = surface.getMidiOutput();
            ITrackBank trackBank = this.model.getTrackBank();
            if (this.encoderManager.isParameterMode()) {
                EncoderMode activeEncoderMode = this.encoderManager.getActiveEncoderMode();
                switch (activeEncoderMode) {
                    case MASTER_VOLUME: {
                        value = this.valueChanger.toMidiValue(this.model.getMasterTrack().getVolume());
                        break;
                    }
                    case MASTER_PANNING: {
                        value = this.valueChanger.toMidiValue(this.model.getMasterTrack().getPan());
                        break;
                    }
                    case SELECTED_TRACK_VOLUME: 
                    case SELECTED_TRACK_PANNING: {
                        Optional trackOptional = trackBank.getSelectedItem();
                        ITrack track = trackOptional.isPresent() ? (ITrack)trackOptional.get() : EmptyTrack.getInstance(((ITrack)trackBank.getItem(0)).getSendBank().getPageSize());
                        value = this.valueChanger.toMidiValue(activeEncoderMode == EncoderMode.SELECTED_TRACK_VOLUME ? track.getVolume() : track.getPan());
                        break;
                    }
                    case CUE_VOLUME: {
                        value = this.valueChanger.toMidiValue(this.model.getProject().getCueVolume());
                        break;
                    }
                    case CUE_MIX: {
                        value = this.valueChanger.toMidiValue(this.model.getProject().getCueMix());
                        break;
                    }
                    case METRONOME_VOLUME: {
                        value = this.valueChanger.toMidiValue(this.model.getTransport().getMetronomeVolume());
                        break;
                    }
                    default: {
                        value = 0;
                        break;
                    }
                }
            } else {
                Optional trackOptional;
                ITrack track = this.encoderManager.isActiveEncoderMode(EncoderMode.SELECTED_TRACK_VOLUME) ? ((trackOptional = trackBank.getSelectedItem()).isPresent() ? (ITrack)trackOptional.get() : EmptyTrack.getInstance(((ITrack)trackBank.getItem(0)).getSendBank().getPageSize())) : this.model.getMasterTrack();
                value = this.valueChanger.toMidiValue(track.getVu());
            }
            midiOutput.sendCC(10, value);
        }
    }

    private boolean isRibbonMode(Set<RibbonMode> modes) {
        return modes.contains((Object)((MaschineConfiguration)this.configuration).getRibbonMode());
    }

    @Override
    protected BindType getTriggerBindType(ButtonID buttonID) {
        return buttonID == ButtonID.ROW2_7 ? BindType.NOTE : BindType.CC;
    }
}

