/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ni.maschine.jam.view;

import de.mossgrabers.controller.ni.maschine.jam.MaschineJamConfiguration;
import de.mossgrabers.controller.ni.maschine.jam.controller.MaschineJamControlSurface;
import de.mossgrabers.controller.ni.maschine.jam.view.IViewNavigation;
import de.mossgrabers.framework.command.trigger.Direction;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.grid.LightInfo;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.IScene;
import de.mossgrabers.framework.daw.data.ISlot;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.ISceneBank;
import de.mossgrabers.framework.daw.data.bank.ITrackBank;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.AbstractSessionView;

public class SessionView
extends AbstractSessionView<MaschineJamControlSurface, MaschineJamConfiguration>
implements IViewNavigation {
    public SessionView(MaschineJamControlSurface surface, IModel model) {
        super("Session", surface, model, 8, 8, true);
        LightInfo isRecording = new LightInfo(6, 6, false);
        LightInfo isRecordingQueued = new LightInfo(6, 0, true);
        LightInfo isPlaying = new LightInfo(30, -1, false);
        LightInfo isPlayingQueued = new LightInfo(30, 30, true);
        LightInfo hasContent = new LightInfo(14, 78, false);
        LightInfo noContent = new LightInfo(0, -1, false);
        LightInfo recArmed = new LightInfo(5, -1, false);
        LightInfo isMuted = new LightInfo(76, -1, false);
        this.setColors(isRecording, isRecordingQueued, isPlaying, isPlayingQueued, hasContent, noContent, recArmed, isMuted);
        this.birdColorHasContent = hasContent;
        this.birdColorSelected = isPlaying;
    }

    @Override
    public void onGridNote(int note, int velocity) {
        if (this.isBirdsEyeActive()) {
            if (velocity == 0) {
                return;
            }
            int index = note - 36;
            int x = index % this.columns;
            int y = this.rows - 1 - index / this.columns;
            this.onGridNoteBirdsEyeView(x, y, 0);
            return;
        }
        super.onGridNote(note, velocity);
    }

    @Override
    public void onButton(ButtonID buttonID, ButtonEvent event, int velocity) {
        boolean flipSession = ((MaschineJamConfiguration)((MaschineJamControlSurface)this.surface).getConfiguration()).isFlipSession();
        boolean isDown = event == ButtonEvent.DOWN;
        switch (buttonID) {
            case ARROW_LEFT: 
            case ARROW_RIGHT: {
                if (!isDown) break;
                if (flipSession) {
                    this.scrollSceneBank(buttonID == ButtonID.ARROW_RIGHT);
                    break;
                }
                this.scrollTrackBank(buttonID == ButtonID.ARROW_RIGHT);
                break;
            }
            case ARROW_UP: 
            case ARROW_DOWN: {
                if (!isDown) break;
                if (flipSession) {
                    this.scrollTrackBank(buttonID == ButtonID.ARROW_DOWN);
                    break;
                }
                this.scrollSceneBank(buttonID == ButtonID.ARROW_DOWN);
                break;
            }
            default: {
                super.onButton(buttonID, event, velocity);
            }
        }
    }

    @Override
    public String getButtonColorID(ButtonID buttonID) {
        int scene = buttonID.ordinal() - ButtonID.SCENE1.ordinal();
        if (scene < 0 || scene >= 8) {
            return "BUTTON_COLOR_OFF";
        }
        ISceneBank sceneBank = this.model.getSceneBank();
        IScene s = (IScene)sceneBank.getItem(scene);
        if (s.doesExist()) {
            return s.isSelected() ? "COLOR_SELECTED_SCENE" : "COLOR_SCENE";
        }
        return "COLOR_SELECTED_OFF";
    }

    @Override
    protected boolean handleButtonCombinations(ITrack track, ISlot slot) {
        if (!track.doesExist()) {
            return true;
        }
        if (this.isButtonCombination(ButtonID.MUTE)) {
            track.stop(((MaschineJamControlSurface)this.surface).isSelectPressed());
            return true;
        }
        if (this.isButtonCombination(ButtonID.SELECT)) {
            slot.select();
            return true;
        }
        if (this.isButtonCombination(ButtonID.GROOVE)) {
            track.returnToArrangement();
            return true;
        }
        return super.handleButtonCombinations(track, slot);
    }

    @Override
    public boolean canScroll(Direction direction) {
        boolean flipSession = ((MaschineJamConfiguration)((MaschineJamControlSurface)this.surface).getConfiguration()).isFlipSession();
        ITrackBank trackBank = this.model.getCurrentTrackBank();
        switch (direction) {
            case LEFT: 
            case RIGHT: {
                if (flipSession) {
                    return direction == Direction.LEFT ? trackBank.getSceneBank().canScrollPageBackwards() : trackBank.getSceneBank().canScrollPageForwards();
                }
                return direction == Direction.LEFT ? trackBank.canScrollPageBackwards() : trackBank.canScrollPageForwards();
            }
            case UP: 
            case DOWN: {
                if (flipSession) {
                    return direction == Direction.UP ? trackBank.canScrollPageBackwards() : trackBank.canScrollPageForwards();
                }
                return direction == Direction.UP ? trackBank.getSceneBank().canScrollPageBackwards() : trackBank.getSceneBank().canScrollPageForwards();
            }
        }
        return false;
    }

    private void scrollTrackBank(boolean isForwards) {
        ITrackBank trackBank = this.model.getCurrentTrackBank();
        if (isForwards) {
            trackBank.scrollForwards();
        } else {
            trackBank.scrollBackwards();
        }
    }

    private void scrollSceneBank(boolean isForwards) {
        ISceneBank sceneBank = this.model.getCurrentTrackBank().getSceneBank();
        if (isForwards) {
            sceneBank.scrollForwards();
        } else {
            sceneBank.scrollBackwards();
        }
    }
}

