/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ni.kontrol.mkii.mode;

import de.mossgrabers.controller.ni.kontrol.mkii.KontrolProtocolConfiguration;
import de.mossgrabers.controller.ni.kontrol.mkii.TrackType;
import de.mossgrabers.controller.ni.kontrol.mkii.controller.KontrolProtocolControlSurface;
import de.mossgrabers.framework.controller.ContinuousID;
import de.mossgrabers.framework.controller.valuechanger.IValueChanger;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.ISceneBank;
import de.mossgrabers.framework.daw.data.bank.ISlotBank;
import de.mossgrabers.framework.mode.track.TrackVolumeMode;
import de.mossgrabers.framework.parameterprovider.special.CombinedParameterProvider;
import de.mossgrabers.framework.parameterprovider.track.PanParameterProvider;
import de.mossgrabers.framework.parameterprovider.track.VolumeParameterProvider;
import java.util.List;
import java.util.Optional;

public class MixerMode
extends TrackVolumeMode<KontrolProtocolControlSurface, KontrolProtocolConfiguration> {
    public MixerMode(KontrolProtocolControlSurface surface, IModel model, List<ContinuousID> controls) {
        super(surface, model, false);
        this.setControls(controls);
        this.setParameterProvider(new CombinedParameterProvider(new VolumeParameterProvider(model), new PanParameterProvider(model)));
    }

    @Override
    public int getKnobValue(int index) {
        ISceneBank sceneBank;
        IValueChanger valueChanger = this.model.getValueChanger();
        if (index >= 80 && index < 88) {
            ITrack track = (ITrack)this.bank.getItem(index - 80);
            return valueChanger.toMidiValue(track.getVolume());
        }
        if (index >= 88 && index < 96) {
            ITrack track = (ITrack)this.bank.getItem(index - 88);
            return valueChanger.toMidiValue(track.getPan());
        }
        Optional selectedTrack = this.bank.getSelectedItem();
        int scrollTracksState = (this.bank.canScrollBackwards() ? 1 : 0) + (this.bank.canScrollForwards() ? 2 : 0);
        int scrollClipsState = 0;
        if (selectedTrack.isPresent()) {
            ISlotBank slotBank = ((ITrack)selectedTrack.get()).getSlotBank();
            scrollClipsState = (slotBank.canScrollBackwards() ? 1 : 0) + (slotBank.canScrollForwards() ? 2 : 0);
        }
        int scrollScenesState = ((sceneBank = this.model.getSceneBank()).canScrollBackwards() ? 1 : 0) + (sceneBank.canScrollForwards() ? 2 : 0);
        KontrolProtocolConfiguration configuration = (KontrolProtocolConfiguration)((KontrolProtocolControlSurface)this.surface).getConfiguration();
        switch (index) {
            case 49: {
                return (this.bank.canScrollPageBackwards() ? 1 : 0) + (this.bank.canScrollPageForwards() ? 2 : 0);
            }
            case 48: {
                if (configuration.isFlipTrackClipNavigation()) {
                    return configuration.isFlipClipSceneNavigation() ? scrollScenesState : scrollClipsState;
                }
                return scrollTracksState;
            }
            case 50: {
                if (configuration.isFlipTrackClipNavigation()) {
                    return scrollTracksState;
                }
                return configuration.isFlipClipSceneNavigation() ? scrollScenesState : scrollClipsState;
            }
        }
        return 0;
    }

    @Override
    public void updateDisplay() {
        IValueChanger valueChanger = this.model.getValueChanger();
        boolean hasSolo = this.model.getProject().hasSolo();
        int[] vuData = new int[16];
        for (int i = 0; i < 8; ++i) {
            ITrack track = (ITrack)this.bank.getItem(i);
            ((KontrolProtocolControlSurface)this.surface).sendKontrolTrackSysEx(64, TrackType.toTrackType(track.getType()), i);
            ((KontrolProtocolControlSurface)this.surface).sendKontrolTrackSysEx(66, track.isSelected() ? 1 : 0, i);
            ((KontrolProtocolControlSurface)this.surface).sendKontrolTrackSysEx(69, track.isRecArm() ? 1 : 0, i);
            ((KontrolProtocolControlSurface)this.surface).sendKontrolTrackSysEx(70, 0, i, track.getVolumeStr(8));
            ((KontrolProtocolControlSurface)this.surface).sendKontrolTrackSysEx(71, 0, i, track.getPanStr(8));
            ((KontrolProtocolControlSurface)this.surface).sendKontrolTrackSysEx(72, 0, i, this.formatTrackName(track));
            int j = 2 * i;
            vuData[j] = valueChanger.toMidiValue(track.getVuLeft());
            vuData[j + 1] = valueChanger.toMidiValue(track.getVuRight());
            ((KontrolProtocolControlSurface)this.surface).sendKontrolTrackSysEx(67, track.isMute() ? 1 : 0, i);
            ((KontrolProtocolControlSurface)this.surface).sendKontrolTrackSysEx(68, track.isSolo() ? 1 : 0, i);
            ((KontrolProtocolControlSurface)this.surface).sendKontrolTrackSysEx(74, !track.isSolo() && hasSolo ? 1 : 0, i);
            Optional selectedTrack = this.bank.getSelectedItem();
            ((KontrolProtocolControlSurface)this.surface).sendCommand(104, selectedTrack.isPresent() ? TrackType.toTrackType(((ITrack)selectedTrack.get()).getType()) : 0);
            ((KontrolProtocolControlSurface)this.surface).sendCommand(105, selectedTrack.isPresent() && !((ITrack)selectedTrack.get()).isSolo() && hasSolo ? 1 : 0);
        }
        ((KontrolProtocolControlSurface)this.surface).sendKontrolTrackSysEx(73, 2, 0, vuData);
    }

    private String formatTrackName(ITrack track) {
        if (!track.doesExist()) {
            return "";
        }
        String name = track.getName();
        if (((KontrolProtocolControlSurface)this.surface).getProtocolVersion() == 1) {
            return name;
        }
        return "Track " + (track.getPosition() + 1) + "\n\n" + name;
    }
}

