/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ni.kontrol.mkii;

import de.mossgrabers.controller.ni.kontrol.mkii.KontrolProtocolConfiguration;
import de.mossgrabers.controller.ni.kontrol.mkii.command.trigger.ModeSwitcherCommand;
import de.mossgrabers.controller.ni.kontrol.mkii.command.trigger.StartClipOrSceneCommand;
import de.mossgrabers.controller.ni.kontrol.mkii.controller.KontrolProtocolColorManager;
import de.mossgrabers.controller.ni.kontrol.mkii.controller.KontrolProtocolControlSurface;
import de.mossgrabers.controller.ni.kontrol.mkii.mode.MixerMode;
import de.mossgrabers.controller.ni.kontrol.mkii.mode.ParamsMode;
import de.mossgrabers.controller.ni.kontrol.mkii.mode.SendMode;
import de.mossgrabers.controller.ni.kontrol.mkii.view.ControlView;
import de.mossgrabers.framework.command.core.NopCommand;
import de.mossgrabers.framework.command.core.TriggerCommand;
import de.mossgrabers.framework.command.trigger.application.RedoCommand;
import de.mossgrabers.framework.command.trigger.application.UndoCommand;
import de.mossgrabers.framework.command.trigger.clip.NewCommand;
import de.mossgrabers.framework.command.trigger.clip.QuantizeCommand;
import de.mossgrabers.framework.command.trigger.clip.StartSceneCommand;
import de.mossgrabers.framework.command.trigger.clip.StopClipCommand;
import de.mossgrabers.framework.command.trigger.mode.ModeMultiSelectCommand;
import de.mossgrabers.framework.command.trigger.track.MuteCommand;
import de.mossgrabers.framework.command.trigger.track.SoloCommand;
import de.mossgrabers.framework.command.trigger.transport.ConfiguredRecordCommand;
import de.mossgrabers.framework.command.trigger.transport.MetronomeCommand;
import de.mossgrabers.framework.command.trigger.transport.PlayCommand;
import de.mossgrabers.framework.command.trigger.transport.StopCommand;
import de.mossgrabers.framework.command.trigger.transport.TapTempoCommand;
import de.mossgrabers.framework.command.trigger.transport.ToggleLoopCommand;
import de.mossgrabers.framework.command.trigger.transport.WriteArrangerAutomationCommand;
import de.mossgrabers.framework.configuration.ISettingsUI;
import de.mossgrabers.framework.controller.AbstractControllerSetup;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.ContinuousID;
import de.mossgrabers.framework.controller.ISetupFactory;
import de.mossgrabers.framework.controller.hardware.BindType;
import de.mossgrabers.framework.controller.hardware.IHwRelativeKnob;
import de.mossgrabers.framework.controller.valuechanger.TwosComplementValueChanger;
import de.mossgrabers.framework.daw.IClipLauncherNavigator;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.ITransport;
import de.mossgrabers.framework.daw.ModelSetup;
import de.mossgrabers.framework.daw.constants.DeviceID;
import de.mossgrabers.framework.daw.data.ISpecificDevice;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.ITrackBank;
import de.mossgrabers.framework.daw.midi.IMidiAccess;
import de.mossgrabers.framework.daw.midi.IMidiInput;
import de.mossgrabers.framework.daw.midi.IMidiOutput;
import de.mossgrabers.framework.featuregroup.IMode;
import de.mossgrabers.framework.featuregroup.ModeManager;
import de.mossgrabers.framework.featuregroup.ViewManager;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.scale.Scales;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.utils.FrameworkException;
import de.mossgrabers.framework.utils.OperatingSystem;
import de.mossgrabers.framework.view.Views;
import java.util.List;
import java.util.Optional;
import java.util.function.IntSupplier;

public class KontrolProtocolControllerSetup
extends AbstractControllerSetup<KontrolProtocolControlSurface, KontrolProtocolConfiguration> {
    private final int version;
    private String kompleteInstance = "";

    public KontrolProtocolControllerSetup(IHost host, ISetupFactory factory, ISettingsUI globalSettings, ISettingsUI documentSettings, int version) {
        super(factory, host, globalSettings, documentSettings);
        this.version = version;
        this.colorManager = new KontrolProtocolColorManager();
        this.valueChanger = new TwosComplementValueChanger(1024, 4);
        this.configuration = new KontrolProtocolConfiguration(host, this.valueChanger, factory.getArpeggiatorModes(), version);
    }

    @Override
    public void init() {
        if (OperatingSystem.get() == OperatingSystem.LINUX && this.version < 3) {
            throw new FrameworkException("Komplete Kontrol MkII is not supported on Linux since there is no Native Instruments DAW Integration Host.");
        }
        super.init();
    }

    @Override
    public void flush() {
        KontrolProtocolControlSurface surface = (KontrolProtocolControlSurface)this.getSurface();
        if (!surface.isConnectedToNIHIA()) {
            return;
        }
        String kompleteInstanceNew = this.getKompleteInstance();
        if (!this.kompleteInstance.equals(kompleteInstanceNew)) {
            this.kompleteInstance = kompleteInstanceNew;
            surface.sendKontrolTrackSysEx(65, 0, 0, kompleteInstanceNew);
        }
        super.flush();
    }

    @Override
    protected void createScales() {
        this.scales = new Scales(this.valueChanger, 0, 128, 128, 1);
        this.scales.setChromatic(true);
    }

    @Override
    protected void createSurface() {
        IMidiAccess midiAccess = this.factory.createMidiAccess();
        IMidiOutput output = midiAccess.createOutput();
        IMidiInput pianoInput = midiAccess.createInput(1, "Keyboard", "8?????", "9?????", "A?????", "B?????", "D?????", "E?????");
        KontrolProtocolControlSurface surface = new KontrolProtocolControlSurface(this.host, this.colorManager, (KontrolProtocolConfiguration)this.configuration, output, midiAccess.createInput(null, new String[0]), this.version);
        this.surfaces.add(surface);
        surface.addPianoKeyboard(49, pianoInput, true);
    }

    @Override
    protected void createModel() {
        ModelSetup ms = new ModelSetup();
        ms.enableMainDrumDevice(false);
        ms.enableDevice(DeviceID.NI_KOMPLETE);
        ms.setHasFullFlatTrackList(true);
        ms.setNumFilterColumnEntries(0);
        ms.setNumResults(0);
        ms.setNumDeviceLayers(0);
        ms.setNumDrumPadLayers(0);
        ms.setNumMarkers(0);
        ms.setWantsClipLauncherNavigator(true);
        this.model = this.factory.createModel(this.configuration, this.colorManager, this.valueChanger, this.scales, ms);
        this.model.getTrackBank().setIndication(true);
    }

    @Override
    protected void createViews() {
        KontrolProtocolControlSurface surface = (KontrolProtocolControlSurface)this.getSurface();
        ViewManager viewManager = surface.getViewManager();
        viewManager.register(Views.CONTROL, new ControlView(surface, this.model));
    }

    @Override
    protected void createModes() {
        KontrolProtocolControlSurface surface = (KontrolProtocolControlSurface)this.getSurface();
        ModeManager modeManager = surface.getModeManager();
        List<ContinuousID> controls = ContinuousID.createSequentialList(ContinuousID.KNOB1, 8);
        controls.addAll(ContinuousID.createSequentialList(ContinuousID.FADER1, 8));
        modeManager.register(Modes.VOLUME, new MixerMode(surface, this.model, controls));
        modeManager.register(Modes.SEND, new SendMode(surface, this.model, controls));
        modeManager.register(Modes.DEVICE_PARAMS, new ParamsMode(surface, this.model, controls));
    }

    @Override
    protected void createObservers() {
        super.createObservers();
        ((KontrolProtocolConfiguration)this.configuration).registerDeactivatedItemsHandler(this.model);
    }

    @Override
    protected void registerTriggerCommands() {
        KontrolProtocolControlSurface surface = (KontrolProtocolControlSurface)this.getSurface();
        ITransport t = this.model.getTransport();
        ModeMultiSelectCommand modeSwitchCommand = new ModeMultiSelectCommand(this.model, surface, Modes.VOLUME, Modes.SEND, Modes.DEVICE_PARAMS);
        ModeSwitcherCommand restartCommand = new ModeSwitcherCommand(new NewCommand(this.model, surface), modeSwitchCommand, KontrolProtocolConfiguration.SwitchButton.RESTART, (KontrolProtocolConfiguration)this.configuration);
        ModeSwitcherCommand redoCommand = new ModeSwitcherCommand(new RedoCommand(this.model, surface), modeSwitchCommand, KontrolProtocolConfiguration.SwitchButton.REDO, (KontrolProtocolConfiguration)this.configuration);
        ModeSwitcherCommand quantizeCommand = new ModeSwitcherCommand(new QuantizeCommand(this.model, surface), modeSwitchCommand, KontrolProtocolConfiguration.SwitchButton.QUANTIZE, (KontrolProtocolConfiguration)this.configuration);
        ModeSwitcherCommand loopCommand = new ModeSwitcherCommand(new ToggleLoopCommand(this.model, surface), modeSwitchCommand, KontrolProtocolConfiguration.SwitchButton.LOOP, (KontrolProtocolConfiguration)this.configuration);
        ModeSwitcherCommand stopCommand = new ModeSwitcherCommand(new StopCommand(this.model, surface), modeSwitchCommand, KontrolProtocolConfiguration.SwitchButton.STOP, (KontrolProtocolConfiguration)this.configuration);
        ModeSwitcherCommand autoCommand = new ModeSwitcherCommand(new WriteArrangerAutomationCommand(this.model, surface), modeSwitchCommand, KontrolProtocolConfiguration.SwitchButton.AUTO, (KontrolProtocolConfiguration)this.configuration);
        ModeSwitcherCommand tempoCommand = new ModeSwitcherCommand(new TapTempoCommand(this.model, surface), modeSwitchCommand, KontrolProtocolConfiguration.SwitchButton.TEMPO, (KontrolProtocolConfiguration)this.configuration);
        ModeSwitcherCommand metronomeCommand = new ModeSwitcherCommand(new MetronomeCommand(this.model, surface, false), modeSwitchCommand, KontrolProtocolConfiguration.SwitchButton.METRONOME, (KontrolProtocolConfiguration)this.configuration);
        this.addButton(ButtonID.PLAY, "Play", new PlayCommand(this.model, surface), 15, 16, t::isPlaying);
        this.addButton(ButtonID.NEW, "Restart", (TriggerCommand)restartCommand, 15, 17);
        ConfiguredRecordCommand recordCommand = new ConfiguredRecordCommand(false, this.model, surface);
        this.addButton(ButtonID.RECORD, "Record", recordCommand, 15, 18, recordCommand::isLit);
        ConfiguredRecordCommand shiftedRecordCommand = new ConfiguredRecordCommand(true, this.model, surface);
        this.addButton(ButtonID.REC_ARM, "Shift+\nRecord", shiftedRecordCommand, 15, 19, shiftedRecordCommand::isLit);
        this.addButton(ButtonID.STOP, "Stop", (TriggerCommand)stopCommand, 15, 20, () -> !t.isPlaying());
        this.addButton(ButtonID.LOOP, "Loop", (TriggerCommand)loopCommand, 15, 22, t::isLoop);
        this.addButton(ButtonID.METRONOME, "Metronome", (TriggerCommand)metronomeCommand, 15, 23, t::isMetronomeOn);
        this.addButton(ButtonID.TAP_TEMPO, "Tempo", (TriggerCommand)tempoCommand, 15, 24);
        this.addButton(ButtonID.UNDO, "Undo", new UndoCommand(this.model, surface), 15, 32, () -> this.model.getApplication().canUndo());
        this.addButton(ButtonID.REDO, "Redo", (TriggerCommand)redoCommand, 15, 33, () -> this.model.getApplication().canRedo());
        this.addButton(ButtonID.QUANTIZE, "Quantize", (TriggerCommand)quantizeCommand, 15, 34, () -> true);
        this.addButton(ButtonID.AUTOMATION, "Automation", (TriggerCommand)autoCommand, 15, 35, t::isWritingArrangerAutomation);
        this.addButton(ButtonID.DELETE, "Modes", modeSwitchCommand, 15, 21, () -> true);
        this.addButton(ButtonID.CLIP, "Start Clip", (TriggerCommand)new StartClipOrSceneCommand(this.model, surface), 15, 96);
        this.addButton(ButtonID.STOP_CLIP, "Stop Clip", new StopClipCommand(this.model, surface), 15, 97);
        this.addButton(ButtonID.SCENE1, "Play Scene", new StartSceneCommand(this.model, surface), 15, 98);
        this.addButton(ButtonID.MUTE, "Mute", new MuteCommand(this.model, surface), 15, 102, () -> {
            ITrackBank tb = this.model.getCurrentTrackBank();
            Optional selectedTrack = tb.getSelectedItem();
            return selectedTrack.isPresent() && ((ITrack)selectedTrack.get()).isMute() ? 1 : 0;
        });
        this.addButton(ButtonID.SOLO, "Solo", new SoloCommand(this.model, surface), 15, 103, () -> {
            ITrackBank tb = this.model.getCurrentTrackBank();
            Optional selectedTrack = tb.getSelectedItem();
            return selectedTrack.isPresent() && ((ITrack)selectedTrack.get()).isSolo() ? 1 : 0;
        });
        this.addButtons(surface, 0, 8, ButtonID.ROW_SELECT_1, "Select", (event, index) -> {
            if (event == ButtonEvent.DOWN) {
                ((ITrack)this.model.getCurrentTrackBank().getItem(index)).selectOrExpandGroup();
            }
        }, 15, 66, index -> ((ITrack)this.model.getTrackBank().getItem(index)).isSelected() ? 1 : 0, new String[0]);
        this.addButtons(surface, 0, 8, ButtonID.ROW1_1, "Mute", (event, index) -> {
            if (event == ButtonEvent.DOWN) {
                ((ITrack)this.model.getTrackBank().getItem(index)).toggleMute();
            }
        }, 15, 67, index -> ((ITrack)this.model.getTrackBank().getItem(index)).isMute() ? 1 : 0, new String[0]);
        this.addButtons(surface, 0, 8, ButtonID.ROW2_1, "Solo", (event, index) -> {
            if (event == ButtonEvent.DOWN) {
                ((ITrack)this.model.getTrackBank().getItem(index)).toggleSolo();
            }
        }, 15, 68, index -> ((ITrack)this.model.getTrackBank().getItem(index)).isSolo() ? 1 : 0, new String[0]);
        this.addButtons(surface, 0, 8, ButtonID.ROW3_1, "Arm", (event, index) -> {
            if (event == ButtonEvent.DOWN) {
                ((ITrack)this.model.getTrackBank().getItem(index)).toggleRecArm();
            }
        }, 15, 69, index -> ((ITrack)this.model.getTrackBank().getItem(index)).isRecArm() ? 1 : 0, new String[0]);
        this.addButton(ButtonID.F1, "", (TriggerCommand)NopCommand.INSTANCE, 15, 104);
        this.addButton(ButtonID.F2, "", (TriggerCommand)NopCommand.INSTANCE, 15, 105);
    }

    @Override
    protected void registerContinuousCommands() {
        KontrolProtocolControlSurface surface = (KontrolProtocolControlSurface)this.getSurface();
        this.addFader(ContinuousID.HELLO, "Hello", surface::handshakeSuccess, BindType.CC, 15, 1);
        this.addButton(surface, ButtonID.BANK_LEFT, "Left", (ButtonEvent event, int velocity) -> this.moveTrackBank(event, true), 15, 49, 127, () -> this.getKnobValue(49), new String[0]);
        this.addButton(surface, ButtonID.BANK_RIGHT, "Right", (ButtonEvent event, int velocity) -> this.moveTrackBank(event, false), 15, 49, 1, () -> this.getKnobValue(49), new String[0]);
        this.addButton(surface, ButtonID.MOVE_TRACK_LEFT, "Enc Left", (ButtonEvent event, int velocity) -> this.moveTrack(event, true), 15, 48, 127, () -> this.getKnobValue(48), new String[0]);
        this.addButton(surface, ButtonID.MOVE_TRACK_RIGHT, "Enc Right", (ButtonEvent event, int velocity) -> this.moveTrack(event, false), 15, 48, 1, () -> this.getKnobValue(48), new String[0]);
        this.addButton(surface, ButtonID.ARROW_UP, "Enc Up", (ButtonEvent event, int velocity) -> this.moveClips(event, true), 15, 50, 127, () -> this.getKnobValue(50), new String[0]);
        this.addButton(surface, ButtonID.ARROW_DOWN, "Enc Down", (ButtonEvent event, int velocity) -> this.moveClips(event, false), 15, 50, 1, () -> this.getKnobValue(50), new String[0]);
        this.addRelativeKnob(ContinuousID.MOVE_TRANSPORT, "Move Transport", (int value) -> this.changeTransportPosition(value, 0), BindType.CC, 15, 52);
        this.addRelativeKnob(ContinuousID.MOVE_LOOP, "Move Loop", this::changeLoopPosition, BindType.CC, 15, 53);
        this.addRelativeKnob(ContinuousID.NAVIGATE_VOLUME, "Navigate Volume", (int value) -> this.changeTransportPosition(value, 1), BindType.CC, 15, 100);
        this.addRelativeKnob(ContinuousID.NAVIGATE_PAN, "Navigate Pan", (int value) -> this.changeTransportPosition(value, 2), BindType.CC, 15, 101);
        for (int i = 0; i < 8; ++i) {
            int knobMidi1 = 80 + i;
            IHwRelativeKnob knob1 = this.addRelativeKnob(ContinuousID.get(ContinuousID.KNOB1, i), "Knob " + (i + 1), null, BindType.CC, 15, knobMidi1);
            knob1.addOutput(() -> this.getKnobValue(knobMidi1), value -> surface.setTrigger(15, knobMidi1, value));
            knob1.setIndexInGroup(i);
            int knobMidi2 = 88 + i;
            IHwRelativeKnob knob2 = this.addRelativeKnob(ContinuousID.get(ContinuousID.FADER1, i), "Fader " + (i + 1), null, BindType.CC, 15, knobMidi2);
            knob2.addOutput(() -> this.getKnobValue(knobMidi2), value -> surface.setTrigger(15, knobMidi2, value));
            knob2.setIndexInGroup(i);
        }
    }

    @Override
    protected void addButton(KontrolProtocolControlSurface surface, ButtonID buttonID, String label, TriggerCommand command, int midiChannel, int midiControl, IntSupplier supplier, String ... colorIds) {
        super.addButton(surface, buttonID, label, (ButtonEvent event, int velocity) -> {
            if (event == ButtonEvent.LONG) {
                return;
            }
            command.execute(ButtonEvent.DOWN, velocity);
            command.execute(ButtonEvent.UP, velocity);
        }, midiChannel, midiControl, supplier, colorIds);
    }

    @Override
    protected void layoutControls() {
        KontrolProtocolControlSurface surface = (KontrolProtocolControlSurface)this.getSurface();
        surface.getButton(ButtonID.PLAY).setBounds(20.25, 149.5, 31.75, 22.75);
        surface.getButton(ButtonID.NEW).setBounds(20.25, 179.5, 31.75, 22.75);
        surface.getButton(ButtonID.RECORD).setBounds(63.0, 149.25, 31.75, 22.75);
        surface.getButton(ButtonID.REC_ARM).setBounds(63.0, 179.25, 31.75, 22.75);
        surface.getButton(ButtonID.STOP).setBounds(105.75, 149.5, 31.75, 22.75);
        surface.getButton(ButtonID.LOOP).setBounds(20.25, 120.5, 31.75, 22.75);
        surface.getButton(ButtonID.METRONOME).setBounds(63.0, 120.5, 31.75, 22.75);
        surface.getButton(ButtonID.TAP_TEMPO).setBounds(105.75, 120.5, 31.75, 22.75);
        surface.getButton(ButtonID.UNDO).setBounds(21.0, 43.0, 31.75, 22.75);
        surface.getButton(ButtonID.REDO).setBounds(21.0, 75.5, 31.75, 22.75);
        surface.getButton(ButtonID.QUANTIZE).setBounds(63.75, 43.0, 31.75, 22.75);
        surface.getButton(ButtonID.AUTOMATION).setBounds(106.5, 43.0, 31.75, 22.75);
        surface.getButton(ButtonID.DELETE).setBounds(225.75, 120.5, 31.75, 22.75);
        surface.getButton(ButtonID.MUTE).setBounds(194.0, 43.0, 24.25, 22.75);
        surface.getButton(ButtonID.SOLO).setBounds(226.25, 43.0, 24.25, 22.75);
        surface.getButton(ButtonID.ROW_SELECT_1).setBounds(276.0, 43.0, 39.75, 16.0);
        surface.getButton(ButtonID.ROW_SELECT_2).setBounds(330.5, 43.0, 39.75, 16.0);
        surface.getButton(ButtonID.ROW_SELECT_3).setBounds(385.0, 43.0, 39.75, 16.0);
        surface.getButton(ButtonID.ROW_SELECT_4).setBounds(439.5, 43.0, 39.75, 16.0);
        surface.getButton(ButtonID.ROW_SELECT_5).setBounds(494.0, 43.0, 39.75, 16.0);
        surface.getButton(ButtonID.ROW_SELECT_6).setBounds(548.5, 43.0, 39.75, 16.0);
        surface.getButton(ButtonID.ROW_SELECT_7).setBounds(602.75, 43.0, 39.75, 16.0);
        surface.getButton(ButtonID.ROW_SELECT_8).setBounds(657.25, 43.0, 39.75, 16.0);
        surface.getButton(ButtonID.ROW1_1).setBounds(276.0, 67.5, 39.75, 16.0);
        surface.getButton(ButtonID.ROW1_2).setBounds(330.5, 67.5, 39.75, 16.0);
        surface.getButton(ButtonID.ROW1_3).setBounds(385.0, 67.5, 39.75, 16.0);
        surface.getButton(ButtonID.ROW1_4).setBounds(439.5, 67.5, 39.75, 16.0);
        surface.getButton(ButtonID.ROW1_5).setBounds(494.0, 67.5, 39.75, 16.0);
        surface.getButton(ButtonID.ROW1_6).setBounds(548.5, 67.5, 39.75, 16.0);
        surface.getButton(ButtonID.ROW1_7).setBounds(602.75, 67.5, 39.75, 16.0);
        surface.getButton(ButtonID.ROW1_8).setBounds(657.25, 67.5, 39.75, 16.0);
        surface.getButton(ButtonID.ROW2_1).setBounds(276.0, 92.25, 39.75, 16.0);
        surface.getButton(ButtonID.ROW2_2).setBounds(330.5, 92.25, 39.75, 16.0);
        surface.getButton(ButtonID.ROW2_3).setBounds(385.0, 92.25, 39.75, 16.0);
        surface.getButton(ButtonID.ROW2_4).setBounds(439.5, 92.25, 39.75, 16.0);
        surface.getButton(ButtonID.ROW2_5).setBounds(494.0, 92.25, 39.75, 16.0);
        surface.getButton(ButtonID.ROW2_6).setBounds(548.5, 92.25, 39.75, 16.0);
        surface.getButton(ButtonID.ROW2_7).setBounds(602.75, 92.25, 39.75, 16.0);
        surface.getButton(ButtonID.ROW2_8).setBounds(657.25, 92.25, 39.75, 16.0);
        surface.getButton(ButtonID.ROW3_1).setBounds(276.0, 116.75, 39.75, 16.0);
        surface.getButton(ButtonID.ROW3_2).setBounds(330.5, 116.75, 39.75, 16.0);
        surface.getButton(ButtonID.ROW3_3).setBounds(385.0, 116.75, 39.75, 16.0);
        surface.getButton(ButtonID.ROW3_4).setBounds(439.5, 116.75, 39.75, 16.0);
        surface.getButton(ButtonID.ROW3_5).setBounds(494.0, 116.75, 39.75, 16.0);
        surface.getButton(ButtonID.ROW3_6).setBounds(548.5, 116.75, 39.75, 16.0);
        surface.getButton(ButtonID.ROW3_7).setBounds(602.75, 116.75, 39.75, 16.0);
        surface.getButton(ButtonID.ROW3_8).setBounds(657.25, 116.75, 39.75, 16.0);
        surface.getButton(ButtonID.BANK_LEFT).setBounds(188.5, 78.5, 29.75, 20.5);
        surface.getButton(ButtonID.BANK_RIGHT).setBounds(225.75, 78.5, 29.75, 20.5);
        surface.getButton(ButtonID.MOVE_TRACK_LEFT).setBounds(705.5, 188.5, 29.75, 20.5);
        surface.getButton(ButtonID.MOVE_TRACK_RIGHT).setBounds(751.0, 188.5, 29.75, 20.5);
        surface.getButton(ButtonID.ARROW_UP).setBounds(727.25, 163.25, 29.75, 20.5);
        surface.getButton(ButtonID.ARROW_DOWN).setBounds(727.25, 211.5, 29.75, 20.5);
        surface.getButton(ButtonID.CLIP).setBounds(512.75, 0.75, 31.75, 22.75);
        surface.getButton(ButtonID.STOP_CLIP).setBounds(550.25, 0.75, 31.75, 22.75);
        surface.getButton(ButtonID.SCENE1).setBounds(588.0, 0.75, 31.75, 22.75);
        surface.getButton(ButtonID.F1).setBounds(637.5, 0.75, 31.75, 22.75);
        surface.getButton(ButtonID.F2).setBounds(675.25, 0.75, 31.75, 22.75);
        surface.getContinuous(ContinuousID.MOVE_TRANSPORT).setBounds(713.5, 40.75, 27.75, 29.75);
        surface.getContinuous(ContinuousID.MOVE_LOOP).setBounds(752.25, 40.75, 27.75, 29.75);
        surface.getContinuous(ContinuousID.NAVIGATE_VOLUME).setBounds(713.5, 80.75, 27.75, 29.75);
        surface.getContinuous(ContinuousID.NAVIGATE_PAN).setBounds(752.25, 80.75, 27.75, 29.75);
        surface.getContinuous(ContinuousID.KNOB1).setBounds(284.0, 143.25, 28.0, 29.25);
        surface.getContinuous(ContinuousID.FADER1).setBounds(284.0, 178.5, 28.0, 29.25);
        surface.getContinuous(ContinuousID.KNOB2).setBounds(338.25, 143.25, 28.0, 29.25);
        surface.getContinuous(ContinuousID.FADER2).setBounds(338.25, 178.5, 28.0, 29.25);
        surface.getContinuous(ContinuousID.KNOB3).setBounds(392.5, 143.25, 28.0, 29.25);
        surface.getContinuous(ContinuousID.FADER3).setBounds(392.75, 178.5, 28.0, 29.25);
        surface.getContinuous(ContinuousID.KNOB4).setBounds(446.75, 143.25, 28.0, 29.25);
        surface.getContinuous(ContinuousID.FADER4).setBounds(447.0, 178.5, 28.0, 29.25);
        surface.getContinuous(ContinuousID.KNOB5).setBounds(501.25, 143.25, 28.0, 29.25);
        surface.getContinuous(ContinuousID.FADER5).setBounds(501.25, 178.5, 28.0, 29.25);
        surface.getContinuous(ContinuousID.KNOB6).setBounds(555.5, 143.25, 28.0, 29.25);
        surface.getContinuous(ContinuousID.FADER6).setBounds(555.75, 178.5, 28.0, 29.25);
        surface.getContinuous(ContinuousID.KNOB7).setBounds(609.75, 143.25, 28.0, 29.25);
        surface.getContinuous(ContinuousID.FADER7).setBounds(610.0, 178.5, 28.0, 29.25);
        surface.getContinuous(ContinuousID.KNOB8).setBounds(664.25, 143.25, 28.0, 29.25);
        surface.getContinuous(ContinuousID.FADER8).setBounds(664.25, 178.5, 28.0, 29.25);
        surface.getContinuous(ContinuousID.MODULATION_WHEEL).setBounds(100.0, 222.75, 22.75, 67.5);
        surface.getContinuous(ContinuousID.PITCHBEND_WHEEL).setBounds(65.5, 222.75, 22.75, 67.5);
        surface.getPianoKeyboard().setBounds(162.75, 218.5, 531.5, 79.75);
    }

    @Override
    public void startup() {
        KontrolProtocolControlSurface surface = (KontrolProtocolControlSurface)this.getSurface();
        surface.getViewManager().setActive(Views.CONTROL);
        surface.getModeManager().setActive(Modes.VOLUME);
        surface.initHandshake();
    }

    private String getKompleteInstance() {
        ISpecificDevice kkDevice = this.model.getSpecificDevice(DeviceID.NI_KOMPLETE);
        return kkDevice.doesExist() ? kkDevice.getID() : "";
    }

    private void moveTrack(ButtonEvent event, boolean isLeft) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        KontrolProtocolControlSurface surface = (KontrolProtocolControlSurface)this.getSurface();
        if (surface.getModeManager().isActive(new Modes[]{Modes.VOLUME})) {
            IClipLauncherNavigator clipLauncherNavigator = this.model.getClipLauncherNavigator();
            if (((KontrolProtocolConfiguration)this.configuration).isFlipTrackClipNavigation()) {
                if (((KontrolProtocolConfiguration)this.configuration).isFlipClipSceneNavigation()) {
                    clipLauncherNavigator.navigateScenes(isLeft);
                } else {
                    clipLauncherNavigator.navigateClips(isLeft);
                }
            } else {
                clipLauncherNavigator.navigateTracks(isLeft);
            }
            return;
        }
        IMode activeMode = (IMode)surface.getModeManager().getActive();
        if (activeMode == null) {
            return;
        }
        if (isLeft) {
            activeMode.selectPreviousItem();
        } else {
            activeMode.selectNextItem();
        }
    }

    private void moveClips(ButtonEvent event, boolean isLeft) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        KontrolProtocolControlSurface surface = (KontrolProtocolControlSurface)this.getSurface();
        ModeManager modeManager = surface.getModeManager();
        switch ((Modes)((Object)modeManager.getActiveID())) {
            case VOLUME: {
                IClipLauncherNavigator clipLauncherNavigator = this.model.getClipLauncherNavigator();
                if (((KontrolProtocolConfiguration)this.configuration).isFlipTrackClipNavigation()) {
                    clipLauncherNavigator.navigateTracks(isLeft);
                    return;
                }
                if (((KontrolProtocolConfiguration)this.configuration).isFlipClipSceneNavigation()) {
                    clipLauncherNavigator.navigateScenes(isLeft);
                    break;
                }
                clipLauncherNavigator.navigateClips(isLeft);
                break;
            }
            case DEVICE_PARAMS: {
                Object f = modeManager.getActive();
                if (!(f instanceof ParamsMode)) break;
                ParamsMode paramMode = (ParamsMode)f;
                paramMode.switchProvider(isLeft);
                break;
            }
            default: {
                this.moveTrackBank(event, isLeft);
            }
        }
    }

    private void changeTransportPosition(int value, int mode) {
        boolean increase = mode == 0 ? value == 1 : value <= 63;
        this.model.getTransport().changePosition(increase, false);
    }

    private void changeLoopPosition(int value) {
        this.model.getTransport().changePosition(value <= 63, true);
    }

    private void moveTrackBank(ButtonEvent event, boolean isLeft) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        IMode activeMode = (IMode)((KontrolProtocolControlSurface)this.getSurface()).getModeManager().getActive();
        if (activeMode == null) {
            return;
        }
        if (isLeft) {
            activeMode.selectPreviousItemPage();
        } else {
            activeMode.selectNextItemPage();
        }
    }

    private int getKnobValue(int continuousMidiControl) {
        IMode mode = (IMode)((KontrolProtocolControlSurface)this.getSurface()).getModeManager().getActive();
        return mode == null ? 0 : Math.max(0, mode.getKnobValue(continuousMidiControl));
    }
}

