/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.melbourne.rotocontrol.mode;

import de.mossgrabers.controller.melbourne.rotocontrol.controller.RotoControlColorManager;
import de.mossgrabers.controller.melbourne.rotocontrol.controller.RotoControlControlSurface;
import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.controller.hardware.IHwButton;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ICursorDevice;
import de.mossgrabers.framework.daw.data.IDevice;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.IDeviceBank;
import de.mossgrabers.framework.daw.data.bank.ISendBank;
import de.mossgrabers.framework.daw.data.bank.ITrackBank;
import de.mossgrabers.framework.utils.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Optional;

public class RotoControlDisplay {
    private static final MessageDigest SHA1_DIGEST;
    public static final int MAX_NAME_LENGTH = 13;
    private int trackCountCache = -1;
    private int sendsCountCache = -1;
    private int firstTrackPositionCache = -1;
    private final String[] trackNameCache = new String[8];
    private final int[] trackColorCache = new int[8];
    private int deviceCountCache = -1;
    private int firstDevicePositionCache = -1;
    private int selectedDeviceIndexCache = -1;
    private final String[] deviceNameCache = new String[8];
    private final RotoControlControlSurface surface;
    private final IModel model;

    public RotoControlDisplay(RotoControlControlSurface surface, IModel model) {
        this.surface = surface;
        this.model = model;
    }

    public void flushTrackDisplay() {
        this.trackCountCache = -1;
        this.sendsCountCache = -1;
        this.firstTrackPositionCache = -1;
        this.selectedDeviceIndexCache = -1;
        Arrays.fill(this.trackNameCache, null);
        Arrays.fill(this.trackColorCache, -1);
    }

    public void updateTrackDisplay() {
        ITrackBank trackBank = this.model.getCurrentTrackBank();
        int trackCount = Math.min(64, trackBank.getItemCount());
        boolean updateAll = false;
        if (trackCount != this.trackCountCache) {
            updateAll = true;
            this.trackCountCache = trackCount;
            this.surface.sendSysex(10, 4, trackCount);
        }
        int sendsCount = 0;
        Optional selectedTrack = this.model.getTrackBank().getSelectedItem();
        if (selectedTrack.isPresent()) {
            ISendBank sendBank = ((ITrack)selectedTrack.get()).getSendBank();
            sendsCount = Math.min(127, sendBank.getItemCount());
        }
        if (updateAll || sendsCount != this.sendsCountCache) {
            this.sendsCountCache = sendsCount;
            this.surface.sendSysex(12, 3, sendsCount);
        }
        int firstTrackPosition = trackBank.getScrollPosition();
        if (updateAll || firstTrackPosition != this.firstTrackPositionCache) {
            this.firstTrackPositionCache = firstTrackPosition;
            this.surface.sendSysex(10, 5, firstTrackPosition);
        }
        int hasBeenUpdated = 0;
        for (int i = 0; i < 8; ++i) {
            ITrack track = (ITrack)trackBank.getItem(i);
            if (!track.doesExist()) continue;
            String name = RotoControlDisplay.create13ByteTextArray(track.getName());
            int colorIndex = ColorEx.getClosestColorIndex(track.getColor(), RotoControlColorManager.DEFAULT_PALETTE);
            if (!updateAll && name.equals(this.trackNameCache[i]) && this.trackColorCache[i] == colorIndex) continue;
            this.trackNameCache[i] = name;
            this.trackColorCache[i] = colorIndex;
            this.sendTrackDetails(track.getPosition(), name, colorIndex);
            ++hasBeenUpdated;
        }
        if (updateAll && trackCount < 8 && trackCount != hasBeenUpdated) {
            this.trackCountCache = -1;
        }
        if (updateAll) {
            for (IHwButton button : this.surface.getButtons().values()) {
                button.getLight().forceFlush();
            }
        }
        if (hasBeenUpdated > 0) {
            this.surface.sendSysex(10, 8);
        }
    }

    public void flushDeviceDisplay() {
        this.deviceCountCache = -1;
        this.firstDevicePositionCache = -1;
        Arrays.fill(this.deviceNameCache, null);
    }

    public void updateDeviceDisplay() {
        int firstDevicePosition;
        ICursorDevice cursorDevice = this.model.getCursorDevice();
        IDeviceBank deviceBank = cursorDevice.getDeviceBank();
        int deviceCount = Math.min(127, deviceBank.getItemCount());
        if (deviceCount != this.deviceCountCache) {
            this.deviceCountCache = deviceCount;
            this.surface.sendSysex(11, 2, deviceCount);
        }
        if ((firstDevicePosition = deviceBank.getScrollPosition()) != this.firstDevicePositionCache) {
            this.firstDevicePositionCache = firstDevicePosition;
            this.surface.sendSysex(11, 3, firstDevicePosition);
        }
        try {
            boolean hasBeenUpdated = false;
            for (int i = 0; i < 8; ++i) {
                IDevice device = (IDevice)deviceBank.getItem(i);
                String name = RotoControlDisplay.create13ByteTextArray(device.getName());
                if (name.equals(this.deviceNameCache[i])) continue;
                this.deviceNameCache[i] = name;
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                out.write(device.getPosition());
                byte[] pluginHash = RotoControlDisplay.createHash(name, 8);
                out.write(pluginHash);
                out.write(device.isEnabled() ? 1 : 0);
                out.write(name.getBytes());
                this.surface.sendSysex(11, 5, out.toByteArray());
                hasBeenUpdated = true;
            }
            if (hasBeenUpdated) {
                this.surface.sendSysex(11, 6);
            }
        }
        catch (IOException hasBeenUpdated) {
            // empty catch block
        }
        int selectedDeviceIndex = cursorDevice.getIndex();
        if (selectedDeviceIndex != this.selectedDeviceIndexCache && selectedDeviceIndex >= 0) {
            this.selectedDeviceIndexCache = selectedDeviceIndex;
            this.surface.sendSysex(11, 8, selectedDeviceIndex);
        }
    }

    public static byte[] createHash(String input, int hashSize) {
        byte[] fullHash = SHA1_DIGEST.digest(input.getBytes(StandardCharsets.UTF_8));
        byte[] pluginDigest = new byte[hashSize];
        for (int i = 0; i < hashSize; ++i) {
            pluginDigest[i] = (byte)(fullHash[i] & 0x7F);
        }
        return pluginDigest;
    }

    public static String create13ByteTextArray(String text) {
        return StringUtils.pad(StringUtils.shortenAndFixASCII(text, 12), 13, '\u0000');
    }

    private void sendTrackDetails(int position, String name, int colorIndex) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            out.write(position);
            out.write(name.getBytes());
            out.write(colorIndex);
            this.surface.sendSysex(10, 7, out.toByteArray());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static {
        try {
            SHA1_DIGEST = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex);
        }
    }
}

