/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.melbourne.rotocontrol.mode;

import de.mossgrabers.controller.melbourne.rotocontrol.RotoControlConfiguration;
import de.mossgrabers.controller.melbourne.rotocontrol.controller.RotoControlControlSurface;
import de.mossgrabers.controller.melbourne.rotocontrol.mode.ReplaceableParameterProvider;
import de.mossgrabers.controller.melbourne.rotocontrol.mode.RotoControlDisplay;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ICursorDevice;
import de.mossgrabers.framework.daw.data.IParameterList;
import de.mossgrabers.framework.featuregroup.AbstractParameterMode;
import de.mossgrabers.framework.parameter.IParameter;
import de.mossgrabers.framework.utils.ButtonEvent;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.List;

public class RotoControlDeviceParameterMode
extends AbstractParameterMode<RotoControlControlSurface, RotoControlConfiguration, IParameter> {
    private boolean learnMode;
    private int lastMappedParameterIndex = -1;
    private final ReplaceableParameterProvider parameterProvider;
    private final ICursorDevice cursorDevice = this.model.getCursorDevice();

    public RotoControlDeviceParameterMode(RotoControlControlSurface surface, IModel model) {
        super("Parameters", surface, model, true);
        this.cursorDevice.getParameterBank().addValueObserver((page, index) -> this.handleMapping(page, index));
        this.parameterProvider = new ReplaceableParameterProvider(16);
    }

    @Override
    public void onKnobValue(int index, int value) {
        IParameter item = this.parameterProvider.get(index);
        if (item != null && item.doesExist()) {
            item.setValue(value);
        }
    }

    @Override
    public int getKnobValue(int index) {
        if (!this.cursorDevice.doesExist()) {
            return -1;
        }
        IParameter item = this.parameterProvider.get(index);
        return item != null && item.doesExist() ? item.getValue() : -1;
    }

    @Override
    public void onButton(int row, int index, ButtonEvent event) {
        if (event == ButtonEvent.LONG) {
            return;
        }
        IParameter item = this.parameterProvider.get(8 + index);
        if (item != null && item.doesExist()) {
            item.setValue(event == ButtonEvent.DOWN ? this.model.getValueChanger().getUpperBound() - 1 : 0);
        }
    }

    @Override
    public int getButtonColor(ButtonID buttonID) {
        int index = buttonID.ordinal() - ButtonID.ROW1_1.ordinal();
        IParameter item = this.parameterProvider.get(8 + index);
        return item != null && item.doesExist() && item.getValue() > 0 ? 127 : 0;
    }

    public void setParamLearn(boolean activateLearn) {
        this.learnMode = activateLearn;
    }

    public void bind(int paramIndex, int posInPage, boolean isSwitch) {
        IParameterList parameterList = this.cursorDevice.getParameterList();
        IHost host = ((RotoControlControlSurface)this.surface).getHost();
        int maxNumberOfParameters = parameterList.getMaxNumberOfParameters();
        if (paramIndex >= maxNumberOfParameters) {
            host.error("Parameter at index " + paramIndex + " is higher than the number of supported parameters (" + maxNumberOfParameters + ").");
            return;
        }
        int index = isSwitch ? 8 + posInPage : posInPage;
        List<IParameter> parameters = parameterList.getParameters();
        int numParams = parameters.size();
        if (paramIndex < numParams) {
            IParameter parameter = parameters.get(paramIndex);
            this.parameterProvider.set(index, parameter);
            host.scheduleTask(() -> this.sendLearnParam(parameter, paramIndex), 100L);
        } else {
            host.error("Parameter at index " + paramIndex + " is out of parameter range (" + numParams + ").");
        }
    }

    private void handleMapping(int page, int index) {
        if (!this.learnMode) {
            return;
        }
        IParameterList parameterList = this.cursorDevice.getParameterList();
        int paramIndex = page * this.cursorDevice.getParameterBank().getPageSize() + index;
        IHost host = ((RotoControlControlSurface)this.surface).getHost();
        int maxNumberOfParameters = parameterList.getMaxNumberOfParameters();
        if (paramIndex >= maxNumberOfParameters) {
            host.error("Parameter at index " + paramIndex + " is higher than the number of supported parameters (" + maxNumberOfParameters + ").");
            return;
        }
        List<IParameter> parameters = parameterList.getParameters();
        int numParams = parameters.size();
        if (paramIndex >= numParams) {
            host.error("Parameter at index " + paramIndex + " is out of parameter range (" + numParams + ").");
            return;
        }
        IParameter param = parameters.get(paramIndex);
        if (param.doesExist()) {
            this.sendLearnParam(param, paramIndex);
        }
    }

    private void sendLearnParam(IParameter param, int paramIndex) {
        byte[] hash;
        if (this.learnMode && this.lastMappedParameterIndex == paramIndex) {
            return;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write((byte)(paramIndex >> 7 & 0x7F));
        out.write((byte)(paramIndex & 0x7F));
        for (byte b : hash = RotoControlDisplay.createHash(param.getName(), 6)) {
            out.write((byte)(b & 0x7F));
        }
        out.write(0);
        int numberOfSteps = param.getNumberOfSteps();
        out.write((byte)(numberOfSteps >= 2 && numberOfSteps <= 24 ? numberOfSteps : 0));
        int paramValue = param.getValue();
        out.write((byte)(paramValue >> 7 & 0x7F));
        out.write((byte)(paramValue & 0x7F));
        try {
            out.write(RotoControlDisplay.create13ByteTextArray(param.getName()).getBytes());
            if (numberOfSteps >= 2 && numberOfSteps <= 16) {
                for (int i = 0; i < numberOfSteps; ++i) {
                    out.write(RotoControlDisplay.create13ByteTextArray("Option " + (i + 1)).getBytes());
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ((RotoControlControlSurface)this.surface).sendSysex(11, 10, out.toByteArray());
        this.lastMappedParameterIndex = paramIndex;
    }
}

