/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.melbourne.rotocontrol.controller;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Optional;

public class RotoControlMessage {
    public static final int GENERAL = 10;
    public static final int PLUGIN = 11;
    public static final int MIX = 12;
    public static final int TR_DAW_STARTED = 1;
    public static final int RCV_PING_DAW = 2;
    public static final int TR_DAW_PING_RESPONSE = 3;
    public static final int TR_NUM_TRACKS = 4;
    public static final int TR_FIRST_TRACK = 5;
    public static final int RCV_SET_FIRST_TRACK = 6;
    public static final int TR_TRACK_DETAILS = 7;
    public static final int TR_TRACK_DETAILS_END = 8;
    public static final int RCV_SELECT_TRACK = 9;
    public static final int RCV_REQUEST_TRANSPORT_STATUS = 10;
    public static final int TR_TRANSPORT_STATUS = 11;
    public static final int RCV_SET_PLUGIN_MODE = 1;
    public static final int TR_NUM_PLUGINS = 2;
    public static final int TR_FIRST_PLUGIN = 3;
    public static final int RCV_SET_FIRST_PLUGIN = 4;
    public static final int TR_PLUGIN_DETAILS = 5;
    public static final int TR_PLUGIN_DETAILS_END = 6;
    public static final int RCV_ROTO_SELECT_PLUGIN = 7;
    public static final int TR_DAW_SELECT_PLUGIN = 8;
    public static final int RCV_SET_PLUGIN_LEARN = 9;
    public static final int TR_LEARN_PARAM = 10;
    public static final int RCV_PARAM_LEARNED = 11;
    public static final int RCV_SET_PLUGIN_ENABLE = 12;
    public static final int RCV_SET_PLUGIN_LOCK = 13;
    public static final int TR_UNMAP_CONTROL = 14;
    public static final int RCV_SET_MIX_ALL_TRACKS_MODE = 1;
    public static final int RCV_SET_MIX_TRACK_MODE = 2;
    public static final int TR_NUM_SENDS = 3;
    public static final int TR_DAW_SELECT_TRACK = 4;
    public static final int RCV_SET_ALL_TRACKS_MODE = 5;
    private static final byte[] MESSAGE_HEADER = new byte[]{-16, 0, 34, 3, 2};
    private final int messageType;
    private final int messageSubType;
    private final int[] content;
    private final byte[] byteContent;

    public RotoControlMessage(int messageType, int messageSubType, int[] content) {
        this.messageType = messageType;
        this.messageSubType = messageSubType;
        this.content = content;
        this.byteContent = null;
    }

    public RotoControlMessage(int messageType, int messageSubType, byte[] byteContent) {
        this.messageType = messageType;
        this.messageSubType = messageSubType;
        this.content = null;
        this.byteContent = byteContent;
    }

    public int getType() {
        return this.messageType;
    }

    public int getSubType() {
        return this.messageSubType;
    }

    public int[] getContent() {
        return this.content;
    }

    public static Optional<RotoControlMessage> getMessageContent(int[] data) {
        int contentLength = data.length - MESSAGE_HEADER.length - 1;
        if (contentLength <= 0 || data[data.length - 1] != 247) {
            return Optional.empty();
        }
        for (int i = 0; i < MESSAGE_HEADER.length; ++i) {
            if (MESSAGE_HEADER[i] == (byte)data[i]) continue;
            return Optional.empty();
        }
        int[] result = new int[contentLength - 2];
        System.arraycopy(data, MESSAGE_HEADER.length + 2, result, 0, contentLength - 2);
        return Optional.of(new RotoControlMessage(data[MESSAGE_HEADER.length], data[MESSAGE_HEADER.length + 1], result));
    }

    public byte[] createMessage() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            out.write(MESSAGE_HEADER);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        out.write(this.messageType);
        out.write(this.messageSubType);
        if (this.content != null) {
            for (int val : this.content) {
                out.write(val);
            }
        } else if (this.byteContent != null) {
            for (byte val : this.byteContent) {
                out.write(val);
            }
        }
        out.write(247);
        return out.toByteArray();
    }
}

