/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.melbourne.rotocontrol.controller;

import de.mossgrabers.controller.melbourne.rotocontrol.RotoControlConfiguration;
import de.mossgrabers.controller.melbourne.rotocontrol.controller.IMessageCallback;
import de.mossgrabers.controller.melbourne.rotocontrol.controller.RotoControlMessage;
import de.mossgrabers.controller.melbourne.rotocontrol.mode.RotoControlDisplay;
import de.mossgrabers.framework.command.core.ContinuousCommand;
import de.mossgrabers.framework.controller.AbstractControlSurface;
import de.mossgrabers.framework.controller.color.ColorManager;
import de.mossgrabers.framework.controller.hardware.BindType;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.midi.IMidiInput;
import de.mossgrabers.framework.daw.midi.IMidiOutput;
import de.mossgrabers.framework.utils.StringUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class RotoControlControlSurface
extends AbstractControlSurface<RotoControlConfiguration> {
    public static final int KNOB_FIRST = 12;
    public static final int BUTTON_FIRST = 20;
    public static final int BUTTON_PLAY = 28;
    public static final int BUTTON_STOP = 29;
    public static final int BUTTON_REC = 30;
    public static final int BUTTON_SESSION_REC = 31;
    public static final int BUTTON_LOOP = 32;
    public static final int BUTTON_PUNCH_IN = 33;
    public static final int BUTTON_PUNCH_OUT = 34;
    public static final int BUTTON_AUTOMATION = 35;
    public static final int BUTTON_REWIND = 36;
    public static final int BUTTON_FORWARD = 37;
    private static final Set<Integer> TRANSPORT_LED_BUTTONS = new HashSet<Integer>();
    private final IMessageCallback callback;
    private final int[] lastCCValues = new int[32];
    private final Map<Integer, ContinuousCommand> commands = new HashMap<Integer, ContinuousCommand>();
    private final RotoControlDisplay rotoDisplay;

    public RotoControlControlSurface(IHost host, ColorManager colorManager, RotoControlConfiguration configuration, IMidiOutput output, IMidiInput input, IMessageCallback callback, IModel model) {
        super(host, configuration, colorManager, output, input, null, 100.0, 100.0);
        this.callback = callback;
        this.rotoDisplay = new RotoControlDisplay(this, model);
        this.input.setSysexCallback(this::handleSysEx);
    }

    public void setHiResContinuousCommand(int cc, ContinuousCommand command) {
        this.commands.put(cc, command);
    }

    public void sendStartupCommand() {
        this.sendSysex(10, 1);
    }

    public void flushRotoDisplay() {
        this.rotoDisplay.flushTrackDisplay();
        this.rotoDisplay.flushDeviceDisplay();
    }

    @Override
    protected void flushHardware() {
        this.rotoDisplay.updateTrackDisplay();
        this.rotoDisplay.updateDeviceDisplay();
        super.flushHardware();
    }

    @Override
    protected void handleCC(int channel, int data1, int data2) {
        ContinuousCommand command;
        if (channel != 15) {
            return;
        }
        if (data1 < 32) {
            if (this.commands.get(data1) != null) {
                this.lastCCValues[data1] = data2;
                return;
            }
        } else if (data1 < 64 && (command = this.commands.get(data1 - 32)) != null) {
            command.execute(this.lastCCValues[data1 - 32] * 128 + data2);
            return;
        }
        super.handleCC(channel, data1, data2);
    }

    private void handleSysEx(String dataStr) {
        int[] data = StringUtils.fromHexStr(dataStr);
        Optional<RotoControlMessage> messageOpt = RotoControlMessage.getMessageContent(data);
        if (messageOpt.isEmpty()) {
            this.host.error("Unknown Roto Control System Exclusive message: " + dataStr);
            return;
        }
        this.callback.handle(messageOpt.get());
    }

    @Override
    public void setTrigger(BindType bindType, int channel, int cc, int value) {
        if (TRANSPORT_LED_BUTTONS.contains(cc)) {
            this.callback.updateTransportStatus();
        } else {
            super.setTrigger(bindType, channel, cc, value);
        }
    }

    public void sendSysex(int messageType, int messageSubType) {
        this.sendSysex(messageType, messageSubType, (int[])null);
    }

    public void sendSysex(int messageType, int messageSubType, int value) {
        this.sendSysex(messageType, messageSubType, new int[]{value});
    }

    public void sendSysex(int messageType, int messageSubType, int[] content) {
        this.output.sendSysex(new RotoControlMessage(messageType, messageSubType, content).createMessage());
    }

    public void sendSysex(int messageType, int messageSubType, byte[] content) {
        this.output.sendSysex(new RotoControlMessage(messageType, messageSubType, content).createMessage());
    }

    static {
        TRANSPORT_LED_BUTTONS.add(28);
        TRANSPORT_LED_BUTTONS.add(29);
        TRANSPORT_LED_BUTTONS.add(30);
        TRANSPORT_LED_BUTTONS.add(31);
        TRANSPORT_LED_BUTTONS.add(32);
        TRANSPORT_LED_BUTTONS.add(33);
        TRANSPORT_LED_BUTTONS.add(34);
        TRANSPORT_LED_BUTTONS.add(35);
    }
}

