/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.melbourne.rotocontrol;

import de.mossgrabers.controller.melbourne.rotocontrol.RotoControlConfiguration;
import de.mossgrabers.controller.melbourne.rotocontrol.command.trigger.transport.RotoControlPunchInCommand;
import de.mossgrabers.controller.melbourne.rotocontrol.command.trigger.transport.RotoControlPunchOutCommand;
import de.mossgrabers.controller.melbourne.rotocontrol.controller.IMessageCallback;
import de.mossgrabers.controller.melbourne.rotocontrol.controller.RotoControlColorManager;
import de.mossgrabers.controller.melbourne.rotocontrol.controller.RotoControlControlSurface;
import de.mossgrabers.controller.melbourne.rotocontrol.controller.RotoControlMessage;
import de.mossgrabers.controller.melbourne.rotocontrol.mode.RotoControlDeviceParameterMode;
import de.mossgrabers.controller.melbourne.rotocontrol.mode.RotoControlDisplay;
import de.mossgrabers.framework.command.continuous.KnobRowModeCommand;
import de.mossgrabers.framework.command.core.TriggerCommand;
import de.mossgrabers.framework.command.trigger.clip.NewCommand;
import de.mossgrabers.framework.command.trigger.mode.ButtonRowModeCommand;
import de.mossgrabers.framework.command.trigger.transport.AutomationCommand;
import de.mossgrabers.framework.command.trigger.transport.PlayCommand;
import de.mossgrabers.framework.command.trigger.transport.RecordCommand;
import de.mossgrabers.framework.command.trigger.transport.StopCommand;
import de.mossgrabers.framework.command.trigger.transport.ToggleLoopCommand;
import de.mossgrabers.framework.command.trigger.transport.WindCommand;
import de.mossgrabers.framework.configuration.ISettingsUI;
import de.mossgrabers.framework.controller.AbstractControllerSetup;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.ISetupFactory;
import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.controller.valuechanger.TwosComplementValueChanger;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.ITransport;
import de.mossgrabers.framework.daw.ModelSetup;
import de.mossgrabers.framework.daw.data.IDevice;
import de.mossgrabers.framework.daw.data.ISend;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.IParameterBank;
import de.mossgrabers.framework.daw.data.bank.ISendBank;
import de.mossgrabers.framework.daw.data.bank.ITrackBank;
import de.mossgrabers.framework.daw.midi.IMidiAccess;
import de.mossgrabers.framework.daw.midi.IMidiInput;
import de.mossgrabers.framework.daw.midi.IMidiOutput;
import de.mossgrabers.framework.featuregroup.IMode;
import de.mossgrabers.framework.featuregroup.ModeManager;
import de.mossgrabers.framework.featuregroup.ViewManager;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.mode.track.TrackMode;
import de.mossgrabers.framework.mode.track.TrackMuteMode;
import de.mossgrabers.framework.mode.track.TrackPanMode;
import de.mossgrabers.framework.mode.track.TrackRecArmMode;
import de.mossgrabers.framework.mode.track.TrackSendMode;
import de.mossgrabers.framework.mode.track.TrackSoloMode;
import de.mossgrabers.framework.mode.track.TrackVolumeMode;
import de.mossgrabers.framework.parameter.IParameter;
import de.mossgrabers.framework.view.DummyView;
import de.mossgrabers.framework.view.Views;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Optional;

public class RotoControlControllerSetup
extends AbstractControllerSetup<RotoControlControlSurface, RotoControlConfiguration>
implements IMessageCallback {
    private static final int NUM_PARAM_PAGES = 16;
    private static final int MIDI_CC_CHANNEL = 15;
    private final boolean[] noteBlocker = new boolean[64];
    private final int[] knobValues = new int[8];
    private final long[] knobValuesEditTime = new long[8];
    private final ModeManager buttonModeManager = new ModeManager();
    private final ModelSetup modelSetup = new ModelSetup();
    private Modes activeButtonMode = Modes.MUTE;

    public RotoControlControllerSetup(IHost host, ISetupFactory factory, ISettingsUI globalSettings, ISettingsUI documentSettings) {
        super(factory, host, globalSettings, documentSettings);
        Arrays.fill(this.knobValuesEditTime, System.currentTimeMillis());
        Arrays.fill(this.noteBlocker, false);
        this.colorManager = new RotoControlColorManager();
        this.valueChanger = new TwosComplementValueChanger(16384, 1);
        this.configuration = new RotoControlConfiguration(host, this.valueChanger, factory.getArpeggiatorModes());
    }

    @Override
    protected void createModel() {
        this.modelSetup.setHasFullFlatTrackList(true);
        this.modelSetup.setNumFxTracks(8);
        this.modelSetup.setNumSends(8);
        this.modelSetup.setNumParamPages(16);
        this.modelSetup.setNumListParams(128);
        this.modelSetup.setNumScenes(16);
        this.modelSetup.setNumDeviceLayers(0);
        this.modelSetup.setNumDrumPadLayers(0);
        this.modelSetup.enableMainDrumDevice(false);
        this.model = this.factory.createModel(this.configuration, this.colorManager, this.valueChanger, this.scales, this.modelSetup);
    }

    @Override
    protected void createSurface() {
        IMidiAccess midiAccess = this.factory.createMidiAccess();
        IMidiOutput output = midiAccess.createOutput();
        IMidiInput input = midiAccess.createInput(null, new String[0]);
        this.surfaces.add(new RotoControlControlSurface(this.host, this.colorManager, (RotoControlConfiguration)this.configuration, output, input, this, this.model));
    }

    @Override
    protected void createModes() {
        RotoControlControlSurface surface = (RotoControlControlSurface)this.getSurface();
        ModeManager modeManager = surface.getModeManager();
        modeManager.register(Modes.TRACK, new TrackMode(surface, this.model, true));
        modeManager.register(Modes.VOLUME, new TrackVolumeMode(surface, this.model, true));
        modeManager.register(Modes.PAN, new TrackPanMode(surface, this.model, true));
        for (int i = 0; i < this.modelSetup.getNumSends(); ++i) {
            modeManager.register(Modes.get(Modes.SEND1, i), new TrackSendMode(i, surface, this.model, true));
        }
        RotoControlDeviceParameterMode deviceParamsMode = new RotoControlDeviceParameterMode(surface, this.model);
        modeManager.register(Modes.DEVICE_PARAMS, deviceParamsMode);
        this.buttonModeManager.register(Modes.DEVICE_PARAMS, deviceParamsMode);
        this.buttonModeManager.register(Modes.MUTE, new TrackMuteMode<RotoControlControlSurface, RotoControlConfiguration>(this, surface, this.model){

            @Override
            public int getButtonColor(ButtonID buttonID) {
                int index = buttonID.ordinal() - ButtonID.ROW1_1.ordinal();
                ITrack item = (ITrack)this.model.getCurrentTrackBank().getItem(index);
                return !item.doesExist() || item.isMute() ? 127 : 0;
            }
        });
        this.buttonModeManager.register(Modes.SOLO, new TrackSoloMode<RotoControlControlSurface, RotoControlConfiguration>(this, surface, this.model){

            @Override
            public int getButtonColor(ButtonID buttonID) {
                int index = buttonID.ordinal() - ButtonID.ROW1_1.ordinal();
                return ((ITrack)this.model.getCurrentTrackBank().getItem(index)).isSolo() ? 127 : 0;
            }
        });
        this.buttonModeManager.register(Modes.REC_ARM, new TrackRecArmMode<RotoControlControlSurface, RotoControlConfiguration>(this, surface, this.model){

            @Override
            public int getButtonColor(ButtonID buttonID) {
                int index = buttonID.ordinal() - ButtonID.ROW1_1.ordinal();
                return ((ITrack)this.model.getCurrentTrackBank().getItem(index)).isRecArm() ? 127 : 0;
            }
        });
        modeManager.addChangeListener((previousID, activeID) -> {
            if (activeID == Modes.DEVICE_PARAMS) {
                this.activeButtonMode = (Modes)((Object)((Object)this.buttonModeManager.getActiveID()));
                this.buttonModeManager.setActive(Modes.DEVICE_PARAMS);
            } else {
                this.buttonModeManager.setActive(this.activeButtonMode);
            }
        });
    }

    @Override
    protected void createViews() {
        RotoControlControlSurface surface = (RotoControlControlSurface)this.getSurface();
        ViewManager viewManager = surface.getViewManager();
        viewManager.register(Views.CONTROL, new DummyView("Control", surface, this.model));
    }

    @Override
    protected void createObservers() {
        super.createObservers();
        ((RotoControlConfiguration)this.configuration).registerDeactivatedItemsHandler(this.model);
        this.model.getTrackBank().addSelectionObserver((index, isSelected) -> this.handleTrackChange(isSelected));
        ITrackBank effectTrackBank = this.model.getEffectTrackBank();
        if (effectTrackBank != null) {
            effectTrackBank.addSelectionObserver((index, isSelected) -> this.handleTrackChange(isSelected));
        }
        ((RotoControlControlSurface)this.getSurface()).getModeManager().addChangeListener((previousID, activeID) -> this.updateIndication((Modes)activeID));
    }

    @Override
    protected void registerTriggerCommands() {
        RotoControlControlSurface surface = (RotoControlControlSurface)this.getSurface();
        ITransport t = this.model.getTransport();
        this.addButton(ButtonID.PLAY, "PLAY", new PlayCommand(this.model, surface), 15, 28, () -> t.isPlaying() ? 127 : 0);
        this.addButton(ButtonID.STOP, "STOP", new StopCommand(this.model, surface), 15, 29, () -> !t.isPlaying() ? 127 : 0);
        this.addButton(ButtonID.RECORD, "REC", new RecordCommand(this.model, surface), 15, 30, () -> t.isRecording() ? 127 : 0);
        this.addButton(ButtonID.NEW, "NEW", new NewCommand(this.model, surface), 15, 31);
        this.addButton(ButtonID.LOOP, "LOOP", new ToggleLoopCommand(this.model, surface), 15, 32, () -> t.isLoop() ? 127 : 0);
        this.addButton(ButtonID.PUNCH_IN, "PUNCH IN", (TriggerCommand)new RotoControlPunchInCommand(this.model, surface), 15, 33, () -> t.isPunchInEnabled() ? 127 : 0);
        this.addButton(ButtonID.PUNCH_OUT, "PUNCH OUT", (TriggerCommand)new RotoControlPunchOutCommand(this.model, surface), 15, 34, () -> t.isPunchOutEnabled() ? 127 : 0);
        this.addButton(ButtonID.AUTOMATION, "AUTOMATION", new AutomationCommand(this.model, surface), 15, 35, () -> t.isWritingArrangerAutomation() ? 127 : 0);
        this.addButton(ButtonID.REWIND, "RWD", new WindCommand(this.model, surface, false), 15, 36);
        this.addButton(ButtonID.FORWARD, "FFW", new WindCommand(this.model, surface, true), 15, 37);
        for (int i = 0; i < 8; ++i) {
            ButtonID buttonID = ButtonID.get(ButtonID.ROW1_1, i);
            this.addButton(buttonID, "Button " + (i + 1), new ButtonRowModeCommand(this.buttonModeManager, 0, i, this.model, surface), 15, 20 + i, () -> this.getModeColor(this.buttonModeManager, buttonID));
        }
    }

    @Override
    protected void registerContinuousCommands() {
        RotoControlControlSurface surface = (RotoControlControlSurface)this.getSurface();
        for (int i = 0; i < 8; ++i) {
            int midiControl = 12 + i;
            KnobRowModeCommand<RotoControlControlSurface, RotoControlConfiguration> command = new KnobRowModeCommand<RotoControlControlSurface, RotoControlConfiguration>(i, this.model, surface){

                @Override
                public void execute(int value) {
                    IMode m = (IMode)((RotoControlControlSurface)this.surface).getModeManager().getActive();
                    if (m != null) {
                        RotoControlControllerSetup.this.knobValuesEditTime[this.index] = System.currentTimeMillis();
                        m.onKnobValue(this.index, value);
                        RotoControlControllerSetup.this.knobValues[this.index] = m.getKnobValue(this.index);
                    }
                }
            };
            surface.setHiResContinuousCommand(midiControl, command);
        }
    }

    @Override
    public void startup() {
        RotoControlControlSurface surface = (RotoControlControlSurface)this.getSurface();
        surface.getViewManager().setActive(Views.CONTROL);
        surface.getModeManager().setActive(Modes.VOLUME);
        this.buttonModeManager.setActive(Modes.MUTE);
        this.host.scheduleTask(surface::sendStartupCommand, 2000L);
    }

    @Override
    public void handle(RotoControlMessage message) {
        int messageType = message.getType();
        switch (messageType) {
            case 10: {
                this.handleGeneralCommands(message);
                break;
            }
            case 11: {
                this.handlePluginCommands(message);
                break;
            }
            case 12: {
                this.handleMixCommands(message);
                break;
            }
            default: {
                this.host.error("Unknown Roto Control message type: " + messageType);
            }
        }
    }

    private void handleGeneralCommands(RotoControlMessage message) {
        RotoControlControlSurface surface = (RotoControlControlSurface)this.getSurface();
        int[] content = message.getContent();
        int subType = message.getSubType();
        ITrackBank bank = this.model.getCurrentTrackBank();
        int pageSize = bank.getPageSize();
        switch (subType) {
            case 2: {
                surface.sendSysex(10, 3);
                break;
            }
            case 6: {
                bank.scrollTo(content[0] / pageSize * pageSize);
                surface.scheduleTask(() -> {
                    ((ITrack)bank.getItem(content[0] % pageSize)).select();
                    this.switchTracks(surface);
                }, 100L);
                break;
            }
            case 9: {
                if (content[0] == 255) break;
                bank.scrollTo(content[0] / pageSize * pageSize);
                ((ITrack)bank.getItem(content[0] % pageSize)).select();
                break;
            }
            case 10: {
                this.updateTransportStatus();
                break;
            }
            default: {
                this.host.error("Unknown Roto Control General message sub-type: " + subType);
            }
        }
    }

    private void switchTracks(RotoControlControlSurface surface) {
        surface.scheduleTask(() -> {
            Arrays.fill(this.knobValues, -1);
            surface.flushButtonLEDs();
        }, 100L);
    }

    private void handlePluginCommands(RotoControlMessage message) {
        RotoControlControlSurface surface = (RotoControlControlSurface)this.getSurface();
        int[] data = message.getContent();
        int subType = message.getSubType();
        ModeManager modeManager = surface.getModeManager();
        switch (subType) {
            case 1: {
                modeManager.setActive(Modes.DEVICE_PARAMS);
                break;
            }
            case 4: {
                this.model.getCursorDevice().getDeviceBank().scrollTo(data[0]);
                break;
            }
            case 7: {
                ((IDevice)this.model.getCursorDevice().getDeviceBank().getItem(data[0])).select();
                break;
            }
            case 9: {
                boolean activateLearn = data[0] > 0;
                Object f = modeManager.get(Modes.DEVICE_PARAMS);
                if (!(f instanceof RotoControlDeviceParameterMode)) break;
                RotoControlDeviceParameterMode rotoParamsMode = (RotoControlDeviceParameterMode)f;
                if (activateLearn && !modeManager.isActive(new Modes[]{Modes.DEVICE_PARAMS})) {
                    modeManager.setActive(Modes.DEVICE_PARAMS);
                }
                rotoParamsMode.setParamLearn(activateLearn);
                break;
            }
            case 11: {
                int paramIndex = data[0] * 128 + data[1];
                boolean isSwitch = data[8] == 1;
                int posInPage = data[9];
                Object f = modeManager.get(Modes.DEVICE_PARAMS);
                if (!(f instanceof RotoControlDeviceParameterMode)) break;
                RotoControlDeviceParameterMode rotoParamsMode = (RotoControlDeviceParameterMode)f;
                rotoParamsMode.bind(paramIndex, posInPage, isSwitch);
                break;
            }
            case 12: {
                ((IDevice)this.model.getCursorDevice().getDeviceBank().getItem(data[0])).toggleEnabledState();
                break;
            }
            case 13: {
                this.model.getCursorDevice().setPinned(data[0] > 0);
                break;
            }
            default: {
                this.host.error("Unknown Roto Control Plugin message sub-type: " + subType);
            }
        }
    }

    private void handleMixCommands(RotoControlMessage message) {
        RotoControlControlSurface surface = (RotoControlControlSurface)this.getSurface();
        int[] data = message.getContent();
        int subType = message.getSubType();
        ModeManager modeManager = surface.getModeManager();
        switch (subType) {
            case 1: {
                if (this.model.getEffectTrackBank() != null) {
                    if (data[0] == 1) {
                        if (!this.model.isEffectTrackBankActive()) {
                            this.model.toggleCurrentTrackBank();
                        }
                    } else if (this.model.isEffectTrackBankActive()) {
                        this.model.toggleCurrentTrackBank();
                    }
                }
                switch (data[1]) {
                    case 0: {
                        modeManager.setActive(Modes.VOLUME);
                        break;
                    }
                    case 1: {
                        modeManager.setActive(Modes.PAN);
                        break;
                    }
                    case 2: {
                        modeManager.setActive(Modes.get(Modes.SEND1, data[3]));
                        break;
                    }
                    default: {
                        surface.errorln("Unsupported knob mode: " + data[1]);
                    }
                }
                surface.flushRotoDisplay();
                switch (data[2]) {
                    case 0: {
                        this.buttonModeManager.setActive(Modes.MUTE);
                        break;
                    }
                    case 1: {
                        this.buttonModeManager.setActive(Modes.SOLO);
                        break;
                    }
                    case 2: {
                        this.buttonModeManager.setActive(Modes.REC_ARM);
                        break;
                    }
                    default: {
                        surface.errorln("Unsupported button mode: " + data[2]);
                    }
                }
                this.switchTracks(surface);
                break;
            }
            case 2: {
                modeManager.setActive(Modes.TRACK);
                break;
            }
            case 5: {
                ITrackBank currentTrackBank;
                if (this.model.getEffectTrackBank() != null) {
                    if (data[0] == 1) {
                        if (!this.model.isEffectTrackBankActive()) {
                            this.model.toggleCurrentTrackBank();
                        }
                    } else if (this.model.isEffectTrackBankActive()) {
                        this.model.toggleCurrentTrackBank();
                    }
                }
                if ((currentTrackBank = this.model.getCurrentTrackBank()).getSelectedItem().isEmpty()) {
                    ((ITrack)currentTrackBank.getItem(0)).select();
                }
                this.switchTracks(surface);
                break;
            }
            default: {
                this.host.error("Unknown Roto Control Plugin message sub-type: " + subType);
            }
        }
    }

    @Override
    public void flush() {
        super.flush();
        RotoControlControlSurface surface = (RotoControlControlSurface)this.getSurface();
        ModeManager modeManager = surface.getModeManager();
        IMode mode = (IMode)modeManager.getActive();
        if (mode == null) {
            return;
        }
        IMidiOutput output = surface.getMidiOutput();
        for (int i = 0; i < 8; ++i) {
            int value;
            long now = System.currentTimeMillis();
            if (now - this.knobValuesEditTime[i] < 1000L || (value = Math.max(0, mode.getKnobValue(i))) == this.knobValues[i]) continue;
            this.knobValues[i] = value;
            int midiControl = 12 + i;
            output.sendCCEx(15, midiControl, value / 128);
            output.sendCCEx(15, midiControl + 32, value % 128);
        }
    }

    @Override
    public void updateTransportStatus() {
        ITransport transport = this.model.getTransport();
        int[] attributes = new int[]{transport.isPlaying() ? 1 : 0, !transport.isPlaying() ? 1 : 0, transport.isRecording() ? 1 : 0, transport.isLauncherOverdub() ? 1 : 0, transport.isLoop() ? 1 : 0, transport.isPunchInEnabled() ? 1 : 0, transport.isPunchOutEnabled() ? 1 : 0, transport.isWritingArrangerAutomation() ? 1 : 0};
        ((RotoControlControlSurface)this.getSurface()).sendSysex(10, 11, attributes);
    }

    @Override
    protected void handleTrackChange(boolean isSelected) {
        if (!isSelected) {
            return;
        }
        Optional selectedItem = this.model.getCurrentTrackBank().getSelectedItem();
        if (!selectedItem.isPresent()) {
            return;
        }
        ITrack track = (ITrack)selectedItem.get();
        String name = RotoControlDisplay.create13ByteTextArray(track.getName());
        int colorIndex = ColorEx.getClosestColorIndex(track.getColor(), RotoControlColorManager.DEFAULT_PALETTE);
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            out.write(track.getPosition());
            out.write(name.getBytes());
            out.write(colorIndex);
            RotoControlControlSurface surface = (RotoControlControlSurface)this.getSurface();
            surface.sendSysex(12, 4, out.toByteArray());
            surface.flushRotoDisplay();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void updateIndication(Modes activeModeID) {
        boolean isTrack = activeModeID == Modes.TRACK;
        boolean isVolume = activeModeID == Modes.VOLUME;
        boolean isPan = activeModeID == Modes.PAN;
        boolean isDevice = activeModeID == Modes.DEVICE_PARAMS;
        int sendModeIndex = Modes.isSendMode(activeModeID) ? activeModeID.ordinal() - Modes.SEND1.ordinal() : -1;
        ITrackBank trackBank = this.model.getCurrentTrackBank();
        Optional selectedTrack = trackBank.getSelectedItem();
        for (int i = 0; i < trackBank.getPageSize(); ++i) {
            boolean hasTrackSel = selectedTrack.isPresent() && ((ITrack)selectedTrack.get()).getIndex() == i;
            ITrack track = (ITrack)trackBank.getItem(i);
            track.setVolumeIndication(isVolume || hasTrackSel && isTrack);
            track.setPanIndication(isPan || hasTrackSel && isTrack);
            ISendBank sendBank = track.getSendBank();
            int sendPageSize = sendBank.getPageSize();
            for (int j = 0; j < sendPageSize; ++j) {
                ((ISend)sendBank.getItem(j)).setIndication(sendModeIndex == j || hasTrackSel && isTrack);
            }
        }
        IParameterBank parameterBank = this.model.getCursorDevice().getParameterBank();
        for (int i = 0; i < parameterBank.getPageSize(); ++i) {
            ((IParameter)parameterBank.getItem(i)).setIndication(isDevice);
        }
    }
}

