/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.mackie.mcu.mode.layer;

import de.mossgrabers.controller.mackie.mcu.controller.MCUControlSurface;
import de.mossgrabers.controller.mackie.mcu.mode.BaseMode;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.display.ITextDisplay;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.constants.DeviceID;
import de.mossgrabers.framework.daw.data.IChannel;
import de.mossgrabers.framework.daw.data.ILayer;
import de.mossgrabers.framework.daw.data.ISpecificDevice;
import de.mossgrabers.framework.daw.data.bank.ILayerBank;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.utils.StringUtils;

public abstract class AbstractLayerMode
extends BaseMode<ILayer> {
    protected AbstractLayerMode(String name, MCUControlSurface surface, IModel model) {
        super(name, surface, model, AbstractLayerMode.getDevice(model).getLayerBank());
        ISpecificDevice device = AbstractLayerMode.getDevice(model);
        device.addHasDrumPadsObserver(hasDrumPads -> this.switchBanks(device.hasDrumPads() ? device.getDrumPadBank() : device.getLayerBank()));
    }

    @Override
    protected void drawTrackNameHeader() {
        ISpecificDevice device = AbstractLayerMode.getDevice(this.model);
        ILayerBank layerBank = device.hasDrumPads() ? device.getDrumPadBank() : device.getLayerBank();
        int extenderOffset = this.getExtenderOffset();
        ITextDisplay d = ((MCUControlSurface)this.surface).getTextDisplay().clear();
        int textLength = this.getTextLength();
        for (int i = 0; i < 8; ++i) {
            IChannel c = (IChannel)layerBank.getItem(extenderOffset + i);
            d.setCell(0, i, StringUtils.shortenAndFixASCII(c.getName(), textLength));
        }
        d.done(0);
    }

    @Override
    public void onButton(int row, int index, ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        if (row == 0) {
            this.resetParameter(index);
            return;
        }
        if (this.pinFXtoLastDevice) {
            super.onButton(row, index, event);
            return;
        }
        ISpecificDevice device = AbstractLayerMode.getDevice(this.model);
        ILayerBank layerBank = device.hasDrumPads() ? device.getDrumPadBank() : device.getLayerBank();
        IChannel channel = (IChannel)layerBank.getItem(this.getExtenderOffset() + index);
        if (row == 2) {
            if (((MCUControlSurface)this.surface).isSelectPressed()) {
                this.model.getProject().clearSolo();
            } else {
                channel.toggleSolo();
            }
        } else if (row == 3) {
            if (((MCUControlSurface)this.surface).isSelectPressed()) {
                this.model.getProject().clearMute();
            } else {
                channel.toggleMute();
            }
        }
    }

    @Override
    public int getButtonColor(ButtonID buttonID) {
        if (this.pinFXtoLastDevice) {
            return super.getButtonColor(buttonID);
        }
        ISpecificDevice device = AbstractLayerMode.getDevice(this.model);
        ILayerBank layerBank = device.hasDrumPads() ? device.getDrumPadBank() : device.getLayerBank();
        int extenderOffset = this.getExtenderOffset();
        for (int i = 0; i < 8; ++i) {
            IChannel channel = (IChannel)layerBank.getItem(extenderOffset + i);
            boolean exists = channel.doesExist();
            if (buttonID == ButtonID.get(ButtonID.ROW_SELECT_1, i)) {
                return exists && channel.isSelected() ? 127 : 0;
            }
            if (buttonID == ButtonID.get(ButtonID.ROW2_1, i)) {
                return 0;
            }
            if (buttonID == ButtonID.get(ButtonID.ROW3_1, i)) {
                return exists && channel.isSolo() ? 127 : 0;
            }
            if (buttonID != ButtonID.get(ButtonID.ROW4_1, i)) continue;
            return exists && channel.isMute() ? 127 : 0;
        }
        return 0;
    }

    protected static final ISpecificDevice getDevice(IModel model) {
        return model.getSpecificDevice(DeviceID.FIRST_INSTRUMENT);
    }

    @Override
    public void updateDisplay() {
        super.updateDisplay();
        this.updateItemIndices();
    }

    protected void updateItemIndices() {
        ISpecificDevice device = AbstractLayerMode.getDevice(this.model);
        ILayerBank layerBank = device.hasDrumPads() ? device.getDrumPadBank() : device.getLayerBank();
        int extenderOffset = this.getExtenderOffset();
        int[] indices = new int[8];
        for (int i = 0; i < 8; ++i) {
            IChannel item = (IChannel)layerBank.getItem(extenderOffset + i);
            indices[i] = item.doesExist() ? item.getPosition() + (device.hasDrumPads() ? 0 : 1) : 0;
        }
        ((MCUControlSurface)this.surface).setItemIndices(indices);
    }
}

