/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.generic.flexihandler;

import de.mossgrabers.controller.generic.GenericFlexiConfiguration;
import de.mossgrabers.controller.generic.controller.FlexiCommand;
import de.mossgrabers.controller.generic.controller.GenericFlexiControlSurface;
import de.mossgrabers.controller.generic.flexihandler.AbstractHandler;
import de.mossgrabers.controller.generic.flexihandler.utils.FlexiHandlerException;
import de.mossgrabers.controller.generic.flexihandler.utils.KnobMode;
import de.mossgrabers.controller.generic.flexihandler.utils.MidiValue;
import de.mossgrabers.framework.controller.valuechanger.IValueChanger;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.ITransport;
import de.mossgrabers.framework.daw.data.IMasterTrack;
import de.mossgrabers.framework.parameter.IParameter;

public class MasterHandler
extends AbstractHandler {
    public MasterHandler(IModel model, GenericFlexiControlSurface surface, GenericFlexiConfiguration configuration, IValueChanger absoluteLowResValueChanger, IValueChanger signedBitRelativeValueChanger, IValueChanger signedBit2RelativeValueChanger, IValueChanger offsetBinaryRelativeValueChanger) {
        super(model, surface, configuration, absoluteLowResValueChanger, signedBitRelativeValueChanger, signedBit2RelativeValueChanger, offsetBinaryRelativeValueChanger);
    }

    @Override
    public FlexiCommand[] getSupportedCommands() {
        return new FlexiCommand[]{FlexiCommand.MASTER_SET_VOLUME, FlexiCommand.MASTER_SET_PANNING, FlexiCommand.MASTER_TOGGLE_MUTE, FlexiCommand.MASTER_SET_MUTE, FlexiCommand.MASTER_TOGGLE_SOLO, FlexiCommand.MASTER_SET_SOLO, FlexiCommand.MASTER_TOGGLE_ARM, FlexiCommand.MASTER_SET_ARM, FlexiCommand.MASTER_CROSSFADER, FlexiCommand.MASTER_SELECT};
    }

    @Override
    public int getCommandValue(FlexiCommand command) {
        IMasterTrack masterTrack = this.model.getMasterTrack();
        switch (command) {
            case MASTER_SET_VOLUME: {
                return masterTrack.getVolume();
            }
            case MASTER_SET_PANNING: {
                return masterTrack.getPan();
            }
            case MASTER_TOGGLE_MUTE: 
            case MASTER_SET_MUTE: {
                return MasterHandler.toMidiValue(masterTrack.isMute());
            }
            case MASTER_TOGGLE_SOLO: 
            case MASTER_SET_SOLO: {
                return MasterHandler.toMidiValue(masterTrack.isSolo());
            }
            case MASTER_TOGGLE_ARM: 
            case MASTER_SET_ARM: {
                return MasterHandler.toMidiValue(masterTrack.isRecArm());
            }
            case MASTER_CROSSFADER: {
                return this.model.getTransport().getCrossfade();
            }
            case MASTER_SELECT: {
                return MasterHandler.toMidiValue(masterTrack.isSelected());
            }
        }
        return -1;
    }

    @Override
    public void handle(FlexiCommand command, KnobMode knobMode, MidiValue value) {
        boolean isButtonPressed = this.isButtonPressed(knobMode, value);
        switch (command) {
            case MASTER_SET_VOLUME: {
                this.changeMasterVolume(knobMode, value);
                break;
            }
            case MASTER_SET_PANNING: {
                this.changeMasterPanning(knobMode, value);
                break;
            }
            case MASTER_TOGGLE_MUTE: {
                if (!isButtonPressed) break;
                this.model.getMasterTrack().toggleMute();
                break;
            }
            case MASTER_SET_MUTE: {
                if (!isButtonPressed) break;
                this.model.getMasterTrack().setMute(value.isPositive());
                break;
            }
            case MASTER_TOGGLE_SOLO: {
                if (!isButtonPressed) break;
                this.model.getMasterTrack().toggleSolo();
                break;
            }
            case MASTER_SET_SOLO: {
                if (!isButtonPressed) break;
                this.model.getMasterTrack().setSolo(value.isPositive());
                break;
            }
            case MASTER_TOGGLE_ARM: {
                if (!isButtonPressed) break;
                this.model.getMasterTrack().toggleRecArm();
                break;
            }
            case MASTER_SET_ARM: {
                if (!isButtonPressed) break;
                this.model.getMasterTrack().setRecArm(value.isPositive());
                break;
            }
            case MASTER_CROSSFADER: {
                this.changeMasterCrossfader(knobMode, value);
                break;
            }
            case MASTER_SELECT: {
                if (!isButtonPressed) break;
                this.model.getMasterTrack().select();
                this.mvHelper.notifySelectedTrack();
                break;
            }
            default: {
                throw new FlexiHandlerException(command);
            }
        }
    }

    private void changeMasterVolume(KnobMode knobMode, MidiValue value) {
        IMasterTrack track = this.model.getMasterTrack();
        int val = value.getValue();
        IParameter volumeParameter = track.getVolumeParameter();
        if (MasterHandler.isAbsolute(knobMode)) {
            volumeParameter.setValue(this.getAbsoluteValueChanger(value), val);
        } else {
            volumeParameter.changeValue(this.getRelativeValueChanger(knobMode), val);
        }
    }

    private void changeMasterPanning(KnobMode knobMode, MidiValue value) {
        IMasterTrack track = this.model.getMasterTrack();
        int val = value.getValue();
        IParameter panParameter = track.getPanParameter();
        if (MasterHandler.isAbsolute(knobMode)) {
            panParameter.setValue(this.getAbsoluteValueChanger(value), val);
        } else {
            panParameter.changeValue(this.getRelativeValueChanger(knobMode), val);
        }
    }

    private void changeMasterCrossfader(KnobMode knobMode, MidiValue value) {
        ITransport transport = this.model.getTransport();
        int val = value.getValue();
        IParameter crossfadeParameter = transport.getCrossfadeParameter();
        if (MasterHandler.isAbsolute(knobMode)) {
            crossfadeParameter.setValue(this.getAbsoluteValueChanger(value), val);
        } else {
            crossfadeParameter.changeValue(this.getRelativeValueChanger(knobMode), val);
        }
    }
}

