/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.generic.flexihandler;

import de.mossgrabers.controller.generic.GenericFlexiConfiguration;
import de.mossgrabers.controller.generic.controller.FlexiCommand;
import de.mossgrabers.controller.generic.controller.GenericFlexiControlSurface;
import de.mossgrabers.controller.generic.flexihandler.AbstractHandler;
import de.mossgrabers.controller.generic.flexihandler.utils.FlexiHandlerException;
import de.mossgrabers.controller.generic.flexihandler.utils.KnobMode;
import de.mossgrabers.controller.generic.flexihandler.utils.MidiValue;
import de.mossgrabers.framework.controller.valuechanger.IValueChanger;
import de.mossgrabers.framework.daw.IBrowser;
import de.mossgrabers.framework.daw.IModel;

public class BrowserHandler
extends AbstractHandler {
    public BrowserHandler(IModel model, GenericFlexiControlSurface surface, GenericFlexiConfiguration configuration, IValueChanger absoluteLowResValueChanger, IValueChanger signedBitRelativeValueChanger, IValueChanger signedBit2RelativeValueChanger, IValueChanger offsetBinaryRelativeValueChanger) {
        super(model, surface, configuration, absoluteLowResValueChanger, signedBitRelativeValueChanger, signedBit2RelativeValueChanger, offsetBinaryRelativeValueChanger);
    }

    @Override
    public FlexiCommand[] getSupportedCommands() {
        return new FlexiCommand[]{FlexiCommand.BROWSER_BROWSE_PRESETS, FlexiCommand.BROWSER_INSERT_DEVICE_BEFORE_CURRENT, FlexiCommand.BROWSER_INSERT_DEVICE_AFTER_CURRENT, FlexiCommand.BROWSER_COMMIT_SELECTION, FlexiCommand.BROWSER_CANCEL_SELECTION, FlexiCommand.BROWSER_SELECT_PREVIOUS_FILTER_IN_COLUMN_1, FlexiCommand.BROWSER_SELECT_PREVIOUS_FILTER_IN_COLUMN_2, FlexiCommand.BROWSER_SELECT_PREVIOUS_FILTER_IN_COLUMN_3, FlexiCommand.BROWSER_SELECT_PREVIOUS_FILTER_IN_COLUMN_4, FlexiCommand.BROWSER_SELECT_PREVIOUS_FILTER_IN_COLUMN_5, FlexiCommand.BROWSER_SELECT_PREVIOUS_FILTER_IN_COLUMN_6, FlexiCommand.BROWSER_SELECT_PREVIOUS_FILTER_IN_COLUMN_7, FlexiCommand.BROWSER_SELECT_PREVIOUS_FILTER_IN_COLUMN_8, FlexiCommand.BROWSER_SELECT_NEXT_FILTER_IN_COLUMN_1, FlexiCommand.BROWSER_SELECT_NEXT_FILTER_IN_COLUMN_2, FlexiCommand.BROWSER_SELECT_NEXT_FILTER_IN_COLUMN_3, FlexiCommand.BROWSER_SELECT_NEXT_FILTER_IN_COLUMN_4, FlexiCommand.BROWSER_SELECT_NEXT_FILTER_IN_COLUMN_5, FlexiCommand.BROWSER_SELECT_NEXT_FILTER_IN_COLUMN_6, FlexiCommand.BROWSER_SELECT_NEXT_FILTER_IN_COLUMN_7, FlexiCommand.BROWSER_SELECT_NEXT_FILTER_IN_COLUMN_8, FlexiCommand.BROWSER_SCROLL_FILTER_IN_COLUMN_1, FlexiCommand.BROWSER_SCROLL_FILTER_IN_COLUMN_2, FlexiCommand.BROWSER_SCROLL_FILTER_IN_COLUMN_3, FlexiCommand.BROWSER_SCROLL_FILTER_IN_COLUMN_4, FlexiCommand.BROWSER_SCROLL_FILTER_IN_COLUMN_5, FlexiCommand.BROWSER_SCROLL_FILTER_IN_COLUMN_6, FlexiCommand.BROWSER_SCROLL_FILTER_IN_COLUMN_7, FlexiCommand.BROWSER_SCROLL_FILTER_IN_COLUMN_8, FlexiCommand.BROWSER_RESET_FILTER_COLUMN_1, FlexiCommand.BROWSER_RESET_FILTER_COLUMN_2, FlexiCommand.BROWSER_RESET_FILTER_COLUMN_3, FlexiCommand.BROWSER_RESET_FILTER_COLUMN_4, FlexiCommand.BROWSER_RESET_FILTER_COLUMN_5, FlexiCommand.BROWSER_RESET_FILTER_COLUMN_6, FlexiCommand.BROWSER_RESET_FILTER_COLUMN_7, FlexiCommand.BROWSER_RESET_FILTER_COLUMN_8, FlexiCommand.BROWSER_SELECT_THE_PREVIOUS_PRESET, FlexiCommand.BROWSER_SELECT_THE_NEXT_PRESET, FlexiCommand.BROWSER_SCROLL_PRESETS, FlexiCommand.BROWSER_SELECT_THE_PREVIOUS_TAB, FlexiCommand.BROWSER_SELECT_THE_NEXT_TAB, FlexiCommand.BROWSER_SCROLL_TABS};
    }

    @Override
    public int getCommandValue(FlexiCommand command) {
        return -1;
    }

    @Override
    public void handle(FlexiCommand command, KnobMode knobMode, MidiValue value) {
        boolean isButtonPressed = this.isButtonPressed(knobMode, value);
        IBrowser browser = this.model.getBrowser();
        switch (command) {
            case BROWSER_BROWSE_PRESETS: {
                if (!isButtonPressed) break;
                browser.replace(this.model.getCursorDevice());
                break;
            }
            case BROWSER_INSERT_DEVICE_BEFORE_CURRENT: {
                if (!isButtonPressed) break;
                browser.insertBeforeCursorDevice();
                break;
            }
            case BROWSER_INSERT_DEVICE_AFTER_CURRENT: {
                if (!isButtonPressed) break;
                browser.insertAfterCursorDevice();
                break;
            }
            case BROWSER_COMMIT_SELECTION: {
                if (!isButtonPressed) break;
                browser.stopBrowsing(true);
                break;
            }
            case BROWSER_CANCEL_SELECTION: {
                if (!isButtonPressed) break;
                browser.stopBrowsing(false);
                break;
            }
            case BROWSER_SELECT_PREVIOUS_FILTER_IN_COLUMN_1: 
            case BROWSER_SELECT_PREVIOUS_FILTER_IN_COLUMN_2: 
            case BROWSER_SELECT_PREVIOUS_FILTER_IN_COLUMN_3: 
            case BROWSER_SELECT_PREVIOUS_FILTER_IN_COLUMN_4: 
            case BROWSER_SELECT_PREVIOUS_FILTER_IN_COLUMN_5: 
            case BROWSER_SELECT_PREVIOUS_FILTER_IN_COLUMN_6: 
            case BROWSER_SELECT_PREVIOUS_FILTER_IN_COLUMN_7: 
            case BROWSER_SELECT_PREVIOUS_FILTER_IN_COLUMN_8: {
                if (!isButtonPressed) break;
                browser.selectPreviousFilterItem(command.ordinal() - FlexiCommand.BROWSER_SELECT_PREVIOUS_FILTER_IN_COLUMN_1.ordinal());
                break;
            }
            case BROWSER_SELECT_NEXT_FILTER_IN_COLUMN_1: 
            case BROWSER_SELECT_NEXT_FILTER_IN_COLUMN_2: 
            case BROWSER_SELECT_NEXT_FILTER_IN_COLUMN_3: 
            case BROWSER_SELECT_NEXT_FILTER_IN_COLUMN_4: 
            case BROWSER_SELECT_NEXT_FILTER_IN_COLUMN_5: 
            case BROWSER_SELECT_NEXT_FILTER_IN_COLUMN_6: 
            case BROWSER_SELECT_NEXT_FILTER_IN_COLUMN_7: 
            case BROWSER_SELECT_NEXT_FILTER_IN_COLUMN_8: {
                if (!isButtonPressed) break;
                browser.selectNextFilterItem(command.ordinal() - FlexiCommand.BROWSER_SELECT_NEXT_FILTER_IN_COLUMN_1.ordinal());
                break;
            }
            case BROWSER_SCROLL_FILTER_IN_COLUMN_1: 
            case BROWSER_SCROLL_FILTER_IN_COLUMN_2: 
            case BROWSER_SCROLL_FILTER_IN_COLUMN_3: 
            case BROWSER_SCROLL_FILTER_IN_COLUMN_4: 
            case BROWSER_SCROLL_FILTER_IN_COLUMN_5: 
            case BROWSER_SCROLL_FILTER_IN_COLUMN_6: 
            case BROWSER_SCROLL_FILTER_IN_COLUMN_7: 
            case BROWSER_SCROLL_FILTER_IN_COLUMN_8: {
                this.scrollFilterColumn(knobMode, command.ordinal() - FlexiCommand.BROWSER_SCROLL_FILTER_IN_COLUMN_1.ordinal(), value);
                break;
            }
            case BROWSER_RESET_FILTER_COLUMN_1: 
            case BROWSER_RESET_FILTER_COLUMN_2: 
            case BROWSER_RESET_FILTER_COLUMN_3: 
            case BROWSER_RESET_FILTER_COLUMN_4: 
            case BROWSER_RESET_FILTER_COLUMN_5: 
            case BROWSER_RESET_FILTER_COLUMN_6: 
            case BROWSER_RESET_FILTER_COLUMN_7: 
            case BROWSER_RESET_FILTER_COLUMN_8: {
                if (!isButtonPressed) break;
                browser.resetFilterColumn(command.ordinal() - FlexiCommand.BROWSER_RESET_FILTER_COLUMN_1.ordinal());
                break;
            }
            case BROWSER_SELECT_THE_PREVIOUS_PRESET: {
                if (!isButtonPressed) break;
                browser.selectPreviousResult();
                break;
            }
            case BROWSER_SELECT_THE_NEXT_PRESET: {
                if (!isButtonPressed) break;
                browser.selectNextResult();
                break;
            }
            case BROWSER_SCROLL_PRESETS: {
                this.scrollPresetColumn(knobMode, value);
                break;
            }
            case BROWSER_SELECT_THE_PREVIOUS_TAB: {
                if (!isButtonPressed) break;
                browser.previousContentType();
                break;
            }
            case BROWSER_SELECT_THE_NEXT_TAB: {
                if (!isButtonPressed) break;
                browser.nextContentType();
                break;
            }
            case BROWSER_SCROLL_TABS: {
                this.scrollBrowserTabs(knobMode, value);
                break;
            }
            default: {
                throw new FlexiHandlerException(command);
            }
        }
    }

    private void scrollFilterColumn(KnobMode knobMode, int filterColumn, MidiValue value) {
        if (BrowserHandler.isAbsolute(knobMode)) {
            return;
        }
        IBrowser browser = this.model.getBrowser();
        if (this.isIncrease(knobMode, value)) {
            browser.selectNextFilterItem(filterColumn);
        } else {
            browser.selectPreviousFilterItem(filterColumn);
        }
    }

    private void scrollPresetColumn(KnobMode knobMode, MidiValue value) {
        if (BrowserHandler.isAbsolute(knobMode)) {
            return;
        }
        IBrowser browser = this.model.getBrowser();
        if (this.isIncrease(knobMode, value)) {
            browser.selectNextResult();
        } else {
            browser.selectPreviousResult();
        }
    }

    private void scrollBrowserTabs(KnobMode knobMode, MidiValue value) {
        if (BrowserHandler.isAbsolute(knobMode) || !this.increaseKnobMovement()) {
            return;
        }
        IBrowser browser = this.model.getBrowser();
        if (this.isIncrease(knobMode, value)) {
            browser.nextContentType();
        } else {
            browser.previousContentType();
        }
    }
}

