/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.generic.flexihandler;

import de.mossgrabers.controller.generic.GenericFlexiConfiguration;
import de.mossgrabers.controller.generic.controller.FlexiCommand;
import de.mossgrabers.controller.generic.controller.GenericFlexiControlSurface;
import de.mossgrabers.controller.generic.flexihandler.AbstractHandler;
import de.mossgrabers.controller.generic.flexihandler.utils.KnobMode;
import de.mossgrabers.controller.generic.flexihandler.utils.MidiValue;
import de.mossgrabers.framework.controller.valuechanger.IValueChanger;
import de.mossgrabers.framework.daw.IModel;

public class ActionHandler
extends AbstractHandler {
    public ActionHandler(IModel model, GenericFlexiControlSurface surface, GenericFlexiConfiguration configuration, IValueChanger absoluteLowResValueChanger, IValueChanger signedBitRelativeValueChanger, IValueChanger signedBit2RelativeValueChanger, IValueChanger offsetBinaryRelativeValueChanger) {
        super(model, surface, configuration, absoluteLowResValueChanger, signedBitRelativeValueChanger, signedBit2RelativeValueChanger, offsetBinaryRelativeValueChanger);
    }

    @Override
    public FlexiCommand[] getSupportedCommands() {
        return new FlexiCommand[]{FlexiCommand.ACTION_1, FlexiCommand.ACTION_2, FlexiCommand.ACTION_3, FlexiCommand.ACTION_4, FlexiCommand.ACTION_5, FlexiCommand.ACTION_6, FlexiCommand.ACTION_7, FlexiCommand.ACTION_8};
    }

    @Override
    public int getCommandValue(FlexiCommand command) {
        return -1;
    }

    @Override
    public void handle(FlexiCommand command, KnobMode knobMode, MidiValue value) {
        if (!this.isButtonPressed(knobMode, value)) {
            return;
        }
        String assignableActionID = this.configuration.getAssignableAction(command.ordinal() - FlexiCommand.ACTION_1.ordinal());
        if (assignableActionID != null && !assignableActionID.isBlank()) {
            this.model.getApplication().invokeAction(assignableActionID);
        }
    }
}

