/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.electra.one.mode;

import de.mossgrabers.controller.electra.one.ElectraOneConfiguration;
import de.mossgrabers.controller.electra.one.controller.ElectraOneColorManager;
import de.mossgrabers.controller.electra.one.controller.ElectraOneControlSurface;
import de.mossgrabers.controller.electra.one.mode.AbstractElectraOneMode;
import de.mossgrabers.framework.command.trigger.clip.NewCommand;
import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.IProject;
import de.mossgrabers.framework.daw.ITransport;
import de.mossgrabers.framework.daw.constants.AutomationMode;
import de.mossgrabers.framework.daw.data.IMarker;
import de.mossgrabers.framework.daw.data.IMasterTrack;
import de.mossgrabers.framework.daw.data.ISlot;
import de.mossgrabers.framework.daw.data.bank.IMarkerBank;
import de.mossgrabers.framework.parameter.IFocusedParameter;
import de.mossgrabers.framework.parameter.PlayPositionParameter;
import de.mossgrabers.framework.parameter.TempoParameter;
import de.mossgrabers.framework.parameterprovider.special.CombinedParameterProvider;
import de.mossgrabers.framework.parameterprovider.special.EmptyParameterProvider;
import de.mossgrabers.framework.parameterprovider.special.FixedParameterProvider;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.utils.StringUtils;
import java.util.Optional;

public class TransportMode
extends AbstractElectraOneMode {
    private final ITransport transport;
    private final IMasterTrack masterTrack;
    private final IProject project;
    private final NewCommand<ElectraOneControlSurface, ElectraOneConfiguration> newCommand;
    private boolean launchMarkers = false;

    public TransportMode(ElectraOneControlSurface surface, IModel model) {
        super(4, "Transport", surface, model);
        this.newCommand = new NewCommand(model, surface);
        this.transport = this.model.getTransport();
        this.masterTrack = this.model.getMasterTrack();
        this.project = this.model.getProject();
        EmptyParameterProvider emptyParameterProvider5 = new EmptyParameterProvider(5);
        EmptyParameterProvider emptyParameterProvider6 = new EmptyParameterProvider(6);
        this.setParameterProvider(new CombinedParameterProvider(emptyParameterProvider5, new FixedParameterProvider(this.masterTrack.getVolumeParameter()), emptyParameterProvider5, new FixedParameterProvider(new PlayPositionParameter(model.getValueChanger(), this.transport, surface)), emptyParameterProvider5, new FixedParameterProvider(new TempoParameter(model.getValueChanger(), this.transport, surface)), emptyParameterProvider6, new EmptyParameterProvider(1), new FixedParameterProvider(this.transport.getMetronomeVolumeParameter()), new FixedParameterProvider(this.project.getCueVolumeParameter()), new EmptyParameterProvider(3), new EmptyParameterProvider(2), new FixedParameterProvider(this.model.getFocusedParameter().get()), new EmptyParameterProvider(3)));
    }

    @Override
    public void onButton(int row, int column, ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        block0 : switch (row) {
            case 0: {
                switch (column) {
                    case 0: {
                        this.newCommand.execute();
                        break block0;
                    }
                    case 1: {
                        this.model.getCursorClip().quantize(1.0);
                        break block0;
                    }
                    case 2: {
                        this.transport.toggleWriteArrangerAutomation();
                        break block0;
                    }
                    case 3: {
                        this.transport.setAutomationWriteMode(AutomationMode.READ);
                        break block0;
                    }
                    case 4: {
                        this.transport.setAutomationWriteMode(AutomationMode.WRITE);
                        break block0;
                    }
                }
                break;
            }
            case 1: {
                switch (column) {
                    case 0: {
                        Optional<ISlot> slot = this.model.getSelectedSlot();
                        if (slot.isEmpty()) {
                            return;
                        }
                        ISlot s = slot.get();
                        if (!s.isRecording()) {
                            s.startRecording();
                        }
                        s.launch(true, false);
                        break block0;
                    }
                    case 1: {
                        this.transport.toggleLauncherOverdub();
                        break block0;
                    }
                    case 2: {
                        this.transport.toggleWriteClipLauncherAutomation();
                        break block0;
                    }
                    case 3: {
                        this.transport.setAutomationWriteMode(AutomationMode.LATCH);
                        break block0;
                    }
                    case 4: {
                        this.transport.setAutomationWriteMode(AutomationMode.TOUCH);
                        break block0;
                    }
                }
                break;
            }
            case 2: {
                if (column == 0) {
                    this.model.getMarkerBank().selectNextPage();
                    break;
                }
                if (column >= 5) break;
                this.handleMarker(column - 1);
                break;
            }
            case 3: {
                switch (column) {
                    case 0: {
                        this.model.getMarkerBank().selectPreviousPage();
                        break block0;
                    }
                    case 5: {
                        this.transport.tapTempo();
                        break block0;
                    }
                }
                this.handleMarker(4 + column - 1);
                break;
            }
            case 4: {
                switch (column) {
                    case 0: {
                        this.model.getApplication().redo();
                        break block0;
                    }
                    case 4: {
                        this.model.getMarkerBank().addMarker();
                        break block0;
                    }
                    case 5: {
                        this.transport.startRecording();
                        break block0;
                    }
                }
                break;
            }
            case 5: {
                switch (column) {
                    case 0: {
                        this.model.getApplication().undo();
                        break block0;
                    }
                    case 1: {
                        this.transport.toggleMetronome();
                        break block0;
                    }
                    case 3: {
                        this.transport.toggleOverdub();
                        break block0;
                    }
                    case 4: {
                        this.launchMarkers = !this.launchMarkers;
                        break block0;
                    }
                    case 5: {
                        this.transport.play();
                        break block0;
                    }
                }
            }
        }
    }

    @Override
    public void updateDisplay() {
        AutomationMode automationWriteMode = this.transport.getAutomationWriteMode();
        this.pageCache.updateColor(0, 2, this.transport.isWritingArrangerAutomation() ? ElectraOneColorManager.AUTO_ON : ElectraOneColorManager.AUTO_OFF);
        this.pageCache.updateColor(0, 3, automationWriteMode == AutomationMode.READ ? ElectraOneColorManager.AUTO_MODE_ON : ElectraOneColorManager.AUTO_MODE_OFF);
        this.pageCache.updateColor(0, 4, automationWriteMode == AutomationMode.WRITE ? ElectraOneColorManager.AUTO_MODE_ON : ElectraOneColorManager.AUTO_MODE_OFF);
        this.pageCache.updateColor(1, 1, this.transport.isLauncherOverdub() ? ElectraOneColorManager.AUTO_MODE_ON : ElectraOneColorManager.AUTO_MODE_OFF);
        this.pageCache.updateColor(1, 2, this.transport.isWritingClipLauncherAutomation() ? ElectraOneColorManager.AUTO_ON : ElectraOneColorManager.AUTO_OFF);
        this.pageCache.updateColor(1, 3, automationWriteMode == AutomationMode.LATCH ? ElectraOneColorManager.AUTO_MODE_ON : ElectraOneColorManager.AUTO_MODE_OFF);
        this.pageCache.updateColor(1, 4, automationWriteMode == AutomationMode.TOUCH ? ElectraOneColorManager.AUTO_MODE_ON : ElectraOneColorManager.AUTO_MODE_OFF);
        this.pageCache.updateValue(2, 5, 0, this.transport.formatTempo(this.transport.getTempo()));
        IMarkerBank markerBank = this.model.getMarkerBank();
        for (int i = 0; i < 4; ++i) {
            IMarker marker = (IMarker)markerBank.getItem(i);
            boolean doesExist = marker.doesExist();
            this.pageCache.updateElement(2, 1 + i, doesExist ? marker.getName() : " ", doesExist ? marker.getColor() : ColorEx.BLACK, Boolean.TRUE);
            marker = (IMarker)markerBank.getItem(4 + i);
            doesExist = marker.doesExist();
            this.pageCache.updateElement(3, 1 + i, doesExist ? marker.getName() : " ", doesExist ? marker.getColor() : ColorEx.BLACK, Boolean.TRUE);
        }
        this.pageCache.updateValue(4, 1, this.transport.getMetronomeVolume(), StringUtils.optimizeName(StringUtils.fixASCII(this.transport.getMetronomeVolumeStr()), 15));
        this.pageCache.updateValue(4, 2, this.project.getCueVolume(), StringUtils.optimizeName(StringUtils.fixASCII(this.project.getCueVolumeStr()), 15));
        this.pageCache.updateColor(5, 1, this.transport.isMetronomeOn() ? ElectraOneColorManager.METRONOME_ON : ElectraOneColorManager.METRONOME_OFF);
        Optional<IFocusedParameter> focusedParameter = this.model.getFocusedParameter();
        int paramValue = focusedParameter.isPresent() ? focusedParameter.get().getValue() : 0;
        String paramStr = focusedParameter.isPresent() ? focusedParameter.get().getDisplayedValue() : "";
        this.pageCache.updateValue(5, 2, paramValue, StringUtils.optimizeName(StringUtils.fixASCII(paramStr), 15));
        this.pageCache.updateColor(5, 3, this.transport.isArrangerOverdub() ? ElectraOneColorManager.AUTO_MODE_ON : ElectraOneColorManager.AUTO_MODE_OFF);
        this.pageCache.updateColor(5, 4, this.launchMarkers ? ElectraOneColorManager.MARKER_LAUNCH_ON : ElectraOneColorManager.MARKER_LAUNCH_OFF);
        this.pageCache.updateColor(0, 5, this.masterTrack.getColor());
        this.pageCache.updateValue(0, 5, this.masterTrack.getVolume(), StringUtils.optimizeName(StringUtils.fixASCII(this.masterTrack.getVolumeStr()), 15));
        this.pageCache.updateValue(1, 5, 0, StringUtils.optimizeName(StringUtils.fixASCII(this.transport.getBeatText()), 15));
        this.pageCache.updateElement(1, 5, StringUtils.optimizeName(StringUtils.fixASCII(this.transport.getPositionText()), 15), null, null);
        this.pageCache.updateColor(4, 5, this.transport.isRecording() ? ElectraOneColorManager.RECORD_ON : ElectraOneColorManager.RECORD_OFF);
        this.pageCache.updateColor(5, 5, this.transport.isPlaying() ? ElectraOneColorManager.PLAY_ON : ElectraOneColorManager.PLAY_OFF);
        this.pageCache.flush();
    }

    private void handleMarker(int markerIndex) {
        IMarker marker = (IMarker)this.model.getMarkerBank().getItem(markerIndex);
        if (this.launchMarkers) {
            marker.launch(true);
        } else {
            marker.select();
        }
    }
}

