/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.akai.fire.view;

import de.mossgrabers.controller.akai.fire.FireConfiguration;
import de.mossgrabers.controller.akai.fire.controller.FireControlSurface;
import de.mossgrabers.controller.akai.fire.view.IFireView;
import de.mossgrabers.framework.configuration.AbstractConfiguration;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ICursorTrack;
import de.mossgrabers.framework.scale.Scales;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.AbstractPlayView;

public class PlayView
extends AbstractPlayView<FireControlSurface, FireConfiguration>
implements IFireView {
    public PlayView(FireControlSurface surface, IModel model) {
        this("Play", surface, model);
    }

    public PlayView(String name, FireControlSurface surface, IModel model) {
        super(name, surface, model, true);
        Object configuration = ((FireControlSurface)this.surface).getConfiguration();
        PlayView playView = this;
        configuration.addSettingObserver(AbstractConfiguration.ACTIVATE_FIXED_ACCENT, () -> playView.initMaxVelocity());
        playView = this;
        configuration.addSettingObserver(AbstractConfiguration.FIXED_ACCENT_VALUE, () -> playView.initMaxVelocity());
    }

    @Override
    public void onButton(ButtonID buttonID, ButtonEvent event, int velocity) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        boolean isShiftPressed = ((FireControlSurface)this.surface).isShiftPressed();
        boolean isAltPressed = ((FireControlSurface)this.surface).isPressed(ButtonID.ALT);
        ICursorTrack cursorTrack = this.model.getCursorTrack();
        switch (buttonID) {
            case ARROW_LEFT: {
                this.handleArrowLeft(isShiftPressed, isAltPressed);
                break;
            }
            case ARROW_RIGHT: {
                this.handleArrowRight(isShiftPressed, isAltPressed);
                break;
            }
            case SCENE1: {
                if (!cursorTrack.doesExist()) break;
                cursorTrack.stop(false);
                break;
            }
            case SCENE2: {
                if (!cursorTrack.doesExist()) break;
                cursorTrack.toggleMute();
                break;
            }
            case SCENE3: {
                if (!cursorTrack.doesExist()) break;
                cursorTrack.toggleSolo();
                break;
            }
            case SCENE4: {
                if (!cursorTrack.doesExist()) break;
                cursorTrack.toggleRecArm();
                break;
            }
        }
    }

    @Override
    public int getButtonColor(ButtonID buttonID) {
        switch (buttonID) {
            case SCENE1: 
            case SCENE2: 
            case SCENE3: 
            case SCENE4: {
                return ((FireControlSurface)this.surface).isPressed(buttonID) ? 2 : 1;
            }
        }
        return super.getButtonColor(buttonID);
    }

    @Override
    public int getSoloButtonColor(int index) {
        ICursorTrack cursorTrack = this.model.getCursorTrack();
        switch (index) {
            case 0: {
                return 0;
            }
            case 1: {
                return cursorTrack.doesExist() && cursorTrack.isMute() ? 3 : 0;
            }
            case 2: {
                return cursorTrack.doesExist() && cursorTrack.isSolo() ? 4 : 0;
            }
            case 3: {
                return cursorTrack.doesExist() && cursorTrack.isRecArm() ? 1 : 0;
            }
        }
        return 0;
    }

    private void handleArrowLeft(boolean isShiftPressed, boolean isAltPressed) {
        if (isShiftPressed) {
            if (isAltPressed) {
                this.scales.prevScaleLayout();
                this.mvHelper.delayDisplay(() -> this.scales.getScaleLayout().getName());
            } else {
                this.scales.prevScale();
                this.mvHelper.delayDisplay(() -> this.scales.getScale().getName());
            }
        } else if (isAltPressed) {
            this.scales.prevScaleOffset();
            this.mvHelper.delayDisplay(() -> Scales.BASES.get(this.scales.getScaleOffsetIndex()));
        } else {
            this.scales.toggleChromatic();
            this.mvHelper.delayDisplay(() -> this.scales.isChromatic() ? "Chromatic" : "In Scale");
        }
        this.updateScale();
    }

    private void handleArrowRight(boolean isShiftPressed, boolean isAltPressed) {
        if (isShiftPressed) {
            if (isAltPressed) {
                this.scales.nextScaleLayout();
                this.mvHelper.delayDisplay(() -> this.scales.getScaleLayout().getName());
            } else {
                this.scales.nextScale();
                this.mvHelper.delayDisplay(() -> this.scales.getScale().getName());
            }
        } else if (isAltPressed) {
            this.scales.nextScaleOffset();
            this.mvHelper.delayDisplay(() -> Scales.BASES.get(this.scales.getScaleOffsetIndex()));
        } else {
            this.scales.toggleChromatic();
            this.mvHelper.delayDisplay(() -> this.scales.isChromatic() ? "Chromatic" : "In Scale");
        }
        this.updateScale();
    }

    @Override
    public void onSelectKnobValue(int value) {
        if (this.model.getValueChanger().isIncrease(value)) {
            this.scales.incOctave();
        } else {
            this.scales.decOctave();
        }
        this.mvHelper.delayDisplay(this.scales::getRangeText);
        this.updateNoteMapping();
    }
}

