/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.akai.fire.view;

import de.mossgrabers.controller.akai.fire.FireConfiguration;
import de.mossgrabers.controller.akai.fire.controller.FireControlSurface;
import de.mossgrabers.controller.akai.fire.mode.FireLayerMode;
import de.mossgrabers.controller.akai.fire.view.IFireView;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.clip.INoteClip;
import de.mossgrabers.framework.daw.clip.NotePosition;
import de.mossgrabers.framework.daw.clip.StepState;
import de.mossgrabers.framework.daw.constants.Resolution;
import de.mossgrabers.framework.daw.data.IDrumDevice;
import de.mossgrabers.framework.daw.data.IDrumPad;
import de.mossgrabers.framework.daw.data.ISlot;
import de.mossgrabers.framework.daw.data.bank.IDrumPadBank;
import de.mossgrabers.framework.featuregroup.IMode;
import de.mossgrabers.framework.featuregroup.ModeManager;
import de.mossgrabers.framework.mode.INoteEditorMode;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.sequencer.AbstractDrumXoXView;

public class DrumXoXView
extends AbstractDrumXoXView<FireControlSurface, FireConfiguration>
implements IFireView {
    protected boolean isCopy = true;
    protected boolean isSolo = true;
    protected boolean editLoopRange = false;

    public DrumXoXView(FireControlSurface surface, IModel model) {
        super("Drum", surface, model, 16);
        this.buttonSelect = ButtonID.ALT;
        this.deleteButton = ButtonID.SCENE1;
        this.editLoopTriggerButton = ButtonID.SCENE3;
    }

    @Override
    protected IDrumDevice getDrumDevice() {
        return this.model.getDrumDevice(16);
    }

    @Override
    protected void selectDrumPad(int index) {
        super.selectDrumPad(index);
        Object f = ((FireControlSurface)this.surface).getModeManager().getActive();
        if (f instanceof FireLayerMode) {
            FireLayerMode fireLayerMode = (FireLayerMode)f;
            fireLayerMode.parametersAdjusted();
        }
    }

    @Override
    public void onButton(ButtonID buttonID, ButtonEvent event, int velocity) {
        if (event != ButtonEvent.UP || !this.isActive() || this.handleGridNavigation(buttonID) || !ButtonID.isSceneButton(buttonID)) {
            return;
        }
        IDrumPadBank drumPadBank2 = this.getDrumDevice().getDrumPadBank();
        int index = buttonID.ordinal() - ButtonID.SCENE1.ordinal();
        switch (index) {
            case 0: {
                this.isCopy = !this.isCopy;
                break;
            }
            case 1: {
                if (this.isButtonCombination(ButtonID.ALT)) {
                    for (int i = 0; i < drumPadBank2.getPageSize(); ++i) {
                        IDrumPad item = drumPadBank2.getItem(i);
                        if (this.isSolo) {
                            item.setSolo(false);
                            continue;
                        }
                        item.setMute(false);
                    }
                    return;
                }
                this.isSolo = !this.isSolo;
                break;
            }
            case 2: {
                this.editLoopRange = !this.editLoopRange;
                break;
            }
            default: {
                this.configuration.toggleNoteRepeatActive();
                this.mvHelper.delayDisplay(() -> "Note Repeat: " + (this.configuration.isNoteRepeatActive() ? "On" : "Off"));
            }
        }
    }

    @Override
    public void onSelectKnobValue(int value) {
        IDrumDevice drumDevice = this.getDrumDevice();
        if (!drumDevice.hasDrumPads() || this.blockSelectKnob) {
            return;
        }
        boolean isUp = this.model.getValueChanger().isIncrease(value);
        if (this.configuration.isNoteRepeatActive()) {
            boolean isDrumPadPressed = false;
            for (int i = 0; i < 16; ++i) {
                if (!((FireControlSurface)this.surface).isPressed(ButtonID.get(ButtonID.PAD33, i))) continue;
                isDrumPadPressed = true;
            }
            if (isDrumPadPressed) {
                Resolution activePeriod = this.configuration.getNoteRepeatPeriod();
                Resolution sel = isUp ? (Resolution)((Object)NEXT_RESOLUTION.get((Object)activePeriod)) : (Resolution)((Object)PREV_RESOLUTION.get((Object)activePeriod));
                this.configuration.setNoteRepeatPeriod(sel);
                this.mvHelper.delayDisplay(() -> "Period: " + sel.getName());
                return;
            }
        }
        this.adjustPage(isUp, 0);
    }

    @Override
    public int getSoloButtonColor(int index) {
        if (!this.isActive()) {
            return 0;
        }
        switch (index) {
            case 0: {
                return this.isCopy ? 2 : 1;
            }
            case 1: {
                return this.isSolo ? 2 : 1;
            }
            case 2: {
                return this.isEditLoopRange() ? 2 : 0;
            }
        }
        return this.configuration.isNoteRepeatActive() ? 2 : 0;
    }

    @Override
    protected void handleClipLaunch(ISlot slot, boolean isPressed) {
        if (this.isAlternateFunction()) {
            slot.select();
        } else {
            slot.launch(isPressed, ((FireControlSurface)this.surface).isPressed(this.buttonSelect));
        }
    }

    @Override
    protected boolean isAlternateFunction() {
        return ((FireControlSurface)this.surface).isPressed(ButtonID.ALT) && ((FireControlSurface)this.surface).isPressed(ButtonID.SHIFT);
    }

    protected boolean handleGridNavigation(ButtonID buttonID) {
        INoteClip clip = this.getClip();
        if (buttonID == ButtonID.ARROW_LEFT) {
            if (((FireControlSurface)this.surface).isPressed(ButtonID.SHIFT)) {
                this.rotateStepsLeft(clip);
            } else if (((FireControlSurface)this.surface).isPressed(ButtonID.ALT)) {
                this.setResolutionIndex(this.getResolutionIndex() - 1);
            } else {
                clip.scrollStepsPageBackwards();
                this.mvHelper.notifyEditPage(clip);
            }
            return true;
        }
        if (buttonID == ButtonID.ARROW_RIGHT) {
            if (((FireControlSurface)this.surface).isPressed(ButtonID.SHIFT)) {
                this.rotateStepsRight(clip);
            } else if (((FireControlSurface)this.surface).isPressed(ButtonID.ALT)) {
                this.setResolutionIndex(this.getResolutionIndex() + 1);
            } else {
                clip.scrollStepsPageForward();
                this.mvHelper.notifyEditPage(clip);
            }
            return true;
        }
        return false;
    }

    @Override
    protected boolean handleSequencerAreaButtonCombinations(INoteClip clip, NotePosition notePosition, int velocity) {
        boolean isUpPressed = ((FireControlSurface)this.surface).isPressed(ButtonID.ARROW_UP);
        if (isUpPressed || ((FireControlSurface)this.surface).isPressed(ButtonID.ARROW_DOWN)) {
            ((FireControlSurface)this.surface).setTriggerConsumed(isUpPressed ? ButtonID.ARROW_UP : ButtonID.ARROW_DOWN);
            if (velocity > 0) {
                this.handleSequencerAreaRepeatOperator(clip, notePosition, velocity, isUpPressed);
            }
            return true;
        }
        return super.handleSequencerAreaButtonCombinations(clip, notePosition, velocity);
    }

    @Override
    protected boolean handleNoteEditorMode(int x, int y, int offsetY, int velocity) {
        ModeManager modeManager = ((FireControlSurface)this.surface).getModeManager();
        if (velocity > 0) {
            IMode activeMode = (IMode)modeManager.getActive();
            if (activeMode instanceof INoteEditorMode) {
                INoteEditorMode noteMode = (INoteEditorMode)((Object)activeMode);
                int sound = offsetY + this.selectedPad;
                int step = this.numColumns * (this.allRows - 1 - y) + x;
                NotePosition notePosition = new NotePosition(this.configuration.getMidiEditChannel(), step, sound);
                INoteClip clip = this.getClip();
                StepState state = clip.getStep(notePosition).getState();
                if (state == StepState.START) {
                    this.editNote(clip, notePosition, true);
                    if (noteMode.getNoteEditor().getNotes().isEmpty()) {
                        ((FireControlSurface)this.surface).getDisplay().notify("Edit Notes: Off");
                        this.isNoteEdited = false;
                    }
                }
                return true;
            }
            return false;
        }
        if (this.isNoteEdited) {
            this.isNoteEdited = false;
        }
        return modeManager.isActive(new Modes[]{Modes.NOTE});
    }

    @Override
    protected boolean isSoloTrigger() {
        return this.isSolo && this.isButtonCombination(ButtonID.SCENE2);
    }

    @Override
    protected boolean isMuteTrigger() {
        return !this.isSolo && this.isButtonCombination(ButtonID.SCENE2);
    }

    @Override
    protected boolean isDeleteTrigger() {
        return !this.isCopy && this.isButtonCombination(this.deleteButton);
    }

    @Override
    protected boolean isDuplicateTrigger() {
        return this.isCopy && this.isButtonCombination(this.deleteButton);
    }

    @Override
    protected boolean isEditLoopRange() {
        return ((FireControlSurface)this.surface).isPressed(ButtonID.SCENE3) || this.editLoopRange;
    }
}

