/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.akai.fire.command.trigger;

import de.mossgrabers.controller.akai.fire.FireConfiguration;
import de.mossgrabers.controller.akai.fire.command.trigger.FireBrowserCommand;
import de.mossgrabers.controller.akai.fire.controller.FireControlSurface;
import de.mossgrabers.controller.akai.fire.mode.FireNoteMode;
import de.mossgrabers.framework.command.core.AbstractTriggerCommand;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.featuregroup.ModeManager;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.utils.ButtonEvent;

public class FireSelectButtonCommand
extends AbstractTriggerCommand<FireControlSurface, FireConfiguration> {
    public FireSelectButtonCommand(IModel model, FireControlSurface surface) {
        super(model, surface);
    }

    @Override
    public void execute(ButtonEvent event, int velocity) {
        if (velocity > 0) {
            return;
        }
        ModeManager modeManager = ((FireControlSurface)this.surface).getModeManager();
        if (modeManager.isActive(new Modes[]{Modes.NOTE})) {
            ((FireNoteMode)modeManager.get(Modes.NOTE)).resetTranspose();
            return;
        }
        if (modeManager.isActive(new Modes[]{Modes.BROWSER})) {
            ((FireBrowserCommand)((FireControlSurface)this.surface).getButton(ButtonID.BROWSE).getCommand()).discardBrowser(true);
            return;
        }
        FireConfiguration configuration = (FireConfiguration)((FireControlSurface)this.surface).getConfiguration();
        if (modeManager.isActive(new Modes[]{Modes.DEVICE_PARAMS})) {
            if (configuration.isDeleteModeActive()) {
                this.model.getCursorDevice().remove();
                configuration.toggleDeleteModeActive();
                return;
            }
            if (((FireControlSurface)this.surface).isPressed(ButtonID.ALT) && ((FireControlSurface)this.surface).isPressed(ButtonID.SHIFT)) {
                this.model.getCursorDevice().toggleEnabledState();
                return;
            }
        }
        if (((FireControlSurface)this.surface).isPressed(ButtonID.ALT)) {
            this.model.getCursorDevice().toggleWindowOpen();
        } else {
            configuration.toggleControlLastParam();
            this.mvHelper.delayDisplay(() -> "Last Param: " + (configuration.isControlLastParam() ? "ON" : "OFF"));
        }
    }
}

