/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.akai.apc.view;

import de.mossgrabers.controller.akai.apc.APCConfiguration;
import de.mossgrabers.controller.akai.apc.controller.APCControlSurface;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.grid.LightInfo;
import de.mossgrabers.framework.daw.DAWColor;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.IScene;
import de.mossgrabers.framework.daw.data.ISlot;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.ISceneBank;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.AbstractSessionView;

public class SessionView
extends AbstractSessionView<APCControlSurface, APCConfiguration> {
    public SessionView(APCControlSurface surface, IModel model) {
        super("Session", surface, model, 5, 8, surface.isMkII());
        if (surface.isMkII()) {
            LightInfo isRecording = new LightInfo(5, 5, false);
            LightInfo isRecordingQueued = new LightInfo(5, 5, true);
            LightInfo isPlaying = new LightInfo(21, 21, false);
            LightInfo isPlayingQueued = new LightInfo(21, 21, true);
            LightInfo hasContent = new LightInfo(10, 3, false);
            LightInfo noContent = new LightInfo(0, -1, false);
            LightInfo recArmed = new LightInfo(7, -1, false);
            LightInfo isMuted = new LightInfo(1, -1, false);
            this.setColors(isRecording, isRecordingQueued, isPlaying, isPlayingQueued, hasContent, noContent, recArmed, isMuted);
        } else {
            LightInfo isRecording = new LightInfo(3, -1, false);
            LightInfo isRecordingQueued = new LightInfo(3, 4, false);
            LightInfo isPlaying = new LightInfo(1, -1, false);
            LightInfo isPlayingQueued = new LightInfo(1, 2, false);
            LightInfo hasContent = new LightInfo(5, 6, false);
            LightInfo noContent = new LightInfo(0, -1, false);
            LightInfo recArmed = new LightInfo(0, -1, false);
            LightInfo isMuted = new LightInfo(0, -1, false);
            this.setColors(isRecording, isRecordingQueued, isPlaying, isPlayingQueued, hasContent, noContent, recArmed, isMuted);
        }
    }

    @Override
    public String getButtonColorID(ButtonID buttonID) {
        int scene = buttonID.ordinal() - ButtonID.SCENE1.ordinal();
        if (scene < 0 || scene >= 8) {
            return "BUTTON_COLOR_OFF";
        }
        ISceneBank sceneBank = this.model.getSceneBank();
        IScene s = (IScene)sceneBank.getItem(scene);
        if (!s.doesExist()) {
            return "COLOR_SELECTED_OFF";
        }
        if (s.isSelected()) {
            return "COLOR_SELECTED_SCENE";
        }
        return this.useClipColor ? DAWColor.getColorID(s.getColor()) : "COLOR_SCENE";
    }

    @Override
    public void onGridNote(int note, int velocity) {
        if (this.isBirdsEyeActive()) {
            if (velocity == 0) {
                return;
            }
            int index = note - 36;
            int x = index % this.columns;
            int y = this.rows - 1 - index / this.columns;
            this.onGridNoteBirdsEyeView(x, y, 0);
            return;
        }
        super.onGridNote(note, velocity);
    }

    @Override
    public void onButton(ButtonID buttonID, ButtonEvent event, int velocity) {
        super.onButton(buttonID, event, velocity);
        if (ButtonID.isSceneButton(buttonID) && event == ButtonEvent.UP && ((APCControlSurface)this.surface).isShiftPressed()) {
            this.setAlternateInteractionUsed(true);
        }
    }

    @Override
    protected boolean isSceneSelectAction() {
        return false;
    }

    @Override
    protected boolean handleButtonCombinations(ITrack track, ISlot slot) {
        if (super.handleButtonCombinations(track, slot)) {
            return true;
        }
        int index = track.getIndex();
        if (index < 0) {
            return true;
        }
        if (this.isButtonCombination(ButtonID.get(ButtonID.ROW1_1, index))) {
            slot.duplicate();
            return true;
        }
        if (this.isButtonCombination(ButtonID.get(ButtonID.ROW6_1, index))) {
            slot.remove();
            return true;
        }
        return false;
    }
}

