/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.akai.apc.mode;

import de.mossgrabers.controller.akai.apc.APCConfiguration;
import de.mossgrabers.controller.akai.apc.controller.APCControlSurface;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.IItem;
import de.mossgrabers.framework.daw.data.bank.IBank;
import de.mossgrabers.framework.featuregroup.AbstractParameterMode;
import de.mossgrabers.framework.utils.ButtonEvent;
import java.util.Date;

public abstract class BaseMode<B extends IItem>
extends AbstractParameterMode<APCControlSurface, APCConfiguration, B> {
    private boolean isKnobMoving;
    private long moveStartTime;
    private final int ledMode;

    protected BaseMode(String name, APCControlSurface surface, IModel model, int ledMode, IBank<B> bank) {
        super(name, surface, model, false, bank, DEFAULT_KNOB_IDS);
        this.ledMode = ledMode;
        this.isKnobMoving = false;
        this.moveStartTime = 0L;
    }

    public void setValue(int index, int value) {
    }

    @Override
    public void onKnobValue(int index, int value) {
        this.setValue(index, value);
        this.moveStartTime = new Date().getTime();
        if (this.isKnobMoving) {
            return;
        }
        this.isKnobMoving = true;
        this.startCheckKnobMovement();
    }

    @Override
    public void updateDisplay() {
        if (this.isKnobMoving) {
            return;
        }
        for (int i = 0; i < 8; ++i) {
            int value = this.getKnobValue(i);
            boolean isOff = value < 0;
            ((APCControlSurface)this.surface).setLED(56 + i, isOff ? 2 : this.ledMode);
            ((APCControlSurface)this.surface).setLED(48 + i, isOff ? 0 : value);
        }
    }

    protected void startCheckKnobMovement() {
        ((APCControlSurface)this.surface).scheduleTask(this::checkKnobMovement, 100L);
    }

    protected void checkKnobMovement() {
        if (!this.isKnobMoving) {
            return;
        }
        if (new Date().getTime() - this.moveStartTime > 200L) {
            this.isKnobMoving = false;
        } else {
            this.startCheckKnobMovement();
        }
    }

    @Override
    public void onButton(int row, int index, ButtonEvent event) {
    }
}

