/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.akai.acvs.controller;

import de.mossgrabers.controller.akai.acvs.controller.ACVSMidiOutput;
import de.mossgrabers.controller.akai.acvs.controller.ScreenItem;
import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.controller.display.AbstractTextDisplay;
import de.mossgrabers.framework.controller.display.ITextDisplay;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.utils.StringUtils;
import java.util.EnumMap;
import java.util.Map;

public class ACVSDisplay
extends AbstractTextDisplay {
    public static final int ITEM_ID_TRACK_HEADER_FIRST = 0;
    public static final int ITEM_ID_CLIPS_FIRST = 16;
    public static final int ITEM_ID_SCENES_FIRST = 80;
    public static final int ITEM_ID_TRACK_FADER_LEVEL_FIRST = 256;
    public static final int ITEM_ID_TRACK_PEAK_LEVEL_FIRST = 264;
    public static final int ITEM_ID_TRACK_PAN_FIRST = 272;
    public static final int ITEM_ID_TRACK_SEND1_FIRST = 280;
    public static final int ITEM_ID_TRACK_SEND2_FIRST = 288;
    public static final int ITEM_ID_TRACK_SEND3_FIRST = 296;
    public static final int ITEM_ID_TRACK_SEND4_FIRST = 304;
    public static final int ITEM_ID_DEVICE_BANK_NAME = 512;
    public static final int ITEM_ID_DEVICE_NAME = 513;
    public static final int ITEM_ID_DEVICE_PARAMETER_NAME_FIRST = 528;
    public static final int ITEM_ID_DEVICE_PARAMETER_VALUE_FIRST = 544;
    public static final int ITEM_ID_TEMPO = 768;
    public static final int ITEM_ID_ARRANGEMENT_POSITION = 784;
    public static final int ITEM_ID_LOOP_START = 785;
    public static final int ITEM_ID_LOOP_LENGTH = 786;
    public static final int ITEM_ID_DEVICE_PARAM_NAME1 = 4624;
    public static final int ITEM_ID_DEVICE_PARAM_VALUE1 = 4655;
    private static final int ITEM_ID_MAX = 4672;
    private final ColorEx[] currentColor;
    private final ColorEx[] color;
    private final Map<ScreenItem, Integer> screenItemCache = new EnumMap<ScreenItem, Integer>(ScreenItem.class);

    public ACVSDisplay(IHost host, ACVSMidiOutput output) {
        super(host, output, 4672, 1, 16);
        for (ScreenItem item : ScreenItem.values()) {
            this.screenItemCache.put(item, -1);
        }
        this.currentColor = new ColorEx[this.noOfLines];
        this.color = new ColorEx[this.noOfLines];
    }

    @Override
    public void writeLine(int row, String text, String previousText) {
        if (text != null) {
            ((ACVSMidiOutput)this.output).sendText(row, StringUtils.fixASCII(text));
        }
    }

    @Override
    public void shutdown() {
    }

    public void setColor(int row, ColorEx color) {
        this.color[row] = color;
    }

    @Override
    public void flush() {
        super.flush();
        for (int row = 0; row < this.noOfLines; ++row) {
            if (this.currentColor[row] != null && this.currentColor[row].equals(this.color[row])) continue;
            this.currentColor[row] = this.color[row];
            if (this.currentColor[row] == null) continue;
            this.updateColor(row, this.currentColor[row]);
        }
    }

    @Override
    public void forceFlush() {
        int row;
        for (row = 0; row < this.noOfLines; ++row) {
            this.currentMessage[row] = null;
        }
        for (row = 0; row < this.noOfLines; ++row) {
            this.currentColor[row] = null;
        }
        for (ScreenItem item : ScreenItem.values()) {
            this.screenItemCache.put(item, -1);
        }
    }

    private void updateColor(int row, ColorEx color) {
        if (color != null) {
            ((ACVSMidiOutput)this.output).sendColor(row, color);
        }
    }

    @Override
    public ITextDisplay done(int row) {
        return this.fullRows[row] == null ? this : super.done(row);
    }

    @Override
    protected void notifyOnDisplay(String message) {
    }

    public void setScreenItem(ScreenItem screenItem, int value) {
        Integer currentValue = this.screenItemCache.get((Object)screenItem);
        if (currentValue == value) {
            return;
        }
        this.screenItemCache.put(screenItem, value);
        if (screenItem.isNote()) {
            this.output.sendNoteEx(screenItem.getChannel(), screenItem.getNoteCC(), value);
        } else {
            this.output.sendCCEx(screenItem.getChannel(), screenItem.getNoteCC(), value);
        }
    }
}

