/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ableton.push.mode.device;

import de.mossgrabers.controller.ableton.push.PushConfiguration;
import de.mossgrabers.controller.ableton.push.controller.PushControlSurface;
import de.mossgrabers.controller.ableton.push.mode.device.DeviceLayerMode;
import de.mossgrabers.controller.ableton.push.parameterprovider.PushVolumeLayerOrDrumPadParameterProvider;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.display.Format;
import de.mossgrabers.framework.controller.display.IGraphicDisplay;
import de.mossgrabers.framework.controller.display.ITextDisplay;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.IChannel;
import de.mossgrabers.framework.daw.data.ILayer;
import java.util.Optional;

public class DeviceLayerVolumeMode
extends DeviceLayerMode {
    public DeviceLayerVolumeMode(PushControlSurface surface, IModel model) {
        super("Layer Volume", surface, model);
        this.setParameterProvider(new PushVolumeLayerOrDrumPadParameterProvider(this.cursorDevice));
    }

    @Override
    public void onKnobTouch(int index, boolean isTouched) {
        this.setTouchedKnob(index, isTouched);
        int offset = this.getDrumPadIndex();
        IChannel layer = (IChannel)this.bank.getItem(offset + index);
        if (!layer.doesExist()) {
            return;
        }
        if (isTouched && ((PushControlSurface)this.surface).isDeletePressed()) {
            ((PushControlSurface)this.surface).setTriggerConsumed(ButtonID.DELETE);
            layer.resetVolume();
        }
        layer.touchVolume(isTouched);
        this.checkStopAutomationOnKnobRelease(isTouched);
    }

    @Override
    public void updateDisplay1(ITextDisplay display) {
        if (!this.cursorDevice.hasLayers()) {
            display.setBlock(1, 1, "    This device  ").setBlock(1, 2, "does not have layers.");
        } else if (!this.bank.hasExistingItems()) {
            display.setBlock(1, 1, "    Please create").setBlock(1, 2, this.cursorDevice.hasDrumPads() ? "a Drum Pad..." : "a Device Layer...");
        } else {
            int offset = this.getDrumPadIndex();
            PushConfiguration config = (PushConfiguration)((PushControlSurface)this.surface).getConfiguration();
            for (int i = 0; i < 8; ++i) {
                IChannel layer = (IChannel)this.bank.getItem(offset + i);
                display.setCell(0, i, layer.doesExist() ? "Volume" : "").setCell(1, i, layer.getVolumeStr(8));
                if (!layer.doesExist()) continue;
                display.setCell(2, i, config.isEnableVUMeters() ? layer.getVu() : layer.getVolume(), Format.FORMAT_VALUE);
            }
        }
        this.drawRow4(display);
    }

    @Override
    public void updateDisplayElements(IGraphicDisplay message, Optional<ILayer> l) {
        this.updateChannelDisplay(message, 1, true, false);
    }
}

