/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ableton.push.mode.device;

import de.mossgrabers.controller.ableton.push.controller.PushControlSurface;
import de.mossgrabers.controller.ableton.push.mode.device.DeviceLayerMode;
import de.mossgrabers.controller.ableton.push.parameterprovider.PushSendLayerOrDrumPadParameterProvider;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.display.Format;
import de.mossgrabers.framework.controller.display.IGraphicDisplay;
import de.mossgrabers.framework.controller.display.ITextDisplay;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.IChannel;
import de.mossgrabers.framework.daw.data.ILayer;
import de.mossgrabers.framework.daw.data.ISend;
import de.mossgrabers.framework.daw.data.bank.ISendBank;
import de.mossgrabers.framework.daw.resource.ChannelType;
import de.mossgrabers.framework.graphics.canvas.utils.SendData;
import de.mossgrabers.framework.parameter.IParameter;
import de.mossgrabers.framework.utils.Pair;
import java.util.Optional;

public class DeviceLayerSendMode
extends DeviceLayerMode {
    private final int sendIndex;

    public DeviceLayerSendMode(PushControlSurface surface, IModel model, int sendIndex) {
        super("Layer Sends", surface, model);
        this.sendIndex = sendIndex;
        this.setParameterProvider(new PushSendLayerOrDrumPadParameterProvider(this.cursorDevice, sendIndex));
    }

    @Override
    public void onKnobTouch(int index, boolean isTouched) {
        IParameter iParameter;
        this.setTouchedKnob(index, isTouched);
        int offset = this.getDrumPadIndex();
        IChannel layer = (IChannel)this.bank.getItem(offset + index);
        if (!layer.doesExist()) {
            return;
        }
        if (isTouched && ((PushControlSurface)this.surface).isDeletePressed()) {
            ((PushControlSurface)this.surface).setTriggerConsumed(ButtonID.DELETE);
            ((ISend)layer.getSendBank().getItem(this.sendIndex)).resetValue();
        }
        ((ISend)layer.getSendBank().getItem(this.sendIndex)).touchValue(isTouched);
        this.checkStopAutomationOnKnobRelease(isTouched);
        if (isTouched && ((PushControlSurface)this.surface).isShiftPressed() && ((PushControlSurface)this.surface).isSelectPressed() && (iParameter = this.getParameterProvider().get(index)) instanceof ISend) {
            ISend send = (ISend)iParameter;
            ((PushControlSurface)this.surface).setTriggerConsumed(ButtonID.SELECT);
            send.toggleEnabled();
        }
    }

    @Override
    public void updateDisplay1(ITextDisplay display) {
        if (!this.cursorDevice.hasLayers()) {
            display.setBlock(1, 1, "    This device  ").setBlock(1, 2, "does not have layers.");
        } else if (!this.bank.hasExistingItems()) {
            display.setBlock(1, 1, "    Please create").setBlock(1, 2, this.cursorDevice.hasDrumPads() ? "a Drum Pad..." : "a Device Layer...");
        } else {
            int offset = this.getDrumPadIndex();
            for (int i = 0; i < 8; ++i) {
                IChannel layer = (IChannel)this.bank.getItem(offset + i);
                boolean exists = layer.doesExist();
                ISendBank sendBank = layer.getSendBank();
                ISend send = (ISend)sendBank.getItem(this.sendIndex);
                display.setCell(0, i, exists ? send.getName() : "").setCell(1, i, send.getDisplayedValue(8));
                if (!exists) continue;
                display.setCell(2, i, send.getValue(), Format.FORMAT_VALUE);
            }
        }
        this.drawRow4(display);
    }

    @Override
    public void updateDisplayElements(IGraphicDisplay display, Optional<ILayer> l) {
        this.updateMenuItems(5 + this.sendIndex % 4);
        int offset = this.getDrumPadIndex();
        for (int i = 0; i < 8; ++i) {
            IChannel layer = (IChannel)this.bank.getItem(offset + i);
            Pair pair = (Pair)this.menu.get(i);
            String topMenu = (String)pair.getKey();
            boolean isTopMenuOn = (Boolean)pair.getValue();
            SendData[] sendData = new SendData[4];
            ISendBank sendBank = layer.getSendBank();
            for (int j = 0; j < 4; ++j) {
                ISend send = (ISend)sendBank.getItem(j);
                boolean exists = send.doesExist();
                sendData[j] = new SendData(send.isEnabled(), send.getName(), exists && this.sendIndex == j && this.isKnobTouched(i) ? send.getDisplayedValue() : "", exists ? send.getValue() : 0, exists ? send.getModulatedValue() : 0, this.sendIndex == j);
            }
            display.addSendsElement(topMenu, isTopMenuOn, layer.doesExist() ? layer.getName() : "", ChannelType.LAYER, ((ILayer)this.bank.getItem(offset + i)).getColor(), layer.isSelected(), sendData, false, layer.isActivated(), layer.isActivated());
        }
    }
}

